/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.UI;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.ButtonGroup;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.EmbeddedLocalizations;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.Util;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.AnimEncConfigPopup;
import com.tom.cpm.shared.editor.gui.popup.CreateGistPopup;
import com.tom.cpm.shared.editor.gui.popup.DescPopup;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$$Lambda$1;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$$Lambda$2;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$$Lambda$3;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$$Lambda$4;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$$Lambda$5;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$B64$$Lambda$1;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$B64$$Lambda$2;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$B64$$Lambda$3;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$B64$$Lambda$4;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$B64$$Lambda$5;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$ExportMode$$Lambda$1;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$ExportMode$$Lambda$2;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$ExportMode$$Lambda$3;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$ExportMode$$Lambda$4;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$ExportMode$$Lambda$5;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$ExportMode$$Lambda$6;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$ExportMode$$Lambda$7;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$ExportMode$$Lambda$8;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Model$$Lambda$1;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Model$$Lambda$2;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Model$$Lambda$3;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Model$$Lambda$4;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Model$$Lambda$5;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Model$$Lambda$6;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Model$$Lambda$7;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$1;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$10;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$11;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$12;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$13;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$14;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$15;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$16;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$17;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$18;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$19;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$2;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$20;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$21;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$22;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$23;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$3;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$4;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$5;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$6;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$7;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$8;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Skin$$Lambda$9;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Template$$Lambda$1;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Template$$Lambda$2;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup$Template$$Lambda$3;
import com.tom.cpm.shared.editor.gui.popup.ExportStringResultPopup;
import com.tom.cpm.shared.editor.gui.popup.ScreenshotPopup;
import com.tom.cpm.shared.editor.template.TemplateExporter;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.gui.SelectSkinPopup;
import com.tom.cpm.shared.gui.SkinUploadPopup;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.parts.ModelPartDefinitionLink;
import com.tom.cpm.shared.parts.ModelPartLink;
import com.tom.cpm.shared.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class ExportPopup
extends PopupPanel {
    protected final EditorGui editorGui;
    protected Button ok;
    protected Button modeBtn;

    protected ExportPopup(EditorGui e, int width, int height, ExportMode mode) {
        super(e.getGui());
        this.editorGui = e;
        this.modeBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.export.as_" + mode.name().toLowerCase(Locale.ROOT), new Object[0]), ExportPopup$$Lambda$1.lambdaFactory$(this, mode, e));
        this.modeBtn.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export.as_" + mode.name().toLowerCase(Locale.ROOT), new Object[0])));
        this.modeBtn.setBounds(new Box(5, 5, 170, 20));
        this.addElement(this.modeBtn);
        this.ok = new Button(this.gui, this.gui.i18nFormat("button.cpm.file.export", new Object[0]), ExportPopup$$Lambda$2.lambdaFactory$(this));
        this.ok.setBounds(new Box(5, height - 25, 80, 20));
        this.addElement(this.ok);
        this.setBounds(new Box(0, 0, width, height));
    }

    protected void export() {
        if (Exporter.check(this.editorGui.getEditor(), this.editorGui.getGui(), ExportPopup$$Lambda$3.lambdaFactory$(this))) {
            this.export0();
            this.close();
        }
    }

    protected abstract void export0();

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.exportSkin", new Object[0]);
    }

    public static boolean isTemplate(Editor e) {
        return e.templateSettings != null;
    }

    private static void openScreenshot(EditorGui e, EditorTexture icon, ExportPopup popup) {
        popup.close();
        EditorTexture editorTexture = icon;
        editorTexture.getClass();
        e.openPopup(new ScreenshotPopup(e, ExportPopup$$Lambda$4.lambdaFactory$(editorTexture), ExportPopup$$Lambda$5.lambdaFactory$(e, popup)));
    }

    public static PopupPanel createPopup(EditorGui e) {
        for (ExportMode m : ExportMode.VALUES) {
            if (!m.canDisplay.test(e.getEditor())) continue;
            return (PopupPanel)m.factory.apply(e);
        }
        IGui gui = e.getGui();
        Log.error("Project can't be exported in any format");
        return new MessagePopup(e, gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("error.cpm.unknownError", new Object[0]));
    }

    static /* synthetic */ void lambda$openScreenshot$1(EditorGui e, ExportPopup popup) {
        e.openPopup(popup);
    }

    static /* synthetic */ void lambda$new$0(ExportPopup this_, ExportMode mode, EditorGui e) {
        this_.close();
        for (int i = mode.ordinal() + 1; i < ExportMode.VALUES.length * 2; ++i) {
            ExportMode em = ExportMode.VALUES[i % ExportMode.VALUES.length];
            if (!em.canDisplay.test(e.getEditor())) continue;
            e.openPopup((PopupPanel)em.factory.apply(e));
            return;
        }
    }

    private static class Model
    extends ExportPopup {
        private TextField nameField;
        private TextField descField;
        private EditorTexture icon;
        private Checkbox skinCompat;
        private Checkbox chbxClone;
        private Checkbox chbxUUIDLock;
        private Link defLink;
        private Button okDef;
        private boolean gist;

        protected Model(EditorGui e) {
            super(e, 320, 260, ExportMode.MODEL);
            Editor editor = e.getEditor();
            Label nameLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0]));
            nameLbl.setBounds(new Box(5, 35, 150, 10));
            this.addElement(nameLbl);
            this.nameField = new TextField(this.gui);
            this.nameField.setBounds(new Box(5, 45, 150, 20));
            this.addElement(this.nameField);
            Label descLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]));
            descLbl.setBounds(new Box(5, 70, 150, 10));
            this.addElement(descLbl);
            this.descField = new TextField(this.gui);
            this.descField.setBounds(new Box(5, 80, 150, 20));
            this.addElement(this.descField);
            this.icon = new EditorTexture();
            if (editor.description != null) {
                this.nameField.setText(editor.description.name);
                this.descField.setText(editor.description.desc);
                if (editor.description.icon != null) {
                    this.icon.setImage(editor.description.icon);
                }
            }
            Button setIcon = new Button(this.gui, this.gui.i18nFormat("button.cpm.setIcon", new Object[0]), ExportPopup$Model$$Lambda$1.lambdaFactory$(this, e));
            setIcon.setBounds(new Box(5, 105, 100, 20));
            this.addElement(setIcon);
            this.skinCompat = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.export.skinCompat", new Object[0]));
            this.skinCompat.setBounds(new Box(5, 130, 100, 20));
            this.skinCompat.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skinCompat", new Object[0])));
            this.addElement(this.skinCompat);
            this.skinCompat.setAction(ExportPopup$Model$$Lambda$2.lambdaFactory$(this));
            this.chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
            this.chbxClone.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
            this.chbxClone.setBounds(new Box(5, 155, 60, 20));
            this.chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
            this.addElement(this.chbxClone);
            this.chbxUUIDLock = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uuidlock", new Object[0]));
            this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlock", MinecraftClientAccess$.get().getClientPlayer().getUUID().toString())));
            this.chbxUUIDLock.setBounds(new Box(5, 180, 60, 20));
            this.chbxUUIDLock.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            this.addElement(this.chbxUUIDLock);
            Button changeUUID = new Button(this.gui, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), new InputPopup(e, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), this.gui.i18nFormat("label.cpm.enterNewUUID", new Object[0]), ExportPopup$Model$$Lambda$3.lambdaFactory$(this, editor, e), null));
            changeUUID.setEnabled(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            changeUUID.setBounds(new Box(90, 180, 80, 20));
            this.addElement(changeUUID);
            if (editor.description != null && editor.description.uuid != null) {
                this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
            }
            this.chbxClone.setAction(ExportPopup$Model$$Lambda$4.lambdaFactory$(this, changeUUID));
            this.chbxUUIDLock.setAction(ExportPopup$Model$$Lambda$5.lambdaFactory$(this, changeUUID));
            this.okDef = new Button(this.gui, this.gui.i18nFormat("button.cpm.export_def", new Object[0]), ExportPopup$Model$$Lambda$6.lambdaFactory$(this));
            this.okDef.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export_def.model", new Object[0])));
            this.okDef.setBounds(new Box(90, 235, 80, 20));
            this.addElement(this.okDef);
            this.updateLink();
        }

        @Override
        protected void export0() {
            ModelDescription.CopyProtection cp;
            Editor editor = this.editorGui.getEditor();
            if (editor.templateSettings != null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.templateExportAsSkin", new Object[0])));
                return;
            }
            boolean descChanged = false;
            if (editor.description == null) {
                editor.description = new ModelDescription();
                descChanged = true;
            }
            if (!descChanged && !editor.description.name.equals(this.nameField.getText())) {
                descChanged = true;
            }
            if (!descChanged && !editor.description.desc.equals(this.descField.getText())) {
                descChanged = true;
            }
            editor.description.name = this.nameField.getText();
            editor.description.desc = this.descField.getText();
            ModelDescription.CopyProtection copyProtection = this.chbxUUIDLock.isSelected() ? ModelDescription.CopyProtection.UUID_LOCK : (cp = this.chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : ModelDescription.CopyProtection.NORMAL);
            if (editor.description.copyProtection != cp) {
                editor.description.copyProtection = cp;
                descChanged = true;
            }
            if (descChanged) {
                editor.markDirty();
            }
            if (this.gist) {
                Exporter.exportUpdate(editor, this.gui, this.defLink);
            } else {
                File modelsDir = new File(MinecraftClientAccess$.get().getGameDir(), "player_models");
                modelsDir.mkdirs();
                String fileName = this.nameField.getText().replaceAll("[^a-zA-Z0-9\\.\\-]", "") + ".cpmmodel";
                File selFile = new File(modelsDir, fileName);
                if (selFile.exists()) {
                    this.editorGui.openPopup(new ConfirmPopup(this.editorGui, this.gui.i18nFormat("label.cpm.overwrite", new Object[0]), this.gui.i18nFormat("label.cpm.overwrite", new Object[0]), ExportPopup$Model$$Lambda$7.lambdaFactory$(this, editor, selFile), null));
                } else {
                    Exporter.exportModel(editor, this.gui, selFile, editor.description, this.skinCompat.isSelected());
                }
            }
        }

        private void updateLink() {
            File modelsDir = new File(MinecraftClientAccess$.get().getGameDir(), "player_models");
            modelsDir.mkdirs();
            String fileName = this.nameField.getText().replaceAll("[^a-zA-Z0-9\\.\\-]", "") + ".cpmmodel";
            File selFile = new File(modelsDir, fileName);
            this.defLink = null;
            boolean incompatibleDef = false;
            if (selFile.exists()) {
                try {
                    ModelPartLink link;
                    ModelFile mf = ModelFile.load(selFile);
                    ModelDefinition def = MinecraftClientAccess$.get().getDefinitionLoader().loadModel(mf.getDataBlock(), MinecraftClientAccess$.get().getClientPlayer());
                    if (def != null && (link = def.findDefLink()) != null) {
                        this.defLink = link.getLink();
                        if (link instanceof ModelPartDefinitionLink == ModConfig.getCommonConfig().getBoolean("experimentalExport0614", false)) {
                            this.defLink = null;
                            incompatibleDef = true;
                        }
                    }
                }
                catch (IOException e) {
                    Log.error("Failed to load file", e);
                }
            }
            this.okDef.setEnabled(this.defLink != null);
            if (this.defLink != null) {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.model", new Object[0])));
            } else if (incompatibleDef) {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.incompatible", new Object[0])));
            } else {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.noLink.model", new Object[0])));
            }
        }

        @Override
        public void onClosed() {
            this.icon.free();
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon.getImage() != null) {
                this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + 14, 130, 130, this.gui.getColors().color_picker_border);
                this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, -1);
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }

        static /* synthetic */ void lambda$export0$6(Model this_, Editor editor, File selFile) {
            Exporter.exportModel(editor, this_.gui, selFile, editor.description, this_.skinCompat.isSelected());
        }

        static /* synthetic */ void lambda$new$5(Model this_) {
            if (this_.defLink != null) {
                this_.gist = true;
                this_.close();
                this_.export();
            }
        }

        static /* synthetic */ void lambda$new$4(Model this_, Button changeUUID) {
            changeUUID.setEnabled(!this_.chbxUUIDLock.isSelected());
            if (!this_.chbxUUIDLock.isSelected()) {
                this_.chbxUUIDLock.setSelected(true);
                this_.chbxClone.setSelected(false);
            } else {
                this_.chbxUUIDLock.setSelected(false);
            }
        }

        static /* synthetic */ void lambda$new$3(Model this_, Button changeUUID) {
            if (!this_.chbxClone.isSelected()) {
                this_.chbxUUIDLock.setSelected(false);
                this_.chbxClone.setSelected(true);
                changeUUID.setEnabled(false);
            } else {
                this_.chbxClone.setSelected(false);
            }
        }

        static /* synthetic */ void lambda$new$2(Model this_, Editor editor, EditorGui e, String n) {
            if (editor.description == null) {
                editor.description = new ModelDescription();
            }
            try {
                editor.description.uuid = Util.uuidFromString(n);
                this_.chbxUUIDLock.setTooltip(new Tooltip(e, this_.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
            }
            catch (IllegalArgumentException ex) {
                e.openPopup(new MessagePopup(e, this_.gui.i18nFormat("label.cpm.error", new Object[0]), this_.gui.i18nFormat("label.cpm.invalidUUID", new Object[0])));
            }
        }

        static /* synthetic */ void lambda$new$1(Model this_) {
            this_.skinCompat.setSelected(!this_.skinCompat.isSelected());
        }

        static /* synthetic */ void lambda$new$0(Model this_, EditorGui e) {
            ExportPopup.openScreenshot(e, this_.icon, (ExportPopup)this_);
        }
    }

    private static class B64
    extends ExportPopup {
        private Checkbox forceLinkFile;
        private Checkbox chbxClone;

        protected B64(EditorGui e) {
            super(e, 180, 150, ExportMode.B64);
            this.forceLinkFile = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.force_link_file", new Object[0]));
            this.addElement(this.forceLinkFile);
            this.forceLinkFile.setAction(ExportPopup$B64$$Lambda$1.lambdaFactory$(this));
            this.forceLinkFile.setBounds(new Box(5, 55, 135, 20));
            this.chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
            this.chbxClone.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
            this.chbxClone.setBounds(new Box(5, 80, 60, 20));
            this.addElement(this.chbxClone);
            this.chbxClone.setAction(ExportPopup$B64$$Lambda$2.lambdaFactory$(this));
            Button btnEditDesc = new Button(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]), ExportPopup$B64$$Lambda$3.lambdaFactory$(this, e));
            btnEditDesc.setBounds(new Box(90, 80, 85, 20));
            this.addElement(btnEditDesc);
            this.updateDesc();
        }

        private void updateDesc() {
            Editor editor = this.editorGui.getEditor();
            this.chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
        }

        @Override
        protected void export0() {
            if (this.editorGui.getEditor().templateSettings != null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.templateExportAsSkin", new Object[0])));
                return;
            }
            Editor e = this.editorGui.getEditor();
            if (e.description == null && this.chbxClone.isSelected()) {
                e.description = new ModelDescription();
                e.markDirty();
            }
            if (e.description != null) {
                ModelDescription.CopyProtection cp;
                ModelDescription.CopyProtection copyProtection = cp = this.chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : e.description.copyProtection;
                if (e.description.copyProtection != cp) {
                    e.description.copyProtection = cp;
                    e.markDirty();
                }
            }
            Exporter.exportB64(this.editorGui.getEditor(), this.gui, ExportPopup$B64$$Lambda$4.lambdaFactory$(this), this.forceLinkFile.isSelected());
        }

        static /* synthetic */ void lambda$export0$3(B64 this_, String b64) {
            this_.editorGui.openPopup(new ExportStringResultPopup(this_.editorGui, "base64_model", b64));
        }

        static /* synthetic */ void lambda$new$2(B64 this_, EditorGui e) {
            e.openPopup(new DescPopup(e, false, ExportPopup$B64$$Lambda$5.lambdaFactory$(this_)));
        }

        static /* synthetic */ void lambda$new$1(B64 this_) {
            this_.chbxClone.setSelected(!this_.chbxClone.isSelected());
        }

        static /* synthetic */ void lambda$new$0(B64 this_) {
            this_.forceLinkFile.setSelected(!this_.forceLinkFile.isSelected());
        }

        static /* synthetic */ void access$lambda$0(B64 b64) {
            b64.updateDesc();
        }
    }

    private static class Template
    extends ExportPopup {
        private TextField nameField;
        private TextField descField;
        private EditorTexture icon;

        protected Template(EditorGui e) {
            super(e, 320, 190, ExportMode.TEMPLATE);
            Editor editor = e.getEditor();
            Label nameLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0]));
            nameLbl.setBounds(new Box(5, 55, 150, 10));
            this.addElement(nameLbl);
            this.nameField = new TextField(this.gui);
            this.nameField.setBounds(new Box(5, 65, 150, 20));
            this.addElement(this.nameField);
            Label descLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]));
            descLbl.setBounds(new Box(5, 90, 150, 10));
            this.addElement(descLbl);
            this.descField = new TextField(this.gui);
            this.descField.setBounds(new Box(5, 100, 150, 20));
            this.addElement(this.descField);
            this.icon = new EditorTexture();
            if (editor.description != null) {
                this.nameField.setText(editor.description.name);
                this.descField.setText(editor.description.desc);
                if (editor.description.icon != null) {
                    this.icon.setImage(editor.description.icon);
                }
            }
            Button setIcon = new Button(this.gui, this.gui.i18nFormat("button.cpm.setIcon", new Object[0]), ExportPopup$Template$$Lambda$1.lambdaFactory$(this, e));
            setIcon.setBounds(new Box(5, 125, 100, 20));
            this.addElement(setIcon);
        }

        @Override
        protected void export0() {
            Editor editor = this.editorGui.getEditor();
            if (editor.templateSettings == null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.projectNotTemplate", new Object[0])));
                return;
            }
            if (editor.description == null) {
                editor.description = new ModelDescription();
            }
            editor.description.name = this.nameField.getText();
            editor.description.desc = this.descField.getText();
            editor.markDirty();
            TemplateExporter.exportTemplate(editor, this.gui, editor.description, ExportPopup$Template$$Lambda$2.lambdaFactory$(this));
        }

        @Override
        public void onClosed() {
            this.icon.free();
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon.getImage() != null) {
                this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + 14, 130, 130, this.gui.getColors().color_picker_border);
                this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, -1);
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }

        static /* synthetic */ void lambda$export0$2(Template this_, String t) {
            this_.editorGui.openPopup(new CreateGistPopup(this_.editorGui, this_.gui, "template_export", t, ExportPopup$Template$$Lambda$3.lambdaFactory$(this_)));
        }

        static /* synthetic */ void lambda$null$1(Template this_, Link l) {
            this_.editorGui.openPopup(new ExportStringResultPopup(this_.editorGui, "template", l.toString()));
        }

        static /* synthetic */ void lambda$new$0(Template this_, EditorGui e) {
            ExportPopup.openScreenshot(e, this_.icon, (ExportPopup)this_);
        }
    }

    private static class Skin
    extends ExportPopup {
        private EditorTexture vanillaSkin;
        private Button okDef;
        private Button okUpload;
        private Button changeUUID;
        private File selFile;
        private Checkbox forceLinkFile;
        private Checkbox chbxClone;
        private Checkbox chbxUUIDLock;
        private Link defLink;
        private Tooltip vanillaSkinTooltip;
        private boolean gist;
        private boolean upload;
        private SkinType skinType;
        private ButtonGroup<SkinType, Checkbox> groupSkinType;

        protected Skin(EditorGui e) {
            super(e, 320, 280, ExportMode.SKIN);
            Editor editor = e.getEditor();
            this.skinType = editor.skinType;
            this.vanillaSkin = new EditorTexture();
            this.vanillaSkin.setImage(editor.vanillaSkin);
            Button encSettings = new Button(this.gui, this.gui.i18nFormat("button.cpm.animEncSettings", new Object[0]), ExportPopup$Skin$$Lambda$1.lambdaFactory$(this, e, editor));
            encSettings.setBounds(new Box(5, 30, 170, 20));
            this.addElement(encSettings);
            Button changeVanillaSkin = new Button(this.gui, this.gui.i18nFormat("button.cpm.change_vanilla_skin", new Object[0]), ExportPopup$Skin$$Lambda$2.lambdaFactory$(this, e, editor));
            changeVanillaSkin.setBounds(new Box(this.bounds.w - 135, this.bounds.y + 150, 128, 20));
            this.addElement(changeVanillaSkin);
            Label vanillaSkinLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.vanilla_skin", new Object[0]));
            vanillaSkinLbl.setBounds(new Box(185, 5, 0, 0));
            this.addElement(vanillaSkinLbl);
            this.forceLinkFile = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.force_link_file", new Object[0]));
            this.addElement(this.forceLinkFile);
            this.forceLinkFile.setBounds(new Box(5, 80, 135, 20));
            this.forceLinkFile.setAction(ExportPopup$Skin$$Lambda$3.lambdaFactory$(this));
            this.forceLinkFile.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.force_link_file", new Object[0])));
            Label expOutLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.export_output", new Object[0]));
            expOutLbl.setBounds(new Box(5, 160, 0, 0));
            this.addElement(expOutLbl);
            Label exportName = new Label(this.gui, this.gui.i18nFormat("label.cpm.no_file", new Object[0]));
            exportName.setBounds(new Box(5, 175, 0, 0));
            this.addElement(exportName);
            Button setOut = new Button(this.gui, "...", ExportPopup$Skin$$Lambda$4.lambdaFactory$(this, e, exportName));
            setOut.setBounds(new Box(150, 170, 25, 20));
            this.addElement(setOut);
            this.chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
            this.chbxClone.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
            this.chbxClone.setBounds(new Box(5, 105, 60, 20));
            this.addElement(this.chbxClone);
            Button btnEditDesc = new Button(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]), ExportPopup$Skin$$Lambda$5.lambdaFactory$(this, e));
            btnEditDesc.setBounds(new Box(90, 105, 85, 20));
            this.addElement(btnEditDesc);
            this.chbxUUIDLock = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uuidlock", new Object[0]));
            this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlock", MinecraftClientAccess$.get().getClientPlayer().getUUID().toString())));
            this.chbxUUIDLock.setBounds(new Box(5, 130, 60, 20));
            this.addElement(this.chbxUUIDLock);
            this.changeUUID = new Button(this.gui, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), new InputPopup(e, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), this.gui.i18nFormat("label.cpm.enterNewUUID", new Object[0]), ExportPopup$Skin$$Lambda$6.lambdaFactory$(this, editor, e), null));
            this.changeUUID.setBounds(new Box(90, 130, 85, 20));
            this.addElement(this.changeUUID);
            this.chbxClone.setAction(ExportPopup$Skin$$Lambda$7.lambdaFactory$(this));
            this.chbxUUIDLock.setAction(ExportPopup$Skin$$Lambda$8.lambdaFactory$(this));
            this.okDef = new Button(this.gui, this.gui.i18nFormat("button.cpm.export_def", new Object[0]), ExportPopup$Skin$$Lambda$9.lambdaFactory$(this));
            this.okDef.setBounds(new Box(90, this.bounds.h - 25, 80, 20));
            this.addElement(this.okDef);
            this.okUpload = new Button(this.gui, this.gui.i18nFormat("button.cpm.export.skin.exportApply", new Object[0]), ExportPopup$Skin$$Lambda$10.lambdaFactory$(this));
            this.okUpload.setBounds(new Box(175, this.bounds.h - 25, 100, 20));
            if (MinecraftClientAccess$.get().getServerSideStatus() != MinecraftClientAccess.ServerStatus.OFFLINE) {
                this.okUpload.setEnabled(false);
                this.okUpload.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.cantUploadIngame", new Object[0])));
            } else {
                this.okUpload.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.exportApply", new Object[0])));
            }
            this.addElement(this.okUpload);
            this.groupSkinType = new ButtonGroup(ExportPopup$Skin$$Lambda$11.lambdaFactory$(), ExportPopup$Skin$$Lambda$12.lambdaFactory$(), ExportPopup$Skin$$Lambda$13.lambdaFactory$(this));
            for (int j = 0; j < SkinType.VANILLA_TYPES.length; ++j) {
                SkinType s = SkinType.VANILLA_TYPES[j];
                Checkbox chbxSt = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.skin_type." + s.getName(), new Object[0]));
                chbxSt.setBounds(new Box(this.bounds.w - 135, this.bounds.y + 175 + j * 25, 60, 20));
                this.addElement(chbxSt);
                this.groupSkinType.addElement(s, chbxSt);
            }
            this.groupSkinType.accept(this.skinType);
            this.ok.setEnabled(false);
            this.ok.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.noFile", new Object[0])));
            this.detectLink();
            this.updateDesc();
            this.vanillaSkinTooltip = new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.vanillaSkinInfo", new Object[0]));
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + 14, 130, 130, this.gui.getColors().color_picker_border);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, -1);
            this.vanillaSkin.bind();
            this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
            if (event.isHovered(new Box(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128))) {
                this.vanillaSkinTooltip.set();
            }
        }

        private void updateDesc() {
            Editor editor = this.editorGui.getEditor();
            this.chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
            this.chbxUUIDLock.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            this.changeUUID.setEnabled(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            if (editor.description != null && editor.description.uuid != null) {
                this.chbxUUIDLock.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
            }
        }

        @Override
        public void onClosed() {
            this.vanillaSkin.free();
        }

        private void detectLink() {
            ModelPartLink link;
            ModelDefinition def = MinecraftClientAccess$.get().getDefinitionLoader().loadModel(this.editorGui.getEditor().vanillaSkin, MinecraftClientAccess$.get().getClientPlayer());
            boolean incompatibleDef = false;
            if (def != null && (link = def.findDefLink()) != null) {
                this.defLink = link.getLink();
                if (link instanceof ModelPartDefinitionLink == ModConfig.getCommonConfig().getBoolean("experimentalExport0614", false)) {
                    this.defLink = null;
                    incompatibleDef = true;
                }
            }
            this.okDef.setEnabled(this.defLink != null);
            if (this.defLink != null) {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def", new Object[0])));
            } else if (incompatibleDef) {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.incompatible", new Object[0])));
            } else {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.noLink", new Object[0])));
            }
        }

        @Override
        protected void export0() {
            Editor e = this.editorGui.getEditor();
            if (this.editorGui.getEditor().templateSettings != null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.templateExportAsSkin", new Object[0])));
                return;
            }
            if (e.description == null && (this.chbxClone.isSelected() || this.chbxUUIDLock.isSelected())) {
                e.description = new ModelDescription();
                e.markDirty();
            }
            if (e.description != null) {
                ModelDescription.CopyProtection cp;
                ModelDescription.CopyProtection copyProtection = this.chbxUUIDLock.isSelected() ? ModelDescription.CopyProtection.UUID_LOCK : (cp = this.chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : ModelDescription.CopyProtection.NORMAL);
                if (e.description.copyProtection != cp) {
                    e.description.copyProtection = cp;
                    e.markDirty();
                }
            }
            if (e.skinType != this.skinType) {
                if (e.elements.stream().anyMatch(ExportPopup$Skin$$Lambda$14.lambdaFactory$())) {
                    this.editorGui.openPopup(new ConfirmPopup(this.editorGui, this.gui.i18nFormat("label.cpm.confirmSkinTypeEdit", this.gui.i18nFormat("label.cpm.skin_type." + e.skinType.getName(), new Object[0]), this.gui.i18nFormat("label.cpm.skin_type." + this.skinType.getName(), new Object[0])), ExportPopup$Skin$$Lambda$15.lambdaFactory$(this, e), null));
                    return;
                }
                e.skinType = this.skinType;
                e.markDirty();
            }
            this.export1();
        }

        private void export1() {
            Editor e = this.editorGui.getEditor();
            if (this.gist) {
                Exporter.exportUpdate(e, this.gui, this.defLink);
            } else if (this.upload) {
                this.editorGui.openPopup(new ConfirmPopup(this.editorGui, this.gui.i18nFormat("label.cpm.export.upload", new Object[0]), this.gui.i18nFormat("label.cpm.export.upload.desc", new Object[0]), ExportPopup$Skin$$Lambda$16.lambdaFactory$(this, e), null));
            } else {
                Exporter.exportSkin(e, (UI)this.gui, this.selFile, this.forceLinkFile.isSelected());
            }
        }

        static /* synthetic */ void lambda$export1$18(Skin this_, Editor e) {
            Exporter.exportSkin(e, (UI)this_.gui, ExportPopup$Skin$$Lambda$17.lambdaFactory$(this_, e), this_.forceLinkFile.isSelected());
        }

        static /* synthetic */ void lambda$null$17(Skin this_, Editor e, Image img) throws IOException {
            new SkinUploadPopup(this_.editorGui, e.skinType, img).start();
        }

        static /* synthetic */ void lambda$export0$16(Skin this_, Editor e) {
            e.skinType = this_.skinType;
            e.markDirty();
            this_.export1();
        }

        static /* synthetic */ boolean lambda$export0$15(ModelElement m) {
            return !m.hidden;
        }

        static /* synthetic */ void lambda$new$14(Skin this_, SkinType i) {
            this_.skinType = i;
        }

        static /* synthetic */ void lambda$new$13(Skin this_) {
            this_.upload = true;
            this_.close();
            this_.export();
        }

        static /* synthetic */ void lambda$new$12(Skin this_) {
            if (this_.defLink != null) {
                this_.gist = true;
                this_.close();
                this_.export();
            }
        }

        static /* synthetic */ void lambda$new$11(Skin this_) {
            this_.changeUUID.setEnabled(!this_.chbxUUIDLock.isSelected());
            if (!this_.chbxUUIDLock.isSelected()) {
                this_.chbxUUIDLock.setSelected(true);
                this_.chbxClone.setSelected(false);
            } else {
                this_.chbxUUIDLock.setSelected(false);
            }
        }

        static /* synthetic */ void lambda$new$10(Skin this_) {
            if (!this_.chbxClone.isSelected()) {
                this_.chbxUUIDLock.setSelected(false);
                this_.chbxClone.setSelected(true);
                this_.changeUUID.setEnabled(false);
            } else {
                this_.chbxClone.setSelected(false);
            }
        }

        static /* synthetic */ void lambda$new$9(Skin this_, Editor editor, EditorGui e, String n) {
            if (editor.description == null) {
                editor.description = new ModelDescription();
            }
            try {
                editor.description.uuid = Util.uuidFromString(n);
                this_.chbxUUIDLock.setTooltip(new Tooltip(e, this_.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
            }
            catch (IllegalArgumentException ex) {
                e.openPopup(new MessagePopup(e, this_.gui.i18nFormat("label.cpm.error", new Object[0]), this_.gui.i18nFormat("label.cpm.invalidUUID", new Object[0])));
            }
        }

        static /* synthetic */ void lambda$new$8(Skin this_, EditorGui e) {
            e.openPopup(new DescPopup(e, false, ExportPopup$Skin$$Lambda$18.lambdaFactory$(this_)));
        }

        static /* synthetic */ void lambda$new$7(Skin this_, EditorGui e, Label exportName) {
            FileChooserPopup fc = new FileChooserPopup(e);
            fc.setTitle(EmbeddedLocalizations.exportSkin);
            fc.setFileDescText(EmbeddedLocalizations.filePng);
            fc.setFilter(new FileChooserPopup.FileFilter("png"));
            fc.setSaveDialog(true);
            fc.setExtAdder(ExportPopup$Skin$$Lambda$19.lambdaFactory$());
            fc.setAccept(ExportPopup$Skin$$Lambda$20.lambdaFactory$(this_, exportName));
            fc.setButtonText(this_.gui.i18nFormat("button.cpm.ok", new Object[0]));
            e.openPopup(fc);
        }

        static /* synthetic */ void lambda$null$6(Skin this_, Label exportName, File f) {
            this_.selFile = f;
            this_.ok.setEnabled(true);
            this_.ok.setTooltip(null);
            exportName.setText(f.getName());
        }

        static /* synthetic */ String lambda$null$5(String n) {
            return n + ".png";
        }

        static /* synthetic */ void lambda$new$4(Skin this_) {
            this_.forceLinkFile.setSelected(!this_.forceLinkFile.isSelected());
        }

        static /* synthetic */ void lambda$new$3(Skin this_, EditorGui e, Editor editor) {
            SelectSkinPopup ssp = new SelectSkinPopup(e, this_.skinType, ExportPopup$Skin$$Lambda$21.lambdaFactory$(this_, editor));
            ssp.setOnClosed(ExportPopup$Skin$$Lambda$22.lambdaFactory$(editor));
            e.openPopup(ssp);
            editor.displayViewport.accept(false);
        }

        static /* synthetic */ void lambda$null$2(Editor editor) {
            editor.displayViewport.accept(true);
        }

        static /* synthetic */ void lambda$null$1(Skin this_, Editor editor, SkinType type, Image img) {
            this_.skinType = type;
            this_.groupSkinType.accept(type);
            editor.vanillaSkin = img;
            this_.vanillaSkin.setImage(img);
            this_.detectLink();
        }

        static /* synthetic */ void lambda$new$0(Skin this_, EditorGui e, Editor editor) {
            EditorTexture editorTexture = this_.vanillaSkin;
            editorTexture.getClass();
            e.openPopup(new AnimEncConfigPopup(this_.gui, editor, ExportPopup$Skin$$Lambda$23.lambdaFactory$(editorTexture)));
        }

        static /* synthetic */ void access$lambda$0(Skin skin) {
            skin.updateDesc();
        }
    }

    private static enum ExportMode {
        SKIN(ExportPopup$ExportMode$$Lambda$1.lambdaFactory$(), ExportPopup$ExportMode$$Lambda$2.lambdaFactory$().negate()),
        MODEL(ExportPopup$ExportMode$$Lambda$3.lambdaFactory$(), ExportPopup$ExportMode$$Lambda$4.lambdaFactory$().negate()),
        B64(ExportPopup$ExportMode$$Lambda$5.lambdaFactory$(), ExportPopup$ExportMode$$Lambda$6.lambdaFactory$().negate()),
        TEMPLATE(ExportPopup$ExportMode$$Lambda$7.lambdaFactory$(), ExportPopup$ExportMode$$Lambda$8.lambdaFactory$());

        public static final ExportMode[] VALUES;
        private Function<EditorGui, ExportPopup> factory;
        private Predicate<Editor> canDisplay;

        private ExportMode(Function<EditorGui, ExportPopup> factory, Predicate<Editor> canDisplay) {
            this.factory = factory;
            this.canDisplay = canDisplay;
        }

        static {
            VALUES = ExportMode.values();
        }
    }
}

