/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Direction;
import com.tom.cpl.util.EmbeddedLocalizations;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.elements.MultiSelector;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$1;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$10;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$11;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$12;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$13;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$2;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$3;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$4;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$5;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$6;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$7;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$8;
import com.tom.cpm.shared.editor.gui.popup.ExportUVMapPopup$$Lambda$9;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.util.OpenRasterFile;
import com.tom.cpm.shared.model.render.PerFaceUV;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpm.shared.util.Log;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

public class ExportUVMapPopup
extends PopupPanel {
    private EditorGui eg;
    private Checkbox layeredExport;
    private Checkbox onlySelected;

    public ExportUVMapPopup(EditorGui eg) {
        super(eg.getGui());
        this.eg = eg;
        this.setBounds(new Box(0, 0, 200, 80));
        this.layeredExport = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uvexport.layered", new Object[0]));
        this.layeredExport.setBounds(new Box(5, 5, 190, 20));
        this.layeredExport.setSelected(true);
        this.layeredExport.setAction(ExportUVMapPopup$$Lambda$1.lambdaFactory$(this));
        this.layeredExport.setTooltip(new Tooltip(eg, this.gui.i18nFormat("tooltip.cpm.uvexport.layered", new Object[0])));
        this.addElement(this.layeredExport);
        this.onlySelected = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uvexport.selected", new Object[0]));
        this.onlySelected.setBounds(new Box(5, 30, 190, 20));
        this.onlySelected.setAction(ExportUVMapPopup$$Lambda$2.lambdaFactory$(this));
        this.addElement(this.onlySelected);
        String okTxt = this.gui.i18nFormat("button.cpm.ok", new Object[0]);
        String cancelTxt = this.gui.i18nFormat("button.cpm.cancel", new Object[0]);
        Button btn = new Button(this.gui, okTxt, ExportUVMapPopup$$Lambda$3.lambdaFactory$(this));
        Button btnNo = new Button(this.gui, cancelTxt, ExportUVMapPopup$$Lambda$4.lambdaFactory$(this));
        btn.setBounds(new Box(5, 55, 25 + this.gui.textWidth(okTxt), 20));
        btnNo.setBounds(new Box(35 + this.gui.textWidth(okTxt), 55, 25 + this.gui.textWidth(cancelTxt), 20));
        this.addElement(btn);
        this.addElement(btnNo);
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.tools.exportUVMap", new Object[0]);
    }

    private void exportUVMapLayers() {
        Set<ModelElement> me = this.onlySelected.isSelected() ? this.getSelected() : null;
        FileChooserPopup fc = new FileChooserPopup(this.eg);
        fc.setTitle(EmbeddedLocalizations.exportUV);
        fc.setFileDescText(EmbeddedLocalizations.fileOra);
        fc.setFilter(new FileChooserPopup.FileFilter("ora"));
        fc.setSaveDialog(true);
        fc.setExtAdder(ExportUVMapPopup$$Lambda$5.lambdaFactory$());
        fc.setAccept(ExportUVMapPopup$$Lambda$6.lambdaFactory$(this, me));
        fc.setButtonText(this.eg.getGui().i18nFormat("button.cpm.ok", new Object[0]));
        this.eg.openPopup(fc);
    }

    private void exportUVMapPNG() {
        Set<ModelElement> me = this.onlySelected.isSelected() ? this.getSelected() : null;
        FileChooserPopup fc = new FileChooserPopup(this.eg);
        fc.setTitle(EmbeddedLocalizations.exportUV);
        fc.setFileDescText(EmbeddedLocalizations.filePng);
        fc.setFilter(new FileChooserPopup.FileFilter("png"));
        fc.setSaveDialog(true);
        fc.setExtAdder(ExportUVMapPopup$$Lambda$7.lambdaFactory$());
        fc.setAccept(ExportUVMapPopup$$Lambda$8.lambdaFactory$(this, me));
        fc.setButtonText(this.eg.getGui().i18nFormat("button.cpm.ok", new Object[0]));
        this.eg.openPopup(fc);
    }

    private void exportUVMapLayers(File out, Set<ModelElement> sel) {
        CompletionStage cf;
        Editor editor = this.eg.getEditor();
        ETextures tex = editor.getTextureProvider();
        if (tex == null) {
            return;
        }
        OpenRasterFile o = new OpenRasterFile(tex.provider.getImage().getWidth(), tex.provider.getImage().getHeight());
        o.addLayer(0, tex.getTexture().provider.getImage(), 0, 0, "current");
        OpenRasterFile.Stack st = o.addStack("UVMap", 1);
        for (int i = 0; i < editor.elements.size(); ++i) {
            ModelElement m = editor.elements.get(i);
            OpenRasterFile.Stack s = st.addStack(m.getName(), i + 1);
            this.exportUVMapLayers(tex, m, s, sel);
        }
        editor.setInfoMsg.accept(Pair.of(200000, this.eg.getGui().i18nFormat("tooltip.cpm.saving", out.getName())));
        try {
            CompletableFuture<Void> completableFuture = o.write(out);
            Runnable runnable = ExportUVMapPopup$$Lambda$9.lambdaFactory$(this, editor, out);
            IGui iGui = this.eg.getGui();
            iGui.getClass();
            cf = completableFuture.thenRunAsync(runnable, ExportUVMapPopup$$Lambda$10.lambdaFactory$(iGui));
        }
        catch (Exception e) {
            cf = new CompletableFuture();
            cf.completeExceptionally(e);
        }
        BiFunction biFunction = ExportUVMapPopup$$Lambda$11.lambdaFactory$(this, editor);
        IGui iGui = this.eg.getGui();
        iGui.getClass();
        cf.handleAsync(biFunction, ExportUVMapPopup$$Lambda$12.lambdaFactory$(iGui));
    }

    private void exportUVMap(File out, Set<ModelElement> sel) {
        Editor editor = this.eg.getEditor();
        ETextures tex = editor.getTextureProvider();
        if (tex == null) {
            return;
        }
        Image res = new Image(tex.provider.getImage().getWidth(), tex.provider.getImage().getHeight());
        for (int i = 0; i < editor.elements.size(); ++i) {
            ModelElement m = editor.elements.get(i);
            this.exportUVMap(tex, m, res, sel);
        }
        editor.setInfoMsg.accept(Pair.of(200000, this.eg.getGui().i18nFormat("tooltip.cpm.saving", out.getName())));
        try {
            ImageIO.write(res, out);
            editor.setInfoMsg.accept(Pair.of(2000, this.eg.getGui().i18nFormat("tooltip.cpm.saveSuccess", out.getName())));
        }
        catch (Exception e) {
            Log.warn("Error exporting UV map", e);
            ErrorLog.addFormattedLog(ErrorLog.LogLevel.ERROR, "label.cpm.error.save", e, new Object[0]);
            this.eg.openPopup(new MessagePopup(this.eg, this.eg.getGui().i18nFormat("label.cpm.error.save", new Object[0]), e.toString()));
            editor.setInfoMsg.accept(Pair.of(0, ""));
        }
    }

    private Set<ModelElement> getSelected() {
        HashSet<ModelElement> me = new HashSet<ModelElement>();
        TreeElement te = this.eg.getEditor().selectedElement;
        if (te instanceof MultiSelector) {
            ((MultiSelector)te).forEachSelected(ExportUVMapPopup$$Lambda$13.lambdaFactory$(me));
        } else {
            ModelElement m = this.eg.getEditor().getSelectedElement();
            if (m != null) {
                me.add(m);
            }
        }
        return me;
    }

    private void exportUVMapLayers(ETextures tex, ModelElement me, OpenRasterFile.Stack st, Set<ModelElement> sel) {
        boolean inc;
        boolean bl = inc = sel == null || sel.contains(me);
        if (inc && me.type == ElementType.NORMAL && me.texture) {
            Image img;
            if (me.faceUV != null) {
                OpenRasterFile.Stack pf = st.addStack("Per-Face", 0);
                for (Direction d : Direction.VALUES) {
                    PerFaceUV.Face f = me.faceUV.get(d);
                    if (f == null) continue;
                    Box box = Box.fromArea(f.sx, f.sy, f.ex, f.ey);
                    if (box.w == 0 || box.h == 0) continue;
                    img = new Image(box.w, box.h);
                    img.fill(0, 0, box.w, box.h, -7829368);
                    pf.addLayer(d.ordinal(), img, box.x, box.y, d.name());
                }
            } else {
                Box box = me.getTextureBox();
                if (box.w != 0 && box.h != 0) {
                    int ts = Math.abs(me.texSize);
                    int bx = me.u * ts;
                    int by = me.v * ts;
                    int dx = MathHelper.ceil(me.size.x * (float)ts);
                    int dy = MathHelper.ceil(me.size.y * (float)ts);
                    int dz = MathHelper.ceil(me.size.z * (float)ts);
                    img = new Image(box.w, box.h);
                    img.fill(dx + dz, dz, dz, dy, -65536);
                    img.fill(0, dz, dz, dy, -2293760);
                    img.fill(dz, 0, dx, dz, -16711936);
                    img.fill(dz + dx, 0, dx, dz, -16720640);
                    img.fill(dz, dz, dx, dy, -16776961);
                    img.fill(dz * 2 + dx, dz, dx, dy, -16776995);
                    st.addLayer(0, img, bx, by, me.getName());
                }
            }
        }
        for (int i = 0; i < me.children.size(); ++i) {
            ModelElement m = me.children.get(i);
            OpenRasterFile.Stack s = st.addStack(m.getName(), i + 1);
            this.exportUVMapLayers(tex, m, s, sel);
        }
    }

    private void exportUVMap(ETextures tex, ModelElement me, Image img, Set<ModelElement> sel) {
        boolean inc;
        boolean bl = inc = sel == null || sel.contains(me);
        if (inc && me.type == ElementType.NORMAL && me.texture) {
            if (me.faceUV != null) {
                for (Direction d : Direction.VALUES) {
                    PerFaceUV.Face f = me.faceUV.get(d);
                    if (f == null) continue;
                    Box box = Box.fromArea(f.sx, f.sy, f.ex, f.ey);
                    if (box.w == 0 || box.h == 0) continue;
                    img.fill(box.x, box.y, box.w, box.h, -7829368);
                }
            } else {
                Box box = me.getTextureBox();
                if (box.w != 0 && box.h != 0) {
                    int ts = Math.abs(me.texSize);
                    int bx = me.u * ts;
                    int by = me.v * ts;
                    int dx = MathHelper.ceil(me.size.x * (float)ts);
                    int dy = MathHelper.ceil(me.size.y * (float)ts);
                    int dz = MathHelper.ceil(me.size.z * (float)ts);
                    img.fill(bx + dx + dz, by + dz, dz, dy, -65536);
                    img.fill(bx, by + dz, dz, dy, -2293760);
                    img.fill(bx + dz, by, dx, dz, -16711936);
                    img.fill(bx + dz + dx, by, dx, dz, -16720640);
                    img.fill(bx + dz, by + dz, dx, dy, -16776961);
                    img.fill(bx + dz * 2 + dx, by + dz, dx, dy, -16776995);
                }
            }
        }
        for (int i = 0; i < me.children.size(); ++i) {
            ModelElement m = me.children.get(i);
            this.exportUVMap(tex, m, img, sel);
        }
    }

    static /* synthetic */ void lambda$getSelected$9(Set me, TreeElement t) {
        if (t instanceof ModelElement) {
            me.add((ModelElement)t);
        }
    }

    static /* synthetic */ Object lambda$exportUVMapLayers$8(ExportUVMapPopup this_, Editor editor, Void v, Throwable e) {
        if (e != null) {
            Log.warn("Error exporting UV map", e);
            ErrorLog.addFormattedLog(ErrorLog.LogLevel.ERROR, "label.cpm.error.save", e, new Object[0]);
            this_.eg.openPopup(new MessagePopup(this_.eg, this_.eg.getGui().i18nFormat("label.cpm.error.save", new Object[0]), e.toString()));
            editor.setInfoMsg.accept(Pair.of(0, ""));
            return null;
        }
        return null;
    }

    static /* synthetic */ void lambda$exportUVMapLayers$7(ExportUVMapPopup this_, Editor editor, File out) {
        editor.setInfoMsg.accept(Pair.of(2000, this_.eg.getGui().i18nFormat("tooltip.cpm.saveSuccess", out.getName())));
    }

    static /* synthetic */ void lambda$exportUVMapPNG$6(ExportUVMapPopup this_, Set me, File f) {
        this_.exportUVMap(f, me);
    }

    static /* synthetic */ String lambda$exportUVMapPNG$5(String n) {
        return n + ".png";
    }

    static /* synthetic */ void lambda$exportUVMapLayers$4(ExportUVMapPopup this_, Set me, File f) {
        this_.exportUVMapLayers(f, me);
    }

    static /* synthetic */ String lambda$exportUVMapLayers$3(String n) {
        return n + ".ora";
    }

    static /* synthetic */ void lambda$new$2(ExportUVMapPopup this_) {
        this_.close();
        if (this_.layeredExport.isSelected()) {
            this_.exportUVMapLayers();
        } else {
            this_.exportUVMapPNG();
        }
    }

    static /* synthetic */ void lambda$new$1(ExportUVMapPopup this_) {
        this_.onlySelected.setSelected(!this_.onlySelected.isSelected());
    }

    static /* synthetic */ void lambda$new$0(ExportUVMapPopup this_) {
        this_.layeredExport.setSelected(!this_.layeredExport.isSelected());
    }
}

