/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.EmbeddedLocalization;
import com.tom.cpl.util.MarkdownRenderer;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.editor.gui.popup.FirstStartPopup;
import com.tom.cpm.shared.editor.gui.popup.WikiBrowserPopup$$Lambda$1;
import com.tom.cpm.shared.editor.gui.popup.WikiBrowserPopup$$Lambda$2;
import com.tom.cpm.shared.editor.gui.popup.WikiBrowserPopup$$Lambda$3;
import com.tom.cpm.shared.editor.gui.popup.WikiBrowserPopup$$Lambda$4;
import com.tom.cpm.shared.editor.gui.popup.WikiBrowserPopup$$Lambda$5;
import com.tom.cpm.shared.editor.gui.popup.WikiBrowserPopup$$Lambda$6;
import com.tom.cpm.shared.util.MdResourceLoader;
import java.util.Stack;
import java.util.regex.Matcher;

public class WikiBrowserPopup
extends PopupPanel {
    private Stack<String> backQueue = new Stack();
    private Stack<String> fwdQueue = new Stack();
    private boolean stepping = false;
    private Button back;
    private Button fwd;
    private Button openSidebar;
    private MarkdownRenderer content;
    private SidebarContent sidebar;
    private static final int SIDEBAR_W = 100;
    private String sidebarLocale;

    public WikiBrowserPopup(IGui gui) {
        this(gui, EmbeddedLocalization.getLocalizedWikiPage(gui, "https://github.com/tom5454/CustomPlayerModels/wiki/Home"));
    }

    public WikiBrowserPopup(IGui gui, String mainPage) {
        super(gui);
        this.back = new Button(gui, "<", WikiBrowserPopup$$Lambda$1.lambdaFactory$(this));
        this.back.setBounds(new Box(5, 5, 20, 20));
        this.addElement(this.back);
        this.fwd = new Button(gui, ">", WikiBrowserPopup$$Lambda$2.lambdaFactory$(this));
        this.fwd.setBounds(new Box(25, 5, 20, 20));
        this.addElement(this.fwd);
        this.fwd.setEnabled(false);
        this.back.setEnabled(false);
        boolean offline = ModConfig.getCommonConfig().getBoolean("wikiOfflineMode", false);
        IGui iGui = gui;
        iGui.getClass();
        this.content = new MarkdownRenderer(gui, (MarkdownRenderer.MarkdownResourceLoader)new MdResourceLoader(WikiBrowserPopup$$Lambda$3.lambdaFactory$(iGui), WikiBrowserPopup$$Lambda$4.lambdaFactory$(this, gui), offline), "Loading");
        this.content.setBounds(new Box(0, 0, 100, 100));
        this.addElement(this.content);
        IGui iGui2 = gui;
        iGui2.getClass();
        this.sidebar = new SidebarContent(gui, new MdResourceLoader(WikiBrowserPopup$$Lambda$5.lambdaFactory$(iGui2), null, offline), "Loading");
        this.sidebar.setBounds(new Box(0, 0, 100, 100));
        this.sidebarLocale = "unknown";
        this.content.browse(mainPage);
        this.openSidebar = new Button(gui, gui.i18nFormat("button.cpm.openWikiSidebar", new Object[0]), null){

            @Override
            public void mouseClick(MouseEvent evt) {
                if (this.enabled && evt.isHovered(this.bounds)) {
                    Vec2i p = evt.getPos();
                    this.gui.getFrame().openPopup(new SidebarPopup(p.x - evt.x + this.bounds.x + this.bounds.w, p.y - evt.y + this.bounds.h + this.bounds.y));
                    evt.consume();
                }
            }
        };
        this.addElement(this.openSidebar);
        Button openExt = new Button(gui, gui.i18nFormat("button.cpm.openWikiExt", new Object[0]), WikiBrowserPopup$$Lambda$6.lambdaFactory$(this, gui));
        openExt.setBounds(new Box(50, 5, 100, 20));
        this.addElement(openExt);
        this.onInit();
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.wiki.title", new Object[0]);
    }

    @Override
    public void onInit() {
        Box b = this.gui.getFrame().getBounds();
        int w = b.w * 2 / 3;
        int h = b.h * 2 / 3;
        this.setBounds(new Box(0, 0, w, h));
        this.remove(this.sidebar);
        if (w < 500) {
            this.sidebar.setBounds(new Box(5, 5, 100, h - 30));
            this.content.setBounds(new Box(5, 30, w - 10, h - 35));
            this.openSidebar.setVisible(true);
            this.openSidebar.setBounds(new Box(w - 45, 5, 40, 20));
        } else {
            this.addElement(this.sidebar);
            this.sidebar.setBounds(new Box(w - 100 - 5, 30, 100, h - 35));
            this.content.setBounds(new Box(5, 30, w - 100 - 15, h - 35));
            this.openSidebar.setVisible(false);
            this.openSidebar.setBounds(new Box(0, 0, 0, 0));
        }
    }

    @Override
    public void onClosed() {
        this.content.cleanup();
        this.sidebar.cleanup();
    }

    static /* synthetic */ void lambda$new$3(WikiBrowserPopup this_, IGui gui) {
        String p = this_.backQueue.peek();
        if (p.endsWith(".md")) {
            p = p.substring(0, p.length() - 3);
        }
        gui.openURL(p);
    }

    static /* synthetic */ void lambda$new$2(WikiBrowserPopup this_, IGui gui, String u) {
        Matcher m;
        if (!this_.stepping) {
            if (u.startsWith("https://github.com/tom5454/CustomPlayerModels/wiki/FirstStartGuide")) {
                this_.close();
                gui.getFrame().openPopup(new FirstStartPopup(gui));
                return;
            }
            this_.backQueue.push(u);
            this_.fwdQueue.clear();
            this_.fwd.setEnabled(false);
            this_.back.setEnabled(this_.backQueue.size() > 1);
        }
        if ((m = MdResourceLoader.LOCALE_EXT.matcher(u)).matches()) {
            String s = m.group(2);
            if (!s.equals(this_.sidebarLocale)) {
                this_.sidebarLocale = s;
                this_.sidebar.setContent("https://github.com/tom5454/CustomPlayerModels/wiki/_Sidebar-" + this_.sidebarLocale);
            }
        } else if (this_.sidebarLocale != null) {
            this_.sidebarLocale = null;
            this_.sidebar.setContent("https://github.com/tom5454/CustomPlayerModels/wiki/_Sidebar");
        }
    }

    static /* synthetic */ void lambda$new$1(WikiBrowserPopup this_) {
        if (!this_.fwdQueue.isEmpty()) {
            this_.stepping = true;
            String n = this_.fwdQueue.pop();
            this_.backQueue.push(n);
            this_.content.browse(n);
            this_.stepping = false;
            this_.back.setEnabled(true);
            this_.fwd.setEnabled(!this_.fwdQueue.isEmpty());
        }
    }

    static /* synthetic */ void lambda$new$0(WikiBrowserPopup this_) {
        if (this_.backQueue.size() > 1) {
            this_.stepping = true;
            String c = this_.backQueue.pop();
            String p = this_.backQueue.peek();
            this_.fwdQueue.push(c);
            this_.content.browse(p);
            this_.stepping = false;
            this_.back.setEnabled(this_.backQueue.size() > 1);
            this_.fwd.setEnabled(true);
        }
    }

    private class SidebarContent
    extends MarkdownRenderer {
        public SidebarContent(IGui gui, MarkdownRenderer.MarkdownResourceLoader loader, String in) {
            super(gui, loader, in);
        }

        @Override
        public void browse(String url) {
            WikiBrowserPopup.this.content.browse(url);
        }

        public void setContent(String url) {
            super.browse(url);
        }
    }

    private class SidebarPopup
    extends PopupPanel {
        private boolean close;
        private boolean shouldClose;

        private SidebarPopup(int x, int y) {
            super(WikiBrowserPopup.this.gui);
            Box b = WikiBrowserPopup.this.sidebar.getBounds();
            this.setBounds(new Box(x - b.w - 10, y, b.w + 10, b.h + 10));
            this.addElement(WikiBrowserPopup.this.sidebar);
        }

        @Override
        public boolean hasDecoration() {
            return false;
        }

        @Override
        public void mouseRelease(MouseEvent event) {
            super.mouseRelease(event);
            if (this.shouldClose) {
                this.close();
            } else {
                this.shouldClose = true;
            }
        }

        @Override
        public void onInit() {
            this.close = true;
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            if (this.close) {
                this.close();
            } else {
                super.draw(event, partialTicks);
            }
        }
    }
}

