/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project;

import com.tom.cpl.util.ThrowingConsumer;
import com.tom.cpl.util.ThrowingFunction;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.IProject$;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectFile$$Lambda$1;
import com.tom.cpm.shared.editor.project.ProjectFile$$Lambda$2;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ProjectFile
implements IProject {
    private Entry root = new Entry();

    public ProjectFile() {
        this.root.children = new HashMap();
    }

    public boolean setEntry(String path, byte[] data) {
        Entry e = this.root;
        for (String nm : path.split("/")) {
            if (e.data != null) {
                return false;
            }
            if (e.children == null) {
                e.children = new HashMap();
            }
            e = (Entry)e.children.computeIfAbsent(nm, ProjectFile$$Lambda$1.lambdaFactory$());
        }
        Entry.access$202(e, data);
        return true;
    }

    @Override
    public byte[] getEntry(String path) {
        Entry e = this.root;
        for (String nm : path.split("/")) {
            if ((e = (Entry)e.children.get(nm)) != null) continue;
            return null;
        }
        return e.data;
    }

    @Override
    public List<String> listEntires(String path) {
        Entry e = this.root;
        if (!path.isEmpty()) {
            for (String nm : path.split("/")) {
                if ((e = (Entry)e.children.get(nm)) != null) continue;
                return null;
            }
        }
        return e.children == null ? null : new ArrayList(e.children.keySet());
    }

    public void delete(String path) {
        Entry e = this.root;
        String[] t = path.split("/");
        for (int i = 0; i < t.length - 1; ++i) {
            if ((e = (Entry)e.children.get(t[i])) != null) continue;
            return;
        }
        if (e.children != null) {
            e.children.remove(t[t.length - 1]);
        }
    }

    public void clearFolder(String path) {
        Entry e = this.root;
        for (String nm : path.split("/")) {
            if ((e = (Entry)e.children.get(nm)) != null) continue;
            return;
        }
        if (e.children != null) {
            e.children.clear();
        }
    }

    public OutputStream setAsStream(final String path) throws IOException {
        if (!this.setEntry(path, new byte[0])) {
            throw new FileNotFoundException();
        }
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                if (!ProjectFile.this.setEntry(path, this.toByteArray())) {
                    throw new FileNotFoundException();
                }
            }
        };
    }

    public CompletableFuture<Void> load(File file) {
        try {
            this.root = new Entry();
            this.root.children = new HashMap();
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
            Throwable throwable = null;
            try {
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    String fileName = ze.getName();
                    if (fileName.endsWith("/")) {
                        fileName = fileName.substring(0, fileName.length() - 1);
                    }
                    Entry e = this.root;
                    for (String nm : fileName.split("/")) {
                        if (e.children == null) {
                            e.children = new HashMap();
                        }
                        e = (Entry)e.children.computeIfAbsent(nm, ProjectFile$$Lambda$2.lambdaFactory$());
                    }
                    if (ze.isDirectory()) {
                        e.children = new HashMap();
                    } else {
                        int len;
                        ByteArrayOutputStream fos = new ByteArrayOutputStream();
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        Entry.access$202(e, fos.toByteArray());
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (zis != null) {
                    if (throwable != null) {
                        try {
                            zis.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        zis.close();
                    }
                }
            }
        }
        catch (IOException e) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(e);
            return f;
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> save(File file) {
        try {
            LinkedList<ZEntry> queue = new LinkedList<ZEntry>();
            queue.push(new ZEntry(this.root, ""));
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(file));
            Throwable throwable = null;
            try {
                while (!queue.isEmpty()) {
                    ZEntry directory = (ZEntry)queue.pop();
                    for (Map.Entry e : directory.entry.children.entrySet()) {
                        String path = directory.path + "/" + (String)e.getKey();
                        if (((Entry)e.getValue()).children != null) {
                            queue.push(new ZEntry((Entry)e.getValue(), path));
                            zout.putNextEntry(new ZipEntry(path.substring(1) + "/"));
                            continue;
                        }
                        zout.putNextEntry(new ZipEntry(path.substring(1)));
                        zout.write(((Entry)e.getValue()).data);
                        zout.closeEntry();
                    }
                }
                zout.closeEntry();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (zout != null) {
                    if (throwable != null) {
                        try {
                            zout.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        zout.close();
                    }
                }
            }
        }
        catch (IOException e) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(e);
            return f;
        }
        return CompletableFuture.completedFuture(null);
    }

    static /* synthetic */ Entry lambda$load$1(String k) {
        return new Entry();
    }

    static /* synthetic */ Entry lambda$setEntry$0(String k) {
        return new Entry();
    }

    @Override
    public InputStream getAsStream(String string) {
        return IProject$.getAsStream(this, string);
    }

    public Object getIfExists(String string, ThrowingFunction throwingFunction) {
        return IProject$.getIfExists(this, string, throwingFunction);
    }

    @Override
    public JsonMap toJson(InputStreamReader inputStreamReader) {
        return IProject$.toJson(this, inputStreamReader);
    }

    @Override
    public JsonMap getJson(String string) {
        return IProject$.getJson(this, string);
    }

    public void ifExists(String string, ThrowingFunction throwingFunction, Consumer consumer) {
        IProject$.ifExists(this, string, throwingFunction, consumer);
    }

    public void jsonIfExists(String string, ThrowingConsumer throwingConsumer) {
        IProject$.jsonIfExists(this, string, throwingConsumer);
    }

    private static class ZEntry {
        private Entry entry;
        private String path;

        public ZEntry(Entry entry, String path) {
            this.entry = entry;
            this.path = path;
        }
    }

    private static class Entry {
        private Map<String, Entry> children;
        private byte[] data;

        private Entry() {
        }

        public String toString() {
            return this.data != null ? "Data" : this.children.toString();
        }

        static /* synthetic */ byte[] access$202(Entry x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }
}

