/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project.loaders;

import com.tom.cpl.math.Vec3f;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectPartLoader;
import com.tom.cpm.shared.editor.project.ProjectPartLoader$;
import com.tom.cpm.shared.editor.project.ProjectWriter;
import com.tom.cpm.shared.editor.project.loaders.DescriptionLoaderV1$$Lambda$1;
import com.tom.cpm.shared.editor.project.loaders.DescriptionLoaderV1$$Lambda$2;
import com.tom.cpm.shared.editor.project.loaders.DescriptionLoaderV1$$Lambda$3;
import com.tom.cpm.shared.editor.project.loaders.DescriptionLoaderV1$$Lambda$4;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.util.Log;
import java.io.IOException;
import java.util.Locale;

public class DescriptionLoaderV1
implements ProjectPartLoader {
    @Override
    public String getId() {
        return "desc";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void load(Editor editor, IProject project) throws IOException {
        project.jsonIfExists("description.json", DescriptionLoaderV1$$Lambda$1.lambdaFactory$(this, editor));
        project.ifExists("desc_icon.png", DescriptionLoaderV1$$Lambda$2.lambdaFactory$(), DescriptionLoaderV1$$Lambda$3.lambdaFactory$(this, editor));
    }

    @Override
    public void save(Editor editor, ProjectWriter project) throws IOException {
        if (editor.description != null) {
            JsonMap data = project.getJson("description.json");
            data.put("name", editor.description.name);
            data.put("desc", editor.description.desc);
            JsonMap map = data.putMap("cam");
            map.put("zoom", Float.valueOf(editor.description.camera.camDist));
            map.put("look", editor.description.camera.look.toMap());
            map.put("pos", editor.description.camera.position.toMap());
            map.put("copyProt", editor.description.copyProtection.name().toLowerCase(Locale.ROOT));
            if (editor.description.icon != null) {
                project.putFile("desc_icon.png", editor.description.icon, DescriptionLoaderV1$$Lambda$4.lambdaFactory$());
            }
        }
    }

    protected void loadDesc(Editor editor, JsonMap data) {
        editor.description = new ModelDescription();
        editor.description.name = data.getString("name");
        editor.description.desc = data.getString("desc");
        JsonMap map = data.getMap("cam");
        editor.description.camera.camDist = map.getFloat("zoom");
        editor.description.camera.look = new Vec3f(map.getMap("look"), editor.description.camera.look);
        editor.description.camera.position = new Vec3f(map.getMap("pos"), editor.description.camera.position);
        editor.description.copyProtection = ModelDescription.CopyProtection.lookup(map.getString("copyProt", "normal"));
    }

    protected void loadIcon(Editor editor, Image img) {
        if (editor.description == null) {
            editor.description = new ModelDescription();
        }
        editor.description.icon = img;
        if (editor.description.icon.getWidth() != 256 || editor.description.icon.getHeight() != 256) {
            editor.description.icon = null;
            Log.error("Illegal image size for model/template icon must be 256x256");
        }
    }

    static /* synthetic */ void lambda$load$1(DescriptionLoaderV1 this_, Editor editor, Image img) {
        this_.loadIcon(editor, img);
    }

    static /* synthetic */ void lambda$load$0(DescriptionLoaderV1 this_, Editor editor, JsonMap data) throws RuntimeException {
        this_.loadDesc(editor, data);
    }

    @Override
    public int getLoadOrder() {
        return ProjectPartLoader$.getLoadOrder(this);
    }
}

