/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project.loaders;

import com.tom.cpl.math.Rotation;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectPartLoader;
import com.tom.cpm.shared.editor.project.ProjectPartLoader$;
import com.tom.cpm.shared.editor.project.ProjectWriter;
import com.tom.cpm.shared.editor.project.loaders.PropertiesLoaderV1$$Lambda$1;
import com.tom.cpm.shared.model.PartPosition;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.util.ScalingOptions;
import java.io.IOException;
import java.util.Locale;

public class PropertiesLoaderV1
implements ProjectPartLoader {
    @Override
    public String getId() {
        return "prop";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void load(Editor editor, IProject project) throws IOException {
        JsonMap fpHand;
        JsonMap data = project.getJson("config.json");
        if (data.containsKey("skinType")) {
            editor.customSkinType = true;
            editor.skinType = SkinType.get(data.getString("skinType"));
        }
        editor.hideHeadIfSkull = data.getBoolean("hideHeadIfSkull", true);
        editor.removeArmorOffset = data.getBoolean("removeArmorOffset", !editor.elements.stream().anyMatch(PropertiesLoaderV1$$Lambda$1.lambdaFactory$()));
        float defScaling = data.getFloat("scaling", 0.0f);
        editor.scalingElem.enabled = defScaling != 0.0f;
        editor.scalingElem.scaling.put(ScalingOptions.ENTITY, Float.valueOf(defScaling));
        JsonMap scaling = data.getMap("scalingEx");
        if (scaling != null) {
            for (ScalingOptions opt : ScalingOptions.VALUES) {
                float v;
                if (opt == ScalingOptions.ENTITY || (v = scaling.getFloat(opt.name().toLowerCase(Locale.ROOT), 0.0f)) == 0.0f) continue;
                editor.scalingElem.scaling.put(opt, Float.valueOf(v));
            }
            editor.scalingElem.pos = new Vec3f(scaling.getMap("render_position"), new Vec3f());
            editor.scalingElem.rotation = new Vec3f(scaling.getMap("render_rotation"), new Vec3f());
            editor.scalingElem.scale = new Vec3f(scaling.getMap("render_scale"), new Vec3f());
        }
        if ((fpHand = data.getMap("firstPersonHand")) != null) {
            editor.leftHandPos = PropertiesLoaderV1.loadPartPos(fpHand, "left");
            editor.rightHandPos = PropertiesLoaderV1.loadPartPos(fpHand, "right");
        }
        if (data.containsKey("modelId")) {
            editor.modelId = data.getString("modelId");
        }
        editor.removeBedOffset = data.getBoolean("removeBedOffset", false);
        editor.enableInvisGlow = data.getBoolean("enableInvisGlow", false);
    }

    protected static PartPosition loadPartPos(JsonMap fpHand, String name) {
        PartPosition p = new PartPosition();
        JsonMap map = fpHand.getMap(name);
        if (map != null) {
            Vec3f pos = new Vec3f(map.getMap("position"), new Vec3f());
            Vec3f rotation = new Vec3f(map.getMap("rotation"), new Vec3f());
            Vec3f scale = new Vec3f(map.getMap("scale"), new Vec3f());
            p.setRenderScale(pos, new Rotation(rotation, true), scale);
        }
        return p;
    }

    protected static void putPartPos(PartPosition pos, JsonMap fpHand, String name) {
        JsonMap map = fpHand.putMap(name);
        map.put("position", pos.getRPos().toMap());
        map.put("rotation", pos.getRRotation().toMap3());
        map.put("scale", pos.getRScale().toMap());
    }

    @Override
    public void save(Editor editor, ProjectWriter project) throws IOException {
        JsonMap data = project.getJson("config.json");
        data.put("skinType", editor.skinType.getName());
        data.put("scaling", Float.valueOf(editor.scalingElem.enabled ? editor.scalingElem.getScale() : 0.0f));
        data.put("hideHeadIfSkull", editor.hideHeadIfSkull);
        data.put("removeArmorOffset", editor.removeArmorOffset);
        JsonMap scaling = data.putMap("scalingEx");
        for (ScalingOptions opt : ScalingOptions.VALUES) {
            if (opt == ScalingOptions.ENTITY) continue;
            scaling.put(opt.name().toLowerCase(Locale.ROOT), Float.valueOf(editor.scalingElem.getScale(opt)));
        }
        scaling.put("render_position", editor.scalingElem.pos.toMap());
        scaling.put("render_rotation", editor.scalingElem.rotation.toMap());
        scaling.put("render_scale", editor.scalingElem.scale.toMap());
        JsonMap fpHand = data.putMap("firstPersonHand");
        PropertiesLoaderV1.putPartPos(editor.leftHandPos, fpHand, "left");
        PropertiesLoaderV1.putPartPos(editor.rightHandPos, fpHand, "right");
        if (editor.modelId != null) {
            data.put("modelId", editor.modelId);
        }
        data.put("removeBedOffset", editor.removeBedOffset);
        data.put("enableInvisGlow", editor.enableInvisGlow);
    }

    static /* synthetic */ boolean lambda$load$0(ModelElement e) {
        return e.duplicated;
    }

    @Override
    public int getLoadOrder() {
        return ProjectPartLoader$.getLoadOrder(this);
    }
}

