/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project.loaders;

import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.JsonList;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectPartLoader;
import com.tom.cpm.shared.editor.project.ProjectPartLoader$;
import com.tom.cpm.shared.editor.project.ProjectWriter;
import com.tom.cpm.shared.editor.project.loaders.TagsLoaderV1$$Lambda$1;
import com.tom.cpm.shared.editor.project.loaders.TagsLoaderV1$$Lambda$2;
import com.tom.cpm.shared.editor.project.loaders.TagsLoaderV1$$Lambda$3;
import com.tom.cpm.shared.editor.project.loaders.TagsLoaderV1$$Lambda$4;
import com.tom.cpm.shared.editor.project.loaders.TagsLoaderV1$$Lambda$5;
import com.tom.cpm.shared.editor.project.loaders.TagsLoaderV1$$Lambda$6;
import com.tom.cpm.shared.editor.tags.EditorTagManager;
import java.io.IOException;
import java.util.List;

public class TagsLoaderV1
implements ProjectPartLoader {
    @Override
    public String getId() {
        return "tags";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void load(Editor editor, IProject project) throws IOException {
        this.readTags(project, (EditorTagManager)editor.tags.getItemTags(), "items");
        this.readTags(project, (EditorTagManager)editor.tags.getBlockTags(), "blocks");
        this.readTags(project, (EditorTagManager)editor.tags.getEntityTags(), "entities");
        this.readTags(project, (EditorTagManager)editor.tags.getBiomeTags(), "biomes");
    }

    @Override
    public void save(Editor editor, ProjectWriter project) throws IOException {
        this.writeTags(project, (EditorTagManager)editor.tags.getItemTags(), "items");
        this.writeTags(project, (EditorTagManager)editor.tags.getBlockTags(), "blocks");
        this.writeTags(project, (EditorTagManager)editor.tags.getEntityTags(), "entities");
        this.writeTags(project, (EditorTagManager)editor.tags.getBiomeTags(), "biomes");
    }

    protected <T> void readTags(IProject project, EditorTagManager<T> mngr, String name) throws IOException {
        project.jsonIfExists("tags/" + name + ".json", TagsLoaderV1$$Lambda$1.lambdaFactory$(mngr));
    }

    protected <T> void writeTags(ProjectWriter project, EditorTagManager<T> mngr, String name) throws IOException {
        String path = "tags/" + name + ".json";
        if (mngr.hasTags()) {
            JsonMap data = project.getJson(path);
            JsonList list = data.putList("tags");
            mngr.getTags().forEach(TagsLoaderV1$$Lambda$2.lambdaFactory$(list));
        } else {
            project.delete(path);
        }
    }

    static /* synthetic */ void lambda$writeTags$3(JsonList list, EditorTagManager.EditableTag t) {
        JsonMap d = list.addMap();
        d.put("id", t.getRawId());
        JsonList l = d.putList("elements");
        List<String> list2 = t.getEntries();
        JsonList jsonList = l;
        jsonList.getClass();
        list2.forEach(TagsLoaderV1$$Lambda$3.lambdaFactory$(jsonList));
    }

    static /* synthetic */ void lambda$readTags$2(EditorTagManager mngr, JsonMap data) throws RuntimeException {
        JsonList list = data.getList("tags");
        list.forEachMap(TagsLoaderV1$$Lambda$4.lambdaFactory$(mngr));
    }

    static /* synthetic */ void lambda$null$1(EditorTagManager mngr, JsonMap d) throws RuntimeException {
        String id = d.getString("id");
        if (id == null) {
            return;
        }
        if ((id = EditorTagManager.formatTag(id)) == null) {
            return;
        }
        String[] elems = (String[])d.getList("elements").stream().map(TagsLoaderV1$$Lambda$5.lambdaFactory$()).toArray(TagsLoaderV1$$Lambda$6.lambdaFactory$());
        mngr.load(id, elems);
    }

    static /* synthetic */ String[] lambda$null$0(int x$0) {
        return new String[x$0];
    }

    @Override
    public int getLoadOrder() {
        return ProjectPartLoader$.getLoadOrder(this);
    }
}

