/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project.loaders;

import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.JsonList;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectPartLoader;
import com.tom.cpm.shared.editor.project.ProjectWriter;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$1;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$10;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$2;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$3;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$4;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$5;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$6;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$7;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$8;
import com.tom.cpm.shared.editor.project.loaders.TemplateLoaderV1$$Lambda$9;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.template.TemplateArgType;
import com.tom.cpm.shared.editor.template.TemplateSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class TemplateLoaderV1
implements ProjectPartLoader {
    @Override
    public String getId() {
        return "template";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void load(Editor editor, IProject project) throws IOException {
        project.jsonIfExists("templates.json", TemplateLoaderV1$$Lambda$1.lambdaFactory$(editor));
        project.jsonIfExists("template_settings.json", TemplateLoaderV1$$Lambda$2.lambdaFactory$(editor));
    }

    @Override
    public void save(Editor editor, ProjectWriter project) throws IOException {
        JsonList lst;
        JsonMap data;
        if (!editor.templates.isEmpty()) {
            data = project.getJson("templates.json");
            lst = data.putList("templates");
            for (EditorTemplate templ : editor.templates) {
                HashMap<String, Object> t = new HashMap<String, Object>();
                lst.add(t);
                templ.store(t);
            }
        }
        if (editor.templateSettings != null) {
            data = project.getJson("template_settings.json");
            lst = data.putList("args");
            data.put("texture", editor.templateSettings.hasTex);
            for (TemplateArgHandler arg : editor.templateSettings.templateArgs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                lst.add(map);
                map.put("name", arg.name);
                map.put("desc", arg.desc);
                map.put("type", arg.type.name().toLowerCase(Locale.ROOT));
                if (arg.handler.requiresParts() && arg.effectedElems != null) {
                    ArrayList partList = new ArrayList();
                    arg.effectedElems.forEach(TemplateLoaderV1$$Lambda$3.lambdaFactory$(partList));
                    map.put("parts", partList);
                }
                HashMap<String, Object> m = new HashMap<String, Object>();
                map.put("data", m);
                arg.handler.saveProject(m);
            }
            ArrayList dispIds = new ArrayList();
            data.put("displayElems", dispIds);
            Editor.walkElements(editor.elements, TemplateLoaderV1$$Lambda$4.lambdaFactory$(dispIds));
        }
    }

    @Override
    public int getLoadOrder() {
        return 1;
    }

    static /* synthetic */ void lambda$save$8(List dispIds, ModelElement e) {
        if (e.templateElement) {
            dispIds.add(e.storeID);
        }
    }

    static /* synthetic */ void lambda$save$7(List partList, ModelElement e) {
        partList.add(e.storeID);
    }

    static /* synthetic */ void lambda$load$6(Editor editor, JsonMap data) throws RuntimeException {
        if (editor.templateSettings == null) {
            editor.templateSettings = new TemplateSettings(editor);
        }
        editor.templateSettings.hasTex = data.getBoolean("texture");
        JsonList lst = data.getList("args");
        lst.forEachMap(TemplateLoaderV1$$Lambda$5.lambdaFactory$(editor));
        List templElems = data.getList("displayElems").stream().map(TemplateLoaderV1$$Lambda$6.lambdaFactory$()).collect(Collectors.toList());
        Editor.walkElements(editor.elements, TemplateLoaderV1$$Lambda$7.lambdaFactory$(templElems));
    }

    static /* synthetic */ void lambda$null$5(List templElems, ModelElement e) {
        if (templElems.contains(e.storeID)) {
            e.templateElement = true;
        }
    }

    static /* synthetic */ void lambda$null$4(Editor editor, JsonMap map) throws RuntimeException {
        TemplateArgType type = TemplateArgType.lookup(map.getString("type"));
        TemplateArgHandler arg = new TemplateArgHandler(editor, map.getString("name"), map.getString("desc"), type);
        editor.templateSettings.templateArgs.add(arg);
        arg.handler.loadProject(map.getMap("data").asMap());
        if (arg.handler.requiresParts() && arg.effectedElems != null) {
            JsonList partList = map.getList("parts");
            partList.forEach(TemplateLoaderV1$$Lambda$8.lambdaFactory$(editor, arg));
        }
    }

    static /* synthetic */ void lambda$null$3(Editor editor, TemplateArgHandler arg, Number e) {
        Editor.walkElements(editor.elements, TemplateLoaderV1$$Lambda$9.lambdaFactory$(e, arg));
    }

    static /* synthetic */ void lambda$null$2(Number e, TemplateArgHandler arg, ModelElement elem) {
        if (elem.storeID == e.longValue()) {
            arg.effectedElems.add(elem);
        }
    }

    static /* synthetic */ void lambda$load$1(Editor editor, JsonMap data) throws IOException {
        JsonList lst = data.getList("templates");
        lst.forEachMap(TemplateLoaderV1$$Lambda$10.lambdaFactory$(editor));
    }

    static /* synthetic */ void lambda$null$0(Editor editor, JsonMap map) throws IOException {
        editor.templates.add(EditorTemplate.load(editor, map));
    }
}

