/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.project.loaders;

import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Generators;
import com.tom.cpm.shared.editor.anim.AnimatedTex;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.elements.RootGroups;
import com.tom.cpm.shared.editor.project.IProject;
import com.tom.cpm.shared.editor.project.JsonList;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.ProjectPartLoader;
import com.tom.cpm.shared.editor.project.ProjectPartLoader$;
import com.tom.cpm.shared.editor.project.ProjectWriter;
import com.tom.cpm.shared.editor.project.loaders.TexturesLoaderV1$$Lambda$1;
import com.tom.cpm.shared.editor.project.loaders.TexturesLoaderV1$$Lambda$2;
import com.tom.cpm.shared.editor.project.loaders.TexturesLoaderV1$$Lambda$3;
import com.tom.cpm.shared.editor.project.loaders.TexturesLoaderV1$$Lambda$4;
import com.tom.cpm.shared.editor.project.loaders.TexturesLoaderV1$$Lambda$5;
import com.tom.cpm.shared.editor.project.loaders.TexturesLoaderV1$$Lambda$6;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class TexturesLoaderV1
implements ProjectPartLoader {
    @Override
    public String getId() {
        return "textures";
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void load(Editor editor, IProject project) throws IOException {
        JsonMap data = project.getJson("config.json");
        JsonMap texDt = data.getMap("textures");
        for (TextureSheetType tex : TextureSheetType.VALUES) {
            boolean customGridSize;
            String name = tex.name().toLowerCase(Locale.ROOT);
            if (!tex.editable) {
                if (!data.getBoolean(name + "Tex", false) && project.getEntry(name + ".png") == null) continue;
                ETextures eTex = editor.textures.get((Object)tex);
                if (eTex == null) {
                    eTex = new ETextures(editor, tex);
                }
                editor.textures.put(tex, eTex);
                eTex.provider.size = tex.getDefSize();
                Image def = new Image(eTex.provider.size.x, eTex.provider.size.y);
                try {
                    InputStream is = ModelDefinitionLoader.class.getResourceAsStream("/assets/cpm/textures/template/" + tex.name().toLowerCase(Locale.ROOT) + ".png");
                    Throwable throwable = null;
                    try {
                        def = Image.loadFrom(is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (IOException is) {
                    // empty catch block
                }
                eTex.setDefaultImg(def);
                eTex.setImage(new Image(def));
                eTex.setChangedLocally(false);
                eTex.markDirty();
                continue;
            }
            Image img = (Image)project.getIfExists(name + ".png", TexturesLoaderV1$$Lambda$1.lambdaFactory$());
            if (img == null) continue;
            if (img.getWidth() > 8192 || img.getHeight() > 8192) {
                Log.error("Illegal image size for texture: " + name);
                continue;
            }
            ETextures eTex = editor.textures.get((Object)tex);
            if (eTex == null) {
                eTex = new ETextures(editor, tex);
            }
            editor.textures.put(tex, eTex);
            eTex.setImage(img);
            eTex.setChangedLocally(false);
            eTex.markDirty();
            JsonMap skinTexSize = data.getMap(name + "Size");
            eTex.provider.size = new Vec2i(skinTexSize, tex.getDefSize());
            boolean bl = customGridSize = img.getWidth() != eTex.provider.size.x || img.getHeight() != eTex.provider.size.y;
            if (texDt != null && texDt.containsKey(name)) {
                JsonMap dt = texDt.getMap(name);
                this.loadAnimatedTexture(editor, dt, eTex, tex);
                eTex.customGridSize = dt.getBoolean("customGridSize", customGridSize);
                continue;
            }
            eTex.customGridSize = customGridSize;
        }
        HashSet<RootGroups> groups = new HashSet<RootGroups>();
        for (ModelElement e : editor.elements) {
            for (RootModelType rmt : RootModelType.VALUES) {
                if (e.typeData != rmt) continue;
                groups.add(RootGroups.getGroup(rmt));
            }
        }
        groups.forEach(TexturesLoaderV1$$Lambda$2.lambdaFactory$(editor));
    }

    @Override
    public void save(Editor editor, ProjectWriter project) throws IOException {
        JsonMap data = project.getJson("config.json");
        JsonMap texDt = data.putMap("textures");
        for (TextureSheetType tex : TextureSheetType.VALUES) {
            String name = tex.name().toLowerCase(Locale.ROOT);
            ETextures eTex = editor.textures.get((Object)tex);
            if (eTex != null) {
                if (eTex.isEditable()) {
                    HashMap<String, Integer> size = new HashMap<String, Integer>();
                    data.put(name + "Size", size);
                    size.put("x", eTex.provider.size.x);
                    size.put("y", eTex.provider.size.y);
                    if (eTex.provider.texture != null && eTex.isEdited()) {
                        project.putFile(name + ".png", eTex.getImage(), TexturesLoaderV1$$Lambda$3.lambdaFactory$());
                    }
                    JsonMap dt = texDt.putMap(name);
                    dt.put("customGridSize", eTex.customGridSize);
                    this.saveAnimatedTexture(dt, eTex);
                    continue;
                }
                data.put(name + "Tex", true);
                continue;
            }
            project.delete(name + ".png");
        }
    }

    protected void loadAnimatedTexture(Editor editor, JsonMap dt, ETextures tex, TextureSheetType sheet) {
        JsonList list = dt.getList("anim");
        list.forEachMap(TexturesLoaderV1$$Lambda$4.lambdaFactory$(tex, editor, sheet));
    }

    protected void saveAnimatedTexture(JsonMap dt, ETextures tex) {
        JsonList list = dt.putList("anim");
        tex.animatedTexs.forEach(TexturesLoaderV1$$Lambda$5.lambdaFactory$(list));
    }

    static /* synthetic */ void lambda$saveAnimatedTexture$2(JsonList list, AnimatedTex t) {
        t.save(list.addMap());
    }

    static /* synthetic */ void lambda$loadAnimatedTexture$1(ETextures tex, Editor editor, TextureSheetType sheet, JsonMap elem) throws RuntimeException {
        tex.animatedTexs.add(new AnimatedTex(editor, sheet, elem));
    }

    static /* synthetic */ void lambda$load$0(Editor editor, RootGroups g) {
        Map<TextureSheetType, ETextures> map = editor.textures;
        map.getClass();
        Generators.loadTextures(editor, g, TexturesLoaderV1$$Lambda$6.lambdaFactory$(map));
    }

    @Override
    public int getLoadOrder() {
        return ProjectPartLoader$.getLoadOrder(this);
    }
}

