/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.template;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.project.JsonMapImpl;
import com.tom.cpm.shared.editor.template.EditorTemplate$$Lambda$1;
import com.tom.cpm.shared.editor.template.EditorTemplate$$Lambda$2;
import com.tom.cpm.shared.editor.template.EditorTemplate$$Lambda$3;
import com.tom.cpm.shared.editor.template.EditorTemplate$$Lambda$4;
import com.tom.cpm.shared.editor.template.EditorTemplate$$Lambda$5;
import com.tom.cpm.shared.editor.template.EditorTemplate$$Lambda$6;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.template.TemplateArgType;
import com.tom.cpm.shared.editor.template.args.TexEditorArg;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.TreeElement$;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.template.Template;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class EditorTemplate
extends Template
implements TreeElement {
    private Editor editor;
    private String name;
    private List<TreeElement> elems;
    private List<TemplateArgHandler.TemplateArg<?>> editorArgs;
    private EditorTexture tex;
    private TexEditorArg textureArg;
    private Tooltip tooltip;

    private EditorTemplate(Editor editor, Link link, InputStreamReader rd, JsonMap data) throws IOException {
        super(link, rd, data, null, null);
        this.editor = editor;
        this.loadPartToCubes();
        this.name = (String)this.data.get("name");
        this.elems = new ArrayList<TreeElement>();
        this.editorArgs = new ArrayList();
        List argsList = (List)this.data.get("args");
        HashMap<String, TemplateArgType> types = new HashMap<String, TemplateArgType>();
        types.put("__tex", TemplateArgType.TEX);
        for (Map arg : argsList) {
            String name = (String)arg.get("name");
            types.put(name, TemplateArgType.lookup((String)arg.get("elem_type")));
        }
        this.templateArgs.forEach(EditorTemplate$$Lambda$1.lambdaFactory$(this, types, editor));
        if (this.texture != null) {
            this.tex = new EditorTexture(this.texture);
            this.textureArg.bind(this);
        }
    }

    private static <T extends Template.IArg> void loadArg(TemplateArgHandler.TemplateArg<T> arg, Template.IArg value) {
        arg.loadTemplate(value);
    }

    public static EditorTemplate load(Editor editor, JsonMap data) throws IOException {
        Link link = new Link(data.getString("link"));
        InputStreamReader rd = new InputStreamReader(MinecraftClientAccess$.get().getDefinitionLoader().load(link, ResourceLoader.ResourceEncoding.NO_ENCODING, null));
        Throwable throwable = null;
        try {
            EditorTemplate editorTemplate = new EditorTemplate(editor, link, rd, data.getMap("data"));
            return editorTemplate;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (rd != null) {
                if (throwable != null) {
                    try {
                        rd.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    rd.close();
                }
            }
        }
    }

    public static EditorTemplate create(Editor editor, String linkIn) throws IOException {
        Link link = new Link(linkIn);
        InputStreamReader rd = new InputStreamReader(MinecraftClientAccess$.get().getDefinitionLoader().load(link, ResourceLoader.ResourceEncoding.NO_ENCODING, null));
        Throwable throwable = null;
        try {
            EditorTemplate editorTemplate = new EditorTemplate(editor, link, rd, new JsonMapImpl());
            return editorTemplate;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (rd != null) {
                if (throwable != null) {
                    try {
                        rd.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    rd.close();
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.editor.ui.i18nFormat("label.cpm.template_name", this.name);
    }

    @Override
    public void getTreeElements(Consumer<TreeElement> c) {
        this.elems.forEach(c);
    }

    public List<RenderedCube> getForPart(VanillaModelPart type) {
        return this.partToCubes.getOrDefault(type, Collections.emptyList());
    }

    public void store(Map<String, Object> map) {
        this.editorArgs.forEach(EditorTemplate$$Lambda$2.lambdaFactory$());
        HashMap data = new HashMap();
        map.put("data", data);
        map.put("link", this.link.toString());
        for (Map.Entry e : this.templateArgs.entrySet()) {
            HashMap<String, Object> dt = new HashMap<String, Object>();
            data.put(e.getKey(), dt);
            ((Template.IArg)e.getValue()).write(dt);
        }
    }

    public void applyToModel() {
        this.editorArgs.forEach(EditorTemplate$$Lambda$3.lambdaFactory$());
        this.loadModelData();
        this.loadPartToCubes();
        if (this.texArg != null && !this.texArg.isTextureMerged() && this.tex != null && this.tex.stitchPos != null) {
            this.getCubes().forEach(EditorTemplate$$Lambda$4.lambdaFactory$(this));
        }
    }

    @Override
    public ETextures getTexture() {
        return this.texArg != null ? (this.texArg.isTextureMerged() ? this.editor.textures.get((Object)TextureSheetType.SKIN) : new ETextures(this.editor, this.tex)) : null;
    }

    @Override
    public TextureProvider getTemplateDefaultTexture() {
        ETextures tex = this.getTexture();
        return tex != null ? tex.provider : null;
    }

    public EditorTexture getTemplateTexture() {
        return this.tex;
    }

    public void stitch(TextureStitcher stitcher) {
        if (this.texArg != null && !this.texArg.isTextureMerged()) {
            stitcher.stitchImage(this.tex);
        }
    }

    @Override
    public void delete() {
        ActionBuilder actionBuilder = this.editor.action("remove", "action.cpm.template").removeFromList(this.editor.templates, this);
        Editor editor = this.editor;
        editor.getClass();
        actionBuilder.onAction(EditorTemplate$$Lambda$5.lambdaFactory$(editor)).onRun(EditorTemplate$$Lambda$6.lambdaFactory$(this)).execute();
        this.editor.updateGui();
    }

    @Override
    public void updateGui() {
        this.editor.setDelEn.accept(true);
    }

    @Override
    public Tooltip getTooltip(IGui gui) {
        if (this.data.containsKey("desc") && this.tooltip == null) {
            this.tooltip = new Tooltip(gui.getFrame(), (String)this.data.get("desc"));
        }
        return this.tooltip;
    }

    static /* synthetic */ void lambda$delete$2(EditorTemplate this_) {
        this_.editor.selectedElement = null;
    }

    static /* synthetic */ void lambda$applyToModel$1(EditorTemplate this_, RenderedCube c) {
        c.getCube().u += this_.tex.stitchPos.x;
        c.getCube().v += this_.tex.stitchPos.y;
    }

    static /* synthetic */ void lambda$new$0(EditorTemplate this_, Map types, final Editor editor, final String n, Template.IArg arg) {
        TemplateArgType type = (TemplateArgType)((Object)types.get(n));
        TemplateArgHandler.TemplateArg<?> a = type.factory.get();
        if (type == TemplateArgType.TEX) {
            this_.textureArg = (TexEditorArg)a;
        }
        EditorTemplate.loadArg(a, arg);
        this_.editorArgs.add(a);
        final ArrayList<TreeElement> options = new ArrayList<TreeElement>();
        a.createTreeElements(options, editor);
        this_.elems.add(new TreeElement(){

            @Override
            public String getName() {
                if (n.equals("__tex")) {
                    return editor.ui.i18nFormat("label.cpm.template_arg_tex", new Object[0]);
                }
                return n;
            }

            @Override
            public void getTreeElements(Consumer<TreeElement> c) {
                options.forEach(c);
            }

            @Override
            public void accept(TreeElement treeElement) {
                TreeElement$.accept(this, treeElement);
            }

            @Override
            public void delete() {
                TreeElement$.delete(this);
            }

            @Override
            public Vec3f getVec(VecType vecType) {
                return TreeElement$.getVec(this, vecType);
            }

            @Override
            public ETextures getTexture() {
                return TreeElement$.getTexture(this);
            }

            @Override
            public void setVec(Vec3f vec3f, VecType vecType) {
                TreeElement$.setVec(this, vec3f, vecType);
            }

            @Override
            public Tooltip getTooltip(IGui iGui) {
                return TreeElement$.getTooltip(this, iGui);
            }

            @Override
            public void drawTexture(IGui iGui, int n3, int n2, float f, float f2) {
                TreeElement$.drawTexture(this, iGui, n3, n2, f, f2);
            }

            @Override
            public void setElemColor(int n2) {
                TreeElement$.setElemColor(this, n2);
            }

            @Override
            public void switchEffect(Effect effect) {
                TreeElement$.switchEffect(this, effect);
            }

            @Override
            public void addNew() {
                TreeElement$.addNew(this);
            }

            @Override
            public void updateGui() {
                TreeElement$.updateGui(this);
            }

            @Override
            public String getElemName() {
                return TreeElement$.getElemName(this);
            }

            @Override
            public void setValue(float f) {
                TreeElement$.setValue(this, f);
            }

            @Override
            public void setVecTemp(VecType vecType, Vec3f vec3f) {
                TreeElement$.setVecTemp(this, vecType, vec3f);
            }

            @Override
            public Box getTextureBox() {
                return TreeElement$.getTextureBox(this);
            }

            @Override
            public void onRefreshTree() {
                TreeElement$.onRefreshTree(this);
            }

            public List getSettingsElements() {
                return TreeElement$.getSettingsElements(this);
            }

            @Override
            public boolean canAccept(TreeElement treeElement) {
                return TreeElement$.canAccept(this, treeElement);
            }

            @Override
            public void populatePopup(PopupMenu popupMenu) {
                TreeElement$.populatePopup(this, popupMenu);
            }

            @Override
            public void modeSwitch() {
                TreeElement$.modeSwitch(this);
            }

            @Override
            public boolean canEditVec(VecType vecType) {
                return TreeElement$.canEditVec(this, vecType);
            }

            @Override
            public void switchVis() {
                TreeElement$.switchVis(this);
            }

            @Override
            public void onClick(IGui iGui, Editor editor2, MouseEvent mouseEvent) {
                TreeElement$.onClick(this, iGui, editor2, mouseEvent);
            }

            @Override
            public void setElemName(String string) {
                TreeElement$.setElemName(this, string);
            }

            @Override
            public boolean isSelected(Editor editor2, TreeElement treeElement) {
                return TreeElement$.isSelected(this, editor2, treeElement);
            }

            @Override
            public boolean canMove() {
                return TreeElement$.canMove(this);
            }

            @Override
            public void drawName(IGui iGui, int n4, int n2, int n3) {
                TreeElement$.drawName(this, iGui, n4, n2, n3);
            }

            @Override
            public void setMCScale(float f) {
                TreeElement$.setMCScale(this, f);
            }

            @Override
            public int textColor(IGui iGui) {
                return TreeElement$.textColor(this, iGui);
            }

            @Override
            public float getValue() {
                return TreeElement$.getValue(this);
            }

            @Override
            public boolean canSelect() {
                return TreeElement$.canSelect(this);
            }

            @Override
            public int bgColor(IGui iGui) {
                return TreeElement$.bgColor(this, iGui);
            }

            @Override
            public int getExtraWidth(IGui iGui) {
                return TreeElement$.getExtraWidth(this, iGui);
            }
        });
    }

    @Override
    public void setVec(Vec3f vec3f, VecType vecType) {
        TreeElement$.setVec(this, vec3f, vecType);
    }

    @Override
    public void drawTexture(IGui iGui, int n, int n2, float f, float f2) {
        TreeElement$.drawTexture(this, iGui, n, n2, f, f2);
    }

    @Override
    public void setElemColor(int n) {
        TreeElement$.setElemColor(this, n);
    }

    @Override
    public void setValue(float f) {
        TreeElement$.setValue(this, f);
    }

    @Override
    public void setVecTemp(VecType vecType, Vec3f vec3f) {
        TreeElement$.setVecTemp(this, vecType, vec3f);
    }

    @Override
    public boolean canAccept(TreeElement treeElement) {
        return TreeElement$.canAccept(this, treeElement);
    }

    @Override
    public void populatePopup(PopupMenu popupMenu) {
        TreeElement$.populatePopup(this, popupMenu);
    }

    @Override
    public void modeSwitch() {
        TreeElement$.modeSwitch(this);
    }

    @Override
    public boolean canEditVec(VecType vecType) {
        return TreeElement$.canEditVec(this, vecType);
    }

    @Override
    public void switchVis() {
        TreeElement$.switchVis(this);
    }

    @Override
    public boolean isSelected(Editor editor, TreeElement treeElement) {
        return TreeElement$.isSelected(this, editor, treeElement);
    }

    @Override
    public void drawName(IGui iGui, int n, int n2, int n3) {
        TreeElement$.drawName(this, iGui, n, n2, n3);
    }

    @Override
    public void setMCScale(float f) {
        TreeElement$.setMCScale(this, f);
    }

    @Override
    public float getValue() {
        return TreeElement$.getValue(this);
    }

    @Override
    public int bgColor(IGui iGui) {
        return TreeElement$.bgColor(this, iGui);
    }

    @Override
    public void accept(TreeElement treeElement) {
        TreeElement$.accept(this, treeElement);
    }

    @Override
    public Vec3f getVec(VecType vecType) {
        return TreeElement$.getVec(this, vecType);
    }

    @Override
    public void switchEffect(Effect effect) {
        TreeElement$.switchEffect(this, effect);
    }

    @Override
    public void addNew() {
        TreeElement$.addNew(this);
    }

    @Override
    public String getElemName() {
        return TreeElement$.getElemName(this);
    }

    @Override
    public Box getTextureBox() {
        return TreeElement$.getTextureBox(this);
    }

    @Override
    public void onRefreshTree() {
        TreeElement$.onRefreshTree(this);
    }

    public List getSettingsElements() {
        return TreeElement$.getSettingsElements(this);
    }

    @Override
    public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
        TreeElement$.onClick(this, iGui, editor, mouseEvent);
    }

    @Override
    public void setElemName(String string) {
        TreeElement$.setElemName(this, string);
    }

    @Override
    public boolean canMove() {
        return TreeElement$.canMove(this);
    }

    @Override
    public int textColor(IGui iGui) {
        return TreeElement$.textColor(this, iGui);
    }

    @Override
    public boolean canSelect() {
        return TreeElement$.canSelect(this);
    }

    @Override
    public int getExtraWidth(IGui iGui) {
        return TreeElement$.getExtraWidth(this, iGui);
    }
}

