/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.template;

import com.tom.cpl.gui.UI;
import com.tom.cpm.externals.com.google.gson.Gson;
import com.tom.cpm.externals.com.google.gson.GsonBuilder;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ExportException;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.template.TemplateExporter$$Lambda$1;
import com.tom.cpm.shared.editor.template.TemplateExporter$$Lambda$2;
import com.tom.cpm.shared.editor.util.ExportHelper;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.TextureSheetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public class TemplateExporter {
    public static final Gson sgson = new GsonBuilder().serializeSpecialFloatingPointValues().create();

    public static void exportTemplate(Editor e, UI gui, ModelDescription desc, Consumer<String> templateOut) {
        try {
            ArrayList<Cube> flatList = new ArrayList<Cube>();
            ExportHelper.flattenElements(e.elements, new int[]{10000}, flatList);
            HashMap<String, Object> data = new HashMap<String, Object>();
            ArrayList<HashMap<String, Object>> cubesList = new ArrayList<HashMap<String, Object>>();
            data.put("cubes", cubesList);
            HashMap cubeDataList = new HashMap();
            flatList.sort(TemplateExporter$$Lambda$1.lambdaFactory$());
            for (Cube cube : flatList) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                Cube.saveTemplateCube(m, cube);
                cubesList.add(m);
                HashMap dtMap = new HashMap();
                m.put("data", dtMap);
                m.put("id", cube.id);
                cubeDataList.put(cube.id, dtMap);
            }
            ExportHelper.walkElements(e.elements, TemplateExporter$$Lambda$2.lambdaFactory$(cubeDataList));
            ArrayList argsList = new ArrayList();
            data.put("args", argsList);
            for (TemplateArgHandler a : e.templateSettings.templateArgs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                argsList.add(map);
                map.put("name", a.name);
                map.put("desc", a.desc);
                map.put("type", a.type.baseType.name().toLowerCase(Locale.ROOT));
                map.put("elem_type", a.type.name().toLowerCase(Locale.ROOT));
                HashMap<String, Object> d = new HashMap<String, Object>();
                a.handler.export().export(d);
                map.put("data", d);
                a.handler.applyArgs(data, a.effectedElems);
            }
            if (e.textures.get((Object)TextureSheetType.SKIN).isEdited()) {
                IOHelper iOHelper = new IOHelper();
                e.textures.get((Object)TextureSheetType.SKIN).write(iOHelper);
                data.put("texture", iOHelper.toB64());
            }
            data.put("name", desc.name);
            data.put("desc", desc.desc);
            if (desc.icon != null) {
                IOHelper iOHelper = new IOHelper();
                Throwable throwable = null;
                try {
                    iOHelper.writeImage(desc.icon);
                    data.put("icon", iOHelper.toB64());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iOHelper != null) {
                        if (throwable != null) {
                            try {
                                iOHelper.close();
                            }
                            catch (Throwable throwable3) {
                            }
                        } else {
                            iOHelper.close();
                        }
                    }
                }
            }
            String string = sgson.toJson(data);
            templateOut.accept(string);
        }
        catch (ExportException ex) {
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("label.cpm.export_error", gui.i18nFormat(ex.getMessage(), new Object[0])));
        }
        catch (Exception ex) {
            gui.onGuiException("Error while exporting", ex, false);
        }
    }

    static /* synthetic */ void lambda$exportTemplate$1(Map cubeDataList, ModelElement el) {
        if (el.type == ElementType.NORMAL && !el.templateElement) {
            Map dt = (Map)cubeDataList.get(el.id);
            dt.put("hidden", el.hidden);
            dt.put("recolor", el.recolor);
            dt.put("glow", el.glow);
        }
    }

    static /* synthetic */ int lambda$exportTemplate$0(Cube a, Cube b) {
        return Integer.compare(a.id, b.id);
    }
}

