/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.tree;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.tree.ScalingElement$ModelScale$$Lambda$1;
import com.tom.cpm.shared.editor.tree.ScalingElement$ModelScale$$Lambda$2;
import com.tom.cpm.shared.editor.tree.ScalingElement$ModelScale$$Lambda$3;
import com.tom.cpm.shared.editor.tree.ScalingElement$ModelScale$$Lambda$4;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.TreeElement$;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public class ScalingElement
implements TreeElement {
    private static boolean editPopupShown = false;
    private List<TreeElement> options;
    private Editor editor;
    public Map<ScalingOptions, Float> scaling = new EnumMap<ScalingOptions, Float>(ScalingOptions.class);
    public Vec3f pos;
    public Vec3f rotation;
    public Vec3f scale;
    public boolean enabled;

    public ScalingElement(Editor editor) {
        this.editor = editor;
        this.pos = new Vec3f();
        this.rotation = new Vec3f();
        this.scale = new Vec3f();
        this.options = new ArrayList<TreeElement>();
        for (ScalingOptions opt : ScalingOptions.VALUES) {
            this.options.add(new ValElem(opt));
        }
        this.options.add(new ModelScale());
    }

    @Override
    public String getName() {
        return this.editor.ui.i18nFormat("label.cpm.effect.scaling", new Object[0]);
    }

    @Override
    public void getTreeElements(Consumer<TreeElement> c) {
        this.options.forEach(c);
    }

    @Override
    public Tooltip getTooltip(IGui gui) {
        return new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.effect.scaling", new Object[0]));
    }

    public void reset() {
        this.scaling.clear();
        this.enabled = false;
        this.pos = new Vec3f();
        this.rotation = new Vec3f();
        this.scale = new Vec3f();
    }

    public boolean hasTransform() {
        return this.pos.x != 0.0f || this.pos.y != 0.0f || this.pos.z != 0.0f || this.rotation.x != 0.0f || this.rotation.y != 0.0f || this.rotation.z != 0.0f || this.scale.x != 0.0f && this.scale.x != 1.0f || this.scale.y != 0.0f && this.scale.y != 1.0f || this.scale.z != 0.0f && this.scale.z != 1.0f;
    }

    public float getScale() {
        return this.getScale(ScalingOptions.ENTITY);
    }

    public float getScale(ScalingOptions opt) {
        float v = this.scaling.getOrDefault((Object)opt, Float.valueOf(1.0f)).floatValue();
        if (v == 0.0f) {
            return 1.0f;
        }
        return v;
    }

    @Override
    public void accept(TreeElement treeElement) {
        TreeElement$.accept(this, treeElement);
    }

    @Override
    public void delete() {
        TreeElement$.delete(this);
    }

    @Override
    public Vec3f getVec(VecType vecType) {
        return TreeElement$.getVec(this, vecType);
    }

    @Override
    public ETextures getTexture() {
        return TreeElement$.getTexture(this);
    }

    @Override
    public void setVec(Vec3f vec3f, VecType vecType) {
        TreeElement$.setVec(this, vec3f, vecType);
    }

    @Override
    public void drawTexture(IGui iGui, int n, int n2, float f, float f2) {
        TreeElement$.drawTexture(this, iGui, n, n2, f, f2);
    }

    @Override
    public void setElemColor(int n) {
        TreeElement$.setElemColor(this, n);
    }

    @Override
    public void switchEffect(Effect effect) {
        TreeElement$.switchEffect(this, effect);
    }

    @Override
    public void addNew() {
        TreeElement$.addNew(this);
    }

    @Override
    public void updateGui() {
        TreeElement$.updateGui(this);
    }

    @Override
    public String getElemName() {
        return TreeElement$.getElemName(this);
    }

    @Override
    public void setValue(float f) {
        TreeElement$.setValue(this, f);
    }

    @Override
    public void setVecTemp(VecType vecType, Vec3f vec3f) {
        TreeElement$.setVecTemp(this, vecType, vec3f);
    }

    @Override
    public Box getTextureBox() {
        return TreeElement$.getTextureBox(this);
    }

    @Override
    public void onRefreshTree() {
        TreeElement$.onRefreshTree(this);
    }

    public List getSettingsElements() {
        return TreeElement$.getSettingsElements(this);
    }

    @Override
    public boolean canAccept(TreeElement treeElement) {
        return TreeElement$.canAccept(this, treeElement);
    }

    @Override
    public void populatePopup(PopupMenu popupMenu) {
        TreeElement$.populatePopup(this, popupMenu);
    }

    @Override
    public void modeSwitch() {
        TreeElement$.modeSwitch(this);
    }

    @Override
    public boolean canEditVec(VecType vecType) {
        return TreeElement$.canEditVec(this, vecType);
    }

    @Override
    public void switchVis() {
        TreeElement$.switchVis(this);
    }

    @Override
    public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
        TreeElement$.onClick(this, iGui, editor, mouseEvent);
    }

    @Override
    public void setElemName(String string) {
        TreeElement$.setElemName(this, string);
    }

    @Override
    public boolean isSelected(Editor editor, TreeElement treeElement) {
        return TreeElement$.isSelected(this, editor, treeElement);
    }

    @Override
    public boolean canMove() {
        return TreeElement$.canMove(this);
    }

    @Override
    public void drawName(IGui iGui, int n, int n2, int n3) {
        TreeElement$.drawName(this, iGui, n, n2, n3);
    }

    @Override
    public void setMCScale(float f) {
        TreeElement$.setMCScale(this, f);
    }

    @Override
    public int textColor(IGui iGui) {
        return TreeElement$.textColor(this, iGui);
    }

    @Override
    public float getValue() {
        return TreeElement$.getValue(this);
    }

    @Override
    public boolean canSelect() {
        return TreeElement$.canSelect(this);
    }

    @Override
    public int bgColor(IGui iGui) {
        return TreeElement$.bgColor(this, iGui);
    }

    @Override
    public int getExtraWidth(IGui iGui) {
        return TreeElement$.getExtraWidth(this, iGui);
    }

    private class ModelScale
    extends OptionElem {
        public ModelScale() {
            super("model");
        }

        @Override
        public void updateGui() {
            ((ScalingElement)ScalingElement.this).editor.setRot.accept(ScalingElement.this.rotation);
            ((ScalingElement)ScalingElement.this).editor.setPosition.accept(ScalingElement.this.pos);
            ((ScalingElement)ScalingElement.this).editor.setMeshScale.accept(ScalingElement.this.scale);
        }

        @Override
        public void setVec(Vec3f v, VecType object) {
            if (((ScalingElement)ScalingElement.this).editor.elements.stream().anyMatch(ScalingElement$ModelScale$$Lambda$1.lambdaFactory$()) && !editPopupShown) {
                editPopupShown = true;
                ((ScalingElement)ScalingElement.this).editor.ui.displayMessagePopup(((ScalingElement)ScalingElement.this).editor.ui.i18nFormat("label.cpm.info", new Object[0]), ((ScalingElement)ScalingElement.this).editor.ui.i18nFormat("label.cpm.warnEditTransform", new Object[0]));
            }
            switch (object) {
                case ROTATION: {
                    ScalingElement.this.editor.action("set", "label.cpm.rotation").updateValueOp(ScalingElement.this, ScalingElement.this.rotation, v, 0, 360, true, ScalingElement$ModelScale$$Lambda$2.lambdaFactory$(), ((ScalingElement)ScalingElement.this).editor.setRot).execute();
                    break;
                }
                case POSITION: {
                    ScalingElement.this.editor.action("set", "label.cpm.position").updateValueOp(ScalingElement.this, ScalingElement.this.pos, v, -48, 48, false, ScalingElement$ModelScale$$Lambda$3.lambdaFactory$(), ((ScalingElement)ScalingElement.this).editor.setPosition).execute();
                    break;
                }
                case MESH_SCALE: {
                    ScalingElement.this.editor.action("set", "label.cpm.scale").updateValueOp(ScalingElement.this, ScalingElement.this.scale, v, 0, 25, false, ScalingElement$ModelScale$$Lambda$4.lambdaFactory$(), ((ScalingElement)ScalingElement.this).editor.setMeshScale).execute();
                    break;
                }
            }
        }

        static /* synthetic */ void lambda$setVec$3(ScalingElement a, Vec3f b) {
            a.scale = b;
        }

        static /* synthetic */ void lambda$setVec$2(ScalingElement a, Vec3f b) {
            a.pos = b;
        }

        static /* synthetic */ void lambda$setVec$1(ScalingElement a, Vec3f b) {
            a.rotation = b;
        }

        static /* synthetic */ boolean lambda$setVec$0(ModelElement e) {
            return !e.hidden;
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public Vec3f getVec(VecType vecType) {
            return TreeElement$.getVec(this, vecType);
        }

        @Override
        public ETextures getTexture() {
            return TreeElement$.getTexture(this);
        }

        @Override
        public void drawTexture(IGui iGui, int n, int n2, float f, float f2) {
            TreeElement$.drawTexture(this, iGui, n, n2, f, f2);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void setVecTemp(VecType vecType, Vec3f vec3f) {
            TreeElement$.setVecTemp(this, vecType, vec3f);
        }

        @Override
        public Box getTextureBox() {
            return TreeElement$.getTextureBox(this);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        @Override
        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    private class ValElem
    extends OptionElem {
        private ScalingOptions opt;

        public ValElem(ScalingOptions opt) {
            super(opt.name().toLowerCase(Locale.ROOT));
            this.opt = opt;
        }

        @Override
        public void updateGui() {
            if (this.opt == ScalingOptions.ENTITY) {
                ((ScalingElement)ScalingElement.this).editor.applyScaling = true;
            }
            ((ScalingElement)ScalingElement.this).editor.setModePanel.accept(ModeDisplayType.VALUE);
            ((ScalingElement)ScalingElement.this).editor.setValue.accept(ScalingElement.this.scaling.getOrDefault((Object)this.opt, Float.valueOf(1.0f)));
        }

        @Override
        public void setValue(float value) {
            ScalingElement.this.editor.action("set", "label.cpm.tree.scaling." + this.name).addToMap(ScalingElement.this.scaling, this.opt, Float.valueOf(value)).execute();
        }

        @Override
        public Tooltip getTooltip(IGui gui) {
            String tooltip = gui.i18nFormat("tooltip.cpm.tree.scaling." + this.name, new Object[0]);
            if (this.opt != ScalingOptions.ENTITY) {
                tooltip = gui.i18nFormat("tooltip.cpm.tree.scaling.serverRequired", tooltip);
            }
            if (!this.opt.getDefualtEnabled()) {
                tooltip = gui.i18nFormat("tooltip.cpm.tree.scaling.disabledByDefault", tooltip, this.name);
            }
            return new Tooltip(gui.getFrame(), tooltip, "Scaling");
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public Vec3f getVec(VecType vecType) {
            return TreeElement$.getVec(this, vecType);
        }

        @Override
        public ETextures getTexture() {
            return TreeElement$.getTexture(this);
        }

        @Override
        public void setVec(Vec3f vec3f, VecType vecType) {
            TreeElement$.setVec(this, vec3f, vecType);
        }

        @Override
        public void drawTexture(IGui iGui, int n, int n2, float f, float f2) {
            TreeElement$.drawTexture(this, iGui, n, n2, f, f2);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setVecTemp(VecType vecType, Vec3f vec3f) {
            TreeElement$.setVecTemp(this, vecType, vec3f);
        }

        @Override
        public Box getTextureBox() {
            return TreeElement$.getTextureBox(this);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        @Override
        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    private class OptionElem
    implements TreeElement {
        protected String name;

        public OptionElem(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return ((ScalingElement)ScalingElement.this).editor.ui.i18nFormat("label.cpm.tree.scaling." + this.name, new Object[0]);
        }

        @Override
        public Tooltip getTooltip(IGui gui) {
            return new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.tree.scaling." + this.name, new Object[0]));
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public Vec3f getVec(VecType vecType) {
            return TreeElement$.getVec(this, vecType);
        }

        @Override
        public ETextures getTexture() {
            return TreeElement$.getTexture(this);
        }

        @Override
        public void setVec(Vec3f vec3f, VecType vecType) {
            TreeElement$.setVec(this, vec3f, vecType);
        }

        @Override
        public void drawTexture(IGui iGui, int n, int n2, float f, float f2) {
            TreeElement$.drawTexture(this, iGui, n, n2, f, f2);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public void updateGui() {
            TreeElement$.updateGui(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void setVecTemp(VecType vecType, Vec3f vec3f) {
            TreeElement$.setVecTemp(this, vecType, vec3f);
        }

        @Override
        public Box getTextureBox() {
            return TreeElement$.getTextureBox(this);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }
}

