/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.tree;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.elements.Tree;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.tree.TreeElement$ModelTree$$Lambda$1;
import com.tom.cpm.shared.editor.tree.VecType;
import java.util.List;
import java.util.function.Consumer;

public interface TreeElement {
    public void onClick(IGui var1, Editor var2, MouseEvent var3);

    public boolean isSelected(Editor var1, TreeElement var2);

    public String getName();

    public int textColor(IGui var1);

    public int bgColor(IGui var1);

    public void accept(TreeElement var1);

    public boolean canAccept(TreeElement var1);

    public boolean canMove();

    public void getTreeElements(Consumer<TreeElement> var1);

    public void populatePopup(PopupMenu var1);

    public Tooltip getTooltip(IGui var1);

    public void setVec(Vec3f var1, VecType var2);

    public void setElemName(String var1);

    public String getElemName();

    public void drawTexture(IGui var1, int var2, int var3, float var4, float var5);

    public ETextures getTexture();

    public Box getTextureBox();

    public List<TreeSettingElement> getSettingsElements();

    public void modeSwitch();

    public void updateGui();

    public void onRefreshTree();

    public void addNew();

    public void delete();

    public void setElemColor(int var1);

    public void setMCScale(float var1);

    public void switchVis();

    public void switchEffect(Effect var1);

    public float getValue();

    public void setValue(float var1);

    public void setVecTemp(VecType var1, Vec3f var2);

    public Vec3f getVec(VecType var1);

    public boolean canEditVec(VecType var1);

    public boolean canSelect();

    public int getExtraWidth(IGui var1);

    public void drawName(IGui var1, int var2, int var3, int var4);

    public static interface TreeSettingElement
    extends TreeElement {
        public TreeElement getParent();

        @Override
        public String getName();

        @Override
        public ETextures getTexture();

        @Override
        public boolean isSelected(Editor var1, TreeElement var2);

        @Override
        public void drawTexture(IGui var1, int var2, int var3, float var4, float var5);
    }

    public static class ModelTree
    extends Tree.TreeModel<TreeElement> {
        private Editor e;
        private TreeElement moveElem;

        public ModelTree(Editor e) {
            this.e = e;
        }

        @Override
        protected int textColor(TreeElement val, IGui gui) {
            return val.textColor(gui);
        }

        @Override
        protected void getElements(TreeElement parent, Consumer<TreeElement> c) {
            if (parent == null) {
                this.e.elements.forEach(c);
                this.e.templates.forEach(c);
                if (this.e.templateSettings != null) {
                    c.accept(this.e.templateSettings);
                }
                if (this.e.scalingElem.enabled) {
                    c.accept(this.e.scalingElem);
                }
                c.accept(this.e.texElem);
            } else {
                parent.getTreeElements(c);
            }
        }

        @Override
        protected int bgColor(TreeElement val, IGui gui) {
            int bg = val.bgColor(gui);
            if (bg != 0) {
                return bg;
            }
            if (this.moveElem != null && this.moveElem == val) {
                return gui.getColors().move_background;
            }
            if (this.isSelected(val)) {
                return gui.getColors().select_background;
            }
            return 0;
        }

        @Override
        protected void treeUpdated() {
            this.e.updateGui();
        }

        @Override
        protected void onClick(IGui gui, MouseEvent evt, TreeElement elem) {
            if (evt.btn == 1 && elem != null) {
                this.displayPopup(gui, evt, elem);
            } else if (elem != null) {
                elem.onClick(gui, this.e, evt);
            } else {
                this.e.selectedElement = null;
            }
        }

        public void displayPopup(IGui gui, MouseEvent evt, TreeElement elem) {
            PopupMenu popup = new PopupMenu(gui, gui.getFrame());
            if (elem.canMove() || this.moveElem != null && elem.canAccept(this.moveElem)) {
                String btnTxt = this.moveElem != null ? (this.moveElem == elem ? gui.i18nFormat("button.cpm.tree.cancelMove", new Object[0]) : gui.i18nFormat("button.cpm.tree.put", new Object[0])) : gui.i18nFormat("button.cpm.tree.move", new Object[0]);
                popup.addButton(btnTxt, TreeElement$ModelTree$$Lambda$1.lambdaFactory$(this, elem));
            }
            elem.populatePopup(popup);
            if (popup.getY() > 0) {
                Vec2i p = evt.getPos();
                popup.display(p.x + 1, p.y + 1);
            }
        }

        @Override
        protected String getName(TreeElement elem) {
            return elem.getName();
        }

        @Override
        protected Tooltip getTooltip(TreeElement elem, IGui gui) {
            if (elem != null) {
                return elem.getTooltip(gui);
            }
            return null;
        }

        @Override
        protected void refresh(TreeElement elem) {
            elem.onRefreshTree();
        }

        @Override
        protected boolean isSelected(TreeElement elem) {
            return this.e.selectedElement != null && this.e.selectedElement.isSelected(this.e, elem);
        }

        @Override
        protected boolean canSelect(TreeElement elem) {
            return elem.canSelect();
        }

        @Override
        protected void drawName(TreeElement elem, IGui gui, int x, int y, int color) {
            if (elem != null) {
                elem.drawName(gui, x, y, color);
            }
        }

        @Override
        protected int getExtraWidth(TreeElement value, IGui gui) {
            return value != null ? value.getExtraWidth(gui) : 0;
        }

        static /* synthetic */ void lambda$displayPopup$0(ModelTree this_, TreeElement elem) {
            if (this_.moveElem != null) {
                if (this_.moveElem != elem) {
                    elem.accept(this_.moveElem);
                }
                this_.moveElem = null;
            } else {
                this_.moveElem = elem;
            }
        }
    }
}

