/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.util;

import com.tom.cpl.util.Image;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.AnimationEncodingData;
import com.tom.cpm.shared.editor.util.PlayerSkinLayer;
import com.tom.cpm.shared.model.SkinType;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class GetFreeSkinSlots {
    private static Image template;

    public static AnimationEncodingData getDefault(Editor editor) {
        AnimationEncodingData dt = new AnimationEncodingData();
        dt.freeLayers = GetFreeSkinSlots.getFreeLayers(editor.vanillaSkin, template, editor.skinType);
        return dt;
    }

    public static Set<PlayerSkinLayer> getFreeLayers(Image img, SkinType skinType) {
        return GetFreeSkinSlots.getFreeLayers(img, template, skinType);
    }

    public static Set<PlayerSkinLayer> getFreeLayers(Image img, Image template, SkinType skinType) {
        HashSet<PlayerSkinLayer> used = new HashSet<PlayerSkinLayer>(EnumSet.allOf(PlayerSkinLayer.class));
        int shift = 8 * (2 - skinType.getChannel());
        for (int x = 0; x < template.getWidth(); ++x) {
            for (int y = 0; y < template.getHeight(); ++y) {
                int i = img.getRGB(x, y);
                int t = template.getRGB(x, y);
                int v = (t & 255 << shift) >> shift & 0xFF;
                if ((t & 0xFF000000) == 0 || (i & 0xFF000000) <= 0) continue;
                used.remove((Object)PlayerSkinLayer.getEnc(v));
            }
        }
        return used;
    }

    public static void clearLayerArea(Image img, SkinType skinType, PlayerSkinLayer layer) {
        GetFreeSkinSlots.clearLayerArea(img, template, skinType, layer);
    }

    public static void clearLayerArea(Image img, Image template, SkinType skinType, PlayerSkinLayer layer) {
        int shift = 8 * (2 - skinType.getChannel());
        for (int x = 0; x < template.getWidth(); ++x) {
            for (int y = 0; y < template.getHeight(); ++y) {
                int t = template.getRGB(x, y);
                int v = (t & 255 << shift) >> shift & 0xFF;
                if ((t & 0xFF000000) == 0 || v != 1 << layer.ordinal()) continue;
                img.setRGB(x, y, 0);
            }
        }
    }

    static {
        try {
            InputStream is = GetFreeSkinSlots.class.getResourceAsStream("/assets/cpm/textures/template/layers_template.png");
            Throwable throwable = null;
            try {
                template = Image.loadFrom(is);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            template = null;
        }
    }
}

