/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.util;

import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.shared.editor.project.ProjectFile;
import com.tom.cpm.shared.editor.util.OpenRasterFile$$Lambda$1;
import com.tom.cpm.shared.editor.util.OpenRasterFile$ImageElement$;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class OpenRasterFile {
    private Stack root = new Stack(null, 0);
    private int width;
    private int height;

    public OpenRasterFile(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void addLayer(int ordering, Image img, int x, int y, String layerName) {
        this.root.addLayer(ordering, img, x, y, layerName);
    }

    public Stack addStack(String name, int ordering) {
        return this.root.addStack(name, ordering);
    }

    public CompletableFuture<Void> write(File file) throws IOException {
        int newHeight;
        int newWidth;
        Object l;
        ArrayList layers;
        ProjectFile pf = new ProjectFile();
        pf.setEntry("mimetype", "image/openraster".getBytes());
        this.root.sort();
        Image merged = new Image(this.width, this.height);
        ArrayList arrayList = layers = new ArrayList();
        arrayList.getClass();
        this.root.forEachLayer(OpenRasterFile$$Lambda$1.lambdaFactory$(arrayList));
        for (int i = layers.size() - 1; i >= 0; --i) {
            l = (Layer)layers.get(i);
            merged.draw(((Layer)l).img, ((Layer)l).x, ((Layer)l).y);
        }
        OutputStream os = pf.setAsStream("mergedimage.png");
        l = null;
        try {
            ImageIO.write(merged, os);
        }
        catch (Throwable throwable) {
            l = throwable;
            throw throwable;
        }
        finally {
            if (os != null) {
                if (l != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                    }
                } else {
                    os.close();
                }
            }
        }
        float aspectRatio = (float)this.width / (float)this.height;
        if (this.width > this.height) {
            newWidth = 256;
            newHeight = (int)((float)newWidth / aspectRatio);
        } else {
            newHeight = 256;
            newWidth = (int)((float)newHeight * aspectRatio);
        }
        Image icon = new Image(newWidth, newHeight);
        icon.draw(merged, 0, 0, newWidth, newHeight);
        for (Layer layer : layers) {
            OutputStream os2 = pf.setAsStream(layer.fileName);
            Throwable throwable = null;
            try {
                ImageIO.write(layer.img, os2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (os2 == null) continue;
                if (throwable != null) {
                    try {
                        os2.close();
                    }
                    catch (Throwable throwable3) {
                    }
                    continue;
                }
                os2.close();
            }
        }
        OutputStream os3 = pf.setAsStream("Thumbnails/thumbnail.png");
        Throwable throwable = null;
        try {
            ImageIO.write(icon, os3);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (os3 != null) {
                if (throwable != null) {
                    try {
                        os3.close();
                    }
                    catch (Throwable throwable5) {
                    }
                } else {
                    os3.close();
                }
            }
        }
        PrintWriter wr = new PrintWriter(new OutputStreamWriter(pf.setAsStream("stack.xml"), StandardCharsets.UTF_8));
        throwable = null;
        try {
            wr.println("<?xml version='1.0' encoding='UTF-8'?>");
            wr.println("<image version=\"0.0.3\" w=\"" + this.width + "\" h=\"" + this.height + "\" xres=\"600\" yres=\"600\">");
            wr.println("<stack>");
            this.root.printConfig(wr);
            wr.println("</stack>");
            wr.println("</image>");
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            if (wr != null) {
                if (throwable != null) {
                    try {
                        wr.close();
                    }
                    catch (Throwable throwable7) {
                    }
                } else {
                    wr.close();
                }
            }
        }
        return pf.save(file);
    }

    public static class Stack
    implements ImageElement {
        private String name;
        private List<ImageElement> elems = new ArrayList<ImageElement>();
        private int ordering;

        public Stack(String name, int ordering) {
            this.name = name;
            this.ordering = ordering;
        }

        public void printConfig(PrintWriter wr) {
            for (ImageElement i : this.elems) {
                if (i instanceof Layer) {
                    Layer layer = (Layer)i;
                    wr.println("<layer name=\"" + layer.name + "\" src=\"" + layer.fileName + "\" x=\"" + layer.x + "\" y=\"" + layer.y + "\" />");
                    continue;
                }
                if (!(i instanceof Stack)) continue;
                Stack s = (Stack)i;
                wr.println("<stack name=\"" + s.name + "\">");
                s.printConfig(wr);
                wr.println("</stack>");
            }
        }

        public void forEachLayer(Consumer<Layer> c) {
            for (ImageElement i : this.elems) {
                if (i instanceof Layer) {
                    c.accept((Layer)i);
                    continue;
                }
                if (!(i instanceof Stack)) continue;
                ((Stack)i).forEachLayer(c);
            }
        }

        public void sort() {
            Collections.sort(this.elems);
            for (ImageElement i : this.elems) {
                if (!(i instanceof Stack)) continue;
                ((Stack)i).sort();
            }
        }

        @Override
        public int getOrdering() {
            return this.ordering;
        }

        public void addLayer(int ordering, Image img, int x, int y, String layerName) {
            this.elems.add(new Layer(ordering, img, x, y, layerName));
        }

        public Stack addStack(String name, int ordering) {
            Stack s = new Stack(name, ordering);
            this.elems.add(s);
            return s;
        }

        @Override
        public int compareTo(ImageElement imageElement) {
            return OpenRasterFile$ImageElement$.compareTo((ImageElement)this, imageElement);
        }

        @Override
        public int compareTo(Object object) {
            return OpenRasterFile$ImageElement$.compareTo((ImageElement)this, object);
        }
    }

    private static class Layer
    implements ImageElement {
        private int ordering;
        private Image img;
        private int x;
        private int y;
        private String name;
        private String fileName;

        public Layer(int ordering, Image img, int x, int y, String name) {
            this.ordering = ordering;
            this.img = img;
            this.x = x;
            this.y = y;
            this.name = name;
            this.fileName = "data/" + UUID.randomUUID().toString().replace("-", "") + ".png";
        }

        @Override
        public int getOrdering() {
            return this.ordering;
        }

        @Override
        public int compareTo(ImageElement imageElement) {
            return OpenRasterFile$ImageElement$.compareTo((ImageElement)this, imageElement);
        }

        @Override
        public int compareTo(Object object) {
            return OpenRasterFile$ImageElement$.compareTo((ImageElement)this, object);
        }
    }

    private static interface ImageElement
    extends Comparable<ImageElement> {
        public int getOrdering();

        @Override
        public int compareTo(ImageElement var1);
    }
}

