/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpl.math.Vec4f;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.elements.MultiSelector;
import com.tom.cpm.shared.editor.elements.MultiSelector$;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.TreeElement$;
import com.tom.cpm.shared.editor.tree.TreeElement$TreeSettingElement$;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.editor.util.UVResizableArea$FaceArea$$Lambda$1;
import com.tom.cpm.shared.editor.util.UVResizableArea$MultiFaceArea$$Lambda$1;
import com.tom.cpm.shared.editor.util.UVResizableArea$MultiFaceArea$$Lambda$2;
import com.tom.cpm.shared.editor.util.UVResizableArea$MultiFaceArea$$Lambda$3;
import com.tom.cpm.shared.editor.util.UVResizableArea$MultiFaceArea$$Lambda$4;
import com.tom.cpm.shared.editor.util.UVResizableArea$MultiFaceArea$$Lambda$5;
import com.tom.cpm.shared.editor.util.UVResizableArea$MultiFaceArea$$Lambda$6;
import com.tom.cpm.shared.editor.util.UVResizableArea$MultiFaceArea$$Lambda$7;
import com.tom.cpm.shared.editor.util.UVResizableArea$MultiFaceArea$$Lambda$8;
import com.tom.cpm.shared.editor.util.UVResizableArea$MultiFaceArea$$Lambda$9;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class UVResizableArea {
    protected final Editor editor;
    protected final TreeElement parent;
    public final TreeElement.TreeSettingElement face;
    public final List<TreeElement.TreeSettingElement> elements;

    public UVResizableArea(Editor editor, TreeElement parent) {
        int i;
        this.editor = editor;
        this.parent = parent;
        this.face = this.face();
        this.elements = new ArrayList<TreeElement.TreeSettingElement>();
        for (i = 0; i < 4; ++i) {
            this.elements.add(new CornerArea(editor, parent, i));
        }
        for (i = 0; i < 4; ++i) {
            this.elements.add(new SideArea(editor, parent, i));
        }
        this.elements.add(this.face);
    }

    protected abstract Area getArea();

    protected abstract void setArea(Area var1, boolean var2);

    protected abstract void setAreaTemp(Area var1);

    protected FaceArea face() {
        return new FaceArea(this.editor, this.parent);
    }

    protected SideArea side(int i) {
        return new SideArea(this.editor, this.parent, i);
    }

    protected CornerArea corner(int i) {
        return new CornerArea(this.editor, this.parent, i);
    }

    public static Vec4f expandBox(Box b, float zoom) {
        if (b.w == 0 || b.h == 0) {
            float sx = b.x;
            float sy = b.y;
            float w = b.w;
            float h = b.h;
            float ex = 2.0f / zoom;
            if (b.w == 0) {
                sx -= ex;
                w = ex * 2.0f;
            }
            if (b.h == 0) {
                sy -= ex;
                h = ex * 2.0f;
            }
            if (b.w == 0 && b.h == 0) {
                sx -= ex;
                w = ex * 4.0f;
                sy -= ex;
                h = ex * 4.0f;
            }
            return new Vec4f(sx, sy, w, h);
        }
        return new Vec4f(b.x, b.y, b.w, b.h);
    }

    public static boolean isHovered(Box b, float x, float y, float zoom) {
        if (b == null) {
            return false;
        }
        if (b.w == 0 || b.h == 0) {
            Vec4f e = UVResizableArea.expandBox(b, zoom);
            return e.x <= x && e.y <= y && e.x + e.z > x && e.y + e.w > y;
        }
        return b.isInBounds((int)x, (int)y);
    }

    public static class MultiFaceArea
    implements MultiSelector {
        private List<FaceArea> elements = new ArrayList<FaceArea>();
        private final Editor editor;

        public MultiFaceArea(Editor editor) {
            this.editor = editor;
        }

        private void addImpl(FaceArea faceArea) {
            if (this.elements.contains(faceArea)) {
                this.elements.remove(faceArea);
            } else {
                this.elements.add(faceArea);
            }
        }

        @Override
        public Vec3f getVec(VecType type) {
            if (type == VecType.TEXTURE) {
                return this.elements.stream().map(UVResizableArea$MultiFaceArea$$Lambda$1.lambdaFactory$()).reduce(new Vec3f(2.1474836E9f, 2.1474836E9f, 1.0f), UVResizableArea$MultiFaceArea$$Lambda$2.lambdaFactory$());
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f v, VecType object) {
            if (object == VecType.TEXTURE) {
                Vec3f uv = this.getVec(VecType.TEXTURE);
                float uOff = v.x - uv.x;
                float vOff = v.y - uv.y;
                this.elements.forEach(UVResizableArea$MultiFaceArea$$Lambda$3.lambdaFactory$(uOff, vOff));
            }
        }

        @Override
        public void setVecTemp(VecType object, Vec3f v) {
            if (object == VecType.TEXTURE) {
                Vec3f uv = this.getVec(VecType.TEXTURE);
                float uOff = v.x - uv.x;
                float vOff = v.y - uv.y;
                this.elements.forEach(UVResizableArea$MultiFaceArea$$Lambda$4.lambdaFactory$(uOff, vOff));
            }
        }

        @Override
        public boolean isSelected(Editor e, TreeElement other) {
            return this.elements.contains(other);
        }

        @Override
        public ETextures getTexture() {
            if (this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(0).getTexture();
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            this.elements.forEach(UVResizableArea$MultiFaceArea$$Lambda$5.lambdaFactory$(gui, x, y, xs, ys));
        }

        @Override
        public boolean add(TreeElement modelElement) {
            if (modelElement instanceof FaceArea) {
                this.addImpl((FaceArea)modelElement);
            } else if (modelElement instanceof ModelElement) {
                ModelElement me = (ModelElement)modelElement;
                if (me.faceUV != null) {
                    me.faceUV.getFaceElements(me).forEach(UVResizableArea$MultiFaceArea$$Lambda$6.lambdaFactory$(this));
                }
            }
            return this.elements.isEmpty();
        }

        @Override
        public void forEachSelected(Consumer<TreeElement> c) {
            this.elements.forEach(c);
        }

        @Override
        public void updateGui() {
            this.editor.setModePanel.accept(ModeDisplayType.TEX);
            Vec3f v = this.getVec(VecType.TEXTURE);
            this.editor.setTexturePanel.accept(new Vec3i((int)v.x, (int)v.y, 1));
        }

        @Override
        public Box getTextureBox() {
            return this.elements.stream().map(UVResizableArea$MultiFaceArea$$Lambda$7.lambdaFactory$()).filter(UVResizableArea$MultiFaceArea$$Lambda$8.lambdaFactory$()).reduce(null, UVResizableArea$MultiFaceArea$$Lambda$9.lambdaFactory$());
        }

        static /* synthetic */ Box lambda$getTextureBox$7(Box a, Box b) {
            return a == null ? b : (b == null ? a : a.union(b));
        }

        static /* synthetic */ boolean lambda$getTextureBox$6(Box e) {
            return e != null;
        }

        static /* synthetic */ void lambda$add$5(MultiFaceArea this_, TreeElement.TreeSettingElement f) {
            if (f instanceof FaceArea) {
                this_.addImpl((FaceArea)f);
            }
        }

        static /* synthetic */ void lambda$drawTexture$4(IGui gui, int x, int y, float xs, float ys, FaceArea e) {
            e.drawTexture(gui, x, y, xs, ys);
        }

        static /* synthetic */ void lambda$setVecTemp$3(float uOff, float vOff, FaceArea e) {
            Vec3f ve = e.getVec(VecType.TEXTURE);
            e.setVecTemp(VecType.TEXTURE, new Vec3f(ve.x + uOff, ve.y + vOff, 1.0f));
        }

        static /* synthetic */ void lambda$setVec$2(float uOff, float vOff, FaceArea e) {
            Vec3f ve = e.getVec(VecType.TEXTURE);
            e.setVec(new Vec3f(ve.x + uOff, ve.y + vOff, 1.0f), VecType.TEXTURE);
        }

        static /* synthetic */ Vec3f lambda$getVec$1(Vec3f a, Vec3f b) {
            return new Vec3f(Math.min(a.x, b.x), Math.min(a.y, b.y), 1.0f);
        }

        static /* synthetic */ Vec3f lambda$getVec$0(FaceArea e) {
            return e.getVec(VecType.TEXTURE);
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public String getName() {
            return MultiSelector$.getName(this);
        }

        @Override
        public Tooltip getTooltip(IGui iGui) {
            return TreeElement$.getTooltip(this, iGui);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    protected class SideArea
    extends BaseArea {
        private int side;

        public SideArea(Editor editor, TreeElement parent, int side) {
            super(editor, parent);
            this.side = side;
        }

        @Override
        public Vec3f getVec(VecType type) {
            Area f = UVResizableArea.this.getArea();
            if (type == VecType.TEXTURE) {
                return new Vec3f(this.side > 1 && this.side % 2 != 0 ? (float)f.ex : (float)f.sx, this.side > 1 && this.side % 2 == 0 ? (float)f.ey : (float)f.sy, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f vec, VecType object) {
            if (object == VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.side % 2 == 0) {
                    if (this.side > 1) {
                        f.ey = (int)vec.y;
                    } else {
                        f.sy = (int)vec.y;
                    }
                } else if (this.side > 1) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                UVResizableArea.this.setArea(f, false);
            }
        }

        @Override
        public void setVecTemp(VecType type, Vec3f vec) {
            if (type == VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.side % 2 == 0) {
                    if (this.side > 1) {
                        f.ey = (int)vec.y;
                    } else {
                        f.sy = (int)vec.y;
                    }
                } else if (this.side > 1) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                UVResizableArea.this.setAreaTemp(f);
            }
        }

        @Override
        public Box getTextureBox() {
            Area f = UVResizableArea.this.getArea();
            return new Box(this.side > 1 && this.side % 2 != 0 ? f.ex : f.sx, this.side > 1 && this.side % 2 == 0 ? f.ey : f.sy, this.side % 2 == 0 ? f.ex - f.sx : 0, this.side % 2 != 0 ? f.ey - f.sy : 0);
        }

        @Override
        protected int getColor() {
            return -10066330;
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public String getName() {
            return TreeElement$TreeSettingElement$.getName(this);
        }

        @Override
        public ETextures getTexture() {
            return TreeElement$TreeSettingElement$.getTexture(this);
        }

        @Override
        public Tooltip getTooltip(IGui iGui) {
            return TreeElement$.getTooltip(this, iGui);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public void updateGui() {
            TreeElement$.updateGui(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        @Override
        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$TreeSettingElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    protected class CornerArea
    extends BaseArea {
        private int corner;

        public CornerArea(Editor editor, TreeElement parent, int corner) {
            super(editor, parent);
            this.corner = corner;
        }

        @Override
        public Vec3f getVec(VecType type) {
            Area f = UVResizableArea.this.getArea();
            if (type == VecType.TEXTURE) {
                return new Vec3f(this.corner % 2 != 0 ? (float)f.ex : (float)f.sx, this.corner > 1 ? (float)f.ey : (float)f.sy, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f vec, VecType object) {
            if (object == VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.corner % 2 != 0) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                if (this.corner > 1) {
                    f.ey = (int)vec.y;
                } else {
                    f.sy = (int)vec.y;
                }
                UVResizableArea.this.setArea(f, false);
            }
        }

        @Override
        public void setVecTemp(VecType type, Vec3f vec) {
            if (type == VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.corner % 2 != 0) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                if (this.corner > 1) {
                    f.ey = (int)vec.y;
                } else {
                    f.sy = (int)vec.y;
                }
                UVResizableArea.this.setAreaTemp(f);
            }
        }

        @Override
        public Box getTextureBox() {
            Area f = UVResizableArea.this.getArea();
            return new Box(this.corner % 2 != 0 ? f.ex : f.sx, this.corner > 1 ? f.ey : f.sy, 0, 0);
        }

        @Override
        protected int getColor() {
            return -5592406;
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public String getName() {
            return TreeElement$TreeSettingElement$.getName(this);
        }

        @Override
        public ETextures getTexture() {
            return TreeElement$TreeSettingElement$.getTexture(this);
        }

        @Override
        public Tooltip getTooltip(IGui iGui) {
            return TreeElement$.getTooltip(this, iGui);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public void updateGui() {
            TreeElement$.updateGui(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        @Override
        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$TreeSettingElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    protected class FaceArea
    extends BaseArea {
        public FaceArea(Editor editor, TreeElement parent) {
            super(editor, parent);
        }

        @Override
        public Vec3f getVec(VecType type) {
            Area f = UVResizableArea.this.getArea();
            if (type == VecType.TEXTURE) {
                return new Vec3f(f.sx, f.sy, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f vec, VecType object) {
            if (object == VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                int x = (int)vec.x - f.sx;
                int y = (int)vec.y - f.sy;
                f.sx += x;
                f.sy += y;
                f.ex += x;
                f.ey += y;
                UVResizableArea.this.setArea(f, true);
            }
        }

        @Override
        public void setVecTemp(VecType type, Vec3f vec) {
            if (type == VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                int x = (int)vec.x - f.sx;
                int y = (int)vec.y - f.sy;
                f.sx += x;
                f.sy += y;
                f.ex += x;
                f.ey += y;
                UVResizableArea.this.setAreaTemp(f);
            }
        }

        @Override
        public Box getTextureBox() {
            Area f = UVResizableArea.this.getArea();
            int sx = Math.min(f.sx, f.ex);
            int sy = Math.min(f.sy, f.ey);
            int ex = Math.max(f.sx, f.ex);
            int ey = Math.max(f.sy, f.ey);
            return new Box(sx, sy, ex - sx, ey - sy);
        }

        @Override
        public void onClick(IGui gui, Editor e, MouseEvent evt) {
            if (gui.isCtrlDown()) {
                if (e.selectedElement instanceof MultiFaceArea) {
                    if (((MultiFaceArea)e.selectedElement).add(this)) {
                        e.selectedElement = null;
                    }
                } else if (e.selectedElement instanceof FaceArea || e.selectedElement instanceof ModelElement) {
                    MultiFaceArea ms = new MultiFaceArea(e);
                    if (e.selectedElement instanceof ModelElement) {
                        ModelElement me = (ModelElement)e.selectedElement;
                        TreeElement.TreeSettingElement f = me.faceUV.getFaceElement(me, me.editor.perfaceFaceDir.get());
                        if (f != null && f instanceof FaceArea) {
                            ms.add(f);
                        }
                    } else {
                        ms.add(e.selectedElement);
                    }
                    ms.add(this);
                    e.selectedElement = ms;
                } else if (e.selectedElement instanceof MultiSelector) {
                    MultiFaceArea ms = new MultiFaceArea(e);
                    MultiSelector multiSelector = (MultiSelector)e.selectedElement;
                    MultiFaceArea multiFaceArea = ms;
                    multiFaceArea.getClass();
                    multiSelector.forEachSelected(UVResizableArea$FaceArea$$Lambda$1.lambdaFactory$(multiFaceArea));
                    ms.add(this);
                    e.selectedElement = ms;
                } else {
                    e.selectedElement = this;
                }
            } else {
                e.selectedElement = this;
            }
        }

        @Override
        protected int getColor() {
            return -6710887;
        }

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public String getName() {
            return TreeElement$TreeSettingElement$.getName(this);
        }

        @Override
        public ETextures getTexture() {
            return TreeElement$TreeSettingElement$.getTexture(this);
        }

        @Override
        public Tooltip getTooltip(IGui iGui) {
            return TreeElement$.getTooltip(this, iGui);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public void updateGui() {
            TreeElement$.updateGui(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        @Override
        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        @Override
        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$TreeSettingElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    private abstract class BaseArea
    implements TreeElement.TreeSettingElement {
        protected final Editor editor;
        protected final TreeElement parent;

        public BaseArea(Editor editor, TreeElement parent) {
            this.editor = editor;
            this.parent = parent;
        }

        @Override
        public TreeElement getParent() {
            return this.parent;
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            if (this.editor.selectedElement == this) {
                TreeElement$TreeSettingElement$.drawTexture(this, gui, x, y, xs, ys);
            }
            Box b = this.getTextureBox();
            Vec4f v = UVResizableArea.expandBox(b, xs);
            gui.drawRectangle((float)x + v.x * xs, (float)y + v.y * ys, v.z * xs, v.w * ys, this.getColor());
        }

        protected abstract int getColor();

        @Override
        public void accept(TreeElement treeElement) {
            TreeElement$.accept(this, treeElement);
        }

        @Override
        public void delete() {
            TreeElement$.delete(this);
        }

        @Override
        public String getName() {
            return TreeElement$TreeSettingElement$.getName(this);
        }

        @Override
        public Vec3f getVec(VecType vecType) {
            return TreeElement$.getVec(this, vecType);
        }

        @Override
        public ETextures getTexture() {
            return TreeElement$TreeSettingElement$.getTexture(this);
        }

        @Override
        public void setVec(Vec3f vec3f, VecType vecType) {
            TreeElement$.setVec(this, vec3f, vecType);
        }

        @Override
        public Tooltip getTooltip(IGui iGui) {
            return TreeElement$.getTooltip(this, iGui);
        }

        @Override
        public void setElemColor(int n) {
            TreeElement$.setElemColor(this, n);
        }

        @Override
        public void switchEffect(Effect effect) {
            TreeElement$.switchEffect(this, effect);
        }

        @Override
        public void addNew() {
            TreeElement$.addNew(this);
        }

        @Override
        public void updateGui() {
            TreeElement$.updateGui(this);
        }

        @Override
        public String getElemName() {
            return TreeElement$.getElemName(this);
        }

        @Override
        public void setValue(float f) {
            TreeElement$.setValue(this, f);
        }

        @Override
        public void setVecTemp(VecType vecType, Vec3f vec3f) {
            TreeElement$.setVecTemp(this, vecType, vec3f);
        }

        @Override
        public Box getTextureBox() {
            return TreeElement$.getTextureBox(this);
        }

        @Override
        public void onRefreshTree() {
            TreeElement$.onRefreshTree(this);
        }

        public List getSettingsElements() {
            return TreeElement$.getSettingsElements(this);
        }

        @Override
        public boolean canAccept(TreeElement treeElement) {
            return TreeElement$.canAccept(this, treeElement);
        }

        @Override
        public void populatePopup(PopupMenu popupMenu) {
            TreeElement$.populatePopup(this, popupMenu);
        }

        @Override
        public void modeSwitch() {
            TreeElement$.modeSwitch(this);
        }

        @Override
        public boolean canEditVec(VecType vecType) {
            return TreeElement$.canEditVec(this, vecType);
        }

        @Override
        public void switchVis() {
            TreeElement$.switchVis(this);
        }

        @Override
        public void onClick(IGui iGui, Editor editor, MouseEvent mouseEvent) {
            TreeElement$.onClick(this, iGui, editor, mouseEvent);
        }

        @Override
        public void setElemName(String string) {
            TreeElement$.setElemName(this, string);
        }

        public void getTreeElements(Consumer consumer) {
            TreeElement$.getTreeElements(this, consumer);
        }

        @Override
        public boolean isSelected(Editor editor, TreeElement treeElement) {
            return TreeElement$TreeSettingElement$.isSelected(this, editor, treeElement);
        }

        @Override
        public boolean canMove() {
            return TreeElement$.canMove(this);
        }

        @Override
        public void drawName(IGui iGui, int n, int n2, int n3) {
            TreeElement$.drawName(this, iGui, n, n2, n3);
        }

        @Override
        public void setMCScale(float f) {
            TreeElement$.setMCScale(this, f);
        }

        @Override
        public int textColor(IGui iGui) {
            return TreeElement$.textColor(this, iGui);
        }

        @Override
        public float getValue() {
            return TreeElement$.getValue(this);
        }

        @Override
        public boolean canSelect() {
            return TreeElement$.canSelect(this);
        }

        @Override
        public int bgColor(IGui iGui) {
            return TreeElement$.bgColor(this, iGui);
        }

        @Override
        public int getExtraWidth(IGui iGui) {
            return TreeElement$.getExtraWidth(this, iGui);
        }
    }

    public static class Area {
        public int sx;
        public int sy;
        public int ex;
        public int ey;

        public Area(int sx, int sy, int ex, int ey) {
            this.sx = sx;
            this.sy = sy;
            this.ex = ex;
            this.ey = ey;
        }
    }
}

