/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.effects;

import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.effects.EffectScaling$$Lambda$1;
import com.tom.cpm.shared.effects.IRenderEffect;
import com.tom.cpm.shared.effects.RenderEffects;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.ScaleData;
import com.tom.cpm.shared.util.ScalingOptions;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;

public class EffectScaling
implements IRenderEffect {
    private Map<ScalingOptions, Float> scaling;

    public EffectScaling() {
        this.scaling = new EnumMap<ScalingOptions, Float>(ScalingOptions.class);
    }

    public EffectScaling(Map<ScalingOptions, Float> scaling) {
        this.scaling = scaling;
    }

    @Override
    public void load(IOHelper in) throws IOException {
        while (in.available() > 0) {
            ScalingOptions opt = (ScalingOptions)in.readEnum(ScalingOptions.VALUES);
            float v = in.readFloat2();
            if (opt == null) continue;
            this.scaling.put(opt, Float.valueOf(v));
        }
    }

    @Override
    public void write(IOHelper out) throws IOException {
        for (Map.Entry<ScalingOptions, Float> e : this.scaling.entrySet()) {
            if (e.getValue().floatValue() == 0.0f || e.getValue().floatValue() == 1.0f) continue;
            out.writeEnum((Enum)e.getKey());
            out.writeFloat2(e.getValue().floatValue());
        }
    }

    @Override
    public void apply(ModelDefinition def) {
        def.setScale(new ScaleData(this.scaling));
    }

    @Override
    public RenderEffects getEffect() {
        return RenderEffects.SCALING;
    }

    public String toString() {
        return this.scaling.entrySet().stream().map(EffectScaling$$Lambda$1.lambdaFactory$()).collect(Collectors.joining("\n", "Scaling:\n", "\n"));
    }

    static /* synthetic */ String lambda$toString$0(Map.Entry e) {
        return ((ScalingOptions)((Object)e.getKey())).name() + ": " + e.getValue();
    }
}

