/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.config.Keybind;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.gui.Keybinds;
import com.tom.cpm.shared.gui.KeybindsPopup$$Lambda$1;
import com.tom.cpm.shared.gui.panel.KeybindPanel;
import com.tom.cpm.shared.gui.panel.MouseControlsPanel;

public class KeybindsPopup
extends PopupPanel {
    private final ConfigEntry ce;

    public KeybindsPopup(Frame frm, final ConfigEntry ce) {
        super(frm.getGui());
        this.ce = ce;
        this.setBounds(new Box(0, 0, 350, 300));
        ScrollPanel scp = new ScrollPanel(this.gui){

            @Override
            protected float getScrollSpeed() {
                return (float)ce.getInt("mouseWheelSensitivity", 100) / 100.0f;
            }
        };
        scp.setBounds(new Box(0, 5, 350, 290));
        this.addElement(scp);
        Panel panel = new Panel(this.gui);
        panel.setBounds(new Box(0, 0, 350, 0));
        scp.setDisplay(panel);
        FlowLayout layout = new FlowLayout(panel, 5, 1);
        for (Object kb : Keybinds.KEYBINDS) {
            if (kb == Keybinds.MOUSE_MARKER) {
                panel.addElement(new MouseControlsPanel(this.gui, ce));
                continue;
            }
            if (kb instanceof Keybind) {
                panel.addElement(new KeybindPanel(frm, (Keybind)kb, ce));
                continue;
            }
            panel.addElement(new Label(this.gui, this.gui.i18nFormat("label.cpm.keybinds." + kb, new Object[0])).setBounds(new Box(5, 0, 100, 10)));
        }
        MinecraftClientAccess$.get().populatePlatformSettings("keybind", panel);
        layout.reflow();
    }

    public static KeybindsPopup create(Frame frm) {
        ModConfigFile.ConfigEntryTemp ce = ModConfig.getCommonConfig().createTemp();
        KeybindsPopup p = new KeybindsPopup(frm, ce);
        p.setBounds(new Box(0, 0, 350, 325));
        Button save = new Button(frm.getGui(), frm.getGui().i18nFormat("button.cpm.saveCfg", new Object[0]), KeybindsPopup$$Lambda$1.lambdaFactory$(ce, p));
        save.setBounds(new Box(5, 300, 80, 20));
        p.addElement(save);
        return p;
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.keybinds.title", new Object[0]);
    }

    private void updateMouseButtons() {
    }

    private String getRotateBtn() {
        return this.gui.i18nFormat("label.cpm.mouse." + this.ce.getInt("editorRotateMouseButton", 2), new Object[0]);
    }

    private String getDragBtn() {
        int d = this.ce.getInt("editorDragMouseButton", -1);
        if (d == -1) {
            return this.gui.i18nFormat("label.cpm.keybind.mod.shift", this.getRotateBtn());
        }
        return this.gui.i18nFormat("label.cpm.mouse." + d, new Object[0]);
    }

    private String getMenuBtn() {
        int d = this.ce.getInt("editorMenuMouseButton", -1);
        if (d == -1) {
            return this.gui.i18nFormat("label.cpm.keybind.mod.ctrl", this.getRotateBtn());
        }
        return this.gui.i18nFormat("label.cpm.mouse." + d, new Object[0]);
    }

    static /* synthetic */ void lambda$create$0(ModConfigFile.ConfigEntryTemp ce, KeybindsPopup p) {
        ce.saveConfig();
        p.close();
    }
}

