/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$1;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$10;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$11;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$12;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$13;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$14;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$15;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$16;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$17;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$18;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$19;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$2;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$20;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$21;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$22;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$23;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$24;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$25;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$3;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$4;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$5;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$6;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$7;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$8;
import com.tom.cpm.shared.gui.PropertiesPopup$$Lambda$9;
import com.tom.cpm.shared.gui.gesture.GestureGuiButtons;
import com.tom.cpm.shared.gui.gesture.IGestureButtonContainer;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PropertiesPopup
extends PopupPanel
implements IGestureButtonContainer {
    private ConfigEntry prop;
    private ConfigEntry current;
    private final ModelDefinition def;
    private List<Runnable> updateState;
    private List<Profile> ps;
    private DropDownBox<Profile> profileBox;
    private Profile createNew;

    public PropertiesPopup(IGui gui, int h, ModelDefinition def) {
        super(gui);
        Profile sel;
        this.def = def;
        this.updateState = new ArrayList<Runnable>();
        if (def.getAnimations().getProfileId() != null) {
            this.prop = ModConfig.getCommonConfig().getEntry("modelProperties").getEntry(def.getAnimations().getProfileId());
            this.ps = this.prop.getEntry("profiles").keySet().stream().map(PropertiesPopup$$Lambda$1.lambdaFactory$(this)).collect(Collectors.toList());
            this.createNew = new Profile(false);
            this.ps.add(this.createNew);
            this.ps.add(new Profile(true));
            this.current = this.prop.getEntry("values");
            String s = this.prop.getString("selected", null);
            sel = s == null ? null : (Profile)this.ps.stream().filter(PropertiesPopup$$Lambda$2.lambdaFactory$(s)).findFirst().orElse(null);
        } else {
            this.ps = Collections.emptyList();
            sel = null;
        }
        this.profileBox = new DropDownBox<Profile>(gui.getFrame(), this.ps);
        this.profileBox.setBounds(new Box(5, 5, 160, 20));
        if (sel != null) {
            this.profileBox.setSelected(sel);
        }
        this.addElement(this.profileBox);
        Button save = new Button(gui, gui.i18nFormat("button.cpm.file.save", new Object[0]), PropertiesPopup$$Lambda$3.lambdaFactory$(this, gui));
        save.setBounds(new Box(5, 30, 50, 20));
        this.addElement(save);
        Button load = new Button(gui, gui.i18nFormat("button.cpm.file.load", new Object[0]), PropertiesPopup$$Lambda$4.lambdaFactory$(this, gui));
        load.setBounds(new Box(60, 30, 50, 20));
        this.addElement(load);
        Button del = new Button(gui, gui.i18nFormat("button.cpm.delete", new Object[0]), ConfirmPopup.confirmHandler(gui.getFrame(), gui.i18nFormat("label.cpm.confirmDel", new Object[0]), PropertiesPopup$$Lambda$5.lambdaFactory$(this)));
        del.setBounds(new Box(115, 30, 50, 20));
        this.addElement(del);
        ScrollPanel scp = new ScrollPanel(gui);
        scp.setBounds(new Box(5, 55, 160, h - 60));
        this.addElement(scp);
        Panel panel = new Panel(gui);
        FlowLayout layout = new FlowLayout(panel, 5, 1);
        scp.setDisplay(panel);
        panel.setBounds(new Box(0, 0, 160, 0));
        def.getAnimations().getNamedActions().stream().filter(PropertiesPopup$$Lambda$6.lambdaFactory$()).map(PropertiesPopup$$Lambda$7.lambdaFactory$(this)).filter(PropertiesPopup$$Lambda$8.lambdaFactory$()).forEach(PropertiesPopup$$Lambda$9.lambdaFactory$(panel));
        if (panel.getElements().isEmpty()) {
            panel.addElement(new Label(gui, gui.i18nFormat("label.cpm.nothing_here", new Object[0])).setBounds(new Box(5, 5, 100, 10)));
        } else {
            this.updateState.forEach(PropertiesPopup$$Lambda$10.lambdaFactory$());
        }
        if (panel.getElements().isEmpty() || def.getAnimations().getProfileId() == null) {
            this.profileBox.setEnabled(false);
            save.setEnabled(false);
            load.setEnabled(false);
            del.setEnabled(false);
        }
        layout.reflow();
        this.setBounds(new Box(0, 0, 170, h));
    }

    private void saveProfile(String name) {
        ConfigEntry ce = this.prop.getEntry("profiles").getEntry(name);
        ce.clear();
        this.def.getAnimations().getNamedActions().stream().filter(PropertiesPopup$$Lambda$11.lambdaFactory$()).forEach(PropertiesPopup$$Lambda$12.lambdaFactory$(ce));
        this.prop.setString("selected", name);
        ModConfig.getCommonConfig().save();
    }

    private void resetProfile() {
        this.current.clear();
        this.prop.clearValue("selected");
        this.def.getAnimations().getNamedActions().stream().filter(PropertiesPopup$$Lambda$13.lambdaFactory$()).forEach(PropertiesPopup$$Lambda$14.lambdaFactory$(this));
        ModConfig.getCommonConfig().save();
        this.updateState.forEach(PropertiesPopup$$Lambda$15.lambdaFactory$());
    }

    private void loadProfile(String name) {
        ConfigEntry ce = this.prop.getEntry("profiles").getEntry(name);
        this.current.clear();
        this.prop.setString("selected", name);
        ModConfig.getCommonConfig().save();
        this.def.getAnimations().getNamedActions().stream().filter(PropertiesPopup$$Lambda$16.lambdaFactory$()).forEach(PropertiesPopup$$Lambda$17.lambdaFactory$(ce));
        this.updateState.forEach(PropertiesPopup$$Lambda$18.lambdaFactory$());
    }

    @Override
    public void onClosed() {
        this.def.getAnimations().getNamedActions().stream().filter(PropertiesPopup$$Lambda$19.lambdaFactory$()).forEach(PropertiesPopup$$Lambda$20.lambdaFactory$(this));
        ModConfig.getCommonConfig().save();
        super.onClosed();
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.modelProperties", new Object[0]);
    }

    @Override
    public IGui gui() {
        return this.gui;
    }

    @Override
    public void updateKeybind(String keybind, String id, boolean mode) {
    }

    @Override
    public IGestureButtonContainer.BoundKeyInfo getBoundKey(String id) {
        return null;
    }

    @Override
    public void valueChanged() {
        if (this.profileBox.getSelected() != null && this.profileBox.getSelected().reset) {
            this.profileBox.setSelected(this.createNew);
        }
    }

    @Override
    public boolean canBindKeys() {
        return false;
    }

    static /* synthetic */ void lambda$onClosed$16(PropertiesPopup this_, AbstractGestureButtonData g) {
        g.storeTo(this_.current);
    }

    static /* synthetic */ void lambda$loadProfile$15(ConfigEntry ce, AbstractGestureButtonData g) {
        g.loadFrom(ce);
    }

    static /* synthetic */ void lambda$resetProfile$14(PropertiesPopup this_, AbstractGestureButtonData g) {
        g.loadFrom(this_.current);
    }

    static /* synthetic */ void lambda$saveProfile$13(ConfigEntry ce, AbstractGestureButtonData g) {
        g.storeTo(ce);
    }

    static /* synthetic */ void lambda$new$12(Panel panel, GuiElement g) {
        g.setBounds(new Box(5, 0, 150, 20));
        panel.addElement(g);
    }

    static /* synthetic */ boolean lambda$new$11(GuiElement e) {
        return e != null;
    }

    static /* synthetic */ GuiElement lambda$new$10(PropertiesPopup this_, AbstractGestureButtonData t) {
        return GestureGuiButtons.make(this_, t);
    }

    static /* synthetic */ boolean lambda$new$9(AbstractGestureButtonData d) {
        return d.isProperty() && d.canShow();
    }

    static /* synthetic */ void lambda$new$8(PropertiesPopup this_) {
        Profile p = this_.profileBox.getSelected();
        if (p != null && p.name != null) {
            this_.ps.remove(p);
            this_.prop.getEntry("profiles").clearValue(p.name);
            this_.profileBox.setSelected(null);
        }
    }

    static /* synthetic */ void lambda$new$7(PropertiesPopup this_, IGui gui) {
        Profile p = this_.profileBox.getSelected();
        if (p != null) {
            if (p.name != null) {
                ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.loadProfile", p.name), PropertiesPopup$$Lambda$21.lambdaFactory$(this_, p));
            } else if (p.reset) {
                ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.loadProfile", p.toString()), PropertiesPopup$$Lambda$22.lambdaFactory$(this_));
            }
        }
    }

    static /* synthetic */ void lambda$null$6(PropertiesPopup this_, Profile p) {
        this_.loadProfile(p.name);
    }

    static /* synthetic */ void lambda$new$5(PropertiesPopup this_, IGui gui) {
        Profile p = this_.profileBox.getSelected();
        if (p != null) {
            if (p.name == null) {
                new InputPopup(gui.getFrame(), gui.i18nFormat("label.cpm.name", new Object[0]), PropertiesPopup$$Lambda$23.lambdaFactory$(this_, gui), null).run();
            } else {
                ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.overwriteProfile", new Object[0]), PropertiesPopup$$Lambda$24.lambdaFactory$(this_, p));
            }
        }
    }

    static /* synthetic */ void lambda$null$4(PropertiesPopup this_, Profile p) {
        this_.saveProfile(p.name);
    }

    static /* synthetic */ void lambda$null$3(PropertiesPopup this_, IGui gui, String n) {
        if (this_.prop.getEntry("profiles").hasEntry(n)) {
            ConfirmPopup.confirm(gui.getFrame(), gui.i18nFormat("label.cpm.overwriteProfile", new Object[0]), PropertiesPopup$$Lambda$25.lambdaFactory$(this_, n));
        } else {
            Profile pr = this_.new Profile(n);
            this_.saveProfile(n);
            this_.ps.add(pr);
            this_.profileBox.setSelected(pr);
        }
    }

    static /* synthetic */ void lambda$null$2(PropertiesPopup this_, String n) {
        this_.saveProfile(n);
    }

    static /* synthetic */ boolean lambda$new$1(String s, Profile p) {
        return s.equals(p.name);
    }

    static /* synthetic */ Profile lambda$new$0(PropertiesPopup this_, String x$0) {
        return this_.new Profile(x$0);
    }

    static /* synthetic */ void access$lambda$0(PropertiesPopup propertiesPopup) {
        propertiesPopup.resetProfile();
    }

    private class Profile
    implements Comparable<Profile> {
        private String name;
        private boolean reset;

        public Profile(boolean reset) {
            this.name = null;
            this.reset = reset;
        }

        public Profile(String name) {
            this.name = name;
            this.reset = false;
        }

        public String toString() {
            return this.name != null ? this.name : (this.reset ? PropertiesPopup.this.gui.i18nFormat("label.cpm.reset_profile", new Object[0]) : PropertiesPopup.this.gui.i18nFormat("label.cpm.new_profile", new Object[0]));
        }

        @Override
        public int compareTo(Profile o) {
            if (o.name == this.name) {
                return 0;
            }
            if (this.name == null && o.name != null) {
                return -1;
            }
            if (o.name == null && this.name != null) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }
    }
}

