/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.ProcessPopup;
import com.tom.cpl.util.EmbeddedLocalizations;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.gui.SkinUploadPopup$$Lambda$1;
import com.tom.cpm.shared.gui.SkinUploadPopup$$Lambda$2;
import com.tom.cpm.shared.gui.SkinUploadPopup$$Lambda$3;
import com.tom.cpm.shared.gui.SkinUploadPopup$$Lambda$4;
import com.tom.cpm.shared.gui.SkinUploadPopup$$Lambda$5;
import com.tom.cpm.shared.gui.SkinUploadPopup$$Lambda$6;
import com.tom.cpm.shared.gui.SkinUploadPopup$$Lambda$7;
import com.tom.cpm.shared.gui.SkinUploadPopup$$Lambda$8;
import com.tom.cpm.shared.gui.SkinUploadPopup$$Lambda$9;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.MojangAPI;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SkinUploadPopup
extends ProcessPopup<Void> {
    private SkinType type;
    private Image img;
    private List<GuiElement> labelsOld;

    public SkinUploadPopup(Frame frm, SkinType type, Image img) {
        super(frm);
        this.type = type;
        this.img = img;
        this.title = this.gui.i18nFormat("label.cpm.uploading", new Object[0]);
        this.finished = SkinUploadPopup$$Lambda$1.lambdaFactory$();
        this.error = SkinUploadPopup$$Lambda$2.lambdaFactory$(this, frm);
        this.function = SkinUploadPopup$$Lambda$3.lambdaFactory$(this);
        this.reSetupLabels("");
    }

    private Void process() {
        this.setupLabelsExec(this.gui.i18nFormat("label.cpm.uploading.connecting", new Object[0]));
        MojangAPI api = MinecraftClientAccess$.get().getMojangAPI();
        if (this.cancelled.get()) {
            return null;
        }
        this.setupLabelsExec(this.gui.i18nFormat("label.cpm.uploading.skin", new Object[0]));
        try {
            api.uploadSkin(this.type, this.img);
        }
        catch (Exception e) {
            if (this.cancelled.get()) {
                return null;
            }
            Log.warn("Failed to upload skin", e);
            this.gui.executeLater(new ConfirmPopup(this.frame, this.title, this.gui.i18nFormat("label.cpm.skinUpload.fail", e.getMessage()), SkinUploadPopup$$Lambda$4.lambdaFactory$(this), null, this.gui.i18nFormat("button.cpm.saveSkinFile", new Object[0])));
            return null;
        }
        this.gui.executeLater(new MessagePopup(this.frame, this.gui.i18nFormat("label.cpm.export_success", new Object[0]), this.gui.i18nFormat("label.cpm.skinUpload.success", new Object[0])));
        MinecraftClientAccess minecraftClientAccess = MinecraftClientAccess$.get();
        minecraftClientAccess.getClass();
        this.gui.executeLater(SkinUploadPopup$$Lambda$5.lambdaFactory$(minecraftClientAccess));
        return null;
    }

    private void setupLabelsExec(String text) {
        this.gui.executeLater(SkinUploadPopup$$Lambda$6.lambdaFactory$(this, text));
    }

    private void reSetupLabels(String text) {
        if (this.labelsOld != null) {
            this.labelsOld.forEach(SkinUploadPopup$$Lambda$7.lambdaFactory$(this));
        }
        this.labelsOld = this.setupLabels(text);
    }

    private void save() {
        FileChooserPopup fc = new FileChooserPopup(this.frame);
        fc.setTitle(EmbeddedLocalizations.exportSkin);
        fc.setFileDescText(EmbeddedLocalizations.filePng);
        fc.setFilter(new FileChooserPopup.FileFilter("png"));
        fc.setSaveDialog(true);
        fc.setExtAdder(SkinUploadPopup$$Lambda$8.lambdaFactory$());
        fc.setAccept(SkinUploadPopup$$Lambda$9.lambdaFactory$(this));
        fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
        this.frame.openPopup(fc);
    }

    static /* synthetic */ void lambda$save$4(SkinUploadPopup this_, File f) {
        try {
            this_.img.storeTo(f);
        }
        catch (IOException e) {
            Log.error("Failed to save image", e);
            this_.frame.openPopup(new MessagePopup(this_.frame, this_.frame.getGui().i18nFormat("label.cpm.error", new Object[0]), this_.frame.getGui().i18nFormat("error.cpm.img_save_failed", e.getLocalizedMessage())));
        }
    }

    static /* synthetic */ String lambda$save$3(String n) {
        return n + ".png";
    }

    static /* synthetic */ void lambda$setupLabelsExec$2(SkinUploadPopup this_, String text) {
        this_.reSetupLabels(text);
    }

    static /* synthetic */ void lambda$new$1(SkinUploadPopup this_, Frame frm, Throwable thr) {
        Log.error("Unchecked exception while uploading skin", thr);
        frm.openPopup(new MessagePopup(this_.frame, this_.gui.i18nFormat("label.cpm.error", new Object[0]), this_.gui.i18nFormat("label.cpm.skinUpload.fail", this_.gui.i18nFormat("error.cpm.unknownError", new Object[0]))));
    }

    static /* synthetic */ void lambda$new$0(Void v) {
    }

    static /* synthetic */ Void access$lambda$0(SkinUploadPopup skinUploadPopup) {
        return skinUploadPopup.process();
    }

    static /* synthetic */ void access$lambda$1(SkinUploadPopup skinUploadPopup) {
        skinUploadPopup.save();
    }
}

