/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.gesture;

import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ChooseElementPopup;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.math.Vec2i;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.gui.gesture.AbstractGestureButton$$Lambda$1;
import com.tom.cpm.shared.gui.gesture.AbstractGestureButton$$Lambda$2;
import com.tom.cpm.shared.gui.gesture.AbstractGestureButton$$Lambda$3;
import com.tom.cpm.shared.gui.gesture.AbstractGestureButton$$Lambda$4;
import com.tom.cpm.shared.gui.gesture.IGestureButton;
import com.tom.cpm.shared.gui.gesture.IGestureButtonContainer;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AbstractGestureButton
extends Button
implements IGestureButton {
    protected boolean isHovered;
    protected AbstractGestureButtonData data;
    protected IGestureButtonContainer.BoundKeyInfo kb;
    protected IGestureButtonContainer container;

    public AbstractGestureButton(IGestureButtonContainer c, AbstractGestureButtonData data, String name, Runnable action) {
        super(c.gui(), name, action);
        this.data = data;
        this.container = c;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.isHovered = event.isHovered(this.bounds);
        int w = this.gui.textWidth(this.name);
        int bgColor = this.gui.getColors().button_fill;
        int color = this.gui.getColors().button_text_color;
        if (!this.enabled) {
            color = this.gui.getColors().button_text_disabled;
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
            bgColor = this.gui.getColors().button_hover;
        }
        if (event.isHovered(this.bounds) && this.tooltip != null) {
            this.tooltip.set();
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
        int nameY = -4;
        if (this.kb != null && this.kb.bound != null) {
            int w2 = this.gui.textWidth(this.kb.bound);
            this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w2 / 2, this.bounds.y + this.bounds.h / 2 + 4, this.kb.bound, color);
            nameY = -10;
        }
        this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 + nameY, this.name, color);
    }

    protected boolean canHold() {
        return true;
    }

    @Override
    public void mouseClick(MouseEvent event) {
        if (event.isHovered(this.bounds) && event.btn == 1 && this.container.canBindKeys()) {
            PopupMenu p = new PopupMenu(this.gui, this.gui.getFrame());
            p.addButton(this.gui.i18nFormat("button.cpm.quick_key.unbind", new Object[0]), AbstractGestureButton$$Lambda$1.lambdaFactory$(this));
            p.addButton(this.gui.i18nFormat("button.cpm.quick_key.bindMenu", new Object[0]), AbstractGestureButton$$Lambda$2.lambdaFactory$(this));
            Vec2i pos = event.getPos();
            p.display(pos.x, pos.y);
            event.consume();
        }
        super.mouseClick(event);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        super.keyPressed(event);
        if (this.isHovered) {
            String keybindPressed = null;
            for (IKeybind kb : MinecraftClientAccess$.get().getKeybinds()) {
                if (!kb.getName().startsWith("qa") || !kb.isPressed(event)) continue;
                keybindPressed = kb.getName();
            }
            if (keybindPressed != null) {
                this.container.updateKeybind(keybindPressed, this.data.getKeybindId(), this.canHold() && this.gui.isCtrlDown());
                event.consume();
            }
        }
    }

    @Override
    public void updateKeybinds() {
        this.kb = this.container.getBoundKey(this.data.getKeybindId());
    }

    static /* synthetic */ void lambda$mouseClick$3(AbstractGestureButton this_) {
        List qas = IntStream.rangeClosed(1, 16).mapToObj(AbstractGestureButton$$Lambda$3.lambdaFactory$(this_)).collect(Collectors.toList());
        this_.gui.getFrame().openPopup(new ChooseElementPopup(this_.gui.getFrame(), this_.gui.i18nFormat("button.cpm.quick_key.bindMenu", new Object[0]), this_.gui.i18nFormat("label.cpm.quick_key.bindMenu", new Object[0]), qas, AbstractGestureButton$$Lambda$4.lambdaFactory$(this_), null));
    }

    static /* synthetic */ void lambda$null$2(AbstractGestureButton this_, QuickAccess q) {
        this_.container.updateKeybind(q.getId(), this_.data.getKeybindId(), this_.canHold() && this_.gui.isCtrlDown());
    }

    static /* synthetic */ QuickAccess lambda$null$1(AbstractGestureButton this_, int x$0) {
        return this_.new QuickAccess(x$0);
    }

    static /* synthetic */ void lambda$mouseClick$0(AbstractGestureButton this_) {
        this_.container.updateKeybind(null, this_.data.getKeybindId(), false);
    }

    private class QuickAccess {
        private final int id;

        public QuickAccess(int id) {
            this.id = id;
        }

        public String getId() {
            return "qa_" + this.id;
        }

        public String toString() {
            String i = this.getId();
            String bound = null;
            for (IKeybind kb : MinecraftClientAccess$.get().getKeybinds()) {
                if (!kb.getName().equals(i) || !(bound = kb.getBoundKey()).isEmpty()) continue;
                bound = null;
            }
            if (bound == null) {
                bound = AbstractGestureButton.this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
            }
            return AbstractGestureButton.this.gui.i18nFormat("key.cpm.qa_" + this.id, new Object[0]) + " (" + bound + ")";
        }
    }
}

