/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.EmbeddedLocalizations;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.editor.project.ProjectFile;
import com.tom.cpm.shared.gui.panel.ErrorLogPanel$$Lambda$1;
import com.tom.cpm.shared.gui.panel.ErrorLogPanel$$Lambda$2;
import com.tom.cpm.shared.gui.panel.ErrorLogPanel$$Lambda$3;
import com.tom.cpm.shared.gui.panel.ErrorLogPanel$$Lambda$4;
import com.tom.cpm.shared.gui.panel.ErrorLogPanel$$Lambda$5;
import com.tom.cpm.shared.gui.panel.ErrorLogPanel$$Lambda$6;
import com.tom.cpm.shared.util.ErrorLog;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ErrorLogPanel
extends Panel {
    private final Frame frm;
    private Button saveLogs;
    private Panel panel;
    private List<ErrorLog.LogEntry> entries;

    public ErrorLogPanel(Frame frm, int w, int h) {
        super(frm.getGui());
        this.frm = frm;
        this.setBounds(new Box(0, 0, w, h));
        ScrollPanel scp = new ScrollPanel(this.gui);
        scp.setBounds(new Box(5, 5, w - 10, h - 35));
        this.addElement(scp);
        this.panel = new Panel(this.gui);
        this.panel.setBackgroundColor(-8947849);
        scp.setDisplay(this.panel);
        this.saveLogs = new Button(this.gui, this.gui.i18nFormat("button.cpm.saveLogs", new Object[0]), ErrorLogPanel$$Lambda$1.lambdaFactory$(this, frm));
        this.saveLogs.setBounds(new Box(5, h - 25, 100, 20));
        this.addElement(this.saveLogs);
        Button clear = new Button(this.gui, this.gui.i18nFormat("button.cpm.clearLogs", new Object[0]), ErrorLogPanel$$Lambda$2.lambdaFactory$(this));
        clear.setBounds(new Box(110, h - 25, 100, 20));
        this.addElement(clear);
        this.loadLogs();
        String v = this.gui.i18nFormat("label.cpm.runtimeVersion", PlatformFeature.getVersion());
        this.addElement(new Label(this.gui, v).setBounds(new Box(w - this.gui.textWidth(v) - 3, h - 11, 0, 0)));
    }

    private void loadLogs() {
        this.panel.getElements().clear();
        this.entries = ErrorLog.collectErrors();
        this.entries.sort(Comparator.comparing(ErrorLogPanel$$Lambda$3.lambdaFactory$()));
        this.panel.setBounds(new Box(0, 0, this.bounds.w - 10, this.entries.size() * 16));
        for (int i = 0; i < this.entries.size(); ++i) {
            ErrorLog.LogEntry e = this.entries.get(i);
            this.panel.addElement(new EntryPanel(e, i * 16, this.bounds.w - 10));
        }
        this.saveLogs.setEnabled(!this.entries.isEmpty());
    }

    private void saveLogs(File f) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", MinecraftClientAccess$.get().getClientPlayer().getName());
        ArrayList a = new ArrayList();
        map.put("entries", a);
        map.put("platform", PlatformFeature.getVersion());
        this.entries.forEach(ErrorLogPanel$$Lambda$4.lambdaFactory$(a));
        ProjectFile pf = new ProjectFile();
        try {
            OutputStreamWriter os = new OutputStreamWriter(pf.setAsStream("logs.json"));
            Throwable throwable = null;
            try {
                MinecraftObjectHolder.gson.toJson(map, (Appendable)os);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (os != null) {
                    if (throwable != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        os.close();
                    }
                }
            }
            pf.save(f);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    static /* synthetic */ void lambda$saveLogs$3(List a, ErrorLog.LogEntry e) {
        a.add(e.toMap());
    }

    static /* synthetic */ void lambda$new$2(ErrorLogPanel this_) {
        ErrorLog.clear();
        this_.loadLogs();
    }

    static /* synthetic */ void lambda$new$1(ErrorLogPanel this_, Frame frm) {
        FileChooserPopup fc = new FileChooserPopup(frm);
        fc.setTitle(EmbeddedLocalizations.saveLogs);
        fc.setFileDescText(EmbeddedLocalizations.fileLog);
        fc.setFilter(new FileChooserPopup.FileFilter("zip"));
        fc.setExtAdder(ErrorLogPanel$$Lambda$5.lambdaFactory$());
        fc.setAccept(ErrorLogPanel$$Lambda$6.lambdaFactory$(this_));
        fc.setSaveDialog(true);
        fc.setButtonText(this_.gui.i18nFormat("button.cpm.ok", new Object[0]));
        fc.setFileName("cpm-errorlog-" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".zip");
        frm.openPopup(fc);
    }

    static /* synthetic */ String lambda$null$0(String n) {
        return n + ".zip";
    }

    static /* synthetic */ void access$lambda$0(ErrorLogPanel errorLogPanel, File file) {
        errorLogPanel.saveLogs(file);
    }

    private class EntryPanel
    extends Panel {
        private Tooltip tooltip;
        private Tooltip tooltipST;

        public EntryPanel(ErrorLog.LogEntry entry, int y, int w) {
            super(ErrorLogPanel.this.getGui());
            this.addElement(new Label(this.gui, this.gui.i18nFormat("label.cpm.level." + entry.getLevel().name().toLowerCase(Locale.ROOT), new Object[0])).setBounds(new Box(5, 4, 20, 10)));
            this.addElement(new Label(this.gui, entry.getMessage().toString(this.gui)).setBounds(new Box(45, 4, w - 35, 10)));
            this.tooltip = new Tooltip(ErrorLogPanel.this.frm, this.gui.wordWrap(entry.toTooltipString(this.gui, false), ((ErrorLogPanel)ErrorLogPanel.this).frm.getBounds().w));
            this.tooltipST = new Tooltip(ErrorLogPanel.this.frm, this.gui.wordWrap(entry.toTooltipString(this.gui, true), ((ErrorLogPanel)ErrorLogPanel.this).frm.getBounds().w));
            switch (entry.getLevel()) {
                case ERROR: {
                    this.setBackgroundColor(-56798);
                    break;
                }
                case INFO: {
                    this.setBackgroundColor(-7829368);
                    break;
                }
                case WARNING: {
                    this.setBackgroundColor(-5592542);
                    break;
                }
            }
            this.setBounds(new Box(0, y, w, 15));
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (event.isHovered(this.bounds)) {
                if (this.gui.isShiftDown()) {
                    this.tooltipST.set();
                } else {
                    this.tooltip.set();
                }
            }
        }
    }
}

