/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.ListElement;
import com.tom.cpl.gui.elements.ListElement$ListModel$;
import com.tom.cpl.gui.elements.ListElement2d;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpm.shared.gui.panel.ListPanel$$Lambda$1;
import com.tom.cpm.shared.gui.panel.ListPanel$$Lambda$2;
import com.tom.cpm.shared.gui.panel.ListPanel$$Lambda$3;
import com.tom.cpm.shared.gui.panel.ListPanel$$Lambda$4;
import com.tom.cpm.shared.gui.panel.ListPanel$$Lambda$5;
import com.tom.cpm.shared.gui.panel.ListPanel$$Lambda$6;
import com.tom.cpm.shared.gui.panel.ListPanel$$Lambda$7;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ListPanel<E>
extends Panel
implements ListElement.ListModel<E> {
    private List<E> list;
    private List<E> listIn;
    private TextField search;
    private Function<E, Tooltip> getTooltip = ListPanel$$Lambda$1.lambdaFactory$();
    private ListElement2d<E> listElement;
    private Consumer<E> onSelect;
    private Panel listPanel;
    private ScrollPanel scpList;
    private int w;
    private int h;
    private ToIntFunction<E> getWidth;
    private ListElementRenderer<E> renderer;
    private Comparator<E> comparator;

    public ListPanel(IGui gui, List<E> listIn, int w, int h) {
        super(gui);
        this.list = new ArrayList();
        this.listIn = listIn;
        this.comparator = Comparator.comparing(ListPanel$$Lambda$2.lambdaFactory$());
        this.listPanel = new Panel(gui);
        this.listPanel.setBackgroundColor(gui.getColors().menu_bar_background);
        this.listElement = new ListElement2d<E>(gui, this, this.list);
        this.listPanel.addElement(this.listElement);
        this.search = new TextField(gui);
        this.search.setEventListener(ListPanel$$Lambda$3.lambdaFactory$(this));
        this.addElement(this.search);
        this.scpList = new ScrollPanel(gui);
        this.scpList.setDisplay(this.listPanel);
        this.addElement(this.scpList);
        this.search.setBounds(new Box(5, 5, w - 10, 20));
        this.scpList.setBounds(new Box(5, 30, w - 10, h - 35));
        this.getWidth = ListPanel$$Lambda$4.lambdaFactory$(this, gui);
        this.renderer = ListPanel$$Lambda$5.lambdaFactory$(this, gui);
        this.w = w;
        this.h = h;
        this.listElement.setPreferredWidth(w);
        this.refreshList();
    }

    public void refreshList() {
        String searchString = this.search.getText();
        Pattern m = null;
        try {
            m = Pattern.compile(searchString.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(searchString.toLowerCase()), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        Pattern fp = m;
        this.list.clear();
        Stream stream = this.listIn.stream().filter(ListPanel$$Lambda$6.lambdaFactory$(fp)).sorted(this.comparator);
        List<E> list = this.list;
        list.getClass();
        stream.forEach(ListPanel$$Lambda$7.lambdaFactory$(list));
        Vec2i size = this.listElement.getSize();
        size.x = Math.max(size.x, this.w - 10);
        this.listElement.setBounds(new Box(0, 0, size.x, size.y));
        this.listPanel.setBounds(new Box(0, 0, size.x, size.y));
        int i = this.list.indexOf(this.listElement.getSelected());
        if (i != -1) {
            if (this.scpList.getBounds().h < i * 10) {
                this.scpList.setScrollY(i * 10 - this.scpList.getBounds().h + 10);
            } else {
                this.scpList.setScrollY(0);
            }
        } else {
            this.scpList.setScrollY(0);
        }
    }

    @Override
    public Tooltip getTooltip(E el) {
        return this.getTooltip.apply(el);
    }

    @Override
    public String getDisplay(E el) {
        return el.toString();
    }

    @Override
    public void selected(E selected) {
        if (this.onSelect != null) {
            this.onSelect.accept(selected);
        }
    }

    public void setSelect(Consumer<E> select) {
        this.onSelect = select;
    }

    public String getSearchText() {
        return this.search.getText();
    }

    public void setSearchText(String txt) {
        this.search.setText(txt);
    }

    public void setSelected(E selected) {
        this.listElement.setSelected(selected);
        this.refreshList();
    }

    public void setWidth(int w) {
        this.w = w;
        this.listElement.setPreferredWidth(w - 10);
        Vec2i size = this.listElement.getSize();
        size.x = Math.max(size.x, w - 10);
        this.listElement.setBounds(new Box(0, 0, size.x, size.y));
        this.listPanel.setBounds(new Box(0, 0, size.x, size.y));
        this.search.setBounds(new Box(5, 5, w - 10, 20));
        this.scpList.setBounds(new Box(5, 30, w - 10, this.h - 35));
        this.setBounds(new Box(this.bounds.x, this.bounds.y, w, this.h));
    }

    public E getSelected() {
        return (E)this.listElement.getSelected();
    }

    public void setGetTooltip(Function<E, Tooltip> getTooltip) {
        this.getTooltip = getTooltip;
    }

    @Override
    public void draw(IGui gui, E el, int x, int y, int w, int h, boolean hovered, boolean selected) {
        this.renderer.draw(el, x, y, w, h, hovered, selected);
    }

    @Override
    public int getWidth(IGui gui, E el) {
        return this.getWidth.applyAsInt(el);
    }

    public void setGetWidth(ToIntFunction<E> getWidth) {
        this.getWidth = getWidth;
    }

    public void setRenderer(ListElementRenderer<E> renderer) {
        this.renderer = renderer;
    }

    public void setComparator(Comparator<E> comparator) {
        this.comparator = comparator;
        this.refreshList();
    }

    static /* synthetic */ boolean lambda$refreshList$3(Pattern fp, Object e) {
        String dspName = e.toString();
        return fp.matcher(dspName.toLowerCase()).find();
    }

    static /* synthetic */ void lambda$new$2(ListPanel this_, IGui gui, Object e, int x, int y, int lw, int lh, boolean m, boolean s) {
        ListElement$ListModel$.draw(this_, gui, e, x, y, lw, lh, m, s);
    }

    static /* synthetic */ int lambda$new$1(ListPanel this_, IGui gui, Object e) {
        return ListElement$ListModel$.getWidth(this_, gui, e);
    }

    static /* synthetic */ Tooltip lambda$new$0(Object e) {
        return null;
    }

    @FunctionalInterface
    public static interface ListElementRenderer<E> {
        public void draw(E var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);
    }
}

