/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.gui.SelectSkinPopup;
import com.tom.cpm.shared.gui.SkinUploadPopup;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ModelDisplayPanel;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$1;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$10;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$11;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$12;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$13;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$14;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$15;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$16;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$17;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$18;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$19;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$2;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$20;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$21;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$22;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$23;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$24;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$25;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$26;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$27;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$28;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$3;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$4;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$5;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$6;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$7;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$8;
import com.tom.cpm.shared.gui.panel.ModelsPanel$$Lambda$9;
import com.tom.cpm.shared.gui.panel.ModelsPanel$FolderPanel$$Lambda$1;
import com.tom.cpm.shared.gui.panel.ModelsPanel$FolderPanel$$Lambda$2;
import com.tom.cpm.shared.gui.panel.ModelsPanel$ModelPanel$$Lambda$1;
import com.tom.cpm.shared.gui.panel.ModelsPanel$ModelPanel$$Lambda$2;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;

public class ModelsPanel
extends Panel
implements ModelDisplayPanel.IModelDisplayPanel {
    private ViewportCamera camera;
    private Frame frm;
    private ScrollPanel list;
    private ModelDisplayPanel display;
    private ModelDefinition selectedDef;
    private String selected;
    private List<ListPanel> panels;
    private List<Consumer<Vec2i>> sizeSetters;
    private Button set;
    private Button upload;
    private Button simpleSkin;
    private boolean doRender = true;
    private AnimationHandler animHandler;
    private String selectedFolder = "";
    private Vec2i size = new Vec2i(0, 0);

    public ModelsPanel(Frame frm, ViewportCamera camera) {
        super(frm.getGui());
        this.frm = frm;
        this.camera = camera;
        this.sizeSetters = new ArrayList<Consumer<Vec2i>>();
        this.animHandler = new AnimationHandler(ModelsPanel$$Lambda$1.lambdaFactory$(this), AnimationEngine.AnimationMode.GUI);
        this.list = new ScrollPanel(this.gui);
        this.list.setBounds(new Box(0, 0, 0, 0));
        this.loadModelList();
        this.addElement(this.list);
        this.display = new ModelDisplayPanel(frm, this);
        this.display.setLoadingText(this.gui.i18nFormat("label.cpm.loading", new Object[0]));
        this.addElement(this.display);
        this.set = new Button(this.gui, this.gui.i18nFormat("button.cpm.applySkin", new Object[0]), ModelsPanel$$Lambda$2.lambdaFactory$(this));
        this.set.setEnabled(false);
        this.addElement(this.set);
        if (MinecraftClientAccess$.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.OFFLINE) {
            this.upload = new Button(this.gui, this.gui.i18nFormat("button.cpm.uploadSkin", new Object[0]), ModelsPanel$$Lambda$3.lambdaFactory$(this));
            this.upload.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.uploadSkin", new Object[0])));
            this.upload.setEnabled(false);
            this.addElement(this.upload);
            this.simpleSkin = new Button(this.gui, this.gui.i18nFormat("button.cpm.changeSkin", new Object[0]), ModelsPanel$$Lambda$4.lambdaFactory$(this, frm));
            this.simpleSkin.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.changeSkin", new Object[0])));
            this.addElement(this.simpleSkin);
        }
        Player<?> player = MinecraftClientAccess$.get().getCurrentClientPlayer();
        player.getDefinitionFuture().thenAccept(ModelsPanel$$Lambda$5.lambdaFactory$(this));
        if (player.forcedSkin) {
            Label lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.skinForced", new Object[0]));
            lbl.setColor(-65536);
            lbl.setBounds(new Box(40, 30, 0, 0));
            this.addElement(lbl);
        }
    }

    private void loadModelList() {
        Label lbl;
        this.sizeSetters.clear();
        Panel panel = new Panel(this.gui);
        File modelsDir = new File(MinecraftClientAccess$.get().getGameDir(), "player_models/" + this.selectedFolder);
        File[] fs = modelsDir.exists() ? modelsDir.listFiles(ModelsPanel$$Lambda$6.lambdaFactory$()) : null;
        String model = ModConfig.getCommonConfig().getString("selectedModel", null);
        if (!this.selectedFolder.isEmpty()) {
            Button moveUp = new Button(this.gui, ".. (" + this.selectedFolder + ")", ModelsPanel$$Lambda$7.lambdaFactory$(this));
            this.sizeSetters.add(ModelsPanel$$Lambda$8.lambdaFactory$(moveUp));
            panel.addElement(moveUp);
        } else {
            Button reset = new Button(this.gui, this.gui.i18nFormat(model == null ? "button.cpm.reset_skin.sel" : "button.cpm.reset_skin", new Object[0]), ModelsPanel$$Lambda$9.lambdaFactory$(this));
            this.sizeSetters.add(ModelsPanel$$Lambda$10.lambdaFactory$(reset));
            panel.addElement(reset);
        }
        this.sizeSetters.add(ModelsPanel$$Lambda$11.lambdaFactory$(panel));
        this.panels = new ArrayList<ListPanel>();
        if (fs == null || fs.length == 0) {
            lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.no_models", new Object[0]));
            lbl.setBounds(new Box(5, 25, 0, 0));
            panel.addElement(lbl);
        } else {
            lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.loading", new Object[0]));
            lbl.setBounds(new Box(5, 25, 0, 0));
            MinecraftClientAccess$.get().getDefinitionLoader().execute(ModelsPanel$$Lambda$12.lambdaFactory$(this, fs, model, panel, lbl));
        }
        this.list.setDisplay(panel);
        panel.setBackgroundColor(this.gui.getColors().panel_background & 0xFFFFFF | Integer.MIN_VALUE);
        this.sizeSetters.forEach(ModelsPanel$$Lambda$13.lambdaFactory$(this));
        this.list.setScrollY(0);
    }

    private String getFullPath(String name) {
        return this.selectedFolder.isEmpty() ? name : this.selectedFolder + "/" + name;
    }

    public void setSize(int width, int height) {
        Vec2i s = new Vec2i(width / 2 - 30, height - 50);
        this.list.setBounds(new Box(20, 40, s.x, s.y));
        this.size = s;
        this.sizeSetters.forEach(ModelsPanel$$Lambda$14.lambdaFactory$(s));
        int dispSize = Math.min(width / 2 - 40, height - 100);
        if (this.upload != null) {
            this.set.setBounds(new Box(width / 2 + dispSize / 2 - 102, height / 2 + dispSize / 2 + 10, 100, 20));
            this.upload.setBounds(new Box(width / 2 + dispSize / 2 + 2, height / 2 + dispSize / 2 + 10, 100, 20));
            this.simpleSkin.setBounds(new Box(width / 2 + dispSize / 2 - 50, 5, 100, 20));
        } else {
            this.set.setBounds(new Box(width / 2 + dispSize / 2 - 50, height / 2 + dispSize / 2 + 10, 100, 20));
        }
        this.display.setBounds(new Box(width / 2 + 10, height / 2 - dispSize / 2, dispSize, dispSize));
        this.setBounds(new Box(0, 0, width, height));
    }

    @Override
    public ModelDefinition getSelectedDefinition() {
        if (this.selectedDef != null) {
            if (this.selectedDef.getResolveState() == ModelDefinition.ModelLoadingState.NEW) {
                this.selectedDef.startResolve();
            } else if (this.selectedDef.getResolveState() == ModelDefinition.ModelLoadingState.LOADED) {
                return this.selectedDef;
            }
        }
        return null;
    }

    @Override
    public void preRender() {
        if (this.getSelectedDefinition() != null) {
            MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine().handleGuiAnimation(this.animHandler, this.getSelectedDefinition());
        }
    }

    private void applySelected() {
        ModConfig.getCommonConfig().setString("selectedModel", this.selected);
        ModConfig.getCommonConfig().save();
        if (MinecraftClientAccess$.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
            MinecraftClientAccess$.get().sendSkinUpdate();
        }
        this.loadModelList();
    }

    private void uploadSelected() {
        if (this.selected != null) {
            ModelFile file;
            File modelsDir = new File(MinecraftClientAccess$.get().getGameDir(), "player_models");
            File modelF = new File(modelsDir, this.selected);
            try {
                file = ModelFile.load(modelF);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            if (!file.convertable()) {
                this.frm.openPopup(new MessagePopup(this.frm, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.skinUpload.fail", this.gui.i18nFormat("label.cpm.modelNotSkinCompatible", new Object[0]))));
                return;
            }
            SelectSkinPopup ssp = new SelectSkinPopup(this.frm, SkinType.DEFAULT, ModelsPanel$$Lambda$15.lambdaFactory$(this, file));
            ssp.setOnClosed(ModelsPanel$$Lambda$16.lambdaFactory$(this));
            this.doRender = false;
            this.frm.openPopup(ssp);
        }
    }

    private void upload(SkinType type, Image img) {
        new SkinUploadPopup(this.frm, type, img).start();
    }

    public void onClosed() {
        this.panels.forEach(ModelsPanel$$Lambda$17.lambdaFactory$());
    }

    @Override
    public ViewportCamera getCamera() {
        return this.camera;
    }

    @Override
    public boolean doRender() {
        return this.doRender;
    }

    public void filesDropped(List<File> files) {
        File modelsDir = new File(MinecraftClientAccess$.get().getGameDir(), "player_models/" + this.selectedFolder);
        modelsDir.mkdirs();
        for (int i = 0; i < files.size(); ++i) {
            File model = files.get(i);
            if (!model.getName().endsWith(".cpmmodel")) continue;
            File m = new File(modelsDir, model.getName());
            Random r = new Random();
            String name = model.getName();
            name = name.substring(0, name.length() - 9);
            while (m.exists()) {
                m = new File(modelsDir, name + "_" + Integer.toHexString(r.nextInt()) + ".cpmmodel");
            }
            try {
                FileInputStream in = new FileInputStream(model);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(m);
                    Throwable throwable2 = null;
                    try {
                        IOHelper.copy(in, out);
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out != null) {
                            if (throwable2 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable4) {
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable6) {
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.loadModelList();
    }

    static /* synthetic */ void lambda$uploadSelected$22(ModelsPanel this_) {
        this_.doRender = true;
    }

    static /* synthetic */ void lambda$uploadSelected$21(ModelsPanel this_, ModelFile file, SkinType type, Image img) {
        this_.frm.openPopup(new ConfirmPopup(this_.frm, this_.gui.i18nFormat("label.cpm.export.upload", new Object[0]), this_.gui.i18nFormat("label.cpm.export.upload.desc", new Object[0]), ModelsPanel$$Lambda$18.lambdaFactory$(this_, file, img, type), null));
    }

    static /* synthetic */ void lambda$null$20(ModelsPanel this_, ModelFile file, Image img, SkinType type) {
        Exporter.convert(file, img, type, ModelsPanel$$Lambda$19.lambdaFactory$(this_, type), ModelsPanel$$Lambda$20.lambdaFactory$(this_));
    }

    static /* synthetic */ void lambda$null$19(ModelsPanel this_) {
        this_.frm.openPopup(new MessagePopup(this_.frm, this_.gui.i18nFormat("label.cpm.error", new Object[0]), this_.gui.i18nFormat("label.cpm.skinUpload.fail", this_.gui.i18nFormat("label.cpm.convertFail", new Object[0]))));
    }

    static /* synthetic */ void lambda$null$18(ModelsPanel this_, SkinType type, Image out) {
        this_.upload(type, out);
    }

    static /* synthetic */ void lambda$setSize$17(Vec2i s, Consumer c) {
        c.accept(s);
    }

    static /* synthetic */ void lambda$loadModelList$16(ModelsPanel this_, Consumer c) {
        c.accept(this_.size);
    }

    static /* synthetic */ void lambda$loadModelList$15(ModelsPanel this_, File[] fs, String model, Panel panel, Label lbl) {
        int y = 20;
        for (int i = 0; i < fs.length; ++i) {
            if (fs[i].getName().equals(".temp.cpmmodel") || fs[i].getName().equals("autosaves")) continue;
            try {
                ListPanel p = fs[i].isDirectory() ? this_.new FolderPanel(this_.gui, fs[i], y) : this_.new ModelPanel(this_.gui, ModelFile.load(fs[i]), model != null && this_.getFullPath(fs[i].getName()).equals(model), y);
                y += ((ListPanel)p).getHeight();
                this_.panels.add(p);
                continue;
            }
            catch (Exception e) {
                Log.warn("Error loading model: " + fs[i].getName(), e);
            }
        }
        int fy = y;
        MinecraftClientAccess$.get().executeOnGameThread(ModelsPanel$$Lambda$21.lambdaFactory$(this_, panel, fy, lbl));
    }

    static /* synthetic */ void lambda$null$14(ModelsPanel this_, Panel panel, int fy, Label lbl) {
        Panel panel2 = panel;
        panel2.getClass();
        this_.panels.forEach(ModelsPanel$$Lambda$22.lambdaFactory$(panel2));
        if (panel.getBounds() != null) {
            int w = panel.getBounds().w;
            this_.panels.forEach(ModelsPanel$$Lambda$23.lambdaFactory$(w));
            panel.setBounds(new Box(0, 0, w, fy));
        }
        this_.sizeSetters.add(ModelsPanel$$Lambda$24.lambdaFactory$(this_, panel, fy));
        panel.getElements().remove(lbl);
    }

    static /* synthetic */ void lambda$null$13(ModelsPanel this_, Panel panel, int fy, Vec2i s) {
        panel.setBounds(new Box(0, 0, s.x, fy));
        this_.panels.forEach(ModelsPanel$$Lambda$25.lambdaFactory$(s));
    }

    static /* synthetic */ void lambda$null$12(Vec2i s, ListPanel p) {
        p.setSize(s.x);
    }

    static /* synthetic */ void lambda$null$11(int w, ListPanel p) {
        p.setSize(w);
    }

    static /* synthetic */ void lambda$loadModelList$10(Panel panel, Vec2i s) {
        panel.setBounds(new Box(0, 0, s.x, 40));
    }

    static /* synthetic */ void lambda$loadModelList$9(Button reset, Vec2i s) {
        reset.setBounds(new Box(0, 0, s.x, 20));
    }

    static /* synthetic */ void lambda$loadModelList$8(ModelsPanel this_) {
        ModConfig.getCommonConfig().clearValue("selectedModel");
        ModConfig.getCommonConfig().save();
        if (MinecraftClientAccess$.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
            MinecraftClientAccess$.get().sendSkinUpdate();
        }
        this_.loadModelList();
    }

    static /* synthetic */ void lambda$loadModelList$7(Button moveUp, Vec2i s) {
        moveUp.setBounds(new Box(0, 0, s.x, 20));
    }

    static /* synthetic */ void lambda$loadModelList$6(ModelsPanel this_) {
        if (this_.selectedFolder.contains("/")) {
            int i = this_.selectedFolder.lastIndexOf(47);
            this_.selectedFolder = this_.selectedFolder.substring(0, i);
        } else {
            this_.selectedFolder = "";
        }
        this_.loadModelList();
    }

    static /* synthetic */ boolean lambda$loadModelList$5(File f, String n) {
        return n.endsWith(".cpmmodel") || new File(f, n).isDirectory();
    }

    static /* synthetic */ void lambda$new$4(ModelsPanel this_, ModelDefinition d) {
        if (this_.selectedDef == null) {
            this_.selectedDef = d;
        }
        this_.animHandler.clear();
    }

    static /* synthetic */ void lambda$new$3(ModelsPanel this_, Frame frm) {
        SelectSkinPopup ssp = new SelectSkinPopup(frm, SkinType.DEFAULT, ModelsPanel$$Lambda$26.lambdaFactory$(this_, frm));
        ssp.setOnClosed(ModelsPanel$$Lambda$27.lambdaFactory$(this_));
        this_.doRender = false;
        frm.openPopup(ssp);
    }

    static /* synthetic */ void lambda$null$2(ModelsPanel this_) {
        this_.doRender = true;
    }

    static /* synthetic */ void lambda$null$1(ModelsPanel this_, Frame frm, SkinType type, Image img) {
        frm.openPopup(new ConfirmPopup(frm, this_.gui.i18nFormat("label.cpm.export.upload", new Object[0]), this_.gui.i18nFormat("label.cpm.export.upload.desc", new Object[0]), ModelsPanel$$Lambda$28.lambdaFactory$(this_, type, img), null));
    }

    static /* synthetic */ void lambda$null$0(ModelsPanel this_, SkinType type, Image img) {
        this_.upload(type, img);
    }

    static /* synthetic */ void access$lambda$0(ModelsPanel modelsPanel) {
        modelsPanel.applySelected();
    }

    static /* synthetic */ void access$lambda$1(ModelsPanel modelsPanel) {
        modelsPanel.uploadSelected();
    }

    private class FolderPanel
    extends ListPanel {
        private TextureProvider icon;
        private Button select;
        private int linesC;
        private int y;

        public FolderPanel(IGui gui, File folder, int y) throws IOException {
            super(gui);
            Label lbl = new Label(gui, folder.getName());
            lbl.setBounds(new Box(70, 5, 100, 10));
            this.addElement(lbl);
            File descFile = new File(folder, "description.txt");
            if (descFile.exists()) {
                int i = 0;
                BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(descFile), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    this.addElement(new Label(gui, rd.readLine()).setBounds(new Box(70, 20 + i++ * 10, 0, 0)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rd != null) {
                        if (throwable != null) {
                            try {
                                rd.close();
                            }
                            catch (Throwable throwable3) {
                            }
                        } else {
                            rd.close();
                        }
                    }
                }
                this.linesC = i;
            }
            this.y = y;
            this.select = new Button(gui, gui.i18nFormat("button.cpm.models.openFolder", new Object[0]), ModelsPanel$FolderPanel$$Lambda$1.lambdaFactory$(this, folder));
            this.addElement(this.select);
            File iconFile = new File(folder, "icon.png");
            if (iconFile.exists()) {
                MinecraftClientAccess$.get().getDefinitionLoader().execute(ModelsPanel$FolderPanel$$Lambda$2.lambdaFactory$(this, iconFile));
            }
        }

        @Override
        public int getHeight() {
            return Math.max(68, this.linesC * 10 + 30);
        }

        @Override
        protected void setSize(int w) {
            this.select.setBounds(new Box(w - 50, 2, 40, 20));
            this.setBounds(new Box(0, this.y, w, this.getHeight()));
        }

        @Override
        protected void onClosed() {
            if (this.icon != null) {
                this.icon.free();
            }
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, 66, 66, this.gui.getColors().popup_background);
            if (this.icon != null) {
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + 2, this.bounds.y + 2, 64, 64, 0.0f, 0.0f, 1.0f, 1.0f);
                this.gui.drawTexture(this.bounds.x + 50, this.bounds.y + 50, 16, 16, 128, 0, "models_menu");
            } else {
                this.gui.drawTexture(this.bounds.x + 2, this.bounds.y + 2, 64, 64, 0, 0, "models_menu");
            }
        }

        static /* synthetic */ void lambda$new$1(FolderPanel this_, File iconFile) {
            try {
                FileInputStream fin = new FileInputStream(iconFile);
                Throwable throwable = null;
                try {
                    this_.icon = new TextureProvider(ImageIO.read(fin), null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fin != null) {
                        if (throwable != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable throwable3) {
                            }
                        } else {
                            fin.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        static /* synthetic */ void lambda$new$0(FolderPanel this_, File folder) {
            this_.ModelsPanel.this.selectedFolder = this_.ModelsPanel.this.getFullPath(folder.getName());
            this_.ModelsPanel.this.loadModelList();
        }
    }

    private class ModelPanel
    extends ListPanel {
        private TextureProvider icon;
        private Button select;
        private int linesC;
        private int y;

        public ModelPanel(IGui gui, ModelFile file, boolean sel, int y) {
            super(gui);
            Label lbl = new Label(gui, file.getName());
            lbl.setBounds(new Box(70, 5, 100, 10));
            if (sel) {
                lbl.setColor(gui.getColors().button_hover);
            }
            this.addElement(lbl);
            String[] lines = file.getDesc().split("\\\\");
            for (int i = 0; i < lines.length; ++i) {
                this.addElement(new Label(gui, lines[i]).setBounds(new Box(70, 20 + i * 10, 0, 0)));
            }
            this.linesC = lines.length;
            this.y = y;
            this.select = new Button(gui, gui.i18nFormat("button.cpm.select", new Object[0]), ModelsPanel$ModelPanel$$Lambda$1.lambdaFactory$(this, file));
            this.addElement(this.select);
            if (file.getIcon() != null && file.getIcon().getWidth() > 0) {
                MinecraftClientAccess$.get().getDefinitionLoader().execute(ModelsPanel$ModelPanel$$Lambda$2.lambdaFactory$(this, file));
            }
        }

        @Override
        public void setSize(int w) {
            this.select.setBounds(new Box(w - 50, 2, 40, 20));
            this.setBounds(new Box(0, this.y, w, this.getHeight()));
        }

        @Override
        public int getHeight() {
            return Math.max(68, this.linesC * 10 + 30);
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, 66, 66, this.gui.getColors().popup_background);
            if (this.icon != null) {
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + 2, this.bounds.y + 2, 64, 64, 0.0f, 0.0f, 1.0f, 1.0f);
            } else {
                this.gui.drawTexture(this.bounds.x + 2, this.bounds.y + 2, 64, 64, 64, 0, "models_menu");
            }
        }

        @Override
        protected void onClosed() {
            if (this.icon != null) {
                this.icon.free();
            }
        }

        static /* synthetic */ void lambda$new$1(ModelPanel this_, ModelFile file) {
            IOHelper.ImageBlock block = file.getIcon();
            try {
                block.doReadImage();
                if (block.getImage() != null) {
                    this_.icon = new TextureProvider(block.getImage(), null);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        static /* synthetic */ void lambda$new$0(ModelPanel this_, ModelFile file) {
            this_.ModelsPanel.this.selected = this_.ModelsPanel.this.getFullPath(file.getFileName());
            this_.ModelsPanel.this.selectedDef = MinecraftClientAccess$.get().getDefinitionLoader().loadModel(file.getDataBlock(), MinecraftClientAccess$.get().getClientPlayer());
            file.registerLocalCache(MinecraftClientAccess$.get().getDefinitionLoader());
            this_.ModelsPanel.this.set.setEnabled(true);
            if (this_.ModelsPanel.this.upload != null) {
                this_.ModelsPanel.this.upload.setEnabled(true);
            }
        }
    }

    private abstract class ListPanel
    extends Panel {
        public ListPanel(IGui gui) {
            super(gui);
        }

        protected abstract void setSize(int var1);

        protected abstract int getHeight();

        protected abstract void onClosed();
    }
}

