/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.HorizontalLayout;
import com.tom.cpl.gui.util.TabbedPanelManager;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ListPanel;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$1;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$10;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$11;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$12;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$13;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$14;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$2;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$3;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$4;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$5;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$6;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$7;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$8;
import com.tom.cpm.shared.gui.panel.SocialPanel$$Lambda$9;
import com.tom.cpm.shared.gui.panel.SocialPanel$PlayerInfoPanel$$Lambda$1;
import com.tom.cpm.shared.gui.panel.SocialPanel$PlayerInfoPanel$$Lambda$2;
import com.tom.cpm.shared.gui.panel.SocialPanel$PlayerInfoPanel$$Lambda$3;
import com.tom.cpm.shared.gui.panel.SocialPanel$PlayerInfoPanel$$Lambda$4;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SocialPanel
extends Panel {
    private final Frame frm;
    private TabbedPanelManager tabs;
    public HorizontalLayout topPanel;
    private UUID selUUID;
    private ScrollPanel scrollPlayer;
    private ViewportCamera cam;
    private ListPanel<PlayerInServer> playerList;
    private int listWidth;
    private int scrollWidth;
    private List<TextureProvider> vanillaSkins = new ArrayList<TextureProvider>();

    public SocialPanel(Frame frm, int width, int height, ViewportCamera cam, UUID selected, boolean isInServer) {
        super(frm.getGui());
        this.frm = frm;
        this.cam = cam;
        this.setBounds(new Box(0, 0, width, height));
        this.tabs = new TabbedPanelManager(this.gui);
        this.tabs.setBounds(new Box(0, 20, width, height - 20));
        this.addElement(this.tabs);
        Panel topPanel = new Panel(this.gui);
        topPanel.setBounds(new Box(0, 0, width, 20));
        topPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        this.addElement(topPanel);
        this.topPanel = new HorizontalLayout(topPanel);
        if (isInServer) {
            Panel inServer = new Panel(this.gui);
            this.addTab("inServer", inServer, 0);
            List<Player<?>> loadedPlayers = MinecraftClientAccess$.get().getDefinitionLoader().getPlayers();
            Set pls = loadedPlayers.stream().map(SocialPanel$$Lambda$1.lambdaFactory$(this)).collect(Collectors.toSet());
            Stream stream = MinecraftClientAccess$.get().getPlayers().stream().map(SocialPanel$$Lambda$2.lambdaFactory$(this));
            Set set = pls;
            set.getClass();
            stream.forEach(SocialPanel$$Lambda$3.lambdaFactory$(set));
            List players = pls.stream().filter(SocialPanel$$Lambda$4.lambdaFactory$()).distinct().sorted(Comparator.comparing(SocialPanel$$Lambda$5.lambdaFactory$())).collect(Collectors.toList());
            this.listWidth = width / 4;
            this.scrollWidth = width - this.listWidth;
            this.scrollPlayer = new ScrollPanel(this.gui);
            this.scrollPlayer.setBounds(new Box(this.listWidth, 0, this.scrollWidth, height - 20));
            this.scrollPlayer.setVisible(false);
            this.playerList = new ListPanel(this.gui, players, width, height - 20);
            this.playerList.setSelect(SocialPanel$$Lambda$6.lambdaFactory$(this));
            this.playerList.setGetTooltip(SocialPanel$$Lambda$7.lambdaFactory$());
            this.playerList.setBounds(new Box(0, 0, width, height - 20));
            this.playerList.setWidth(width);
            this.playerList.setBackgroundColor(this.gui.getColors().popup_background & 0x80FFFFFF);
            inServer.addElement(this.playerList);
            if (selected != null) {
                this.selUUID = selected;
                players.stream().filter(SocialPanel$$Lambda$8.lambdaFactory$(this)).findFirst().ifPresent(SocialPanel$$Lambda$9.lambdaFactory$(this));
            }
            inServer.addElement(this.scrollPlayer);
        }
        Panel friends = new Panel(this.gui);
        this.addTab("friends", friends, 0);
        this.initList(friends, ModConfig.getCommonConfig().getEntry("friendList"));
        Panel blocked = new Panel(this.gui);
        this.addTab("blocked", blocked, 0);
        this.initList(blocked, ModConfig.getCommonConfig().getEntry("blockedList"));
    }

    private void setPlayerPanel(PlayerInServer p) {
        if (p != null) {
            this.playerList.setWidth(this.listWidth);
            this.selUUID = p.getUUID();
            if (this.scrollPlayer.getDisplay() != null) {
                ((SocialPlayerPanel)this.scrollPlayer.getDisplay()).cleanup();
            }
            this.scrollPlayer.setDisplay(new SocialPlayerPanel(this.frm, p.getPlayer(), this.cam, this.scrollWidth, this.bounds.h - 20, SocialPanel$$Lambda$10.lambdaFactory$(this, p)));
            MinecraftClientAccess$.get().getNetHandler().requestPlayerData(this.selUUID);
        } else {
            this.selUUID = null;
            this.playerList.setWidth(this.bounds.w);
        }
        this.scrollPlayer.setVisible(p != null);
    }

    private void initList(Panel panel, ConfigEntry ce) {
        int w = panel.getBounds().w;
        int h = panel.getBounds().h;
        panel.setBackgroundColor(this.gui.getColors().popup_background & 0x80FFFFFF);
        Panel listPanel = new Panel(this.gui);
        listPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        List players = ce.keySet().stream().map(SocialPanel$$Lambda$11.lambdaFactory$(this, ce)).sorted(Comparator.comparing(SocialPanel$$Lambda$12.lambdaFactory$())).collect(Collectors.toList());
        int lw = w / 4;
        int spw = w - lw - 10;
        ScrollPanel scpS = new ScrollPanel(this.gui);
        scpS.setBounds(new Box(lw + 10, 0, spw, h));
        scpS.setVisible(false);
        ListPanel playerList = new ListPanel(this.gui, players, w, h);
        playerList.setSelect(SocialPanel$$Lambda$13.lambdaFactory$(this, playerList, lw, scpS, spw, h, w));
        playerList.setBounds(new Box(0, 0, w, h));
        panel.addElement(playerList);
        panel.addElement(scpS);
    }

    public void addTab(String name, Panel panel, int topPadding) {
        panel.setBounds(new Box(0, topPadding, this.bounds.w, this.bounds.h - 20 - topPadding));
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.social." + name, new Object[0]), panel));
    }

    public UUID getSelectedUUID() {
        return this.selUUID;
    }

    public void cleanup() {
        if (this.scrollPlayer.getDisplay() != null) {
            ((SocialPlayerPanel)this.scrollPlayer.getDisplay()).cleanup();
        }
        this.vanillaSkins.forEach(SocialPanel$$Lambda$14.lambdaFactory$());
        this.vanillaSkins.clear();
    }

    static /* synthetic */ void lambda$initList$7(SocialPanel this_, ListPanel playerList, int lw, ScrollPanel scpS, int spw, int h, int w, Pl p) {
        if (p != null) {
            playerList.setWidth(lw);
            scpS.setDisplay(this_.new PlayerInfoPanel(p, spw - 5, h));
        } else {
            playerList.setWidth(w - 10);
        }
        scpS.setVisible(p != null);
    }

    static /* synthetic */ Pl lambda$initList$6(SocialPanel this_, ConfigEntry ce, String u) {
        return this_.new Pl(u, ce);
    }

    static /* synthetic */ void lambda$setPlayerPanel$5(SocialPanel this_, PlayerInServer p) {
        this_.setPlayerPanel(p);
    }

    static /* synthetic */ boolean lambda$new$4(SocialPanel this_, PlayerInServer p) {
        return p.getUUID().equals(this_.selUUID);
    }

    static /* synthetic */ Tooltip lambda$new$3(Object rec$) {
        return ((PlayerInServer)rec$).getTooltip();
    }

    static /* synthetic */ boolean lambda$new$2(Object rec$) {
        return ((PlayerInServer)rec$).isOtherPlayer();
    }

    static /* synthetic */ PlayerInServer lambda$new$1(SocialPanel this_, Object x$0) {
        return this_.new PlayerInServer(x$0);
    }

    static /* synthetic */ PlayerInServer lambda$new$0(SocialPanel this_, Player x$0) {
        return this_.new PlayerInServer(x$0);
    }

    static /* synthetic */ void access$lambda$0(SocialPanel socialPanel, PlayerInServer playerInServer) {
        socialPanel.setPlayerPanel(playerInServer);
    }

    static /* synthetic */ void access$lambda$1(SocialPanel socialPanel, PlayerInServer playerInServer) {
        socialPanel.setPlayerPanel(playerInServer);
    }

    private class PlayerInfoPanel
    extends Panel {
        public PlayerInfoPanel(Pl pl, int w, int h) {
            super(SocialPanel.this.getGui());
            this.setBounds(new Box(0, 0, w, h));
            FlowLayout layout = new FlowLayout(this, 5, 1);
            Panel padding = new Panel(this.gui);
            padding.setBounds(new Box(0, 0, w, 5));
            this.addElement(padding);
            this.addElement(new Label(this.gui, this.gui.i18nFormat("label.cpm.sSettingsFor", pl.getName())).setBounds(new Box(5, 0, w, 10)));
            Button friend = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isFriend(pl.getUUID()) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]), null);
            friend.setBounds(new Box(5, 0, w - 5, 20));
            friend.setAction(SocialPanel$PlayerInfoPanel$$Lambda$1.lambdaFactory$(this, pl, friend));
            this.addElement(friend);
            Button block = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isBlocked(pl.getUUID()) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]), null);
            block.setBounds(new Box(5, 0, w - 5, 20));
            block.setAction(SocialPanel$PlayerInfoPanel$$Lambda$2.lambdaFactory$(this, pl, block));
            this.addElement(block);
            Button playerSettings = new Button(this.gui, this.gui.i18nFormat("button.cpm.playerSettings", new Object[0]), SocialPanel$PlayerInfoPanel$$Lambda$3.lambdaFactory$(this, pl));
            playerSettings.setBounds(new Box(5, 0, w - 5, 20));
            this.addElement(playerSettings);
            layout.reflow();
        }

        static /* synthetic */ void lambda$new$3(PlayerInfoPanel this_, Pl pl) {
            this_.SocialPanel.this.frm.openPopup(new SocialPlayerPanel.SafetyPopup(this_, pl.getUUID(), pl.getName(), SocialPanel$PlayerInfoPanel$$Lambda$4.lambdaFactory$(), this_.SocialPanel.this.frm));
        }

        static /* synthetic */ void lambda$null$2() {
        }

        static /* synthetic */ void lambda$new$1(PlayerInfoPanel this_, Pl pl, Button block) {
            if (SocialConfig.isBlocked(pl.getUUID())) {
                SocialConfig.removeBlock(pl.getUUID());
            } else {
                SocialConfig.blockPlayer(pl.getUUID(), pl.getName());
            }
            block.setText(this_.gui.i18nFormat(SocialConfig.isBlocked(pl.getUUID()) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]));
            MinecraftClientAccess$.get().getDefinitionLoader().settingsChanged(UUID.fromString(pl.getUUID()));
            ModConfig.getCommonConfig().save();
        }

        static /* synthetic */ void lambda$new$0(PlayerInfoPanel this_, Pl pl, Button friend) {
            if (SocialConfig.isFriend(pl.getUUID())) {
                SocialConfig.removeFriend(pl.getUUID());
            } else {
                SocialConfig.addFriend(pl.getUUID(), pl.getName());
            }
            friend.setText(this_.gui.i18nFormat(SocialConfig.isFriend(pl.getUUID()) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]));
            MinecraftClientAccess$.get().getDefinitionLoader().settingsChanged(UUID.fromString(pl.getUUID()));
            ModConfig.getCommonConfig().save();
        }
    }

    private class Pl {
        private String uuid;
        private String name;

        public Pl(String uuid, ConfigEntry ce) {
            this.uuid = uuid;
            this.name = ce.getEntry(uuid).getString("name", uuid);
        }

        public String getName() {
            return this.name;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String toString() {
            return this.name;
        }
    }

    private class PlayerInServer {
        private Object gp;
        private UUID uuid;
        private String unique;

        private PlayerInServer(Object gp) {
            this.gp = gp;
            this.uuid = MinecraftClientAccess$.get().getDefinitionLoader().getGP_UUID(gp);
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            this.unique = "player";
        }

        private PlayerInServer(Player<?> pl) {
            this(pl.getGameProfile());
            this.unique = pl.unique;
        }

        public Player<?> getPlayer() {
            return MinecraftClientAccess$.get().getDefinitionLoader().loadPlayer(this.gp, this.unique);
        }

        public UUID getUUID() {
            return this.uuid;
        }

        private boolean isOtherPlayer() {
            return !this.getUUID().equals(MinecraftClientAccess$.get().getCurrentClientPlayer().getUUID());
        }

        public String toString() {
            String name = this.getName();
            if (name.length() > 16) {
                name = SocialPanel.this.gui.i18nFormat("label.cpm.shortName", name.substring(0, 15));
            }
            return name;
        }

        private String getName() {
            String name = MinecraftClientAccess$.get().getDefinitionLoader().getGP_Name(this.gp);
            if (name == null) {
                return SocialPanel.this.gui.i18nFormat("label.cpm.unknown", new Object[0]);
            }
            return name;
        }

        private Tooltip getTooltip() {
            String type = "player";
            if (this.unique != null) {
                if (this.unique.equals("skull") || this.unique.startsWith("skull_tex:")) {
                    type = "skull";
                } else if (this.unique.startsWith("model:")) {
                    type = "model";
                } else if (this.unique.startsWith("man:")) {
                    type = "mannequin";
                }
            }
            return new Tooltip(SocialPanel.this.frm, SocialPanel.this.gui.i18nFormat("tooltip.cpm.playerUUID", this.getName(), this.getUUID().toString(), SocialPanel.this.gui.i18nFormat("label.cpm.modelLoadingType." + type, new Object[0])));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.unique == null ? 0 : this.unique.hashCode());
            result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PlayerInServer other = (PlayerInServer)obj;
            if (this.unique == null ? other.unique != null : !this.unique.equals(other.unique)) {
                return false;
            }
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }
    }
}

