/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ModelDisplayPanel;
import com.tom.cpm.shared.gui.panel.SafetyPanel;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$1;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$10;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$11;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$2;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$3;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$4;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$5;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$6;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$7;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$8;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$$Lambda$9;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$SafetyPopup$$Lambda$1;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel$SafetyPopup$$Lambda$2;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.skin.TextureType;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public class SocialPlayerPanel
extends Panel
implements ModelDisplayPanel.IModelDisplayPanel {
    private final Frame frm;
    private ViewportCamera cam;
    private Player<?> player;
    private CompletableFuture<ModelDefinition> def;
    private AnimationHandler animHandler;
    private TextureProvider vanillaSkin;
    private FlowLayout layout;
    private Panel buttonsPanel;
    private Button cloneBtn;
    private boolean cloneLoaded;

    public SocialPlayerPanel(Frame frm, final Player<?> player, ViewportCamera cam, int w, int h, Runnable reload) {
        super(frm.getGui());
        String plname;
        this.frm = frm;
        final Box parentBox = new Box(0, 0, w, h);
        this.setBounds(parentBox);
        this.player = player;
        this.cam = cam;
        this.animHandler = new AnimationHandler(SocialPlayerPanel$$Lambda$1.lambdaFactory$(this), AnimationEngine.AnimationMode.GUI);
        String uuid = player.getUUID().toString();
        int s = Math.min(w, h) - 30;
        if (!SocialConfig.isBlocked(uuid) && !this.gui.isShiftDown()) {
            ModelDisplayPanel modelPanel = new ModelDisplayPanel(frm, this){

                @Override
                public void draw(MouseEvent event, float partialTicks) {
                    FormatText t;
                    ModelDefinition d;
                    this.gui.drawBox(parentBox.x, parentBox.y, parentBox.w, parentBox.h, this.gui.getColors().popup_background & 0x80FFFFFF);
                    if (SocialPlayerPanel.this.def == null && (d = player.getModelDefinition0()) != null && (t = d.getStatus()) != null) {
                        this.setLoadingText(t.toString(this.gui));
                    }
                    super.draw(event, partialTicks);
                }
            };
            modelPanel.setLoadingText(this.gui.i18nFormat("label.cpm.loading", new Object[0]));
            modelPanel.setBackgroundColor(0);
            modelPanel.setBounds(new Box(w - s - 5, 5, s, s));
            this.addElement(modelPanel);
            ModelDefinition def = player.getModelDefinition0();
            if (def == null) {
                this.def = player.getTextures().load().thenCompose(SocialPlayerPanel$$Lambda$2.lambdaFactory$(this, player));
            }
        }
        this.addElement(new Label(this.gui, (plname = player.getName()) != null ? plname : this.gui.i18nFormat("label.cpm.unknown", new Object[0])).setBounds(new Box(5, 5, 100, 10)));
        int bpw = w - s - 10;
        this.buttonsPanel = new Panel(this.gui);
        this.buttonsPanel.setBounds(new Box(0, 15, bpw, h));
        this.addElement(this.buttonsPanel);
        this.layout = new FlowLayout(this.buttonsPanel, 5, 1);
        Button friend = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isFriend(uuid) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]), null);
        friend.setBounds(new Box(5, 0, bpw - 5, 20));
        friend.setAction(SocialPlayerPanel$$Lambda$3.lambdaFactory$(this, uuid, player, friend, reload));
        this.buttonsPanel.addElement(friend);
        Button block = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isBlocked(uuid) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]), null);
        block.setBounds(new Box(5, 0, bpw - 5, 20));
        block.setAction(SocialPlayerPanel$$Lambda$4.lambdaFactory$(this, uuid, player, block, reload));
        this.buttonsPanel.addElement(block);
        Button playerSettings = new Button(this.gui, this.gui.i18nFormat("button.cpm.playerSettings", new Object[0]), SocialPlayerPanel$$Lambda$5.lambdaFactory$(this, frm, player, reload));
        playerSettings.setBounds(new Box(5, 0, bpw - 5, 20));
        this.buttonsPanel.addElement(playerSettings);
        this.cloneBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.clone", new Object[0]), SocialPlayerPanel$$Lambda$6.lambdaFactory$(this, player, frm));
        this.cloneBtn.setBounds(new Box(5, 0, bpw - 5, 20));
        this.buttonsPanel.addElement(this.cloneBtn);
        this.cloneBtn.setVisible(false);
        this.layout.reflow();
    }

    private void clone(String name) {
        CompletableFuture<Boolean> completableFuture = MinecraftClientAccess$.get().getDefinitionLoader().cloneModel(this.player, name);
        Consumer consumer = SocialPlayerPanel$$Lambda$7.lambdaFactory$(this, name);
        IGui iGui = this.gui;
        iGui.getClass();
        completableFuture.thenAcceptAsync(consumer, SocialPlayerPanel$$Lambda$8.lambdaFactory$(iGui));
    }

    @Override
    public ModelDefinition getSelectedDefinition() {
        ModelDefinition d = this.player.getModelDefinition();
        if (d != null) {
            if (!this.cloneLoaded) {
                this.cloneLoaded = true;
                this.cloneBtn.setVisible(d.cloneable != null);
                this.layout.reflow();
            }
            return d;
        }
        if (this.def != null) {
            return this.def.getNow(null);
        }
        return null;
    }

    @Override
    public ViewportCamera getCamera() {
        return this.cam;
    }

    @Override
    public void preRender() {
        if (this.getSelectedDefinition() != null) {
            MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine().handleGuiAnimation(this.animHandler, this.getSelectedDefinition());
        }
    }

    @Override
    public boolean doRender() {
        return true;
    }

    public void cleanup() {
        if (this.vanillaSkin != null) {
            this.vanillaSkin.free();
        }
    }

    static /* synthetic */ void lambda$clone$7(SocialPlayerPanel this_, String name, Object _b) {
        if (((Boolean)_b).booleanValue()) {
            this_.frm.openPopup(new MessagePopup(this_.frm, this_.gui.i18nFormat("label.cpm.success", new Object[0]), this_.gui.i18nFormat("label.cpm.cloningSuccess", name)));
        } else {
            this_.frm.openPopup(new MessagePopup(this_.frm, this_.gui.i18nFormat("label.cpm.error", new Object[0]), this_.gui.i18nFormat("label.cpm.cloningFailed", new Object[0])));
        }
    }

    static /* synthetic */ void lambda$new$6(SocialPlayerPanel this_, Player player, Frame frm) {
        ModelDefinition d = player.getModelDefinition();
        if (d != null && d.cloneable != null) {
            String name = d.cloneable.name;
            if (name == null) {
                frm.openPopup(new InputPopup(frm, this_.gui.i18nFormat("label.cpm.modelName", new Object[0]), SocialPlayerPanel$$Lambda$9.lambdaFactory$(this_), null));
            } else {
                this_.clone(name);
            }
        }
    }

    static /* synthetic */ void lambda$new$5(SocialPlayerPanel this_, Frame frm, Player player, Runnable reload) {
        frm.openPopup(new SafetyPopup(this_, player.getUUID().toString(), player.getName(), reload, frm));
    }

    static /* synthetic */ void lambda$new$4(SocialPlayerPanel this_, String uuid, Player player, Button block, Runnable reload) {
        if (SocialConfig.isBlocked(uuid)) {
            SocialConfig.removeBlock(uuid);
        } else {
            SocialConfig.blockPlayer(uuid, player.getName());
        }
        block.setText(this_.gui.i18nFormat(SocialConfig.isBlocked(uuid) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]));
        MinecraftClientAccess$.get().getDefinitionLoader().settingsChanged(player.getUUID());
        reload.run();
        ModConfig.getCommonConfig().save();
    }

    static /* synthetic */ void lambda$new$3(SocialPlayerPanel this_, String uuid, Player player, Button friend, Runnable reload) {
        if (SocialConfig.isFriend(uuid)) {
            SocialConfig.removeFriend(uuid);
        } else {
            SocialConfig.addFriend(uuid, player.getName());
        }
        friend.setText(this_.gui.i18nFormat(SocialConfig.isFriend(uuid) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]));
        MinecraftClientAccess$.get().getDefinitionLoader().settingsChanged(player.getUUID());
        reload.run();
        ModConfig.getCommonConfig().save();
    }

    static /* synthetic */ CompletionStage lambda$new$2(SocialPlayerPanel this_, Player player, Void _v) {
        return player.getTextures().getTexture(TextureType.SKIN).thenApply(SocialPlayerPanel$$Lambda$10.lambdaFactory$(this_, player));
    }

    static /* synthetic */ ModelDefinition lambda$null$1(SocialPlayerPanel this_, Player player, Image i) {
        if (i == null) {
            i = player.getSkinType().getSkinTexture();
        }
        this_.vanillaSkin = new TextureProvider(i, new Vec2i(64, 64));
        return ModelDefinition.createVanilla(SocialPlayerPanel$$Lambda$11.lambdaFactory$(this_), player.getSkinType());
    }

    static /* synthetic */ TextureProvider lambda$null$0(SocialPlayerPanel this_) {
        return this_.vanillaSkin;
    }

    static /* synthetic */ void access$lambda$0(SocialPlayerPanel socialPlayerPanel, String string) {
        socialPlayerPanel.clone(string);
    }

    public static class SafetyPopup
    extends PopupPanel {
        private final Frame frm;
        private String uuid;
        private String name;
        private ModConfigFile.ConfigEntryTemp config;

        protected SafetyPopup(Panel parent, String uuid, String name, Runnable reload, Frame frm) {
            super(parent.getGui());
            this.frm = frm;
            Box b = parent.getBounds();
            this.setBounds(new Box(0, 0, b.w - 30, b.h - 20));
            this.uuid = uuid;
            this.name = name;
            this.config = ModConfig.getCommonConfig().createTemp();
            ConfigEntry ce = this.config.getEntry("playerSettings").getEntry(uuid);
            if (ce.keySet().isEmpty() && name != null) {
                ce.setString("name", name);
            }
            ScrollPanel scpS = new ScrollPanel(this.gui);
            scpS.setBounds(new Box(5, 5, this.bounds.w - 10, this.bounds.h - 30));
            this.addElement(scpS);
            SafetyPanel sp = new SafetyPanel(this.gui, ce, this.bounds.w - 10, this.getKeyGroup(), uuid, this.config);
            scpS.setDisplay(sp);
            Button saveBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.saveCfg", new Object[0]), SocialPlayerPanel$SafetyPopup$$Lambda$1.lambdaFactory$(this, uuid, reload));
            this.addElement(saveBtn);
            saveBtn.setBounds(new Box(5, this.bounds.h - 25, 80, 20));
        }

        public PlayerSpecificConfigKey.KeyGroup getKeyGroup() {
            return SocialConfig.isFriend(this.uuid) ? PlayerSpecificConfigKey.KeyGroup.FRIEND : PlayerSpecificConfigKey.KeyGroup.GLOBAL;
        }

        @Override
        public String getTitle() {
            return this.gui.i18nFormat("label.cpm.sSettingsFor", this.name == null ? this.gui.i18nFormat("label.cpm.unknown", new Object[0]) : this.name);
        }

        @Override
        public void close() {
            if (this.config.isDirty()) {
                this.frm.openPopup(new ConfirmPopup(this.frm, this.gui.i18nFormat("label.cpm.unsaved", new Object[0]), SocialPlayerPanel$SafetyPopup$$Lambda$2.lambdaFactory$(this), null));
            } else {
                super.close();
            }
        }

        static /* synthetic */ void lambda$close$1(SafetyPopup this_) {
            super.close();
        }

        static /* synthetic */ void lambda$new$0(SafetyPopup this_, String uuid, Runnable reload) {
            this_.config.saveConfig();
            MinecraftClientAccess$.get().getDefinitionLoader().settingsChanged(UUID.fromString(uuid));
            reload.run();
            this_.close();
        }
    }
}

