/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.KeybindHandler;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.gui.Keybinds;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.gui.panel.ViewportPanelBase3d$$Lambda$1;
import com.tom.cpm.shared.gui.panel.ViewportPanelBase3d$$Lambda$2;
import com.tom.cpm.shared.gui.panel.ViewportPanelBase3d$$Lambda$3;
import com.tom.cpm.shared.model.builtin.BlockModel;
import com.tom.cpm.shared.model.builtin.IItemModel;
import com.tom.cpm.shared.model.builtin.ItemModel;
import com.tom.cpm.shared.model.builtin.ParrotModel;
import com.tom.cpm.shared.model.builtin.ShieldModel;
import com.tom.cpm.shared.model.builtin.SkullModel;
import com.tom.cpm.shared.model.builtin.SpyglassModel;
import com.tom.cpm.shared.model.builtin.TridentModel;
import com.tom.cpm.shared.model.builtin.VanillaPlayerModel;
import com.tom.cpm.shared.model.render.GuiModelRenderManager;
import com.tom.cpm.shared.model.render.ItemTransform;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.util.PlayerModelLayer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Set;

public abstract class ViewportPanelBase3d
extends Panel3d {
    public static final GuiModelRenderManager manager = new GuiModelRenderManager();
    protected static final ParrotModel parrot = new ParrotModel();
    protected static final ShieldModel shield = new ShieldModel();
    protected static final BlockModel block = new BlockModel();
    protected static final TridentModel trident = new TridentModel();
    protected static final SkullModel skull = new SkullModel();
    protected static final IItemModel.ItemRenderTransform[] swordTransform = new IItemModel.ItemRenderTransform[]{new IItemModel.ItemRenderTransform(new Vec3f(0.0f, 4.0f, 0.5f), new Vec3f(0.0f, -90.0f, 55.0f), new Vec3f(0.85f, 0.85f, 0.85f)), new IItemModel.ItemRenderTransform(new Vec3f(0.0f, 4.0f, 0.5f), new Vec3f(0.0f, 90.0f, -55.0f), new Vec3f(0.85f, 0.85f, 0.85f))};
    protected static final IItemModel.ItemRenderTransform[] bowTransform = new IItemModel.ItemRenderTransform[]{new IItemModel.ItemRenderTransform(new Vec3f(-1.0f, -2.0f, 2.5f), new Vec3f(-80.0f, 260.0f, -40.0f), new Vec3f(0.9f, 0.9f, 0.9f)), new IItemModel.ItemRenderTransform(new Vec3f(-1.0f, -2.0f, 2.5f), new Vec3f(-80.0f, -280.0f, 40.0f), new Vec3f(0.9f, 0.9f, 0.9f))};
    protected static final IItemModel.ItemRenderTransform[] crossbowTransform = new IItemModel.ItemRenderTransform[]{new IItemModel.ItemRenderTransform(new Vec3f(2.0f, 0.1f, -3.0f), new Vec3f(-90.0f, 0.0f, -60.0f), new Vec3f(0.9f, 0.9f, 0.9f)), new IItemModel.ItemRenderTransform(new Vec3f(2.0f, 0.1f, -3.0f), new Vec3f(-90.0f, 0.0f, 30.0f), new Vec3f(0.9f, 0.9f, 0.9f))};
    protected static final IItemModel.ItemRenderTransform[] itemTransform = new IItemModel.ItemRenderTransform[]{new IItemModel.ItemRenderTransform(new Vec3f(0.0f, 3.0f, 1.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.55f, 0.55f, 0.55f))};
    protected static final IItemModel.ItemRenderTransform[] goatHornTransform = new IItemModel.ItemRenderTransform[]{new IItemModel.ItemRenderTransform(new Vec3f(-1.0f, 2.0f, 2.0f), new Vec3f(0.0f, -125.0f, 0.0f), new Vec3f(0.5f, 0.5f, 0.5f)), new IItemModel.ItemRenderTransform(new Vec3f(1.0f, 2.0f, 2.0f), new Vec3f(0.0f, 125.0f, 0.0f), new Vec3f(0.5f, 0.5f, 0.5f))};
    protected static final IItemModel.ItemRenderTransform[] brushTransform = new IItemModel.ItemRenderTransform[]{new IItemModel.ItemRenderTransform(new Vec3f(0.0f, 4.0f, 0.0f), new Vec3f(0.0f, 0.0f, 45.0f), new Vec3f(0.9f, 0.9f, 0.9f)), new IItemModel.ItemRenderTransform(new Vec3f(0.0f, 4.0f, 0.0f), new Vec3f(0.0f, 0.0f, -45.0f), new Vec3f(0.9f, 0.9f, 0.9f))};
    protected static final ItemModel sword = new ItemModel("sword", swordTransform);
    protected static final ItemModel food = new ItemModel("food", itemTransform);
    protected static final IItemModel[] bow = new IItemModel[]{new ItemModel("bow_pulling_0", bowTransform), new ItemModel("bow_pulling_1", bowTransform), new ItemModel("bow_pulling_2", bowTransform)};
    protected static final IItemModel[] crossbow = new IItemModel[]{new ItemModel("crossbow", crossbowTransform), new ItemModel("crossbow_pulling_0", crossbowTransform), new ItemModel("crossbow_pulling_1", crossbowTransform), new ItemModel("crossbow_pulling_2", crossbowTransform)};
    protected static final SpyglassModel spyglass = new SpyglassModel();
    protected static final ItemModel goatHorn = new ItemModel("goat_horn", goatHornTransform);
    protected static final ItemModel brush = new ItemModel("brush", brushTransform);
    protected static final EnumMap<DisplayItem, IItemModel[]> itemModels = new EnumMap(DisplayItem.class);
    protected int mx;
    protected int my;
    protected boolean enableDrag;
    protected boolean dragMode;
    protected int paintColor;
    protected RenderTypes<RenderMode> types;

    public ViewportPanelBase3d(Frame frm) {
        super(frm);
        this.setBackgroundColor(this.gui.getColors().popup_background);
    }

    public void renderModel(MatrixStack stack, VBuffers buf, float partialTicks) {
        ItemTransform tr;
        float scale = this.getScale();
        stack.push();
        stack.translate(0.5, 0.0, 0.5);
        stack.rotate(Vec3f.POSITIVE_Y.getDegreesQuaternion(90.0f));
        stack.scale(-scale, -scale, scale);
        stack.translate(0.0, -1.5, 0.0);
        ModelDefinition def = this.getDefinition();
        VanillaPlayerModel p = manager.getModel(def.getSkinType());
        VBuffers rp = buf.replay();
        this.preRender(stack, rp);
        manager.setupSkin(this, p, rp, def, this.getAnimMode());
        this.poseModel(p, stack, partialTicks);
        p.render(stack, rp.getBuffer(this.types, RenderMode.DEFAULT));
        Set<PlayerModelLayer> layers = this.getArmorLayers();
        for (PlayerModelLayer playerModelLayer : PlayerModelLayer.VALUES) {
            if (!layers.contains((Object)playerModelLayer)) continue;
            p.poseLayer(playerModelLayer, layers);
        }
        for (Enum enum_ : ItemSlot.SLOTS) {
            ItemTransform tr2;
            stack.push();
            DisplayItem item = this.getHeldItem((ItemSlot)enum_);
            Enum trSlot = enum_;
            if (item.positionOverride != null) {
                trSlot = item.positionOverride;
            }
            if ((tr2 = def.getTransform((ItemSlot)trSlot)) != null) {
                stack.mul(tr2.getMatrix());
            } else {
                p.transformSlot((ItemSlot)trSlot, stack);
            }
            this.renderItem(stack, rp, (ItemSlot)enum_, item);
            stack.pop();
        }
        if ((this.drawParrots() & 1) != 0) {
            stack.push();
            tr = def.getTransform(ItemSlot.LEFT_SHOULDER);
            if (tr != null) {
                stack.mul(tr.getMatrix());
            }
            stack.translate(0.4f, p.crouching ? (double)-1.3f : -1.5, 0.0);
            parrot.render(stack, rp.getBuffer(this.getRenderTypes(parrot.getTexture()), RenderMode.DEFAULT));
            stack.pop();
        }
        if ((this.drawParrots() & 2) != 0) {
            stack.push();
            tr = def.getTransform(ItemSlot.RIGHT_SHOULDER);
            if (tr != null) {
                stack.mul(tr.getMatrix());
            }
            stack.translate(-0.4f, p.crouching ? (double)-1.3f : -1.5, 0.0);
            parrot.render(stack, rp.getBuffer(this.getRenderTypes(parrot.getTexture()), RenderMode.DEFAULT));
            stack.pop();
        }
        manager.unbindModel(p);
        for (Enum enum_ : PlayerModelLayer.VALUES) {
            if (!layers.contains(enum_)) continue;
            manager.setupLayer(this, (PlayerModelLayer)enum_, p, rp, def, this.getAnimMode());
            p.renderLayer(stack, rp.getBuffer(this.types, RenderMode.DEFAULT), (PlayerModelLayer)enum_);
            manager.unbindModel(p);
        }
        this.postRender(stack, rp);
        rp.finishAll();
        stack.pop();
    }

    public void renderItem(MatrixStack stack, VBuffers rp, ItemSlot hand, DisplayItem item) {
        IItemModel[] models = itemModels.get((Object)item);
        if (models != null) {
            IItemModel model = models[this.getItemState(hand, models.length)];
            model.render(stack, rp.getBuffer(this.getRenderTypes(model.getTexture()), RenderMode.DEFAULT), hand);
        }
    }

    protected void poseModel(VanillaPlayerModel p, MatrixStack stack, float partialTicks) {
        p.reset();
        p.setAllVisible(true);
        PlayerModelSetup.setRotationAngles(p, 0.0f, 0.0f, Hand.RIGHT, false);
    }

    public void renderBase(MatrixStack stack, VBuffers buf) {
        RenderTypes<RenderMode> rt = this.getRenderTypes("area");
        VertexBuffer t = buf.getBuffer(rt, RenderMode.DEFAULT);
        Mat3f n = stack.getLast().getNormal();
        Mat4f m = stack.getLast().getMatrix();
        int grid = this.gui.getColors().grid_color;
        t.pos(m, 4.0f, 0.0f, 4.0f).tex(1.0f, 1.0f).normal(n, 0.0f, -1.0f, 0.0f).color(grid).endVertex();
        t.pos(m, 4.0f, 0.0f, -3.0f).tex(0.0f, 1.0f).normal(n, 0.0f, -1.0f, 0.0f).color(grid).endVertex();
        t.pos(m, -3.0f, 0.0f, -3.0f).tex(0.0f, 0.0f).normal(n, 0.0f, -1.0f, 0.0f).color(grid).endVertex();
        t.pos(m, -3.0f, 0.0f, 4.0f).tex(1.0f, 0.0f).normal(n, 0.0f, -1.0f, 0.0f).color(grid).endVertex();
        t.finish();
        rt = this.getRenderTypes("base");
        t = buf.getBuffer(rt, RenderMode.DEFAULT);
        float y = -1.001f;
        t.pos(m, 1.0f, y, 0.0f).tex(1.0f, 1.0f).normal(n, 0.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 0.0f).tex(0.0f, 1.0f).normal(n, 0.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 0.0f).tex(0.0f, 0.0f).normal(n, 0.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 0.0f).tex(1.0f, 0.0f).normal(n, 0.0f, 0.0f, -1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 1.0f).tex(1.0f, 1.0f).normal(n, 0.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 1.0f).tex(0.0f, 1.0f).normal(n, 0.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 1.0f).tex(0.0f, 0.0f).normal(n, 0.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 1.0f).tex(1.0f, 0.0f).normal(n, 0.0f, 0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 1.0f).tex(1.0f, 1.0f).normal(n, 1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 0.0f).tex(0.0f, 1.0f).normal(n, 1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 0.0f).tex(0.0f, 0.0f).normal(n, 1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 1.0f).tex(1.0f, 0.0f).normal(n, 1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 0.0f).tex(1.0f, 1.0f).normal(n, -1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 1.0f).tex(0.0f, 1.0f).normal(n, -1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 1.0f).tex(0.0f, 0.0f).normal(n, -1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 0.0f).tex(1.0f, 0.0f).normal(n, -1.0f, 0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 0.0f).tex(1.0f, 1.0f).normal(n, 0.0f, -1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y, 1.0f).tex(0.0f, 1.0f).normal(n, 0.0f, -1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 1.0f).tex(0.0f, 0.0f).normal(n, 0.0f, -1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y, 0.0f).tex(1.0f, 0.0f).normal(n, 0.0f, -1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 1.0f).tex(1.0f, 1.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 1.0f, y + 1.0f, 0.0f).tex(0.0f, 1.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 0.0f).tex(0.0f, 0.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.pos(m, 0.0f, y + 1.0f, 1.0f).tex(1.0f, 0.0f).normal(n, 0.0f, 1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        t.finish();
    }

    public void load() {
        this.types = this.getRenderTypes();
    }

    public void load(String tex) {
        this.types = this.getRenderTypes(tex);
    }

    public void putRenderTypes(RenderTypes<RenderMode> types) {
        if (this.types == null) {
            this.load();
        }
        types.putAll(this.types);
    }

    protected float getScale() {
        return 1.0f;
    }

    protected abstract void preRender(MatrixStack var1, VBuffers var2);

    protected void postRender(MatrixStack stack, VBuffers buf) {
    }

    protected abstract ModelDefinition getDefinition();

    protected AnimationEngine.AnimationMode getAnimMode() {
        return AnimationEngine.AnimationMode.PLAYER;
    }

    protected Set<PlayerModelLayer> getArmorLayers() {
        return Collections.emptySet();
    }

    public DisplayItem getHeldItem(ItemSlot hand) {
        return DisplayItem.NONE;
    }

    protected int drawParrots() {
        return 0;
    }

    protected int getItemState(ItemSlot slot, int maxStates) {
        return 0;
    }

    protected boolean isRotate(int btn) {
        return true;
    }

    protected boolean isDrag(int btn) {
        return btn == 1;
    }

    @Override
    public void mouseClick(MouseEvent evt) {
        super.mouseClick(evt);
        if (this.isRotate(evt.btn) && evt.isHovered(this.bounds)) {
            this.mx = evt.x;
            this.my = evt.y;
            this.enableDrag = true;
            this.dragMode = this.isDrag(evt.btn);
            evt.consume();
        }
    }

    @Override
    public void mouseRelease(MouseEvent evt) {
        super.mouseRelease(evt);
        if (this.isRotate(evt.btn) && evt.isHovered(this.bounds)) {
            this.enableDrag = false;
            evt.consume();
        }
    }

    @Override
    public void mouseDrag(MouseEvent evt) {
        super.mouseDrag(evt);
        if (this.isRotate(evt.btn) && evt.isHovered(this.bounds) && this.enableDrag) {
            int x = evt.x;
            int y = evt.y;
            ViewportCamera cam = this.getCamera();
            if (this.dragMode) {
                float yaw = cam.look.getYaw();
                double px = 0.0;
                double pz = 0.0;
                int dx = x - this.mx;
                int dy = y - this.my;
                float move = -1.0f / cam.camDist;
                if (dx != 0) {
                    px += Math.sin((double)yaw - 1.5707963267948966) * -1.0 * (double)dx * (double)move;
                    pz += Math.cos((double)yaw - 1.5707963267948966) * (double)dx * (double)move;
                }
                if (dy != 0) {
                    px += Math.sin(yaw) * -1.0 * (double)dy * (double)move;
                    pz += Math.cos(yaw) * (double)dy * (double)move;
                }
                float f = 1.0f - cam.look.y;
                Vec3f by = new Vec3f((float)(px * (double)cam.look.y), 0.0f, (float)(pz * (double)cam.look.y));
                Vec3f by1 = by.mul((float)dy * 0.1f * f);
                cam.position.x = (float)((double)cam.position.x + (px + (double)by1.x));
                cam.position.y += -f * move * (float)dy;
                cam.position.z = (float)((double)cam.position.z + (pz + (double)by1.z));
            } else {
                boolean yFlip = ModConfig.getCommonConfig().getBoolean("editorInvertCamY", false);
                float pitch = (float)Math.asin(cam.look.y);
                float yaw = cam.look.getYaw();
                if (Float.isNaN(pitch)) {
                    pitch = 0.0f;
                }
                if (Float.isNaN(yaw)) {
                    yaw = 0.0f;
                }
                yaw = (float)((double)yaw + Math.toRadians(x - this.mx));
                double dPitch = Math.toRadians(y - this.my);
                pitch = yFlip ? (float)((double)pitch + dPitch) : (float)((double)pitch - dPitch);
                if ((double)yaw < -Math.PI) {
                    yaw = (float)((double)yaw + Math.PI * 2);
                }
                if ((double)yaw > Math.PI) {
                    yaw = (float)((double)yaw - Math.PI * 2);
                }
                yaw = (float)MathHelper.clamp((double)yaw, -Math.PI, Math.PI);
                pitch = (float)MathHelper.clamp((double)pitch, -1.5707963267948966, 1.5707963267948966);
                cam.look.y = (float)Math.sin(pitch);
                double sin = Math.sin(yaw);
                double cos = Math.cos(yaw);
                cam.look.x = (float)cos;
                cam.look.z = (float)sin;
            }
            this.mx = x;
            this.my = y;
            evt.consume();
        }
    }

    @Override
    public void mouseWheel(MouseEvent evt) {
        if (evt.isHovered(this.bounds)) {
            this.zoom(evt.btn);
            evt.consume();
        }
        super.mouseWheel(evt);
    }

    private void zoom(int dir) {
        ViewportCamera cam = this.getCamera();
        cam.camDist += (float)dir * (cam.camDist / 16.0f);
        if (cam.camDist < 32.0f) {
            cam.camDist = 32.0f;
        }
        if (cam.camDist > 4096.0f) {
            cam.camDist = 4096.0f;
        }
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (this.keysCanControlCamera()) {
            KeybindHandler h = this.gui.getFrame().getKeybindHandler();
            h.registerKeybind(Keybinds.ZOOM_IN_CAMERA, ViewportPanelBase3d$$Lambda$1.lambdaFactory$(this));
            h.registerKeybind(Keybinds.ZOOM_OUT_CAMERA, ViewportPanelBase3d$$Lambda$2.lambdaFactory$(this));
            h.registerKeybind(Keybinds.RESET_CAMERA, ViewportPanelBase3d$$Lambda$3.lambdaFactory$(this));
        }
        super.keyPressed(event);
    }

    protected boolean keysCanControlCamera() {
        return true;
    }

    static /* synthetic */ void lambda$keyPressed$2(ViewportPanelBase3d this_) {
        this_.getCamera().reset();
    }

    static /* synthetic */ void lambda$keyPressed$1(ViewportPanelBase3d this_) {
        this_.zoom(-1);
    }

    static /* synthetic */ void lambda$keyPressed$0(ViewportPanelBase3d this_) {
        this_.zoom(1);
    }

    static {
        itemModels.put(DisplayItem.BLOCK, new IItemModel[]{block});
        itemModels.put(DisplayItem.SHIELD, new IItemModel[]{shield});
        itemModels.put(DisplayItem.TRIDENT, new IItemModel[]{trident});
        itemModels.put(DisplayItem.SKULL, new IItemModel[]{skull});
        itemModels.put(DisplayItem.SWORD, new IItemModel[]{sword});
        itemModels.put(DisplayItem.FOOD, new IItemModel[]{food});
        itemModels.put(DisplayItem.BOW, bow);
        itemModels.put(DisplayItem.CROSSBOW, crossbow);
        itemModels.put(DisplayItem.SPYGLASS, new IItemModel[]{spyglass});
        itemModels.put(DisplayItem.GOAT_HORN, new IItemModel[]{goatHorn});
        itemModels.put(DisplayItem.BRUSH, new IItemModel[]{brush});
    }
}

