/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.io;

import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.io.ChecksumInputStream;
import com.tom.cpm.shared.io.IOHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ModelFile {
    private String name;
    private String desc;
    private String fname;
    private Link link;
    private byte[] dataBlock;
    private byte[] overflowLocal;
    private IOHelper.ImageBlock icon;

    private ModelFile() {
    }

    public static ModelFile load(File in) throws IOException {
        FileInputStream fin = new FileInputStream(in);
        Throwable throwable = null;
        try {
            ModelFile modelFile = ModelFile.load(in.getName(), fin);
            return modelFile;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (fin != null) {
                if (throwable != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    fin.close();
                }
            }
        }
    }

    public static ModelFile load(InputStream fin) throws IOException {
        return ModelFile.load("unnamed", fin);
    }

    public static ModelFile load(String name, InputStream fin) throws IOException {
        IOHelper.ImageBlock block;
        if (fin.read() != 83) {
            throw new IOException("Magic number mismatch");
        }
        ChecksumInputStream cis = new ChecksumInputStream(fin);
        IOHelper h = new IOHelper(cis);
        ModelFile mf = new ModelFile();
        mf.fname = name;
        mf.name = h.readUTF();
        mf.desc = h.readUTF();
        mf.dataBlock = h.readByteArray();
        byte[] ovf = h.readByteArray();
        if (ovf.length != 0) {
            mf.overflowLocal = ovf;
            mf.link = new Link(h);
        }
        if ((block = h.readImage()).getWidth() > 256 || block.getHeight() > 256) {
            throw new IOException("Texture size too large");
        }
        mf.icon = block;
        cis.checkSum();
        return mf;
    }

    public byte[] getDataBlock() {
        return this.dataBlock;
    }

    public IOHelper.ImageBlock getIcon() {
        return this.icon;
    }

    public void registerLocalCache(ModelDefinitionLoader loader) {
        if (this.overflowLocal != null) {
            loader.putLocalResource(this.link, this.overflowLocal);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getFileName() {
        return this.fname;
    }

    public boolean convertable() {
        return this.dataBlock.length <= 2048;
    }
}

