/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Rotation;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PartRoot;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.render.IExtraRenderDefinition;
import com.tom.cpm.shared.model.render.ItemTransform;
import com.tom.cpm.shared.model.render.Mesh;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.model.render.ModelRenderManager$RedirectRenderer$$Lambda$1;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import java.util.function.Predicate;

public class ModelRenderManager$RedirectRenderer$<P> {
    public static ModelRenderManager.RedirectRenderer setCopyFrom(ModelRenderManager.RedirectRenderer this_, ModelRenderManager.RedirectRenderer from) {
        ModelRenderManager.RedirectDataHolder.access$1702(this_.getHolder().partData.get(this_), from);
        return this_;
    }

    public static ModelRenderManager.RedirectRenderer setRenderPredicate(ModelRenderManager.RedirectRenderer this_, Predicate renderPredicate) {
        ModelRenderManager.RedirectDataHolder.access$1802(this_.getHolder().partData.get(this_), renderPredicate);
        return this_;
    }

    public static void render(ModelRenderManager.RedirectRenderer this_) {
        ModelRenderManager.RedirectHolder<?, ?, ?, ModelRenderManager.RedirectRenderer> holder = this_.getHolder();
        ModelRenderManager mngr = holder.mngr;
        ModelRenderManager.RedirectRenderer tp = this_;
        Object parent = this_.getParent();
        if (ModelRenderManager.access$1400(holder.mngr).test(tp)) {
            if (holder.def != null) {
                ModelRenderManager.RedirectDataHolder dh = holder.partData.get(this_);
                boolean noReset = ModelRenderManager.RedirectDataHolder.access$1900(dh);
                ModelRenderManager.RedirectDataHolder.access$1902(dh, true);
                VanillaModelPart part = this_.getPart();
                if (!holder.preRenderSetup) {
                    holder.preRenderSetup = true;
                    holder.bindFirstSetup(false);
                }
                if (holder.def.getResolveState() != ModelDefinition.ModelLoadingState.LOADED) {
                    return;
                }
                if (!holder.skinBound) {
                    holder.skinBound = true;
                    holder.bindSkin();
                }
                if (part == null) {
                    if (ModelRenderManager.RedirectDataHolder.access$1700(dh) != null) {
                        holder.copyModel(ModelRenderManager.RedirectDataHolder.access$1700(dh), tp);
                    }
                    return;
                }
                PartRoot elems = holder.def.getModelElementFor(part);
                if (elems != null) {
                    if (elems.isEmpty()) {
                        return;
                    }
                    boolean skipTransform = holder.mode == AnimationEngine.AnimationMode.SKULL || holder.mode == AnimationEngine.AnimationMode.HAND || holder.skipTransform(this_);
                    float px = ModelRenderManager.access$200(mngr).apply(tp);
                    float py = ModelRenderManager.access$300(mngr).apply(tp);
                    float pz = ModelRenderManager.access$400(mngr).apply(tp);
                    float rx = ModelRenderManager.access$500(mngr).apply(tp);
                    float ry = ModelRenderManager.access$600(mngr).apply(tp);
                    float rz = ModelRenderManager.access$700(mngr).apply(tp);
                    boolean doRender = holder.playerObj == null || ModelRenderManager.RedirectDataHolder.access$1800(dh).test(holder.playerObj);
                    elems.forEach(ModelRenderManager$RedirectRenderer$$Lambda$1.lambdaFactory$(this_, holder, elems, part, skipTransform, mngr, tp, doRender, noReset, parent));
                    if (!noReset) {
                        ModelRenderManager.access$1200(mngr).set(parent, px, py, pz);
                        ModelRenderManager.access$1300(mngr).set(parent, rx, ry, rz);
                    }
                    if (!skipTransform) {
                        RootModelElement elem = elems.getMainRoot();
                        ModelRenderManager.access$1200(mngr).set(tp, elem.getPos());
                        ModelRenderManager.access$1300(mngr).set(tp, elem.getRot().asVec3f(false));
                    }
                } else {
                    holder.copyModel(tp, (ModelRenderManager.RedirectRenderer)parent);
                    this_.renderParent();
                }
            } else {
                holder.copyModel(tp, (ModelRenderManager.RedirectRenderer)parent);
                this_.renderParent();
            }
        }
    }

    public static void translateRotate(ModelRenderManager.RedirectRenderer this_, RenderedCube rc, MatrixStack matrixStackIn) {
        ModelRenderManager$RedirectRenderer$.translateRotate(rc.pos.x, rc.pos.y, rc.pos.z, rc.rotation, matrixStackIn);
        if (rc.renderScale.x != 1.0f || rc.renderScale.y != 1.0f || rc.renderScale.z != 1.0f || rc.renderScale.x > 0.0f || rc.renderScale.y > 0.0f || rc.renderScale.z > 0.0f) {
            matrixStackIn.scale(Math.max(rc.renderScale.x, 0.01f), Math.max(rc.renderScale.y, 0.01f), Math.max(rc.renderScale.z, 0.01f));
        }
    }

    public static void translateRotate(float px, float py, float pz, Rotation rot, MatrixStack matrixStackIn) {
        matrixStackIn.translate(px / 16.0f, py / 16.0f, pz / 16.0f);
        matrixStackIn.rotate(rot.asQ());
    }

    public static void translateRotate(ModelRenderManager.RedirectRenderer this_, MatrixStack matrixStackIn) {
        ModelRenderManager.RedirectHolder holder = this_.getHolder();
        ModelRenderManager m = holder.mngr;
        ModelRenderManager.RedirectRenderer tp = this_;
        ModelRenderManager$RedirectRenderer$.translateRotate(ModelRenderManager.access$200(m).apply(tp), ModelRenderManager.access$300(m).apply(tp), ModelRenderManager.access$400(m).apply(tp), new Rotation(ModelRenderManager.access$500(m).apply(tp), ModelRenderManager.access$600(m).apply(tp), ModelRenderManager.access$700(m).apply(tp), false), matrixStackIn);
    }

    public static void render(ModelRenderManager.RedirectRenderer this_, RenderedCube elem, MatrixStack matrixStackIn, VBuffers buf, float red, float green, float blue, float alpha, boolean doRenderRoot, boolean doRenderElems) {
        ModelRenderManager.RedirectHolder holder = this_.getHolder();
        if (holder.def instanceof IExtraRenderDefinition && buf != null) {
            ((IExtraRenderDefinition)((Object)holder.def)).render(this_, matrixStackIn, buf, holder.renderTypes, elem, doRenderElems);
        }
        if (elem.children == null) {
            return;
        }
        for (RenderedCube cube : elem.children) {
            matrixStackIn.push();
            this_.translateRotate(cube, matrixStackIn);
            if (cube.itemRenderer != null) {
                Cube c = cube.getCube();
                if (holder.def instanceof IExtraRenderDefinition && buf != null) {
                    ((IExtraRenderDefinition)((Object)holder.def)).render(this_, matrixStackIn, buf, holder.renderTypes, cube, doRenderElems);
                }
                matrixStackIn.translate(c.offset.x / 16.0f, c.offset.y / 16.0f, c.offset.z / 16.0f);
                matrixStackIn.scale(c.meshScale.x, c.meshScale.y, c.meshScale.z);
                holder.def.storeTransform(cube.itemRenderer, matrixStackIn, (!doRenderRoot || doRenderElems) && cube.display);
                matrixStackIn.pop();
                continue;
            }
            if (!cube.display) {
                this_.render(cube, matrixStackIn, buf, red, green, blue, alpha, doRenderRoot, false);
                matrixStackIn.pop();
                continue;
            }
            if (buf != null && doRenderElems) {
                float r = red;
                float g = green;
                float b = blue;
                if (cube.color != 0xFFFFFF) {
                    r *= (float)((cube.color & 0xFF0000) >> 16) / 255.0f;
                    g *= (float)((cube.color & 0xFF00) >> 8) / 255.0f;
                    b *= (float)(cube.color & 0xFF) / 255.0f;
                }
                if (cube.updateObject || cube.renderObject == null) {
                    if (cube.renderObject != null) {
                        cube.renderObject.free();
                    }
                    cube.renderObject = ModelRenderManager.access$2000(cube, holder);
                    cube.updateObject = false;
                }
                Mesh mesh = cube.renderObject;
                VertexBuffer buffer = buf.getBuffer(holder.renderTypes, mesh.getLayer());
                if (cube.glow) {
                    buffer = buf.getBuffer(holder.renderTypes, mesh.getLayer().glow());
                }
                mesh.draw(matrixStackIn, buffer, r, g, b, alpha);
            }
            this_.render(cube, matrixStackIn, buf, red, green, blue, alpha, doRenderRoot, doRenderElems);
            matrixStackIn.pop();
        }
    }

    public static void doRender0(ModelRenderManager.RedirectRenderer this_, RootModelElement elem, boolean doRender) {
        ModelRenderManager.RedirectHolder holder = this_.getHolder();
        MatrixStack stack = new MatrixStack();
        holder.setupTransform(stack, this_, true);
        this_.translateRotate(stack);
        holder.setupTransform(stack, this_, false);
        if (doRender) {
            Vec4f color = this_.getColor();
            VBuffers bufIn = this_.getVBuffers();
            VBuffers buf = !bufIn.isBatched() ? bufIn.replay() : bufIn;
            this_.render(elem, stack, buf, color.x, color.y, color.z, color.w, doRender, true);
            if (!bufIn.isBatched()) {
                buf.finishAll();
            }
        } else {
            this_.render(elem, stack, null, 1.0f, 1.0f, 1.0f, 1.0f, doRender, false);
        }
    }

    public static MatrixStack.Entry getPartTransform(ModelRenderManager.RedirectRenderer this_) {
        ItemTransform t = this_.getPartTransform0();
        if (t != null) {
            return t.getMatrix();
        }
        return null;
    }

    public static ItemTransform getPartTransform0(ModelRenderManager.RedirectRenderer this_) {
        ModelRenderManager.RedirectHolder holder = this_.getHolder();
        VanillaModelPart part = this_.getPart();
        if (part == PlayerModelParts.LEFT_ARM) {
            return holder.def.getTransform(ItemSlot.LEFT_HAND);
        }
        if (part == PlayerModelParts.RIGHT_ARM) {
            return holder.def.getTransform(ItemSlot.RIGHT_HAND);
        }
        if (part == PlayerModelParts.HEAD) {
            return holder.def.getTransform(ItemSlot.HEAD);
        }
        return null;
    }

    static /* synthetic */ void lambda$render$0(ModelRenderManager.RedirectRenderer this_, ModelRenderManager.RedirectHolder holder, PartRoot elems, VanillaModelPart part, boolean skipTransform, ModelRenderManager mngr, Object tp, boolean doRender, boolean noReset, Object parent, RootModelElement elem) {
        if (!elem.renderPart()) {
            return;
        }
        if (holder.def.isRemoveArmorOffset() && elems.getMainRoot() != elem && part.getCopyFrom() != null) {
            elem.setPosAndRot(holder.def.getModelElementFor(part.getCopyFrom()));
        }
        if (!skipTransform) {
            ModelRenderManager.access$1200(mngr).set(tp, elem.getPos());
            ModelRenderManager.access$1300(mngr).set(tp, elem.getRot().asVec3f(false));
        }
        if (elem.doDisplay() && doRender && holder.enableParentRendering(part)) {
            if (noReset && !skipTransform) {
                float _px = ModelRenderManager.access$200(mngr).apply(parent);
                float _py = ModelRenderManager.access$300(mngr).apply(parent);
                float _pz = ModelRenderManager.access$400(mngr).apply(parent);
                float _rx = ModelRenderManager.access$500(mngr).apply(parent);
                float _ry = ModelRenderManager.access$600(mngr).apply(parent);
                float _rz = ModelRenderManager.access$700(mngr).apply(parent);
                holder.copyModel(tp, parent);
                this_.renderParent();
                ModelRenderManager.access$1200(mngr).set(parent, _px, _py, _pz);
                ModelRenderManager.access$1300(mngr).set(parent, _rx, _ry, _rz);
            } else {
                holder.copyModel(tp, parent);
                this_.renderParent();
            }
        }
        this_.doRender0(elem, doRender);
    }
}

