/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Rotation;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.shared.IPlayerRenderManager;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PartPosition;
import com.tom.cpm.shared.model.PartRoot;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.BatchedBuffers;
import com.tom.cpm.shared.model.render.BoxRender;
import com.tom.cpm.shared.model.render.ItemTransform;
import com.tom.cpm.shared.model.render.Mesh;
import com.tom.cpm.shared.model.render.ModelRenderManager$$Lambda$1;
import com.tom.cpm.shared.model.render.ModelRenderManager$$Lambda$2;
import com.tom.cpm.shared.model.render.ModelRenderManager$$Lambda$3;
import com.tom.cpm.shared.model.render.ModelRenderManager$$Lambda$4;
import com.tom.cpm.shared.model.render.ModelRenderManager$$Lambda$5;
import com.tom.cpm.shared.model.render.ModelRenderManager$$Lambda$6;
import com.tom.cpm.shared.model.render.ModelRenderManager$$Lambda$7;
import com.tom.cpm.shared.model.render.ModelRenderManager$$Lambda$8;
import com.tom.cpm.shared.model.render.ModelRenderManager$$Lambda$9;
import com.tom.cpm.shared.model.render.ModelRenderManager$RedirectHolder$$Lambda$1;
import com.tom.cpm.shared.model.render.ModelRenderManager$RedirectHolder$$Lambda$2;
import com.tom.cpm.shared.model.render.ModelRenderManager$RedirectHolder$$Lambda$3;
import com.tom.cpm.shared.model.render.ModelRenderManager$RedirectHolder$$Lambda$4;
import com.tom.cpm.shared.model.render.ModelRenderManager$RedirectHolder$$Lambda$5;
import com.tom.cpm.shared.model.render.ModelRenderManager$RedirectHolder$$Lambda$6;
import com.tom.cpm.shared.model.render.ModelRenderManager$RedirectRenderer$;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.ErrorLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class ModelRenderManager<D, S, P, MB>
implements IPlayerRenderManager {
    public static final Predicate<Player<?>> ALWAYS = ModelRenderManager$$Lambda$9.lambdaFactory$();
    protected Map<MB, RedirectHolder<MB, D, S, P>> holders = new HashMap<MB, RedirectHolder<MB, D, S, P>>();
    private RedirectHolderFactory<D, S, P> factory;
    private RedirectRendererFactory<MB, S, P> redirectFactory;
    private AnimationEngine animEngine = new AnimationEngine();
    private ModelPartVec3fSetter<P> posSet;
    private ModelPartVec3fSetter<P> rotSet;
    private ToFloatFunction<P> px;
    private ToFloatFunction<P> py;
    private ToFloatFunction<P> pz;
    private ToFloatFunction<P> rx;
    private ToFloatFunction<P> ry;
    private ToFloatFunction<P> rz;
    private Predicate<P> getVis;
    private BoolSetter<P> setVis;
    private P renderPart;

    public void setFactory(RedirectHolderFactory<D, S, P> factory) {
        this.factory = factory;
    }

    public void setRedirectFactory(RedirectRendererFactory<MB, S, P> redirectFactory) {
        this.redirectFactory = redirectFactory;
    }

    public void setModelSetters(ModelPartVec3fSetter<P> posSet, ModelPartVec3fSetter<P> rotSet) {
        this.posSet = posSet;
        this.rotSet = rotSet;
    }

    public void setModelPosGetters(ToFloatFunction<P> x, ToFloatFunction<P> y, ToFloatFunction<P> z) {
        this.px = x;
        this.py = y;
        this.pz = z;
    }

    public void setModelRotGetters(ToFloatFunction<P> x, ToFloatFunction<P> y, ToFloatFunction<P> z) {
        this.rx = x;
        this.ry = y;
        this.rz = z;
    }

    public void setRenderPart(P renderPart) {
        this.renderPart = renderPart;
    }

    public void setVis(Predicate<P> getVis, BoolSetter<P> setVis) {
        this.getVis = getVis;
        this.setVis = setVis;
    }

    public void bindModel(MB model, String arg, D addDt, ModelDefinition def, Player<?> player, AnimationEngine.AnimationMode mode) {
        this.getHolderSafe(model, arg, ModelRenderManager$$Lambda$1.lambdaFactory$(def, addDt, player, mode), true);
    }

    public void bindModel(MB model, D addDt, ModelDefinition def, Player<?> player, AnimationEngine.AnimationMode mode) {
        this.bindModel(model, null, addDt, def, player, mode);
    }

    public void bindSubModel(MB mainModel, MB subModel, String arg) {
        RedirectHolder<MB, D, S, P> h = this.holders.get(mainModel);
        if (h != null && h.swappedIn) {
            this.getHolderSafe(subModel, arg, ModelRenderManager$$Lambda$2.lambdaFactory$(h), true);
        }
    }

    public void unbindModel(MB model) {
        RedirectHolder<MB, D, S, P> h = this.holders.get(model);
        if (h != null) {
            h.swapOut();
        }
    }

    public void bindSkin(MB model, String arg, S cbi, TextureSheetType tex) {
        this.getHolderSafe(model, arg, ModelRenderManager$$Lambda$3.lambdaFactory$(cbi, tex), false);
    }

    public void bindSkin(MB model, S cbi, TextureSheetType tex) {
        this.bindSkin(model, null, cbi, tex);
    }

    public void rebindModel(MB model) {
        this.getHolderSafe(model, null, ModelRenderManager$$Lambda$4.lambdaFactory$(), false);
    }

    public void setModelPose(MB model) {
        this.getHolderSafe(model, null, ModelRenderManager$$Lambda$5.lambdaFactory$(), false);
    }

    public boolean isBound(MB model, String arg) {
        return this.getHolderSafe(model, arg, ModelRenderManager$$Lambda$6.lambdaFactory$(), false, false);
    }

    public boolean isBound(MB model) {
        return this.isBound(model, null);
    }

    public <R> R getHolderSafe(MB model, String arg, Function<RedirectHolder<MB, D, S, P>, R> func, R def, boolean make) {
        RedirectHolder<Object, D, S, P> h = this.holders.get(model);
        if (h == null && make && (h = this.factory.create(model, arg)) != null) {
            this.holders.put(model, h);
        }
        if (h == null) {
            return def;
        }
        return func.apply(h);
    }

    public void getHolderSafe(MB model, String arg, Consumer<RedirectHolder<MB, D, S, P>> func, boolean make) {
        RedirectHolder<Object, D, S, P> h = this.holders.get(model);
        if (h == null && make && (h = this.factory.create(model, arg)) != null) {
            this.holders.put(model, h);
        }
        if (h != null) {
            func.accept(h);
        }
    }

    public void flushBatch(MB model, String arg) {
        this.getHolderSafe(model, arg, ModelRenderManager$$Lambda$7.lambdaFactory$(), false);
    }

    public void copyModelForArmor(P from, P to) {
        this.posSet.set(to, this.px.apply(from), this.py.apply(from), this.pz.apply(from));
        this.rotSet.set(to, this.rx.apply(from), this.ry.apply(from), this.rz.apply(from));
    }

    public P getRenderAnyFor(MB model, String arg, VanillaModelPart part) {
        return this.getHolderSafe(model, arg, ModelRenderManager$$Lambda$8.lambdaFactory$(part), this.renderPart, false);
    }

    private static Mesh createBox(RenderedCube elem, RedirectHolder<?, ?, ?, ?> holder) {
        Cube c = elem.getCube();
        if (c.size.x == 0.0f && c.size.y == 0.0f && c.size.z == 0.0f && c.mcScale == 0.0f) {
            return Mesh.EMPTY;
        }
        if (c.texSize == 0) {
            return BoxRender.createColored(c.offset.x, c.offset.y, c.offset.z, c.size.x * c.meshScale.x, c.size.y * c.meshScale.y, c.size.z * c.meshScale.z, c.mcScale, holder.sheetX, holder.sheetY);
        }
        if (elem.singleTex) {
            return BoxRender.createTexturedSingle(c.offset, c.size, c.meshScale, c.mcScale, c.u, c.v, c.texSize, holder.sheetX, holder.sheetY);
        }
        if (elem.extrude) {
            return BoxRender.createTexturedExtruded(c.offset, c.size, c.meshScale, c.mcScale, c.u, c.v, c.texSize, holder.sheetX, holder.sheetY);
        }
        if (elem.faceUVs != null) {
            return BoxRender.createTextured(c.offset, c.size, c.meshScale, c.mcScale, elem.faceUVs, c.texSize, holder.sheetX, holder.sheetY);
        }
        return BoxRender.createTextured(c.offset, c.size, c.meshScale, c.mcScale, c.u, c.v, c.texSize, holder.sheetX, holder.sheetY);
    }

    @Override
    public AnimationEngine getAnimationEngine() {
        return this.animEngine;
    }

    static /* synthetic */ Object lambda$getRenderAnyFor$7(VanillaModelPart part, RedirectHolder h) {
        return h.getRenderAny(part);
    }

    static /* synthetic */ Boolean lambda$isBound$6(RedirectHolder h) {
        return h.swappedIn;
    }

    static /* synthetic */ void lambda$setModelPose$5(Object rec$) {
        ((RedirectHolder)rec$).poseSetup();
    }

    static /* synthetic */ void lambda$rebindModel$4(Object rec$) {
        ((RedirectHolder)rec$).rebind();
    }

    static /* synthetic */ void lambda$bindSkin$3(Object cbi, TextureSheetType tex, RedirectHolder h) {
        h.bindTexture0(cbi, tex);
    }

    static /* synthetic */ void lambda$bindSubModel$2(RedirectHolder h, RedirectHolder s) {
        s.swapIn(h);
    }

    static /* synthetic */ void lambda$bindModel$1(ModelDefinition def, Object addDt, Player player, AnimationEngine.AnimationMode mode, RedirectHolder h) {
        h.swapIn(def, addDt, player, mode);
    }

    static /* synthetic */ boolean lambda$static$0(Player p) {
        return true;
    }

    static /* synthetic */ Mesh access$2000(RenderedCube x0, RedirectHolder x1) {
        return ModelRenderManager.createBox(x0, x1);
    }

    @FunctionalInterface
    public static interface BoolSetter<P> {
        public void set(P var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ModelPartVec3fSetter<P> {
        public void set(P var1, float var2, float var3, float var4);

        public void set(P var1, Vec3f var2);
    }

    @FunctionalInterface
    public static interface RedirectRendererFactory<M, S, P> {
        public RedirectRenderer<P> create(M var1, RedirectHolder<M, ?, S, P> var2, Supplier<P> var3, VanillaModelPart var4);
    }

    public static class Field<V> {
        private Supplier<V> get;
        private Consumer<V> set;
        private VanillaModelPart part;

        public Field(Supplier<V> get, Consumer<V> set, VanillaModelPart part) {
            this.part = part;
            this.get = get;
            this.set = set;
        }
    }

    public static interface RedirectRenderer<P> {
        public P swapIn();

        public P swapOut();

        public RedirectHolder<?, ?, ?, P> getHolder();

        public P getParent();

        public VanillaModelPart getPart();

        public void renderParent();

        public VBuffers getVBuffers();

        public Vec4f getColor();

        public RedirectRenderer<P> setCopyFrom(RedirectRenderer<P> var1);

        public RedirectRenderer<P> setRenderPredicate(Predicate<Player<?>> var1);

        public void render();

        public void translateRotate(RenderedCube var1, MatrixStack var2);

        public void translateRotate(MatrixStack var1);

        public void render(RenderedCube var1, MatrixStack var2, VBuffers var3, float var4, float var5, float var6, float var7, boolean var8, boolean var9);

        public void doRender0(RootModelElement var1, boolean var2);

        public MatrixStack.Entry getPartTransform();

        public ItemTransform getPartTransform0();
    }

    private static class RedirectDataHolder<P> {
        private RedirectRenderer<P> copyFrom;
        private Predicate<Player<?>> renderPredicate = ALWAYS;
        private boolean wasCalled;

        private RedirectDataHolder() {
        }

        public void reset() {
            this.wasCalled = false;
        }

        static /* synthetic */ RedirectRenderer access$1702(RedirectDataHolder x0, RedirectRenderer x1) {
            x0.copyFrom = x1;
            return x0.copyFrom;
        }

        static /* synthetic */ Predicate access$1802(RedirectDataHolder x0, Predicate x1) {
            x0.renderPredicate = x1;
            return x0.renderPredicate;
        }

        static /* synthetic */ boolean access$1900(RedirectDataHolder x0) {
            return x0.wasCalled;
        }

        static /* synthetic */ boolean access$1902(RedirectDataHolder x0, boolean x1) {
            x0.wasCalled = x1;
            return x0.wasCalled;
        }

        static /* synthetic */ RedirectRenderer access$1700(RedirectDataHolder x0) {
            return x0.copyFrom;
        }

        static /* synthetic */ Predicate access$1800(RedirectDataHolder x0) {
            return x0.renderPredicate;
        }
    }

    public static abstract class RedirectHolder<M, D, S, P> {
        protected final ModelRenderManager<D, S, P, M> mngr;
        public final M model;
        public ModelDefinition def;
        public boolean swappedIn;
        public int sheetX;
        public int sheetY;
        public D addDt;
        public List<Field<P>> modelFields;
        public List<RedirectRenderer<P>> redirectRenderers;
        public boolean preRenderSetup;
        public boolean skinBound;
        public Map<RedirectRenderer<P>, RedirectDataHolder<P>> partData;
        public Player<?> playerObj;
        public AnimationEngine.AnimationMode mode;
        public RenderTypes<RenderMode> renderTypes;
        private boolean loggedWarning;
        private RedirectHolder<M, D, S, P> parent;
        public BatchedBuffers<D, ?, ?> batch;
        private Map<VanillaModelPart, RedirectRenderer<P>> renderAnyMap;

        public RedirectHolder(ModelRenderManager<D, S, P, M> mngr, M model) {
            this.model = model;
            this.mngr = mngr;
            this.modelFields = new ArrayList<Field<P>>();
            this.redirectRenderers = new ArrayList<RedirectRenderer<P>>();
            this.partData = new HashMap<RedirectRenderer<P>, RedirectDataHolder<P>>();
            this.renderTypes = new RenderTypes<RenderMode>(RenderMode.class);
            this.renderAnyMap = new HashMap<VanillaModelPart, RedirectRenderer<P>>();
        }

        public void swapIn(RedirectHolder<M, D, S, P> h) {
            this.swapIn(h.def, h.addDt, h.playerObj, h.mode);
            this.parent = h;
        }

        public final void swapIn(ModelDefinition def, D addDt, Player<?> playerObj, AnimationEngine.AnimationMode mode) {
            this.def = def;
            this.addDt = addDt;
            this.mode = mode;
            if (this.swappedIn) {
                return;
            }
            this.swapIn0();
            for (int i = 0; i < this.modelFields.size(); ++i) {
                Field<P> field = this.modelFields.get(i);
                RedirectRenderer<P> rd = this.redirectRenderers.get(i);
                ((Field)field).set.accept(rd.swapIn());
            }
            this.renderAnyMap.values().forEach(ModelRenderManager$RedirectHolder$$Lambda$1.lambdaFactory$());
            this.partData.values().forEach(ModelRenderManager$RedirectHolder$$Lambda$2.lambdaFactory$());
            this.playerObj = playerObj;
            this.swappedIn = true;
        }

        public final void swapOut() {
            this.def = null;
            this.addDt = null;
            this.skinBound = false;
            this.preRenderSetup = false;
            this.renderTypes.clear();
            this.playerObj = null;
            this.parent = null;
            if (!this.swappedIn) {
                return;
            }
            this.swapOut0();
            for (int i = 0; i < this.modelFields.size(); ++i) {
                Field<P> field = this.modelFields.get(i);
                ((Field)field).set.accept(this.redirectRenderers.get(i).swapOut());
            }
            this.renderAnyMap.values().forEach(ModelRenderManager$RedirectHolder$$Lambda$3.lambdaFactory$());
            this.swappedIn = false;
        }

        private void rebind() {
            if (!this.swappedIn) {
                return;
            }
            ModelDefinition def = this.def;
            D addDt = this.addDt;
            Player<?> playerObj = this.playerObj;
            AnimationEngine.AnimationMode mode = this.mode;
            this.swapOut();
            this.swapIn(def, addDt, playerObj, mode);
        }

        private void poseSetup() {
            if (this.def == null) {
                return;
            }
            if (!this.preRenderSetup) {
                this.preRenderSetup = true;
                this.bindFirstSetup(true);
            }
        }

        private void bindTexture0(S cbi, TextureSheetType tex) {
            if (this.def == null) {
                return;
            }
            TextureProvider skin = this.def.getTexture(tex, this.isDirectMode());
            if (skin != null && skin.texture != null) {
                this.bindTexture(cbi, skin, tex);
                this.sheetX = skin.getSize().x;
                this.sheetY = skin.getSize().y;
            } else {
                Vec2i s = tex.getDefSize();
                this.sheetX = s.x;
                this.sheetY = s.y;
                this.bindDefaultTexture(cbi, tex);
            }
            this.setupRenderSystem(cbi, tex);
        }

        protected void bindTexture(S cbi, TextureProvider skin, TextureSheetType tex) {
            this.bindTexture(cbi, skin);
        }

        protected void setupRenderSystem(S cbi, TextureSheetType tex) {
        }

        protected void bindTexture(S cbi, TextureProvider skin) {
        }

        protected abstract void swapIn0();

        protected abstract void swapOut0();

        protected void bindSkin() {
        }

        protected void bindDefaultTexture(S cbi, TextureSheetType tex) {
        }

        protected void bindFirstSetup(boolean isPoseSetup) {
            if (this.playerObj != null) {
                this.playerObj.updateFromModel(this.model);
                ((ModelRenderManager)this.mngr).animEngine.handleAnimation(this.playerObj, this.mode, this.def);
            }
            if (this.def.getResolveState() != ModelDefinition.ModelLoadingState.LOADED) {
                return;
            }
            for (int i = 0; i < this.redirectRenderers.size(); ++i) {
                PartRoot elems;
                RedirectRenderer<P> re = this.redirectRenderers.get(i);
                VanillaModelPart part = re.getPart();
                if (part == null || part.needsPoseSetup() && !this.isDirectMode() && !isPoseSetup || (elems = this.def.getModelElementFor(part)) == null) continue;
                RedirectRenderer<P> tp = re;
                float px = ((ModelRenderManager)this.mngr).px.apply(tp);
                float py = ((ModelRenderManager)this.mngr).py.apply(tp);
                float pz = ((ModelRenderManager)this.mngr).pz.apply(tp);
                float rx = ((ModelRenderManager)this.mngr).rx.apply(tp);
                float ry = ((ModelRenderManager)this.mngr).ry.apply(tp);
                float rz = ((ModelRenderManager)this.mngr).rz.apply(tp);
                elems.setRootPosAndRot(px, py, pz, rx, ry, rz);
            }
            this.def.getAnimations().applyCopy();
        }

        protected RedirectRenderer<P> register(Field<P> f) {
            RedirectRenderer rd = ((ModelRenderManager)this.mngr).redirectFactory.create(this.model, this, ((Field)f).get, ((Field)f).part);
            this.modelFields.add(f);
            this.redirectRenderers.add(rd);
            this.partData.put(rd, new RedirectDataHolder());
            return rd;
        }

        protected RedirectRenderer<P> register(Field<P> f, Predicate<Player<?>> doRender) {
            return this.register(f).setRenderPredicate(doRender);
        }

        protected RedirectRenderer<P> registerHead(Field<P> f) {
            return this.register(f).setRenderPredicate(ModelRenderManager$RedirectHolder$$Lambda$4.lambdaFactory$(this));
        }

        private RedirectRenderer<P> register(VanillaModelPart part) {
            RedirectRenderer rd = ((ModelRenderManager)this.mngr).redirectFactory.create(this.model, this, ModelRenderManager$RedirectHolder$$Lambda$5.lambdaFactory$(this), part);
            this.partData.put(rd, new RedirectDataHolder());
            if (this.swappedIn) {
                rd.swapIn();
            }
            return rd;
        }

        public void copyModel(P from, P to) {
            ((ModelRenderManager)this.mngr).posSet.set(to, ((ModelRenderManager)this.mngr).px.apply(from), ((ModelRenderManager)this.mngr).py.apply(from), ((ModelRenderManager)this.mngr).pz.apply(from));
            ((ModelRenderManager)this.mngr).rotSet.set(to, ((ModelRenderManager)this.mngr).rx.apply(from), ((ModelRenderManager)this.mngr).ry.apply(from), ((ModelRenderManager)this.mngr).rz.apply(from));
            ((ModelRenderManager)this.mngr).setVis.set(to, ((ModelRenderManager)this.mngr).getVis.test(from));
        }

        protected boolean skipTransform(RedirectRenderer<P> part) {
            return false;
        }

        public void logWarning() {
            if (!this.loggedWarning) {
                ErrorLog.addFormattedLog(ErrorLog.LogLevel.ERROR, "label.cpm.error.renderInitFail", this.model.getClass().toString());
                this.loggedWarning = true;
            }
        }

        protected boolean isDirectMode() {
            return false;
        }

        protected void setupTransform(MatrixStack stack, RedirectRenderer<P> forPart, boolean pre) {
            if (pre && this.def != null && this.def.getScale() != null && this.mode == AnimationEngine.AnimationMode.PLAYER) {
                this.transform(stack, this.def.getScale());
            }
            if (pre && this.def != null && this.def.removeBedOffset && this.mode == AnimationEngine.AnimationMode.PLAYER && this.playerObj != null && !this.playerObj.isClientPlayer() && this.playerObj.animState.sleeping) {
                stack.translate(0.0, 0.0, 0.125);
            }
            if (pre && this.def != null && this.mode == AnimationEngine.AnimationMode.HAND) {
                if (forPart.getPart() == PlayerModelParts.LEFT_ARM && this.def.fpLeftHand != null) {
                    this.transform(stack, this.def.fpLeftHand);
                } else if (forPart.getPart() == PlayerModelParts.RIGHT_ARM && this.def.fpRightHand != null) {
                    this.transform(stack, this.def.fpRightHand);
                }
            }
        }

        public void transform(MatrixStack stack, PartPosition pos) {
            if (pos != null) {
                Vec3f p = pos.getRPos();
                Rotation r = pos.getRRotation();
                Vec3f s = pos.getRScale();
                ModelRenderManager$RedirectRenderer$.translateRotate(p.x, p.y, p.z, r, stack);
                float sx = s.x;
                float sy = s.y;
                float sz = s.z;
                if (sx < 0.1f || sx > 10.0f) {
                    sx = 1.0f;
                }
                if (sy < 0.1f || sy > 10.0f) {
                    sy = 1.0f;
                }
                if (sz < 0.1f || sz > 10.0f) {
                    sz = 1.0f;
                }
                stack.scale(sx, sy, sz);
            }
        }

        public <V> VBuffers nextBatch(Supplier<BatchedBuffers.BufferOutput<V>> prepBuffer, V def) {
            RedirectHolder<M, D, S, P> h = this.parent != null ? this.parent : this;
            return h.batch.nextBatch(prepBuffer, def);
        }

        public void flushBatch() {
            if (this.batch != null) {
                this.batch.flush();
            }
        }

        public P getRenderAny(VanillaModelPart part) {
            return (P)this.renderAnyMap.computeIfAbsent(part, ModelRenderManager$RedirectHolder$$Lambda$6.lambdaFactory$(this));
        }

        public void setInvis(boolean glow) {
            if (glow) {
                this.renderTypes.bindToType(RenderMode.COLOR, RenderMode.NORMAL);
                this.renderTypes.bindToType(RenderMode.DEFAULT, RenderMode.NORMAL);
            } else {
                this.renderTypes.disableType(RenderMode.DEFAULT);
                this.renderTypes.disableType(RenderMode.NORMAL);
                this.renderTypes.disableType(RenderMode.COLOR);
            }
        }

        public boolean setInvisState() {
            if (this.playerObj != null) {
                this.playerObj.animState.invisible = true;
            }
            if (this.def == null) {
                return false;
            }
            if (!MinecraftClientAccess$.get().getNetHandler().enableInvisGlow()) {
                return false;
            }
            return this.def.enableInvisGlow;
        }

        protected boolean enableParentRendering(VanillaModelPart part) {
            return true;
        }

        static /* synthetic */ Object lambda$register$1(RedirectHolder this_) {
            return this_.mngr.renderPart;
        }

        static /* synthetic */ boolean lambda$registerHead$0(RedirectHolder this_, Player p) {
            return !p.animState.hasSkullOnHead || !this_.def.isHideHeadIfSkull();
        }

        static /* synthetic */ RedirectRenderer access$lambda$0(RedirectHolder redirectHolder, VanillaModelPart vanillaModelPart) {
            return redirectHolder.register(vanillaModelPart);
        }
    }

    public static interface RedirectHolderFactory<D, S, P> {
        public <M> RedirectHolder<?, D, S, P> create(M var1, String var2);
    }
}

