/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.util.Direction;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTool;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.TreeElement$;
import com.tom.cpm.shared.editor.tree.TreeElement$TreeSettingElement$;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.editor.util.UVResizableArea;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.render.PerFaceUV$$Lambda$1;
import com.tom.cpm.shared.model.render.PerFaceUV$$Lambda$2;
import com.tom.cpm.shared.model.render.PerFaceUV$$Lambda$3;
import com.tom.cpm.shared.model.render.PerFaceUV$$Lambda$4;
import com.tom.cpm.shared.model.render.PerFaceUV$$Lambda$5;
import com.tom.cpm.shared.model.render.PerFaceUV$$Lambda$6;
import com.tom.cpm.shared.model.render.PerFaceUV$$Lambda$7;
import com.tom.cpm.shared.model.render.PerFaceUV$$Lambda$8;
import com.tom.cpm.shared.model.render.PerFaceUV$$Lambda$9;
import com.tom.cpm.shared.model.render.PerFaceUV$UVArea$$Lambda$1;
import com.tom.cpm.shared.model.render.PerFaceUV$UVArea$$Lambda$2;
import com.tom.cpm.shared.model.render.PerFaceUV$UVArea$$Lambda$3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public class PerFaceUV {
    public Map<Direction, Face> faces = new HashMap<Direction, Face>();

    public PerFaceUV() {
    }

    public PerFaceUV(ModelElement el) {
        float w = el.size.x;
        float h = el.size.y;
        float d = el.size.z;
        int ts = Math.abs(el.textureSize);
        int dx = MathHelper.ceil(w * (float)ts);
        int dy = MathHelper.ceil(h * (float)ts);
        int dz = MathHelper.ceil(d * (float)ts);
        int f4 = el.u;
        int f5 = el.u + dz;
        int f6 = el.u + dz + dx;
        int f7 = el.u + dz + dx + dx;
        int f8 = el.u + dz + dx + dz;
        int f9 = el.u + dz + dx + dz + dx;
        int f10 = el.v;
        int f11 = el.v + dz;
        int f12 = el.v + dz + dy;
        this.faces.put(Direction.UP, new Face(f5, f10, f6, f11));
        this.faces.put(Direction.DOWN, new Face(f6, f11, f7, f10));
        this.faces.put(Direction.WEST, new Face(f4, f11, f5, f12));
        this.faces.put(Direction.NORTH, new Face(f5, f11, f6, f12));
        this.faces.put(Direction.EAST, new Face(f6, f11, f8, f12));
        this.faces.put(Direction.SOUTH, new Face(f8, f11, f9, f12));
    }

    public PerFaceUV(PerFaceUV pfUV) {
        pfUV.faces.forEach(PerFaceUV$$Lambda$1.lambdaFactory$(this));
    }

    public PerFaceUV(JsonMap map) {
        for (Direction d : Direction.VALUES) {
            if (!map.containsKey(d.name().toLowerCase(Locale.ROOT))) continue;
            this.faces.put(d, Face.load(map.getMap(d.name().toLowerCase(Locale.ROOT))));
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PerFaceUV");
        this.faces.forEach(PerFaceUV$$Lambda$2.lambdaFactory$(b));
        return b.toString();
    }

    public void readFaces(IOHelper h) throws IOException {
        int hidden = h.read();
        for (Direction dir : Direction.VALUES) {
            if ((hidden & 1 << dir.ordinal()) == 0) continue;
            Face f = new Face();
            f.sx = h.readVarInt();
            f.sy = h.readVarInt();
            f.ex = h.readVarInt();
            f.ey = h.readVarInt();
            f.rotation = (Rot)h.readEnum(Rot.VALUES);
            this.faces.put(dir, f);
        }
    }

    public void writeFaces(IOHelper h) throws IOException {
        int hidden = 0;
        for (Direction dir : Direction.VALUES) {
            if (this.faces.get((Object)dir) == null) continue;
            hidden |= 1 << dir.ordinal();
        }
        h.write(hidden);
        for (Direction dir : Direction.VALUES) {
            Face face = this.faces.get((Object)dir);
            if (face == null) continue;
            h.writeVarInt(face.sx);
            h.writeVarInt(face.sy);
            h.writeVarInt(face.ex);
            h.writeVarInt(face.ey);
            h.writeEnum(face.rotation);
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        this.faces.forEach(PerFaceUV$$Lambda$3.lambdaFactory$(m));
        return m;
    }

    public boolean contains(Direction key) {
        return this.faces.containsKey((Object)key);
    }

    public Face get(Direction key) {
        return this.faces.get((Object)key);
    }

    public Vec4f getVec(Direction key) {
        Face f = this.faces.get((Object)key);
        if (f == null) {
            return new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return f.getVec();
    }

    public Rot getRot(Direction key) {
        Face f = this.faces.get((Object)key);
        if (f == null) {
            return Rot.ROT_0;
        }
        return f.rotation;
    }

    public Boolean isAutoUV(Direction key) {
        Face f = this.faces.get((Object)key);
        if (f == null) {
            return false;
        }
        return f.autoUV;
    }

    public List<TreeElement.TreeSettingElement> getDragBoxes(ModelElement parent) {
        Editor editor = parent.editor;
        ArrayList<TreeElement.TreeSettingElement> l = new ArrayList<TreeElement.TreeSettingElement>();
        ArrayList<TreeElement.TreeSettingElement> sel = new ArrayList<TreeElement.TreeSettingElement>();
        boolean show = editor.drawMode.get() == EditorTool.MOVE_UV;
        for (Direction d : Direction.VALUES) {
            Face f = this.faces.get((Object)d);
            if (f == null) continue;
            if (f.controlElems == null) {
                f.controlElems = new UVArea(parent, d, f);
            }
            if (show && d == editor.perfaceFaceDir.get()) {
                sel.addAll(((Face)f).controlElems.elements);
                continue;
            }
            l.add(((Face)f).controlElems.face);
        }
        sel.addAll(l);
        return sel;
    }

    public TreeElement.TreeSettingElement getFaceElement(ModelElement parent, Direction d) {
        Face f = this.faces.get((Object)d);
        if (f == null) {
            return null;
        }
        if (f.controlElems == null) {
            f.controlElems = new UVArea(parent, d, f);
        }
        return ((Face)f).controlElems.face;
    }

    public List<TreeElement.TreeSettingElement> getFaceElements(ModelElement parent) {
        ArrayList<TreeElement.TreeSettingElement> l = new ArrayList<TreeElement.TreeSettingElement>();
        for (Direction d : Direction.VALUES) {
            Face f = this.faces.get((Object)d);
            if (f == null) continue;
            if (f.controlElems == null) {
                f.controlElems = new UVArea(parent, d, f);
            }
            l.add(((Face)f).controlElems.face);
        }
        return l;
    }

    public void mirror(ActionBuilder ab, Direction.Axis axis) {
        Face f;
        Direction d;
        int i;
        Direction[] swap = new Direction[2];
        Direction[] mirrorX = new Direction[6];
        Direction[] mirrorY = new Direction[6];
        switch (axis) {
            case X: {
                swap[0] = Direction.NORTH;
                swap[1] = Direction.SOUTH;
                mirrorX[0] = Direction.EAST;
                mirrorX[1] = Direction.WEST;
                mirrorX[2] = Direction.NORTH;
                mirrorX[3] = Direction.SOUTH;
                mirrorY[0] = Direction.UP;
                mirrorY[1] = Direction.DOWN;
                break;
            }
            case Y: {
                swap[0] = Direction.UP;
                swap[1] = Direction.DOWN;
                mirrorY[0] = Direction.NORTH;
                mirrorY[1] = Direction.SOUTH;
                mirrorY[2] = Direction.EAST;
                mirrorY[3] = Direction.WEST;
                break;
            }
            case Z: {
                swap[0] = Direction.EAST;
                swap[1] = Direction.WEST;
                System.arraycopy(Direction.VALUES, 0, mirrorX, 0, 6);
                break;
            }
        }
        ab.onAction(PerFaceUV$$Lambda$4.lambdaFactory$(this));
        Face s0 = this.faces.get((Object)swap[0]);
        Face s1 = this.faces.get((Object)swap[1]);
        if (s0 == null) {
            ab.removeFromMap(this.faces, swap[1]);
        } else {
            ab.addToMap(this.faces, swap[1], s0);
        }
        if (s1 == null) {
            ab.removeFromMap(this.faces, swap[0]);
        } else {
            ab.addToMap(this.faces, swap[0], s1);
        }
        for (i = 0; i < mirrorX.length; ++i) {
            d = mirrorX[i];
            f = this.faces.get((Object)d);
            if (d == null || f == null) continue;
            ab.updateValueOp(f, f.sx, f.ex, PerFaceUV$$Lambda$5.lambdaFactory$());
            ab.updateValueOp(f, f.ex, f.sx, PerFaceUV$$Lambda$6.lambdaFactory$());
        }
        for (i = 0; i < mirrorY.length; ++i) {
            d = mirrorY[i];
            f = this.faces.get((Object)d);
            if (d == null || f == null) continue;
            ab.updateValueOp(f, f.sy, f.ey, PerFaceUV$$Lambda$7.lambdaFactory$());
            ab.updateValueOp(f, f.ey, f.sy, PerFaceUV$$Lambda$8.lambdaFactory$());
        }
    }

    static /* synthetic */ void lambda$mirror$8(Face a, Integer b) {
        a.ey = b;
    }

    static /* synthetic */ void lambda$mirror$7(Face a, Integer b) {
        a.sy = b;
    }

    static /* synthetic */ void lambda$mirror$6(Face a, Integer b) {
        a.ex = b;
    }

    static /* synthetic */ void lambda$mirror$5(Face a, Integer b) {
        a.sx = b;
    }

    static /* synthetic */ void lambda$mirror$4(PerFaceUV this_) {
        this_.faces.values().forEach(PerFaceUV$$Lambda$9.lambdaFactory$());
    }

    static /* synthetic */ void lambda$null$3(Face f) {
        f.controlElems = null;
    }

    static /* synthetic */ void lambda$toMap$2(Map m, Direction d, Face f) {
        m.put(d.name().toLowerCase(Locale.ROOT), f.toMap());
    }

    static /* synthetic */ void lambda$toString$1(StringBuilder b, Direction d, Face f) {
        b.append("\n\t");
        b.append(d.name());
        b.append(": ");
        b.append(f);
    }

    static /* synthetic */ void lambda$new$0(PerFaceUV this_, Direction d, Face f) {
        this_.faces.put(d, new Face(f));
    }

    private static class UVArea
    extends UVResizableArea {
        private Face f;
        private Direction d;

        public UVArea(ModelElement parent, Direction d, Face f) {
            super(parent.editor, parent);
            this.f = f;
            this.d = d;
        }

        @Override
        protected UVResizableArea.Area getArea() {
            return new UVResizableArea.Area(this.f.sx, this.f.sy, this.f.ex, this.f.ey);
        }

        @Override
        protected void setArea(UVResizableArea.Area area, boolean moveOnly) {
            ActionBuilder ab = this.editor.action("set", "action.cpm.texUV");
            Vec4f v = new Vec4f(area.sx, area.sy, area.ex, area.ey);
            ab.updateValueOp(this.f, this.f.getVec(), v, PerFaceUV$UVArea$$Lambda$1.lambdaFactory$());
            if (!moveOnly) {
                ab.updateValueOp(this.f, this.f.autoUV, false, PerFaceUV$UVArea$$Lambda$2.lambdaFactory$());
            }
            ModelElement modelElement = (ModelElement)this.parent;
            modelElement.getClass();
            ab.onAction(PerFaceUV$UVArea$$Lambda$3.lambdaFactory$(modelElement));
            ab.execute();
        }

        @Override
        protected void setAreaTemp(UVResizableArea.Area area) {
            this.f.set(new Vec4f(area.sx, area.sy, area.ex, area.ey));
            ((ModelElement)this.parent).markDirty();
        }

        @Override
        protected UVResizableArea.FaceArea face() {
            return new UVResizableArea.FaceArea(this.editor, this.parent){

                @Override
                public void onClick(IGui gui, Editor e, MouseEvent evt) {
                    super.onClick(gui, e, evt);
                    e.perfaceFaceDir.accept(UVArea.this.d);
                }

                @Override
                public void accept(TreeElement treeElement) {
                    TreeElement$.accept(this, treeElement);
                }

                @Override
                public void delete() {
                    TreeElement$.delete(this);
                }

                @Override
                public String getName() {
                    return TreeElement$TreeSettingElement$.getName(this);
                }

                @Override
                public ETextures getTexture() {
                    return TreeElement$TreeSettingElement$.getTexture(this);
                }

                @Override
                public Tooltip getTooltip(IGui iGui) {
                    return TreeElement$.getTooltip(this, iGui);
                }

                @Override
                public void setElemColor(int n) {
                    TreeElement$.setElemColor(this, n);
                }

                @Override
                public void switchEffect(Effect effect) {
                    TreeElement$.switchEffect(this, effect);
                }

                @Override
                public void addNew() {
                    TreeElement$.addNew(this);
                }

                @Override
                public void updateGui() {
                    TreeElement$.updateGui(this);
                }

                @Override
                public String getElemName() {
                    return TreeElement$.getElemName(this);
                }

                @Override
                public void setValue(float f) {
                    TreeElement$.setValue(this, f);
                }

                @Override
                public void onRefreshTree() {
                    TreeElement$.onRefreshTree(this);
                }

                @Override
                public List getSettingsElements() {
                    return TreeElement$.getSettingsElements(this);
                }

                @Override
                public boolean canAccept(TreeElement treeElement) {
                    return TreeElement$.canAccept(this, treeElement);
                }

                @Override
                public void populatePopup(PopupMenu popupMenu) {
                    TreeElement$.populatePopup(this, popupMenu);
                }

                @Override
                public void modeSwitch() {
                    TreeElement$.modeSwitch(this);
                }

                @Override
                public boolean canEditVec(VecType vecType) {
                    return TreeElement$.canEditVec(this, vecType);
                }

                @Override
                public void switchVis() {
                    TreeElement$.switchVis(this);
                }

                @Override
                public void setElemName(String string) {
                    TreeElement$.setElemName(this, string);
                }

                @Override
                public void getTreeElements(Consumer consumer) {
                    TreeElement$.getTreeElements(this, consumer);
                }

                @Override
                public boolean isSelected(Editor editor, TreeElement treeElement) {
                    return TreeElement$TreeSettingElement$.isSelected(this, editor, treeElement);
                }

                @Override
                public boolean canMove() {
                    return TreeElement$.canMove(this);
                }

                @Override
                public void drawName(IGui iGui, int n, int n2, int n3) {
                    TreeElement$.drawName(this, iGui, n, n2, n3);
                }

                @Override
                public void setMCScale(float f) {
                    TreeElement$.setMCScale(this, f);
                }

                @Override
                public int textColor(IGui iGui) {
                    return TreeElement$.textColor(this, iGui);
                }

                @Override
                public float getValue() {
                    return TreeElement$.getValue(this);
                }

                @Override
                public boolean canSelect() {
                    return TreeElement$.canSelect(this);
                }

                @Override
                public int bgColor(IGui iGui) {
                    return TreeElement$.bgColor(this, iGui);
                }

                @Override
                public int getExtraWidth(IGui iGui) {
                    return TreeElement$.getExtraWidth(this, iGui);
                }
            };
        }

        static /* synthetic */ void lambda$setArea$0(Face a, Boolean b) {
            a.autoUV = b;
        }
    }

    public static enum Rot {
        ROT_0,
        ROT_90,
        ROT_180,
        ROT_270;

        public static final Rot[] VALUES;

        static {
            VALUES = Rot.values();
        }
    }

    public static class Face {
        public int sx;
        public int sy;
        public int ex;
        public int ey;
        public Rot rotation = Rot.ROT_0;
        public boolean autoUV;
        private UVArea controlElems;

        public Face() {
        }

        public Face(Face f) {
            this.sx = f.sx;
            this.sy = f.sy;
            this.ex = f.ex;
            this.ey = f.ey;
            this.rotation = f.rotation;
            this.autoUV = f.autoUV;
        }

        private Face(JsonMap m) {
            this.sx = m.getInt("sx");
            this.sy = m.getInt("sy");
            this.ex = m.getInt("ex");
            this.ey = m.getInt("ey");
            String rot = "ROT_" + m.getString("rot");
            for (Rot r : Rot.VALUES) {
                if (!r.name().equals(rot)) continue;
                this.rotation = r;
                break;
            }
            this.autoUV = m.getBoolean("autoUV", false);
        }

        private Face(int sx, int sy, int ex, int ey) {
            this.sx = sx;
            this.sy = sy;
            this.ex = ex;
            this.ey = ey;
            this.autoUV = true;
        }

        public static Face load(JsonMap m) {
            if (m == null) {
                return null;
            }
            return new Face(m);
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("sx", this.sx);
            m.put("sy", this.sy);
            m.put("ex", this.ex);
            m.put("ey", this.ey);
            m.put("rot", this.rotation.name().toLowerCase(Locale.ROOT).substring(4));
            m.put("autoUV", this.autoUV);
            return m;
        }

        public int getVertexU(int index) {
            int i = this.getVertexRotated(index);
            return i != 0 && i != 1 ? this.ex : this.sx;
        }

        public int getVertexV(int index) {
            int i = this.getVertexRotated(index);
            return i != 0 && i != 3 ? this.ey : this.sy;
        }

        private int getVertexRotated(int index) {
            return (index + this.rotation.ordinal() + 3) % 4;
        }

        public void set(Vec4f v) {
            this.sx = (int)v.x;
            this.sy = (int)v.y;
            this.ex = (int)v.z;
            this.ey = (int)v.w;
        }

        public Vec4f getVec() {
            return new Vec4f(this.sx, this.sy, this.ex, this.ey);
        }
    }
}

