/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network;

import com.tom.cpl.nbt.NBTTag;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.nbt.NBTTagList;
import com.tom.cpl.text.IText;
import com.tom.cpl.text.LiteralText;
import com.tom.cpl.util.ThrowingConsumer;
import com.tom.cpl.util.TriConsumer;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationTrigger;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.ServerAnimationState;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.ConfigChangeRequest;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.ScaleData;
import com.tom.cpm.shared.network.IPacket;
import com.tom.cpm.shared.network.ModelEventType;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler$$Lambda$1;
import com.tom.cpm.shared.network.NetHandler$$Lambda$10;
import com.tom.cpm.shared.network.NetHandler$$Lambda$11;
import com.tom.cpm.shared.network.NetHandler$$Lambda$12;
import com.tom.cpm.shared.network.NetHandler$$Lambda$13;
import com.tom.cpm.shared.network.NetHandler$$Lambda$14;
import com.tom.cpm.shared.network.NetHandler$$Lambda$15;
import com.tom.cpm.shared.network.NetHandler$$Lambda$16;
import com.tom.cpm.shared.network.NetHandler$$Lambda$17;
import com.tom.cpm.shared.network.NetHandler$$Lambda$18;
import com.tom.cpm.shared.network.NetHandler$$Lambda$19;
import com.tom.cpm.shared.network.NetHandler$$Lambda$2;
import com.tom.cpm.shared.network.NetHandler$$Lambda$20;
import com.tom.cpm.shared.network.NetHandler$$Lambda$21;
import com.tom.cpm.shared.network.NetHandler$$Lambda$22;
import com.tom.cpm.shared.network.NetHandler$$Lambda$23;
import com.tom.cpm.shared.network.NetHandler$$Lambda$24;
import com.tom.cpm.shared.network.NetHandler$$Lambda$25;
import com.tom.cpm.shared.network.NetHandler$$Lambda$26;
import com.tom.cpm.shared.network.NetHandler$$Lambda$27;
import com.tom.cpm.shared.network.NetHandler$$Lambda$28;
import com.tom.cpm.shared.network.NetHandler$$Lambda$29;
import com.tom.cpm.shared.network.NetHandler$$Lambda$3;
import com.tom.cpm.shared.network.NetHandler$$Lambda$30;
import com.tom.cpm.shared.network.NetHandler$$Lambda$31;
import com.tom.cpm.shared.network.NetHandler$$Lambda$32;
import com.tom.cpm.shared.network.NetHandler$$Lambda$33;
import com.tom.cpm.shared.network.NetHandler$$Lambda$34;
import com.tom.cpm.shared.network.NetHandler$$Lambda$35;
import com.tom.cpm.shared.network.NetHandler$$Lambda$36;
import com.tom.cpm.shared.network.NetHandler$$Lambda$37;
import com.tom.cpm.shared.network.NetHandler$$Lambda$38;
import com.tom.cpm.shared.network.NetHandler$$Lambda$39;
import com.tom.cpm.shared.network.NetHandler$$Lambda$4;
import com.tom.cpm.shared.network.NetHandler$$Lambda$40;
import com.tom.cpm.shared.network.NetHandler$$Lambda$5;
import com.tom.cpm.shared.network.NetHandler$$Lambda$6;
import com.tom.cpm.shared.network.NetHandler$$Lambda$7;
import com.tom.cpm.shared.network.NetHandler$$Lambda$8;
import com.tom.cpm.shared.network.NetHandler$$Lambda$9;
import com.tom.cpm.shared.network.NetworkUtil;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.network.packet.GestureC2S;
import com.tom.cpm.shared.network.packet.GetSkinS2C;
import com.tom.cpm.shared.network.packet.HelloC2S;
import com.tom.cpm.shared.network.packet.HelloS2C;
import com.tom.cpm.shared.network.packet.PluginMessageC2S;
import com.tom.cpm.shared.network.packet.PluginMessageS2C;
import com.tom.cpm.shared.network.packet.ReceiveEventS2C;
import com.tom.cpm.shared.network.packet.RecommendSafetyS2C;
import com.tom.cpm.shared.network.packet.RequestPlayerC2S;
import com.tom.cpm.shared.network.packet.ScaleInfoS2C;
import com.tom.cpm.shared.network.packet.ServerAnimationS2C;
import com.tom.cpm.shared.network.packet.SetScaleC2S;
import com.tom.cpm.shared.network.packet.SetSkinC2S;
import com.tom.cpm.shared.network.packet.SetSkinS2C;
import com.tom.cpm.shared.network.packet.SubEventC2S;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.ScalingOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NetHandler<RL, P, NET> {
    public static final String GET_SKIN = "get_skin";
    public static final String SET_SKIN = "set_skin";
    public static final String HELLO = "hello";
    public static final String SET_SCALE = "set_scl";
    public static final String RECOMMEND_SAFETY = "rec_sfy";
    public static final String SUBSCRIBE_EVENT = "sub_evt";
    public static final String RECEIVE_EVENT = "rec_evt";
    public static final String GESTURE = "gesture";
    public static final String SERVER_ANIMATION = "srv_anim";
    public static final String PLUGIN = "plugin";
    public static final String REQUEST_PLAYER = "req_pl";
    protected Function<P, UUID> getPlayerUUID;
    private TriConsumer<NET, RL, byte[]> sendPacket;
    private TriConsumer<P, RL, byte[]> sendToAllTracking;
    protected IntFunction<P> getPlayerById;
    protected BiConsumer<P, IText> sendChat;
    protected BiConsumer<P, Consumer<P>> findTracking;
    protected Function<NET, Executor> executor;
    protected Function<P, Object> playerToLoader;
    protected Supplier<P> getClient;
    protected Function<P, NET> getNet;
    protected Function<NET, P> getPlayer;
    protected BiConsumer<P, IText> kickPlayer;
    protected ToIntFunction<P> getPlayerId;
    protected Consumer<IText> displayText;
    protected Supplier<Collection<? extends P>> getOnlinePlayers;
    protected Map<ScalingOptions, Map<String, Scaler<P>>> scaleSetters = new EnumMap<ScalingOptions, Map<String, Scaler<P>>>(ScalingOptions.class);
    protected BiConsumer<? super P, ServerAnimationState> animStateUpdate;
    protected Predicate<NET> allowPackets = NetHandler$$Lambda$1.lambdaFactory$();
    private List<ConfigChangeRequest<?, ?>> recommendedSettingChanges = new ArrayList();
    private EnumSet<ServerCaps> serverCaps = EnumSet.noneOf(ServerCaps.class);
    private boolean scalingWarning;
    protected Map<RL, Supplier<IPacket>> packetS2C = new HashMap<RL, Supplier<IPacket>>();
    protected Map<RL, Supplier<IPacket>> packetC2S = new HashMap<RL, Supplier<IPacket>>();
    protected Map<Class<? extends IPacket>, RL> packetLookup = new HashMap<Class<? extends IPacket>, RL>();
    private BiFunction<String, String, RL> keyFactory;

    public NetHandler(BiFunction<String, String, RL> keyFactory) {
        this.keyFactory = keyFactory;
        this.register(this.packetC2S, HELLO, HelloC2S.class, NetHandler$$Lambda$2.lambdaFactory$());
        this.register(this.packetS2C, HELLO, HelloS2C.class, NetHandler$$Lambda$3.lambdaFactory$());
        this.register(this.packetC2S, SET_SKIN, SetSkinC2S.class, NetHandler$$Lambda$4.lambdaFactory$());
        this.register(this.packetS2C, SET_SKIN, SetSkinS2C.class, NetHandler$$Lambda$5.lambdaFactory$());
        this.register(this.packetS2C, GET_SKIN, GetSkinS2C.class, NetHandler$$Lambda$6.lambdaFactory$());
        this.register(this.packetC2S, SET_SCALE, SetScaleC2S.class, NetHandler$$Lambda$7.lambdaFactory$());
        this.register(this.packetS2C, SET_SCALE, ScaleInfoS2C.class, NetHandler$$Lambda$8.lambdaFactory$());
        this.register(this.packetS2C, RECOMMEND_SAFETY, RecommendSafetyS2C.class, NetHandler$$Lambda$9.lambdaFactory$());
        this.register(this.packetC2S, SUBSCRIBE_EVENT, SubEventC2S.class, NetHandler$$Lambda$10.lambdaFactory$());
        this.register(this.packetS2C, RECEIVE_EVENT, ReceiveEventS2C.class, NetHandler$$Lambda$11.lambdaFactory$());
        this.register(this.packetC2S, GESTURE, GestureC2S.class, NetHandler$$Lambda$12.lambdaFactory$());
        this.register(this.packetS2C, SERVER_ANIMATION, ServerAnimationS2C.class, NetHandler$$Lambda$13.lambdaFactory$());
        this.register(this.packetC2S, PLUGIN, PluginMessageC2S.class, NetHandler$$Lambda$14.lambdaFactory$());
        this.register(this.packetS2C, PLUGIN, PluginMessageS2C.class, NetHandler$$Lambda$15.lambdaFactory$());
        this.register(this.packetC2S, REQUEST_PLAYER, RequestPlayerC2S.class, NetHandler$$Lambda$16.lambdaFactory$());
    }

    protected <PCKT extends IPacket> void register(Map<RL, Supplier<IPacket>> map, String name, Class<PCKT> clazz, Supplier<PCKT> factory) {
        RL key = this.keyFactory.apply("cpm_net", name);
        map.put(key, factory);
        this.packetLookup.put(clazz, key);
    }

    public void onJoin(P player) {
        NBTTagCompound data = new NBTTagCompound();
        int kickTimer = ModConfig.getWorldConfig().getInt("kickPlayersWithoutMod", 0);
        data.setInteger("kickTime", kickTimer);
        data.setTag("caps", this.writeCaps());
        NetH.ServerNetH net = this.getSNetH(player);
        PlayerData pd = this.newData();
        net.cpm$setEncodedModelData(pd);
        pd.load(this.getID(player));
        NBTTagCompound scaling = new NBTTagCompound();
        data.setTag("scaling", scaling);
        for (ScalingOptions o : this.scaleSetters.keySet()) {
            float v = pd.scale.getOrDefault((Object)o, Float.valueOf(1.0f)).floatValue();
            if (v == 1.0f) continue;
            scaling.setFloat(o.getNetKey(), v);
        }
        if (this.allowPackets.test(net)) {
            this.sendPacketTo0(net, new HelloS2C(data));
        }
    }

    private NBTTag writeCaps() {
        NBTTagCompound data = new NBTTagCompound();
        this.scaleSetters.keySet().stream().map(NetHandler$$Lambda$17.lambdaFactory$()).filter(NetHandler$$Lambda$18.lambdaFactory$()).distinct().forEach(NetHandler$$Lambda$19.lambdaFactory$(this, data));
        this.setCap(data, ServerCaps.MODEL_EVENT_SUBS);
        this.setCap(data, ServerCaps.GESTURES);
        this.setCap(data, ServerCaps.PLUGIN_MESSAGES);
        if (ModConfig.getWorldConfig().getBoolean("enableInvisibleGlow", true)) {
            this.setCap(data, ServerCaps.INVIS_GLOW);
        }
        this.setCap(data, ServerCaps.NAMED_PARAMETERS);
        return data;
    }

    private void setCap(NBTTagCompound tag, ServerCaps caps) {
        tag.setBoolean(caps.name().toLowerCase(Locale.ROOT), true);
    }

    protected PlayerData newData() {
        return new PlayerData();
    }

    public void receiveServer(RL key, InputStream data, NetH.ServerNetH net) {
        this.processPacket(this.packetC2S, key, data, net);
    }

    public void receiveClient(RL key, InputStream data, NetH net) {
        this.processPacket(this.packetS2C, key, data, net);
    }

    private void processPacket(Map<RL, Supplier<IPacket>> map, RL key, InputStream data, NetH net) {
        try {
            Supplier<IPacket> factory = map.get(key);
            if (factory != null) {
                IPacket pckt = factory.get();
                IOHelper h = new IOHelper(data);
                pckt.read(h);
                pckt.handleRaw(this, net);
            }
        }
        catch (Throwable e) {
            Log.error("Exception while processing cpm packet: " + key, e);
        }
    }

    public void handleServerCaps(NBTTagCompound tag) {
        this.serverCaps.clear();
        for (ServerCaps c : ServerCaps.VALUES) {
            if (!tag.getBoolean(c.name().toLowerCase(Locale.ROOT))) continue;
            this.serverCaps.add(c);
        }
    }

    public void sendSkinData() {
        if (this.hasModClient()) {
            NetworkUtil.sendSkinDataToServer(this);
        }
    }

    public void setSkin(P pl, String skin, boolean force, boolean save) {
        NetH.ServerNetH h = this.getSNetH(pl);
        PlayerData pd = h.cpm$getEncodedModelData();
        pd.setModel(skin, force, save);
        if (skin == null) {
            this.sendPacketTo(h, new GetSkinS2C());
        }
        this.sendPacketToTracking(pl, NetworkUtil.writeSkinData(this, pd, pl));
        pd.save(this.getID(pl));
    }

    public void setSkin(P pl, byte[] skin, boolean force) {
        PlayerData pd = this.getSNetH(pl).cpm$getEncodedModelData();
        pd.setModel(skin, force, false);
        this.sendPacketToTracking(pl, NetworkUtil.writeSkinData(this, pd, pl));
        pd.save(this.getID(pl));
    }

    public void setScale(ScaleData scl) {
        if (this.hasModClient()) {
            if (scl == null) {
                scl = ScaleData.NULL;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            for (Map.Entry<ScalingOptions, Float> e : scl.getScaling().entrySet()) {
                if (!this.serverCaps.contains((Object)e.getKey().getCaps())) continue;
                nbt.setFloat(e.getKey().getNetKey(), e.getValue().floatValue());
            }
            this.sendPacketToServer(new SetScaleC2S(nbt));
        }
    }

    public void onRespawn(P pl) {
        PlayerData pd = this.getSNetH(pl).cpm$getEncodedModelData();
        pd.rescale(this, pl);
    }

    public void tick() {
        int kickTimer = ModConfig.getWorldConfig().getInt("kickPlayersWithoutMod", 0);
        for (P p : new ArrayList<P>(this.getOnlinePlayers.get())) {
            NetH.ServerNetH net = this.getSNetH(p);
            PlayerData dt = net.cpm$getEncodedModelData();
            if (dt == null) continue;
            if (!net.cpm$hasMod()) {
                ++dt.ticksSinceLogin;
                if (kickTimer > 0 && dt.ticksSinceLogin > (long)kickTimer) {
                    this.kickPlayer.accept(p, new LiteralText(ModConfig.getWorldConfig().getString("kickMessage", "Customizable Player Models is requied on this server")));
                }
            }
            NBTTagCompound evt = new NBTTagCompound();
            NBTTagCompound evtS = new NBTTagCompound();
            this.updatePlayer(p, dt.state);
            for (ModelEventType type : ModelEventType.SYNC_TYPES) {
                if (dt.eventSubs.contains((Object)type)) {
                    type.write(dt.state, evt);
                }
                if (!dt.selfSubs.contains((Object)type)) continue;
                type.write(dt.state, evtS);
            }
            if (evt.tagCount() > 0) {
                this.sendPacketToTracking(p, new ReceiveEventS2C(this.getPlayerId.applyAsInt(p), evt));
            }
            if (evtS.tagCount() <= 0) continue;
            evtS.setBoolean("self", true);
            this.sendPacketTo(net, new ReceiveEventS2C(this.getPlayerId.applyAsInt(p), evtS));
        }
    }

    public void updatePlayer(P player, ServerAnimationState state) {
        this.animStateUpdate.accept(player, state);
    }

    public boolean hasModClient() {
        NET n = this.getClientNet();
        return n instanceof NetH && ((NetH)n).cpm$hasMod();
    }

    public void onLogOut() {
        this.recommendedSettingChanges.clear();
        this.serverCaps.clear();
        this.scalingWarning = false;
    }

    public void sendEventSubs(ModelDefinition def) {
        if (this.serverCaps.contains((Object)ServerCaps.MODEL_EVENT_SUBS)) {
            NBTTagCompound tag = new NBTTagCompound();
            List events = def.getAnimations().getAnimations().stream().flatMap(NetHandler$$Lambda$20.lambdaFactory$()).filter(NetHandler$$Lambda$21.lambdaFactory$()).map(NetHandler$$Lambda$22.lambdaFactory$()).filter(NetHandler$$Lambda$23.lambdaFactory$()).distinct().collect(Collectors.toList());
            NBTTagList list = new NBTTagList();
            tag.setTag("eventList", list);
            Stream stream = events.stream().map(NetHandler$$Lambda$24.lambdaFactory$()).map(NetHandler$$Lambda$25.lambdaFactory$());
            NBTTagList nBTTagList = list;
            nBTTagList.getClass();
            stream.forEach(NetHandler$$Lambda$26.lambdaFactory$(nBTTagList));
            list = new NBTTagList();
            tag.setTag("selfEventList", list);
            Stream stream2 = events.stream();
            MinecraftClientAccess minecraftClientAccess = MinecraftClientAccess$.get();
            minecraftClientAccess.getClass();
            Stream stream3 = stream2.filter(NetHandler$$Lambda$27.lambdaFactory$(minecraftClientAccess)).map(NetHandler$$Lambda$28.lambdaFactory$()).map(NetHandler$$Lambda$29.lambdaFactory$());
            NBTTagList nBTTagList2 = list;
            nBTTagList2.getClass();
            stream3.forEach(NetHandler$$Lambda$30.lambdaFactory$(nBTTagList2));
            AnimationRegistry reg = def.getAnimations();
            NBTTagList list2 = new NBTTagList();
            NBTTagList na = new NBTTagList();
            if (this.serverCaps.contains((Object)ServerCaps.NAMED_PARAMETERS)) {
                tag.setTag("namedparams", na);
            } else {
                tag.setTag("anims", list2);
            }
            reg.getCommandActionsMap().forEach(NetHandler$$Lambda$31.lambdaFactory$(list2, na));
            this.sendPacketToServer(new SubEventC2S(tag));
        }
    }

    public boolean hasServerCap(ServerCaps cap) {
        return this.hasModClient() && this.serverCaps.contains((Object)cap);
    }

    public void onJump(P p) {
        this.onEvent(p, ModelEventType.JUMPING);
    }

    public void onEvent(P p, ModelEventType event) {
        NetH.ServerNetH net = this.getSNetH(p);
        PlayerData dt = net.cpm$getEncodedModelData();
        if (!event.autoSync() && dt != null && dt.eventSubs.contains((Object)event)) {
            NBTTagCompound evt = new NBTTagCompound();
            event.write(dt.state, evt);
            this.sendPacketToTracking(p, new ReceiveEventS2C(this.getPlayerId.applyAsInt(p), evt));
        }
    }

    public void playAnimation(P p, String animation, int value) {
        this.sendPacketTo(this.getSNetH(p), new ServerAnimationS2C(animation, value));
    }

    public boolean sendPluginMessage(String id, NBTTagCompound msg, int flags) {
        if (this.hasModClient() && this.serverCaps.contains((Object)ServerCaps.PLUGIN_MESSAGES)) {
            this.sendPacketToServer(new PluginMessageC2S(id, msg, flags));
            return true;
        }
        return false;
    }

    public boolean enableInvisGlow() {
        return this.hasServerCap(ServerCaps.INVIS_GLOW);
    }

    public int getAnimationPlaying(P player, String animation) {
        PlayerData pd = this.getSNetH(player).cpm$getEncodedModelData();
        CommandAction.ServerCommandAction id = pd.animNames.get(animation);
        if (id == null) {
            return -1;
        }
        return id.getValue();
    }

    public void requestPlayerState(UUID other) {
        if (!this.hasModClient()) {
            return;
        }
        this.sendPacketToServer(new RequestPlayerC2S(other, false));
    }

    public void requestPlayerData(UUID other) {
        if (!this.hasModClient()) {
            return;
        }
        this.sendPacketToServer(new RequestPlayerC2S(other, true));
    }

    public String getID(P pl) {
        return this.getPlayerUUID.apply(pl).toString();
    }

    public NET getClientNet() {
        P p = this.getClient.get();
        return p != null ? (NET)this.getNet.apply(p) : null;
    }

    public NetH.ServerNetH getSNetH(P player) {
        return (NetH.ServerNetH)this.getNet.apply(player);
    }

    public void sendPlayerData(P target, P to) {
        NetworkUtil.sendPlayerData(this, target, to);
    }

    public void execute(NetH net, Runnable task) {
        this.executor.apply(net).execute(task);
    }

    public List<ConfigChangeRequest<?, ?>> getRecommendedSettingChanges() {
        return this.recommendedSettingChanges;
    }

    public void setGetPlayerUUID(Function<P, UUID> getPlayerUUID) {
        this.getPlayerUUID = getPlayerUUID;
    }

    public <PB> void setSendPacketDirect(Function<byte[], PB> wrapper, TriConsumer<NET, RL, PB> sendPacket, TriConsumer<P, RL, PB> sendToAllTracking) {
        this.sendPacket = NetHandler$$Lambda$32.lambdaFactory$(sendPacket, wrapper);
        this.sendToAllTracking = NetHandler$$Lambda$33.lambdaFactory$(sendToAllTracking, wrapper);
    }

    public void setSendPacketDirect(TriConsumer<NET, RL, byte[]> sendPacket, TriConsumer<P, RL, byte[]> sendToAllTracking) {
        this.sendPacket = sendPacket;
        this.sendToAllTracking = sendToAllTracking;
    }

    public <PB> void setSendPacketClient(Function<byte[], PB> wrapper, TriConsumer<NET, RL, PB> sendPacket) {
        this.sendPacket = NetHandler$$Lambda$34.lambdaFactory$(sendPacket, wrapper);
    }

    public void setSendPacketClient(TriConsumer<NET, RL, byte[]> sendPacket) {
        this.sendPacket = sendPacket;
    }

    private void sendPacketServer(P to, RL pck, byte[] data) {
        NET n = this.getNet.apply(to);
        if (n instanceof NetH.ServerNetH && ((NetH.ServerNetH)n).cpm$hasMod()) {
            this.sendPacket.accept(n, pck, data);
        }
    }

    public <PB, C> void setSendPacketServer(Function<byte[], PB> wrapper, TriConsumer<NET, RL, PB> sendPacket, Function<P, Collection<C>> forEachTracking, Function<C, P> toPlayer) {
        this.sendPacket = NetHandler$$Lambda$35.lambdaFactory$(sendPacket, wrapper);
        this.sendToAllTracking = NetHandler$$Lambda$36.lambdaFactory$(this, forEachTracking, toPlayer);
    }

    public void setFindTracking(BiConsumer<P, Consumer<P>> findTracking) {
        this.findTracking = findTracking;
    }

    public void setSendChat(BiConsumer<P, IText> sendChat) {
        this.sendChat = sendChat;
    }

    public void setExecutor(Supplier<Executor> executor) {
        this.executor = NetHandler$$Lambda$37.lambdaFactory$(executor);
    }

    public void setExecutor(Function<NET, Executor> executor) {
        this.executor = executor;
    }

    public void setPlayerToLoader(Function<P, Object> playerToloader) {
        this.playerToLoader = playerToloader;
    }

    public void setGetClient(Supplier<P> getClient) {
        this.getClient = getClient;
    }

    public void setGetNet(Function<P, NET> getNet) {
        this.getNet = getNet;
    }

    public void setGetPlayer(Function<NET, P> getPlayer) {
        this.getPlayer = getPlayer;
    }

    public void setKickPlayer(BiConsumer<P, IText> kickPlayer) {
        this.kickPlayer = kickPlayer;
    }

    public void setGetPlayerById(IntFunction<P> getPlayerById) {
        this.getPlayerById = getPlayerById;
    }

    public void setGetPlayerId(ToIntFunction<P> getPlayerId) {
        this.getPlayerId = getPlayerId;
    }

    public void setDisplayText(Consumer<IText> displayText) {
        this.displayText = displayText;
    }

    public void setGetOnlinePlayers(Supplier<Collection<? extends P>> getOnlinePlayers) {
        this.getOnlinePlayers = getOnlinePlayers;
    }

    public void setGetPlayerAnimGetters(BiConsumer<? super P, ServerAnimationState> animStateUpdate) {
        this.animStateUpdate = animStateUpdate;
    }

    public <E extends Throwable> void registerOut(ThrowingConsumer<RL, E> reg) throws E {
        for (RL e : this.packetS2C.keySet()) {
            reg.accept(e);
        }
    }

    public <E extends Throwable> void registerIn(ThrowingConsumer<RL, E> reg) throws E {
        for (RL e : this.packetC2S.keySet()) {
            reg.accept(e);
        }
    }

    public <K> void addScaler(ScalerInterface<P, K> intf) {
        for (ScalingOptions opt : ScalingOptions.VALUES) {
            K key;
            try {
                key = intf.toKey(opt);
            }
            catch (Throwable e) {
                Log.warn("Failed to create scaler key for " + opt.name().toLowerCase(Locale.ROOT) + ". Make sure your scaling supported mods are up to date!", e);
                continue;
            }
            if (key == null) continue;
            this.scaleSetters.computeIfAbsent(opt, NetHandler$$Lambda$38.lambdaFactory$()).put(intf.getMethodName(), NetHandler$$Lambda$39.lambdaFactory$(intf, key));
        }
    }

    public boolean isSupported(ScalingOptions o) {
        return this.scaleSetters.containsKey((Object)o);
    }

    public P getPlayer(NetH.ServerNetH net) {
        return this.getPlayer.apply(net);
    }

    public void forEachTracking(P pl, Consumer<P> cons) {
        this.findTracking.accept(pl, cons);
    }

    public void sendPacketTo(NetH.ServerNetH net, IPacket packet) {
        if (!net.cpm$hasMod()) {
            return;
        }
        this.sendPacketTo0(net, packet);
    }

    public void sendPacketToServer(IPacket packet) {
        if (!this.hasModClient()) {
            return;
        }
        this.sendPacketTo0(this.getClientNet(), packet);
    }

    private void sendPacketTo0(NET net, IPacket packet) {
        byte[] data;
        RL id = this.packetLookup.get(packet.getClass());
        if (id == null) {
            return;
        }
        try {
            data = this.packet2byte(packet);
        }
        catch (IOException e) {
            return;
        }
        this.sendPacket.accept(net, id, data);
    }

    public void sendPacketToTracking(P player, IPacket packet) {
        byte[] data;
        RL id = this.packetLookup.get(packet.getClass());
        if (id == null) {
            return;
        }
        try {
            data = this.packet2byte(packet);
        }
        catch (IOException e) {
            return;
        }
        this.sendToAllTracking.accept(player, id, data);
    }

    private byte[] packet2byte(IPacket pckt) throws IOException {
        IOHelper h = new IOHelper();
        pckt.write(h);
        return h.toBytes();
    }

    public int getPlayerId(P target) {
        return this.getPlayerId.applyAsInt(target);
    }

    public void sendChat(P player, IText chatMsg) {
        this.sendChat.accept(player, chatMsg);
    }

    public Map<ScalingOptions, Map<String, Scaler<P>>> getScaleSetters() {
        return this.scaleSetters;
    }

    public void displayText(IText text) {
        this.displayText.accept(text);
    }

    public P getPlayerById(int entityId) {
        return this.getPlayerById.apply(entityId);
    }

    public P getPlayerByUUID(UUID uuid) {
        return this.getOnlinePlayers.get().stream().filter(NetHandler$$Lambda$40.lambdaFactory$(this, uuid)).findFirst().orElse(null);
    }

    public List<P> getOnlinePlayers() {
        return new ArrayList<P>(this.getOnlinePlayers.get());
    }

    public Object getLoaderId(P player) {
        return this.playerToLoader.apply(player);
    }

    public void setScalingWarning() {
        this.scalingWarning = true;
    }

    public boolean hasScalingWarning() {
        return this.scalingWarning;
    }

    public void setAllowPackets(Predicate<NET> allowPackets) {
        this.allowPackets = allowPackets;
    }

    public RL getPacketKey(Class<? extends IPacket> packetClass) {
        return this.packetLookup.get(packetClass);
    }

    static /* synthetic */ boolean lambda$getPlayerByUUID$15(NetHandler this_, UUID uuid, Object p) {
        return uuid.equals(this_.getPlayerUUID.apply(p));
    }

    static /* synthetic */ void lambda$addScaler$14(ScalerInterface intf, Object key, Object p, float v) {
        intf.setScale(key, p, v);
    }

    static /* synthetic */ Map lambda$addScaler$13(ScalingOptions __) {
        return new LinkedHashMap();
    }

    static /* synthetic */ Executor lambda$setExecutor$12(Supplier executor, Object v) {
        return (Executor)executor.get();
    }

    static /* synthetic */ void lambda$setSendPacketServer$11(NetHandler this_, Function forEachTracking, Function toPlayer, Object p, Object rl, byte[] d) {
        for (Object t : (Collection)forEachTracking.apply(p)) {
            this_.sendPacketServer(toPlayer.apply(t), rl, d);
        }
        this_.sendPacketServer(p, rl, d);
    }

    static /* synthetic */ void lambda$setSendPacketServer$10(TriConsumer sendPacket, Function wrapper, Object a, Object b, byte[] c) {
        sendPacket.accept(a, b, wrapper.apply(c));
    }

    static /* synthetic */ void lambda$setSendPacketClient$9(TriConsumer sendPacket, Function wrapper, Object a, Object b, byte[] c) {
        sendPacket.accept(a, b, wrapper.apply(c));
    }

    static /* synthetic */ void lambda$setSendPacketDirect$8(TriConsumer sendToAllTracking, Function wrapper, Object a, Object b, byte[] c) {
        sendToAllTracking.accept(a, b, wrapper.apply(c));
    }

    static /* synthetic */ void lambda$setSendPacketDirect$7(TriConsumer sendPacket, Function wrapper, Object a, Object b, byte[] c) {
        sendPacket.accept(a, b, wrapper.apply(c));
    }

    static /* synthetic */ void lambda$sendEventSubs$6(NBTTagList list, NBTTagList na, String k, CommandAction v) {
        if (v instanceof CommandAction.LegacyCommandActionWriter) {
            CommandAction.LegacyCommandActionWriter w = (CommandAction.LegacyCommandActionWriter)((Object)v);
            NBTTagCompound t = new NBTTagCompound();
            w.writeLegacy(t);
            list.appendTag(t);
        }
        NBTTagCompound t = new NBTTagCompound();
        v.write(t);
        t.setString("name", k);
        t.setString("type", v.getType().name());
        na.appendTag(t);
    }

    static /* synthetic */ boolean lambda$sendEventSubs$5(ModelEventType e) {
        return e != null;
    }

    static /* synthetic */ boolean lambda$sendEventSubs$4(IPose e) {
        return e instanceof VanillaPose;
    }

    static /* synthetic */ Stream lambda$sendEventSubs$3(AnimationTrigger e) {
        return e.onPoses.stream();
    }

    static /* synthetic */ void lambda$writeCaps$2(NetHandler this_, NBTTagCompound data, ServerCaps c) {
        this_.setCap(data, c);
    }

    static /* synthetic */ boolean lambda$writeCaps$1(ServerCaps e) {
        return e != null;
    }

    static /* synthetic */ boolean lambda$new$0(Object net) {
        return true;
    }

    @FunctionalInterface
    public static interface Scaler<P> {
        public void applyScaling(P var1, float var2);
    }

    public static interface ScalerInterface<P, K> {
        public static final String ATTRIBUTE = "attribute";
        public static final String PEHKUI = "pehkui";

        public void setScale(K var1, P var2, float var3);

        public K toKey(ScalingOptions var1);

        public String getMethodName();
    }
}

