/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network.packet;

import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.network.IC2SPacket;
import com.tom.cpm.shared.network.IC2SPacket$;
import com.tom.cpm.shared.network.IPacket$;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.NetworkUtil;
import com.tom.cpm.shared.network.packet.GetSkinS2C;
import com.tom.cpm.shared.network.packet.HelloC2S$$Lambda$1;
import java.io.IOException;

public class HelloC2S
implements IC2SPacket {
    private byte status;

    public HelloC2S() {
    }

    public HelloC2S(int status) {
        this.status = (byte)status;
    }

    @Override
    public void read(IOHelper pb) throws IOException {
        this.status = pb.readByte();
    }

    @Override
    public void write(IOHelper pb) throws IOException {
        pb.writeByte(this.status);
    }

    @Override
    public <P> void handle(NetHandler<?, P, ?> handler, NetH.ServerNetH net, P pl) {
        net.cpm$setHasMod(true);
        handler.forEachTracking(pl, HelloC2S$$Lambda$1.lambdaFactory$(handler, pl));
        PlayerData pd = net.cpm$getEncodedModelData();
        if (pd.canChangeModel()) {
            handler.sendPacketTo(net, new GetSkinS2C());
        } else {
            handler.sendPacketTo(net, NetworkUtil.writeSkinData(handler, pd, pl));
        }
        if (ModConfig.getWorldConfig().getBoolean("serverRecommendSafetySettings", false)) {
            NetworkUtil.sendSafetySettings(handler, net);
        }
    }

    static /* synthetic */ void lambda$handle$0(NetHandler handler, Object pl, Object p) {
        NetworkUtil.sendPlayerData(handler, p, pl);
    }

    public void handle(NetHandler netHandler, NetH netH) {
        IC2SPacket$.handle(this, netHandler, netH);
    }

    public void handleRaw(NetHandler netHandler, NetH netH) {
        IPacket$.handleRaw(this, netHandler, netH);
    }

    public void handle0(NetHandler netHandler, NetH netH) {
        IC2SPacket$.handle0(this, netHandler, netH);
    }
}

