/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network.packet;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.network.IPacket$;
import com.tom.cpm.shared.network.IS2CPacket;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import java.io.IOException;

public abstract class NBTEntityS2C
implements IS2CPacket {
    private int entityId;
    protected NBTTagCompound tag;

    public NBTEntityS2C() {
    }

    public NBTEntityS2C(int entityId, NBTTagCompound data) {
        this.entityId = entityId;
        this.tag = data;
    }

    @Override
    public void read(IOHelper pb) throws IOException {
        this.entityId = pb.readVarInt();
        this.tag = pb.readNBT();
    }

    @Override
    public void write(IOHelper pb) throws IOException {
        pb.writeVarInt(this.entityId);
        pb.writeNBT(this.tag);
    }

    @Override
    public void handle(NetHandler<?, ?, ?> handler, NetH from) {
        this.handle0(handler, from);
    }

    private <P> void handle0(NetHandler<?, P, ?> handler, NetH from) {
        P player = handler.getPlayerById(this.entityId);
        if (player != null) {
            this.handle(handler, from, player);
        }
    }

    protected abstract <P> void handle(NetHandler<?, P, ?> var1, NetH var2, P var3);

    public void handleRaw(NetHandler netHandler, NetH netH) {
        IPacket$.handleRaw(this, netHandler, netH);
    }
}

