/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network.packet;

import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.network.IC2SPacket;
import com.tom.cpm.shared.network.IC2SPacket$;
import com.tom.cpm.shared.network.IPacket$;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.NetworkUtil;
import java.io.IOException;
import java.util.UUID;

public class RequestPlayerC2S
implements IC2SPacket {
    private UUID entityId;
    private boolean full;

    public RequestPlayerC2S() {
    }

    public RequestPlayerC2S(UUID entityId, boolean full) {
        this.entityId = entityId;
        this.full = full;
    }

    @Override
    public void read(IOHelper pb) throws IOException {
        this.entityId = pb.readUUID();
        this.full = pb.readBoolean();
    }

    @Override
    public void write(IOHelper pb) throws IOException {
        pb.writeUUID(this.entityId);
        pb.writeBoolean(this.full);
    }

    @Override
    public <P> void handle(NetHandler<?, P, ?> handler, NetH.ServerNetH from, P player) {
        P req = handler.getPlayerByUUID(this.entityId);
        if (req != null) {
            if (this.full) {
                NetworkUtil.sendPlayerData(handler, req, player);
            } else {
                NetworkUtil.sendPlayerState(handler, req, player);
            }
        }
    }

    public void handle(NetHandler netHandler, NetH netH) {
        IC2SPacket$.handle(this, netHandler, netH);
    }

    public void handleRaw(NetHandler netHandler, NetH netH) {
        IPacket$.handleRaw(this, netHandler, netH);
    }

    public void handle0(NetHandler netHandler, NetH netH) {
        IC2SPacket$.handle0(this, netHandler, netH);
    }
}

