/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpl.util.Image;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.SafetyException;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart$;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;

public class ModelPartCloneable
implements IModelPart,
IResolvedModelPart {
    public String name;
    public String desc;
    public Image icon;

    public ModelPartCloneable(IOHelper is, ModelDefinition def) throws IOException {
        byte fields;
        byte by = fields = is.size() == 0 ? (byte)0 : is.readByte();
        if ((fields & 1) != 0) {
            this.name = is.readUTF();
        }
        if ((fields & 2) != 0) {
            this.desc = is.readUTF();
        }
        if ((fields & 4) != 0) {
            IOHelper.ImageBlock img = is.readImage();
            if (img.getWidth() > 400) {
                throw new SafetyException(SafetyException.BlockReason.TEXTURE_OVERFLOW);
            }
            if (img.getHeight() > 400) {
                throw new SafetyException(SafetyException.BlockReason.TEXTURE_OVERFLOW);
            }
            img.doReadImage();
            this.icon = img.getImage();
        }
    }

    public ModelPartCloneable(String name, String desc, Image icon) {
        this.name = name;
        this.desc = desc;
        this.icon = icon;
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        return this;
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        int fields = 0;
        if (this.name != null && !this.name.isEmpty()) {
            fields |= 1;
        }
        if (this.desc != null && !this.desc.isEmpty()) {
            fields |= 2;
        }
        if (this.icon != null) {
            fields |= 4;
        }
        dout.writeByte(fields);
        if ((fields & 1) != 0) {
            dout.writeUTF(this.name);
        }
        if ((fields & 2) != 0) {
            dout.writeUTF(this.desc);
        }
        if ((fields & 4) != 0) {
            dout.writeImage(this.icon);
        }
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.CLONEABLE;
    }

    @Override
    public void apply(ModelDefinition def) {
        def.cloneable = this;
    }

    @Override
    public void preApply(ModelDefinition modelDefinition) {
        IResolvedModelPart$.preApply(this, modelDefinition);
    }

    @Override
    public void stitch(TextureStitcher textureStitcher) {
        IResolvedModelPart$.stitch(this, textureStitcher);
    }
}

