/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartCollection$Pack$$Lambda$1;
import com.tom.cpm.shared.parts.ModelPartCollection$Pack$$Lambda$2;
import com.tom.cpm.shared.parts.ModelPartCollection$Pack$$Lambda$3;
import com.tom.cpm.shared.parts.ModelPartCollection$Pack$$Lambda$4;
import com.tom.cpm.shared.parts.ModelPartEnd;
import com.tom.cpm.shared.parts.ModelPartLink;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.parts.PartCollection;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ModelPartCollection
extends ArrayList<IModelPart>
implements PartCollection {
    private static final long serialVersionUID = 7943493602412147742L;

    @Override
    public void writeBlocks(IOHelper dout) throws IOException {
        for (IModelPart part : this) {
            dout.writeObjectBlock(part);
        }
    }

    @Override
    public String toString() {
        StringBuilder bb = new StringBuilder("PartCollection:");
        for (IModelPart iModelPart : this) {
            bb.append("\n\t\t");
            bb.append(iModelPart.toString().replace("\n", "\n\t\t"));
        }
        return bb.toString();
    }

    @Override
    public void writePackage(IOHelper dout) throws IOException {
        this.writeBlocks(dout);
        dout.writeObjectBlock(ModelPartEnd.END);
    }

    @Override
    public IModelPart toLink(Link link) {
        return new PackageLink(link);
    }

    private static class Pack
    implements IModelPart,
    IResolvedModelPart {
        private List<IModelPart> parts;
        private List<IResolvedModelPart> resolvedParts;

        private Pack(IOHelper is, ModelDefinition def) throws IOException {
            this.parts = new ArrayList<IModelPart>();
            block4: while (true) {
                IModelPart part;
                if ((part = (IModelPart)is.readObjectBlock(ModelPartType.VALUES, ModelPartCollection$Pack$$Lambda$1.lambdaFactory$(def))) == null) {
                    continue;
                }
                if (part instanceof ModelPartEnd) break;
                switch (part.getType()) {
                    case DEFINITION: 
                    case DEFINITION_LINK: 
                    case SKIN_LINK: 
                    case PACKAGE_LINK: {
                        throw new IOException("Invalid tag in package");
                    }
                    case END: {
                        continue block4;
                    }
                }
                this.parts.add(part);
            }
        }

        private Pack(List<IModelPart> parts) {
            this.parts = parts;
        }

        @Override
        public IResolvedModelPart resolve() throws IOException {
            this.resolvedParts = new ArrayList<IResolvedModelPart>();
            for (IModelPart t : this.parts) {
                this.resolvedParts.add(t.resolve());
            }
            return this;
        }

        @Override
        public void write(IOHelper dout) throws IOException {
            throw new IOException("Can't write Pack");
        }

        @Override
        public ModelPartType getType() {
            return null;
        }

        @Override
        public void apply(ModelDefinition def) {
            this.resolvedParts.forEach(ModelPartCollection$Pack$$Lambda$2.lambdaFactory$(def));
        }

        @Override
        public void preApply(ModelDefinition def) {
            this.resolvedParts.forEach(ModelPartCollection$Pack$$Lambda$3.lambdaFactory$(def));
        }

        @Override
        public void stitch(TextureStitcher stitcher) {
            this.resolvedParts.forEach(ModelPartCollection$Pack$$Lambda$4.lambdaFactory$(stitcher));
        }

        public String toString() {
            StringBuilder bb = new StringBuilder("PartCollection:");
            for (IModelPart iModelPart : this.parts) {
                bb.append("\n\t\t");
                bb.append(iModelPart.toString().replace("\n", "\n\t\t"));
            }
            return bb.toString();
        }

        static /* synthetic */ void lambda$stitch$3(TextureStitcher stitcher, IResolvedModelPart p) {
            p.stitch(stitcher);
        }

        static /* synthetic */ void lambda$preApply$2(ModelDefinition def, IResolvedModelPart p) {
            p.preApply(def);
        }

        static /* synthetic */ void lambda$apply$1(ModelDefinition def, IResolvedModelPart p) {
            p.apply(def);
        }

        static /* synthetic */ IModelPart lambda$new$0(ModelDefinition def, ModelPartType t, IOHelper d) throws IOException {
            return t.getFactory().create(d, def);
        }
    }

    public static class PackageLink
    extends ModelPartLink {
        public PackageLink(IOHelper in, ModelDefinition def) throws IOException {
            super(in, def);
        }

        private PackageLink(Link link) {
            super(link);
        }

        @Override
        public ModelPartType getType() {
            return ModelPartType.PACKAGE_LINK;
        }

        @Override
        protected IModelPart load(IOHelper din, ModelDefinition def) throws IOException {
            return new Pack(din, def);
        }
    }
}

