/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.effects.IRenderEffect;
import com.tom.cpm.shared.effects.RenderEffects;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart$;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;

public class ModelPartRenderEffect
implements IModelPart,
IResolvedModelPart {
    private IRenderEffect effect;

    public ModelPartRenderEffect(IOHelper in, ModelDefinition def) throws IOException {
        RenderEffects ef = (RenderEffects)in.readEnum(RenderEffects.VALUES);
        if (ef != null) {
            this.effect = ef.create();
            this.effect.load(in);
        }
    }

    public ModelPartRenderEffect(IRenderEffect effect) {
        this.effect = effect;
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        return this;
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.writeEnum(this.effect.getEffect());
        this.effect.write(dout);
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.RENDER_EFFECT;
    }

    @Override
    public void apply(ModelDefinition def) {
        if (this.effect != null) {
            this.effect.apply(def);
        }
    }

    public String toString() {
        return "RenderEffect: " + this.effect;
    }

    @Override
    public void preApply(ModelDefinition modelDefinition) {
        IResolvedModelPart$.preApply(this, modelDefinition);
    }

    @Override
    public void stitch(TextureStitcher textureStitcher) {
        IResolvedModelPart$.stitch(this, textureStitcher);
    }
}

