/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpl.math.Rotation;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart$;
import com.tom.cpm.shared.parts.ModelPartRootInfo$$Lambda$1;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;

public class ModelPartRootInfo
implements IModelPart,
IResolvedModelPart {
    public static final int ROOT_HIDDEN = 1;
    public static final int ROOT_CREATE = 2;
    public static final int ROOT_MODEL = 4;
    public static final int ROOT_TRANSFORM = 8;
    public static final int ROOT_DISABLE_VANILLA = 16;
    private VanillaModelPart root;
    private Vec3f pos;
    private Vec3f rot;
    private int createFrom;
    private boolean hidden;
    private boolean disableVanilla;

    public ModelPartRootInfo(IOHelper is, ModelDefinition def) throws IOException {
        byte flags = is.readByte();
        this.root = (flags & 4) != 0 ? (VanillaModelPart)((Object)is.readEnum(RootModelType.VALUES)) : (VanillaModelPart)((Object)is.readEnum(PlayerModelParts.VALUES));
        if ((flags & 8) != 0) {
            this.pos = is.readVarVec3();
            this.rot = is.readAngle();
        } else {
            this.pos = new Vec3f();
            this.rot = new Vec3f();
        }
        if ((flags & 2) != 0) {
            this.createFrom = is.readVarInt();
        }
        this.hidden = (flags & 1) != 0;
        this.disableVanilla = (flags & 0x10) != 0;
    }

    public ModelPartRootInfo(VanillaModelPart root, Vec3f pos, Vec3f rot, boolean hidden, boolean disableVanilla) {
        this.root = root;
        this.pos = pos;
        this.rot = rot;
        this.hidden = hidden;
        this.disableVanilla = disableVanilla;
    }

    public ModelPartRootInfo(VanillaModelPart root, int createFrom, boolean hidden, boolean disableVanilla) {
        this.root = root;
        this.pos = Vec3f.ZERO;
        this.rot = Vec3f.ZERO;
        this.createFrom = createFrom;
        this.hidden = hidden;
        this.disableVanilla = disableVanilla;
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        return this;
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        boolean transform = !this.pos.epsilon(0.1f) || !this.rot.epsilon(0.1f);
        int flags = 0;
        if (this.root instanceof RootModelType) {
            flags = (byte)(flags | 4);
        }
        if (transform) {
            flags = (byte)(flags | 8);
        }
        if (this.hidden) {
            flags = (byte)(flags | 1);
        }
        if (this.createFrom != 0) {
            flags = (byte)(flags | 2);
        }
        if (this.disableVanilla) {
            flags = (byte)(flags | 0x10);
        }
        dout.writeByte(flags);
        dout.writeEnum((Enum)((Object)this.root));
        if (transform) {
            dout.writeVarVec3(this.pos);
            Vec3f rot = new Vec3f(this.rot);
            ActionBuilder.limitVec(rot, 0, 360, true);
            dout.writeAngle(rot);
        }
        if (this.createFrom != 0) {
            dout.writeVarInt(this.createFrom);
        }
    }

    @Override
    public void preApply(ModelDefinition def) {
        if (this.createFrom == 0) {
            RootModelElement elem = def.getModelElementFor(this.root).getMainRoot();
            elem.setHidden(this.hidden);
            elem.posN = this.pos;
            elem.rotN = new Rotation(this.rot, false);
            elem.disableVanilla = this.disableVanilla;
        }
    }

    @Override
    public void apply(ModelDefinition def) {
        if (this.createFrom != 0) {
            RootModelElement elem = def.getModelElementFor(PlayerModelParts.CUSTOM_PART).get();
            for (RenderedCube rc : elem.children) {
                if (rc.getId() != this.createFrom) continue;
                elem.children.remove(rc);
                RootModelElement e = def.addRoot(this.createFrom, this.root);
                e.posN = rc.pos;
                e.rotN = rc.rotation;
                e.setHidden(this.hidden);
                e.disableVanilla = this.disableVanilla;
                if (rc.children == null) break;
                e.children.addAll(rc.children);
                rc.children.forEach(ModelPartRootInfo$$Lambda$1.lambdaFactory$(e));
                break;
            }
        }
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.ROOT_INFO;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Part Root Info: ");
        sb.append(this.root);
        if (this.hidden) {
            sb.append(" [H]");
        }
        if (this.disableVanilla) {
            sb.append(" [DV]");
        }
        if (!this.pos.epsilon(0.1f)) {
            sb.append("\n\tPos: ");
            sb.append(this.pos);
        }
        if (!this.rot.epsilon(0.1f)) {
            sb.append("\n\tRot: ");
            sb.append(this.rot);
        }
        if (this.createFrom != 0) {
            sb.append("\n\tNew Root");
        }
        return sb.toString();
    }

    static /* synthetic */ void lambda$apply$0(RootModelElement e, RenderedCube p) {
        p.setParent(e);
    }

    @Override
    public void stitch(TextureStitcher textureStitcher) {
        IResolvedModelPart$.stitch(this, textureStitcher);
    }
}

