/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpl.math.Vec2i;
import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart$;
import com.tom.cpm.shared.parts.ModelPartTemplate$ModelPartResolvedTemplate$$Lambda$1;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.template.Template;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.function.Consumer;

public class ModelPartTemplate
implements IModelPart {
    private Link link;
    private IOHelper args;
    private ModelDefinition def;

    public ModelPartTemplate(IOHelper in, ModelDefinition def) throws IOException {
        this.link = new Link(in);
        this.args = in.readNextBlock();
        this.def = def;
    }

    public ModelPartTemplate(Template template) throws IOException {
        this.link = template.getLink();
        this.args = template.writeArgs();
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        InputStreamReader rd = new InputStreamReader(this.def.getLoader().load(this.link, ResourceLoader.ResourceEncoding.NO_ENCODING, this.def));
        Throwable throwable = null;
        try {
            Template template = new Template(this.link, rd, null, this.args, this.def);
            ModelPartResolvedTemplate modelPartResolvedTemplate = new ModelPartResolvedTemplate(template);
            return modelPartResolvedTemplate;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (rd != null) {
                if (throwable != null) {
                    try {
                        rd.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    rd.close();
                }
            }
        }
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        this.link.write(dout);
        this.args.writeBlock(dout);
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.TEMPLATE;
    }

    public class ModelPartResolvedTemplate
    implements IResolvedModelPart {
        private Template template;

        public ModelPartResolvedTemplate(Template template) {
            this.template = template;
        }

        @Override
        public void preApply(ModelDefinition def) {
            def.addCubes(this.template.getCubes());
        }

        @Override
        public void stitch(TextureStitcher stitcher) {
            if (!this.template.isTextureMerged()) {
                TextureProvider textureProvider = this.template.getTemplateDefaultTexture();
                Template template = this.template;
                template.getClass();
                stitcher.stitchImage(textureProvider, (Consumer<Vec2i>)ModelPartTemplate$ModelPartResolvedTemplate$$Lambda$1.lambdaFactory$(template));
            }
        }

        @Override
        public void apply(ModelDefinition modelDefinition) {
            IResolvedModelPart$.apply(this, modelDefinition);
        }
    }
}

