/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.AnimationExporter;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.util.PlayerSkinLayer;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState$$Lambda$1;
import com.tom.cpm.shared.parts.anim.LayerEncondingHelper;
import com.tom.cpm.shared.parts.anim.ParameterDetails;
import com.tom.cpm.shared.parts.anim.SerializedAnimation;
import com.tom.cpm.shared.parts.anim.SerializedTrigger;
import com.tom.cpm.shared.parts.anim.TagType;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnimLoaderState {
    private ModelDefinition def;
    private ParameterDetails parameters = ParameterDetails.DEFAULT;
    private List<AbstractGestureButtonData> gestureButtons = new ArrayList<AbstractGestureButtonData>();
    private Map<Integer, SerializedAnimation> anims = new HashMap<Integer, SerializedAnimation>();
    private Map<Integer, SerializedTrigger> triggers = new HashMap<Integer, SerializedTrigger>();
    private int trID = 0;
    private int anID = 0;
    private SerializedAnimation cA = null;
    private SerializedTrigger cT = null;
    private int blankId;
    private int resetId;
    private String modelProfilesId;
    private int defGidMask;
    private int valGidMask;
    private List<PlayerSkinLayer> allLayers;
    private List<Integer> stagedList = new ArrayList<Integer>();

    public AnimLoaderState(ModelDefinition def) {
        this.def = def;
    }

    public ModelDefinition getDefinition() {
        return this.def;
    }

    public SerializedTrigger getTrigger() {
        return this.cT;
    }

    public SerializedAnimation getAnim() {
        return this.cA;
    }

    public int newTrigger(SerializedTrigger tr) {
        int id = this.trID++;
        this.triggers.put(id, tr);
        this.cT = tr;
        return id;
    }

    public int newAnimation(SerializedAnimation an) {
        int id = this.anID++;
        this.anims.put(id, an);
        this.cA = an;
        return id;
    }

    public Map<Integer, SerializedAnimation> getAnims() {
        return this.anims;
    }

    public Map<Integer, SerializedTrigger> getTriggers() {
        return this.triggers;
    }

    private void loadInfo(Editor e) {
        this.valGidMask = e.animEnc == null ? 0 : PlayerSkinLayer.encode(e.animEnc.freeLayers);
        this.defGidMask = e.animEnc == null ? 0 : PlayerSkinLayer.encode(e.animEnc.defaultLayerValue) & ~this.valGidMask;
        this.resetId = this.defGidMask | this.valGidMask;
        this.blankId = this.defGidMask | 0;
        this.modelProfilesId = e.modelId;
        this.allLayers = e.animEnc != null ? new ArrayList<PlayerSkinLayer>(e.animEnc.freeLayers) : new ArrayList();
        Collections.sort(this.allLayers);
    }

    public void loadFromEditor(Editor e) {
        this.loadInfo(e);
        AnimationExporter exporter = new AnimationExporter(e, this);
        exporter.processElements();
        List<EditorAnim> list = e.animations;
        AnimationExporter animationExporter = exporter;
        animationExporter.getClass();
        list.forEach(AnimLoaderState$$Lambda$1.lambdaFactory$(animationExporter));
        this.parameters = exporter.paramAlloc.finish();
        this.gestureButtons = exporter.sortButtons();
        exporter.linkStagingAnims();
        LayerEncondingHelper.handleLayers(this.triggers, this.allLayers, this.gestureButtons, this.blankId, this.resetId, this.valGidMask, this.defGidMask);
    }

    public static void parseInfo(IOHelper block, AnimLoaderState state) throws IOException {
        state.blankId = block.read();
        state.resetId = block.read();
        state.modelProfilesId = block.readUTF();
    }

    public void writeInfo(IOHelper dout) throws IOException {
        IOHelper d = dout.writeNextObjectBlock(TagType.CONTROL_INFO);
        Throwable throwable = null;
        try {
            d.write(this.blankId);
            d.write(this.resetId);
            if (this.modelProfilesId == null) {
                d.writeVarInt(0);
            } else {
                d.writeUTF(this.modelProfilesId);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (d != null) {
                if (throwable != null) {
                    try {
                        d.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    d.close();
                }
            }
        }
        if (!this.parameters.equals(ParameterDetails.DEFAULT)) {
            d = dout.writeNextObjectBlock(TagType.PARAMETERS);
            throwable = null;
            try {
                this.parameters.write(d);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (d != null) {
                    if (throwable != null) {
                        try {
                            d.close();
                        }
                        catch (Throwable throwable5) {
                        }
                    } else {
                        d.close();
                    }
                }
            }
        }
    }

    public void applyInfos(AnimationRegistry reg) {
        reg.setBlankGesture(this.blankId);
        reg.setPoseResetId(this.resetId);
        reg.setProfileId(this.modelProfilesId);
        reg.setParams(this.parameters);
    }

    public void processTriggers() {
    }

    public void setParameters(ParameterDetails parameters) {
        this.parameters = parameters;
    }

    public ParameterDetails getParameters() {
        return this.parameters;
    }

    public void addGestureButton(AbstractGestureButtonData button) {
        this.gestureButtons.add(button);
    }

    public List<AbstractGestureButtonData> getGestureButtons() {
        return this.gestureButtons;
    }

    public List<Integer> getStagedList() {
        return this.stagedList;
    }
}

