/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpl.function.FloatUnaryOperator;
import com.tom.cpm.shared.animation.AnimationNew;
import com.tom.cpm.shared.animation.AnimationNew$PartAnimationDriver$;
import com.tom.cpm.shared.animation.InterpolationInfo;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.parts.anim.AnimationFrameData;
import com.tom.cpm.shared.parts.anim.AnimatorChannel$$Lambda$1;
import com.tom.cpm.shared.parts.anim.Float3Driver;
import com.tom.cpm.shared.parts.anim.SerializedAnimation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class AnimatorChannel {
    public AnimationNew.PartAnimationDriver part;
    public AnimationFrameData frameData;
    private boolean mappedCube;

    public AnimatorChannel(AnimationNew.PartAnimationDriver part) {
        this.part = part;
    }

    public static Map<InterpolatorChannel, Integer> addCubeToChannels(SerializedAnimation an, int cubeId, boolean additive) {
        HashMap<InterpolatorChannel, Integer> map = new HashMap<InterpolatorChannel, Integer>();
        BiConsumer reg = AnimatorChannel$$Lambda$1.lambdaFactory$(map, an);
        Float3Driver.make(new CubePosDriver(cubeId, additive), InterpolatorChannel.POS_X, InterpolatorChannel.POS_Y, InterpolatorChannel.POS_Z, reg);
        Float3Driver.make(new CubeRotDriver(cubeId, additive), InterpolatorChannel.ROT_X, InterpolatorChannel.ROT_Y, InterpolatorChannel.ROT_Z, reg);
        Float3Driver.make(new CubeColorDriver(cubeId, additive), InterpolatorChannel.COLOR_R, InterpolatorChannel.COLOR_G, InterpolatorChannel.COLOR_B, reg);
        Float3Driver.make(new CubeScaleDriver(cubeId, additive), InterpolatorChannel.SCALE_X, InterpolatorChannel.SCALE_Y, InterpolatorChannel.SCALE_Z, reg);
        AnimatorChannel ac = new AnimatorChannel(new CubeVisDriver(cubeId));
        reg.accept(null, ac);
        return map;
    }

    public boolean isMappedCube() {
        return this.mappedCube;
    }

    public void addToAnim(AnimationNew a, ModelDefinition def) {
        this.part.init(def);
        AnimationNew.AnimationDriver d = this.frameData != null ? this.part.makeDriver(this.frameData.createDriver(this.part.getInterpolationInfo())) : this.part.makeDriver(null);
        if (d != null) {
            a.add(d);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Channel ");
        sb.append(this.part);
        return sb.toString();
    }

    static /* synthetic */ void lambda$addCubeToChannels$0(Map map, SerializedAnimation an, InterpolatorChannel ic, AnimatorChannel ac) {
        ac.mappedCube = true;
        map.put(ic, an.addChannel(ac));
    }

    public static class CubeVisDriver
    implements AnimationNew.PartAnimationDriver {
        private final int cubeId;
        private RenderedCube cube;

        public CubeVisDriver(int cubeId) {
            this.cubeId = cubeId;
        }

        @Override
        public void set(float value) {
            this.cube.setVisible(value > 0.5f);
        }

        @Override
        public InterpolationInfo getInterpolationInfo() {
            return InterpolationInfo.NULL;
        }

        @Override
        public void init(ModelDefinition def) {
            this.cube = def.getElementById(this.cubeId);
        }

        public String toString() {
            return "Vis: " + this.cubeId;
        }

        @Override
        public AnimationNew.AnimationDriver makeDriver(FloatUnaryOperator floatUnaryOperator) {
            return AnimationNew$PartAnimationDriver$.makeDriver(this, floatUnaryOperator);
        }
    }

    public static class CubeScaleDriver
    extends CubeFloatDriver {
        public CubeScaleDriver(int cubeId, boolean additive) {
            super(cubeId, additive);
        }

        @Override
        public void set(float x, float y, float z) {
            this.cube.setRenderScale(this.additive, x, y, z);
        }

        @Override
        public float getX() {
            return this.additive ? 0.0f : this.cube.getRenderScale().x;
        }

        @Override
        public float getY() {
            return this.additive ? 0.0f : this.cube.getRenderScale().y;
        }

        @Override
        public float getZ() {
            return this.additive ? 0.0f : this.cube.getRenderScale().z;
        }

        @Override
        public InterpolationInfo getXInfo() {
            return InterpolatorChannel.SCALE_X;
        }

        @Override
        public InterpolationInfo getYInfo() {
            return InterpolatorChannel.SCALE_Y;
        }

        @Override
        public InterpolationInfo getZInfo() {
            return InterpolatorChannel.SCALE_Z;
        }

        public String toString() {
            return "Scale: " + this.cubeId;
        }
    }

    public static class CubeColorDriver
    extends CubeFloatDriver {
        public CubeColorDriver(int cubeId, boolean additive) {
            super(cubeId, additive);
        }

        @Override
        public void set(float x, float y, float z) {
            this.cube.setColor(x, y, z);
        }

        @Override
        public float getX() {
            return (this.cube.getRGB() & 0xFF0000) >> 16;
        }

        @Override
        public float getY() {
            return (this.cube.getRGB() & 0xFF00) >> 8;
        }

        @Override
        public float getZ() {
            return this.cube.getRGB() & 0xFF;
        }

        @Override
        public InterpolationInfo getXInfo() {
            return InterpolatorChannel.COLOR_R;
        }

        @Override
        public InterpolationInfo getYInfo() {
            return InterpolatorChannel.COLOR_G;
        }

        @Override
        public InterpolationInfo getZInfo() {
            return InterpolatorChannel.COLOR_B;
        }

        public String toString() {
            return "Color: " + this.cubeId;
        }
    }

    public static class CubeRotDriver
    extends CubeFloatDriver {
        public CubeRotDriver(int cubeId, boolean additive) {
            super(cubeId, additive);
        }

        @Override
        public void set(float x, float y, float z) {
            this.cube.setRotation(this.additive, x, y, z);
        }

        @Override
        public float getX() {
            return this.additive ? 0.0f : this.cube.getRotation().x;
        }

        @Override
        public float getY() {
            return this.additive ? 0.0f : this.cube.getRotation().y;
        }

        @Override
        public float getZ() {
            return this.additive ? 0.0f : this.cube.getRotation().z;
        }

        @Override
        public InterpolationInfo getXInfo() {
            return InterpolatorChannel.ROT_X;
        }

        @Override
        public InterpolationInfo getYInfo() {
            return InterpolatorChannel.ROT_Y;
        }

        @Override
        public InterpolationInfo getZInfo() {
            return InterpolatorChannel.ROT_Z;
        }

        public String toString() {
            return "Rotation: " + this.cubeId;
        }
    }

    public static class CubePosDriver
    extends CubeFloatDriver {
        public CubePosDriver(int cubeId, boolean additive) {
            super(cubeId, additive);
        }

        @Override
        public void set(float x, float y, float z) {
            this.cube.setPosition(this.additive, x, y, z);
        }

        @Override
        public float getX() {
            return this.additive ? 0.0f : this.cube.getPosition().x;
        }

        @Override
        public float getY() {
            return this.additive ? 0.0f : this.cube.getPosition().y;
        }

        @Override
        public float getZ() {
            return this.additive ? 0.0f : this.cube.getPosition().z;
        }

        @Override
        public InterpolationInfo getXInfo() {
            return InterpolatorChannel.POS_X;
        }

        @Override
        public InterpolationInfo getYInfo() {
            return InterpolatorChannel.POS_Y;
        }

        @Override
        public InterpolationInfo getZInfo() {
            return InterpolatorChannel.POS_Z;
        }

        public String toString() {
            return "Position: " + this.cubeId;
        }
    }

    public static abstract class CubeFloatDriver
    implements Float3Driver.Float3Consumer {
        public final int cubeId;
        public boolean additive;
        protected RenderedCube cube;

        public CubeFloatDriver(int cubeId, boolean additive) {
            this.cubeId = cubeId;
            this.additive = additive;
        }

        @Override
        public void init(ModelDefinition def) {
            this.cube = def.getElementById(this.cubeId);
        }
    }
}

