/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.animation.Animation;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationTrigger;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.StagedAnimation;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$1;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$10;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$11;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$12;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$13;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$14;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$2;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$3;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$4;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$5;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$6;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$7;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$8;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$$Lambda$9;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$Gesture$$Lambda$1;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$Group$$Lambda$1;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$Group$$Lambda$2;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser$Group$$Lambda$3;
import com.tom.cpm.shared.parts.anim.ParameterDetails;
import com.tom.cpm.shared.parts.anim.menu.BoolParameterToggleButtonData;
import com.tom.cpm.shared.parts.anim.menu.CustomPoseGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.LegacyDropdownButtonData;
import com.tom.cpm.shared.parts.anim.menu.ValueParameterButtonData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LegacyAnimationParser {
    private final ModelDefinition def;
    private final AnimationRegistry reg;
    private Map<Gesture, Integer> layerToId = new HashMap<Gesture, Integer>();
    private Map<CustomPose, Integer> poseGid = new HashMap<CustomPose, Integer>();
    private List<Gesture> stageGestures = new ArrayList<Gesture>();
    public Map<String, List<IAnimation>> gestures = new HashMap<String, List<IAnimation>>();
    private Map<IPose, List<IAnimation>> animations = new HashMap<IPose, List<IAnimation>>();
    private Map<String, Gesture> gesturesMap = new HashMap<String, Gesture>();
    private Map<String, Pose> customPoses = new HashMap<String, Pose>();
    private Set<IPose> mustFinishPoses = new HashSet<IPose>();

    public LegacyAnimationParser(ModelDefinition def) {
        this.def = def;
        this.reg = def.getAnimations();
    }

    private void finishLoading() {
        HashMap anims = new HashMap();
        for (Gesture g : this.stageGestures) {
            String[] nm = g.name.split(":", 2);
            if (nm.length != 2) continue;
            IPose pose = null;
            StagedAnimation san = (StagedAnimation)anims.computeIfAbsent(g.name, LegacyAnimationParser$$Lambda$1.lambdaFactory$());
            if (g.type == AnimationType.SETUP) {
                List<IAnimation> list = g.animation;
                StagedAnimation stagedAnimation = san;
                stagedAnimation.getClass();
                list.forEach(LegacyAnimationParser$$Lambda$2.lambdaFactory$(stagedAnimation));
            } else if (g.type == AnimationType.FINISH) {
                List<IAnimation> list = g.animation;
                StagedAnimation stagedAnimation = san;
                stagedAnimation.getClass();
                list.forEach(LegacyAnimationParser$$Lambda$3.lambdaFactory$(stagedAnimation));
            }
            String string = nm[0];
            int n = -1;
            switch (string.hashCode()) {
                case 112: {
                    if (!string.equals("p")) break;
                    n = 0;
                    break;
                }
                case 99: {
                    if (!string.equals("c")) break;
                    n = 1;
                    break;
                }
                case 103: {
                    if (!string.equals("g")) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    for (VanillaPose p : VanillaPose.VALUES) {
                        if (!nm[1].equals(p.name().toLowerCase(Locale.ROOT))) continue;
                        pose = p;
                        break;
                    }
                }
                case 1: {
                    Pose p;
                    if (pose == null && (p = this.customPoses.get(nm[1])) != null) {
                        pose = p.pose;
                    }
                    if (pose == null) break;
                    this.animations.computeIfPresent(pose, LegacyAnimationParser$$Lambda$4.lambdaFactory$(this, san));
                    break;
                }
                case 2: {
                    this.gesturesMap.computeIfPresent(nm[1], LegacyAnimationParser$$Lambda$5.lambdaFactory$(san));
                    break;
                }
            }
        }
    }

    public void addPose(IPose pose, Animation anim, boolean finish) {
        this.animations.computeIfAbsent(pose, LegacyAnimationParser$$Lambda$6.lambdaFactory$()).add(anim);
        if (finish) {
            this.mustFinishPoses.add(pose);
        }
    }

    public void addCustomPose(Pose pose, int gid) {
        this.customPoses.put(pose.pose.getName(), pose);
        if (gid != -1) {
            this.poseGid.put(pose.pose, gid);
        }
    }

    public void addGesture(Gesture g, int gid) {
        if (g.type.isStaged()) {
            this.stageGestures.add(g);
        } else {
            this.gesturesMap.put(g.name, g);
            if (g.type.isLayer()) {
                this.layerToId.put(g, this.layerToId.size() + 2);
            }
            if (gid != -1) {
                g.gid = gid;
            }
        }
    }

    public void register() {
        this.finishLoading();
        HashMap groups = new HashMap();
        Stream.concat(this.gesturesMap.values().stream(), this.customPoses.values().stream()).sorted(Comparator.comparingInt(LegacyAnimationParser$$Lambda$7.lambdaFactory$())).map(LegacyAnimationParser$$Lambda$8.lambdaFactory$(groups)).filter(LegacyAnimationParser$$Lambda$9.lambdaFactory$()).collect(Collectors.toList()).forEach(LegacyAnimationParser$$Lambda$10.lambdaFactory$(this));
        byte[] sync = new byte[this.layerToId.size() + 2];
        this.layerToId.forEach(LegacyAnimationParser$$Lambda$11.lambdaFactory$(sync));
        this.reg.setParams(new ParameterDetails(sync, new byte[0]));
        this.animations.forEach(LegacyAnimationParser$$Lambda$12.lambdaFactory$(this));
    }

    static /* synthetic */ void lambda$register$10(LegacyAnimationParser this_, IPose p, List an) {
        AnimationTrigger t = new AnimationTrigger(this_.reg, Collections.singleton(p), p instanceof VanillaPose ? (VanillaPose)p : null, an, true, this_.mustFinishPoses.contains(p));
        this_.reg.register(t);
    }

    static /* synthetic */ void lambda$register$9(byte[] sync, Gesture g, Integer i) {
        sync[i.intValue()] = g.defVal;
    }

    static /* synthetic */ void lambda$register$8(LegacyAnimationParser this_, IPoseGesture g) {
        g.register(this_);
    }

    static /* synthetic */ boolean lambda$register$7(IPoseGesture e) {
        return e != null;
    }

    static /* synthetic */ IPoseGesture lambda$register$6(Map groups, IPoseGesture g) {
        if (g instanceof Gesture && ((Gesture)g).group != null) {
            String k = ((Gesture)g).group;
            Group gr = (Group)groups.get(k);
            if (gr == null) {
                gr = new Group(k);
                groups.put(k, gr);
                gr.add((Gesture)g);
                return gr;
            }
            gr.add((Gesture)g);
            return null;
        }
        return g;
    }

    static /* synthetic */ List lambda$addPose$5(IPose __) {
        return new ArrayList();
    }

    static /* synthetic */ Gesture lambda$finishLoading$4(StagedAnimation san, String k, Gesture gs) {
        gs.animation.forEach(LegacyAnimationParser$$Lambda$13.lambdaFactory$(san, gs));
        gs.animation = san.getAll();
        gs.mustFinish = false;
        return gs;
    }

    static /* synthetic */ void lambda$null$3(StagedAnimation san, Gesture gs, IAnimation a) {
        san.addPlay(a, gs.mustFinish);
    }

    static /* synthetic */ List lambda$finishLoading$2(LegacyAnimationParser this_, StagedAnimation san, IPose p, List an) {
        boolean mf = this_.mustFinishPoses.contains(p);
        an.forEach(LegacyAnimationParser$$Lambda$14.lambdaFactory$(san, mf));
        if (mf) {
            this_.mustFinishPoses.remove(p);
        }
        return san.getAll();
    }

    static /* synthetic */ void lambda$null$1(StagedAnimation san, boolean mf, IAnimation a) {
        san.addPlay(a, mf);
    }

    static /* synthetic */ StagedAnimation lambda$finishLoading$0(String k) {
        return new StagedAnimation();
    }

    public static class Gesture
    implements IPoseGesture {
        public final AnimationType type;
        public List<IAnimation> animation;
        public boolean isLoop;
        public String name;
        public byte defVal;
        public int order;
        public boolean isProperty;
        public boolean command;
        public boolean layerCtrl;
        public boolean mustFinish;
        public String group;
        public int gid;
        public byte maxValue;
        public boolean interpolateVal;
        public boolean hidden;

        public Gesture(AnimationType type, List<IAnimation> animation, String name, boolean isLoop, int order, boolean mustFinish) {
            this.type = type;
            this.animation = animation;
            this.name = name;
            this.isLoop = isLoop;
            this.order = order;
            this.mustFinish = mustFinish;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public void register(LegacyAnimationParser reg) {
            switch (this.type) {
                case GESTURE: {
                    CustomPoseGestureButtonData data = new CustomPoseGestureButtonData(false);
                    data.setName(this.name);
                    data.layerCtrl = this.layerCtrl;
                    data.command = this.command;
                    data.id = this.gid;
                    data.hidden = this.hidden;
                    if (this.layerCtrl) {
                        data.gid = this.gid;
                    }
                    if (!this.isLoop) {
                        int len = this.animation.stream().mapToInt(LegacyAnimationParser$Gesture$$Lambda$1.lambdaFactory$()).max().orElse(-1);
                        data.gestureTimeout = len == -1 ? -1 : (int)Math.ceil((float)len / 50.0f) + 5;
                    }
                    data.setDef(reg.def);
                    reg.reg.register(data);
                    reg.reg.register(new AnimationTrigger.GestureTrigger(reg.reg, Collections.singleton(VanillaPose.GLOBAL), this.animation, this.gid, this.gid, this.isLoop, this.mustFinish));
                    break;
                }
                case LAYER: {
                    BoolParameterToggleButtonData dt = new BoolParameterToggleButtonData();
                    dt.setName(this.name);
                    dt.command = this.command;
                    dt.isProperty = this.isProperty;
                    dt.parameter = (Integer)reg.layerToId.get(this);
                    dt.mask = 1;
                    dt.hidden = this.hidden;
                    dt.setDef(reg.def);
                    reg.reg.register(dt);
                    reg.reg.register(new AnimationTrigger.LayerTrigger(reg.reg, Collections.singleton(VanillaPose.GLOBAL), this.animation, dt.parameter, 1, true, this.mustFinish));
                    break;
                }
                case VALUE_LAYER: {
                    ValueParameterButtonData dt = new ValueParameterButtonData();
                    dt.setName(this.name);
                    dt.command = this.command;
                    dt.isProperty = this.isProperty;
                    dt.parameter = (Integer)reg.layerToId.get(this);
                    dt.maxValue = this.maxValue == 0 ? 255 : Byte.toUnsignedInt(this.maxValue);
                    dt.hidden = this.hidden;
                    dt.setDef(reg.def);
                    reg.reg.register(dt);
                    reg.reg.register(new AnimationTrigger.ValueTrigger(reg.reg, Collections.singleton(VanillaPose.GLOBAL), this.animation, dt.parameter, this.maxValue == 0 ? true : this.interpolateVal));
                    break;
                }
            }
        }

        static /* synthetic */ int lambda$register$0(IAnimation a) {
            return a.getDuration(AnimationEngine.AnimationMode.PLAYER);
        }
    }

    public static class Pose
    implements IPoseGesture {
        private CustomPose pose;
        public boolean hidden;

        public Pose(CustomPose pose) {
            this.pose = pose;
        }

        @Override
        public int getOrder() {
            return this.pose.order;
        }

        @Override
        public void register(LegacyAnimationParser reg) {
            CustomPoseGestureButtonData data = new CustomPoseGestureButtonData(true);
            data.setName(this.pose.getId());
            data.layerCtrl = this.pose.layerCtrl;
            data.command = this.pose.command;
            data.hidden = this.hidden;
            int id = (Integer)reg.poseGid.get(this.pose);
            if (this.pose.layerCtrl) {
                data.gid = id;
            }
            data.id = id;
            data.setDef(reg.def);
            reg.reg.register(data);
        }
    }

    private static interface IPoseGesture {
        public int getOrder();

        public void register(LegacyAnimationParser var1);
    }

    private static class Group
    implements IPoseGesture {
        private List<Gesture> gs = new ArrayList<Gesture>();
        private String id;
        private int order = Integer.MIN_VALUE;

        public Group(String id) {
            this.id = id;
        }

        public void add(Gesture g) {
            this.gs.add(g);
        }

        @Override
        public int getOrder() {
            if (this.order == Integer.MIN_VALUE) {
                this.order = this.gs.stream().mapToInt(LegacyAnimationParser$Group$$Lambda$1.lambdaFactory$()).max().orElse(0);
            }
            return this.order;
        }

        @Override
        public void register(LegacyAnimationParser reg) {
            LegacyDropdownButtonData dt = new LegacyDropdownButtonData();
            dt.setName(this.id);
            dt.command = this.gs.stream().anyMatch(LegacyAnimationParser$Group$$Lambda$2.lambdaFactory$());
            dt.isProperty = this.gs.stream().anyMatch(LegacyAnimationParser$Group$$Lambda$3.lambdaFactory$());
            dt.setDef(reg.def);
            for (Gesture g : this.gs) {
                int l = (Integer)reg.layerToId.get(g);
                reg.reg.register(new AnimationTrigger.LayerTrigger(reg.reg, Collections.singleton(VanillaPose.GLOBAL), g.animation, l, 1, true, g.mustFinish));
                dt.register(g.name, l);
            }
            reg.reg.register(dt);
        }

        static /* synthetic */ boolean lambda$register$1(Gesture g) {
            return g.isProperty;
        }

        static /* synthetic */ boolean lambda$register$0(Gesture g) {
            return g.command;
        }
    }
}

