/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;

public class BitmaskParameterValueAction
implements CommandAction {
    private final String name;
    public int parameter;
    public int mask;
    private boolean cc;

    public BitmaskParameterValueAction(String name, int parameter, int mask, boolean cc) {
        this.name = name;
        this.parameter = parameter;
        this.mask = mask;
        this.cc = cc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.setInteger("param", this.parameter);
        tag.setByte("mask", (byte)this.mask);
        tag.setBoolean("cc", this.cc);
    }

    @Override
    public CommandAction.ActionType getType() {
        return CommandAction.ActionType.BITMASK;
    }

    @Override
    public int getValue() {
        AnimationEngine an = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine();
        return (an.getGestureValue(this.parameter) & this.mask) == this.mask ? 1 : 0;
    }

    @Override
    public void setValue(int v) {
        AnimationEngine an = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine();
        byte val = an.getGestureValue(this.parameter);
        val = v == -1 ? (byte)(val ^ this.mask) : (v == 0 ? (byte)(val & ~this.mask) : (byte)(val | this.mask));
        an.setGestureValue(this.parameter, val);
    }

    @Override
    public int getMaxValue() {
        return 1;
    }

    @Override
    public boolean isCommandControlled() {
        return this.cc;
    }

    public static class ServerAction
    implements CommandAction.ServerCommandAction {
        private PlayerData data;
        private String name;
        private int parameter;
        private int value;
        private boolean cc;

        public ServerAction(String name, NBTTagCompound tag, PlayerData data) {
            this.name = name;
            this.data = data;
            this.parameter = tag.getInteger("param");
            this.value = tag.getByte("mask");
            this.cc = tag.getBoolean("cc");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValue() {
            if (this.parameter < 0 || this.data.gestureData.length <= this.parameter) {
                return -1;
            }
            return (this.data.gestureData[this.parameter] & this.value) == this.value ? 1 : 0;
        }

        @Override
        public boolean isCommandControlled() {
            return this.cc;
        }
    }
}

