/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.menu.AbstractDropdownButtonData;
import com.tom.cpm.shared.parts.anim.menu.GestureButtonType;
import com.tom.cpm.shared.parts.anim.menu.SimpleParameterValueAction;
import com.tom.cpm.shared.parts.anim.menu.ValueParameterValueAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DropdownButtonData
extends AbstractDropdownButtonData {
    public int parameter;
    public List<String> opts = new ArrayList<String>();

    @Override
    protected void parseData(IOHelper block, AnimLoaderState state) throws IOException {
        super.parseData(block, state);
        this.parameter = block.readVarInt();
        int options = block.readByte();
        this.opts = new ArrayList<String>();
        for (int i = 0; i < options; ++i) {
            String opt = block.readUTF();
            this.opts.add(opt);
        }
    }

    @Override
    public void onRegistered() {
        super.onRegistered();
        for (int i = 0; i < this.opts.size(); ++i) {
            String opt = this.opts.get(i);
            this.commandActions.add(new SimpleParameterValueAction(opt, this.parameter, i, this.command));
        }
        this.commandActions.add(new ValueParameterValueAction(this.name, this.parameter, this.command, this.opts.size() - 1));
    }

    @Override
    public GestureButtonType getType() {
        return GestureButtonType.DROPDOWN;
    }

    @Override
    public void write(IOHelper block) throws IOException {
        super.write(block);
        block.writeVarInt(this.parameter);
        block.writeByte(this.opts.size());
        for (String string : this.opts) {
            block.writeUTF(string);
        }
    }

    public int add(String id) {
        int i = this.opts.size();
        this.opts.add(id);
        return i;
    }

    @Override
    public List<String> getActiveOptions() {
        return this.opts;
    }

    @Override
    public void set(String selected) {
        AnimationEngine an = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine();
        int i = this.opts.indexOf(selected);
        an.setGestureValue(this.parameter, i == -1 ? 0 : i);
    }

    @Override
    public String get() {
        AnimationEngine an = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine();
        int val = Byte.toUnsignedInt(an.getGestureValue(this.parameter));
        return this.opts.size() > val && val >= 0 ? this.opts.get(val) : "";
    }

    @Override
    public String getKeybindId() {
        return "d" + this.name;
    }

    @Override
    public void storeTo(ConfigEntry ce) {
        ce.setString(this.name, this.get());
    }

    @Override
    public void loadFrom(ConfigEntry ce) {
        int val = Byte.toUnsignedInt(this.def.getAnimations().getParams().getDefaultParam(this.parameter));
        this.set(ce.getString(this.name, this.opts.size() > val && val >= 0 ? this.opts.get(val) : ""));
    }
}

