/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;

public class SimpleParameterValueAction
implements CommandAction,
CommandAction.LegacyCommandActionWriter {
    private final String name;
    public int parameter;
    public int value;
    private boolean cc;

    public SimpleParameterValueAction(String name, int parameter, int value, boolean cc) {
        this.name = name;
        this.parameter = parameter;
        this.value = value;
        this.cc = cc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.setInteger("param", this.parameter);
        tag.setByte("value", (byte)this.value);
        tag.setBoolean("cc", this.cc);
    }

    @Override
    public void writeLegacy(NBTTagCompound tag) {
        tag.setString("name", this.name);
        tag.setByte("id", (byte)this.parameter);
        tag.setByte("type", (byte)((this.cc ? 16 : 0) | (this.parameter > 2 ? 2 : this.parameter)));
    }

    @Override
    public CommandAction.ActionType getType() {
        return CommandAction.ActionType.SIMPLE;
    }

    @Override
    public int getValue() {
        AnimationEngine an = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine();
        return an.getGestureValue(this.parameter) == this.value ? 1 : 0;
    }

    @Override
    public void setValue(int v) {
        AnimationEngine an = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine();
        if (v == -1 && an.getGestureValue(this.parameter) == this.value || v == 0) {
            an.setGestureValue(this.parameter, 0);
        } else {
            an.setGestureValue(this.parameter, this.value);
        }
    }

    @Override
    public int getMaxValue() {
        return 1;
    }

    @Override
    public boolean isCommandControlled() {
        return this.cc;
    }

    public static class ServerAction
    implements CommandAction.ServerCommandAction {
        private PlayerData data;
        private String name;
        private int parameter;
        private int value;
        private boolean cc;

        public ServerAction(String name, NBTTagCompound tag, PlayerData data) {
            this.name = name;
            this.data = data;
            this.parameter = tag.getInteger("param");
            this.value = tag.getByte("value");
            this.cc = tag.getBoolean("cc");
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValue() {
            if (this.parameter < 0 || this.data.gestureData.length <= this.parameter) {
                return -1;
            }
            return this.data.gestureData[this.parameter] == this.value ? 1 : 0;
        }

        @Override
        public boolean isCommandControlled() {
            return this.cc;
        }
    }
}

