/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.MinecraftClientAccess$;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;

public class ValueParameterValueAction
implements CommandAction,
CommandAction.LegacyCommandActionWriter {
    private final String name;
    private int parameter;
    private int max;
    private boolean cc;

    public ValueParameterValueAction(String name, int parameter, boolean cc, int max) {
        this.name = name;
        this.parameter = parameter;
        this.cc = cc;
        this.max = max;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void write(NBTTagCompound tag) {
        tag.setInteger("param", this.parameter);
        tag.setBoolean("cc", this.cc);
        tag.setInteger("max", this.max);
    }

    @Override
    public CommandAction.ActionType getType() {
        return CommandAction.ActionType.VALUE;
    }

    @Override
    public int getValue() {
        AnimationEngine an = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine();
        return Math.round((float)(Byte.toUnsignedInt(an.getGestureValue(this.parameter)) * this.max) / 255.0f);
    }

    @Override
    public void setValue(int v) {
        AnimationEngine an = MinecraftClientAccess$.get().getPlayerRenderManager().getAnimationEngine();
        an.setGestureValue(this.parameter, Math.round((float)v * 255.0f / (float)this.max));
    }

    @Override
    public int getMaxValue() {
        return this.max;
    }

    @Override
    public boolean isCommandControlled() {
        return this.cc;
    }

    @Override
    public void writeLegacy(NBTTagCompound tag) {
        tag.setString("name", this.name);
        tag.setByte("id", (byte)this.parameter);
        tag.setByte("type", (byte)((this.cc ? 16 : 0) | 2));
    }

    public static class ServerAction
    implements CommandAction.ServerCommandAction {
        private PlayerData data;
        private String name;
        private int parameter;
        private int max;
        private boolean cc;

        public ServerAction(String name, NBTTagCompound tag, PlayerData data) {
            this.name = name;
            this.data = data;
            this.parameter = tag.getInteger("param");
            this.cc = tag.getBoolean("cc");
            this.max = tag.getInteger("max");
        }

        public ServerAction(PlayerData data, String name, int parameter, boolean cc) {
            this.data = data;
            this.name = name;
            this.parameter = parameter;
            this.cc = cc;
            this.max = 255;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValue() {
            if (this.parameter < 0 || this.data.gestureData.length <= this.parameter) {
                return -1;
            }
            return Byte.toUnsignedInt(this.data.gestureData[this.parameter]) * this.max / 255;
        }

        @Override
        public boolean isCommandControlled() {
            return this.cc;
        }
    }
}

