/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.paste;

import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.LocalizedIOException;
import com.tom.cpl.util.ThrowingConsumer;
import com.tom.cpl.util.Util;
import com.tom.cpm.externals.com.google.gson.JsonParseException;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.io.HTTPIO;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$1;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$10;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$2;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$3;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$4;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$5;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$6;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$7;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$8;
import com.tom.cpm.shared.paste.PasteClient$$Lambda$9;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.MojangAPI;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class PasteClient {
    public static final boolean CAN_OPEN_BROWSER = true;
    public static final String URL = "https://paste.tom5454.com";
    public static final String URL_CF = "https://cf-paste.tom5454.com";
    private MojangAPI mojang;
    private String url;
    private String fallback;
    private String session;
    private long loginTime = -1L;
    private int maxSize = -1;
    private int maxPastes = -1;

    public PasteClient(MojangAPI mojang, String url, String fallback) {
        this.mojang = mojang;
        this.url = url;
        this.fallback = fallback;
    }

    private static <T> CompletableFuture<T> run(ThrowingConsumer<CompletableFuture<T>, IOException> task) {
        CompletableFuture cf = new CompletableFuture();
        ModelDefinitionLoader.THREAD_POOL.execute(PasteClient$$Lambda$1.lambdaFactory$(task, cf));
        return cf;
    }

    private static void disconnectOnError(CompletableFuture<?> cf, HttpURLConnection httpCon) {
        cf.exceptionally(PasteClient$$Lambda$2.lambdaFactory$(httpCon));
    }

    public CompletableFuture<Void> connect() {
        return PasteClient.run(PasteClient$$Lambda$3.lambdaFactory$(this));
    }

    public CompletableFuture<List<Paste>> listFiles() {
        return PasteClient.run(PasteClient$$Lambda$4.lambdaFactory$(this));
    }

    public CompletableFuture<String> uploadFile(String name, byte[] content) {
        return PasteClient.run(PasteClient$$Lambda$5.lambdaFactory$(this, name, content));
    }

    public CompletableFuture<Void> updateFile(String id, byte[] content) {
        return PasteClient.run(PasteClient$$Lambda$6.lambdaFactory$(this, id, content));
    }

    public CompletableFuture<Void> deleteFile(String id) {
        return PasteClient.run(PasteClient$$Lambda$7.lambdaFactory$(this, id));
    }

    public CompletableFuture<String> createBrowserLoginURL() {
        return PasteClient.run(PasteClient$$Lambda$8.lambdaFactory$(this));
    }

    public CompletableFuture<Void> logout() {
        return null;
    }

    private HttpURLConnection createUrlConnection(URL url, CompletableFuture<?> cf) throws IOException {
        HttpURLConnection httpCon = HTTPIO.createUrlConnection(url, false);
        httpCon.setRequestProperty("Session", this.session);
        PasteClient.disconnectOnError(cf, httpCon);
        return httpCon;
    }

    private Map<String, Object> parseResponse(String response) throws IOException {
        try {
            Map r = (Map)MinecraftObjectHolder.gson.fromJson(response, Object.class);
            if (r.containsKey("error")) {
                if ("error.paste.invalidSession".equals(r.get("errorMessage"))) {
                    this.loginTime = -1L;
                }
                throw new LocalizedIOException(String.valueOf(r.get("error")), new FormatText(String.valueOf(r.get("errorMessage")), new Object[0]));
            }
            return r;
        }
        catch (JsonParseException | ClassCastException e) {
            throw new LocalizedIOException("Result parse error", new FormatText("error.paste.parseError", new Object[0]), e);
        }
    }

    private static byte[] digestData(byte[] ... p_244731_0_) throws Exception {
        MessageDigest messagedigest = MessageDigest.getInstance("SHA-1");
        for (byte[] abyte : p_244731_0_) {
            messagedigest.update(abyte);
        }
        return messagedigest.digest();
    }

    public boolean isConnected() {
        return this.loginTime != -1L && System.currentTimeMillis() - this.loginTime < 900000L;
    }

    public int getMaxPastes() {
        return this.maxPastes;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getUrl() {
        return this.url;
    }

    static /* synthetic */ void lambda$createBrowserLoginURL$8(PasteClient this_, CompletableFuture cf) throws IOException {
        URL url = new URL(this_.url + "/api/browser_login");
        HttpURLConnection httpCon = this_.createUrlConnection(url, cf);
        String response = HTTPIO.getResponse(httpCon, url);
        Map<String, Object> r = this_.parseResponse(response);
        cf.complete((String)r.get("id"));
    }

    static /* synthetic */ void lambda$deleteFile$7(PasteClient this_, String id, CompletableFuture cf) throws IOException {
        URL url = new URL(this_.url + "/api/delete?file=" + id);
        HttpURLConnection httpCon = this_.createUrlConnection(url, cf);
        this_.parseResponse(HTTPIO.getResponse(httpCon, url));
        cf.complete(null);
    }

    static /* synthetic */ void lambda$updateFile$6(PasteClient this_, String id, byte[] content, CompletableFuture cf) throws IOException {
        URL url = new URL(this_.url + "/api/update?file=" + id);
        HttpURLConnection httpCon = this_.createUrlConnection(url, cf);
        httpCon.setRequestProperty("Content-Length", Integer.toString(content.length));
        httpCon.setDoOutput(true);
        httpCon.setRequestMethod("POST");
        httpCon.getOutputStream().write(content);
        this_.parseResponse(HTTPIO.getResponse(httpCon, url));
        cf.complete(null);
    }

    static /* synthetic */ void lambda$uploadFile$5(PasteClient this_, String name, byte[] content, CompletableFuture cf) throws IOException {
        URL url = new URL(this_.url + "/api/upload");
        HttpURLConnection httpCon = this_.createUrlConnection(url, cf);
        httpCon.setRequestProperty("File-Name", name);
        httpCon.setRequestProperty("Content-Length", Integer.toString(content.length));
        httpCon.setDoOutput(true);
        httpCon.setRequestMethod("POST");
        httpCon.getOutputStream().write(content);
        String response = HTTPIO.getResponse(httpCon, url);
        Map<String, Object> r = this_.parseResponse(response);
        cf.complete((String)r.get("id"));
    }

    static /* synthetic */ void lambda$listFiles$4(PasteClient this_, CompletableFuture cf) throws IOException {
        URL url = new URL(this_.url + "/api/list");
        HttpURLConnection httpCon = this_.createUrlConnection(url, cf);
        String response = HTTPIO.getResponse(httpCon, url);
        Map<String, Object> r = this_.parseResponse(response);
        List files = (List)r.get("files");
        ArrayList ret = new ArrayList();
        files.forEach(PasteClient$$Lambda$9.lambdaFactory$(ret));
        this_.maxSize = ((Number)r.get("maxSize")).intValue();
        this_.maxPastes = ((Number)r.get("maxFiles")).intValue();
        cf.complete(ret);
    }

    static /* synthetic */ void lambda$null$3(List ret, Map m) {
        String id = (String)m.get("id");
        String name = (String)m.get("name");
        long time = Long.parseLong((String)m.get("time"));
        ret.add(new Paste(id, name, time));
    }

    static /* synthetic */ void lambda$connect$2(PasteClient this_, CompletableFuture cf) throws IOException {
        byte[] mojangKey;
        String response;
        URL url = new URL(this_.url + "/api/connect?name=" + this_.mojang.getName());
        HttpURLConnection httpCon = HTTPIO.createUrlConnection(url, false);
        PasteClient.disconnectOnError(cf, httpCon);
        try {
            response = HTTPIO.getResponse(httpCon, url);
            Log.info("[Paste API]: Connected to paste site");
        }
        catch (ConnectException | SocketTimeoutException e) {
            Log.info("[Paste API]: Paste site timeout, trying fallback");
            url = new URL(this_.fallback + "/api/connect?name=" + this_.mojang.getName());
            httpCon = HTTPIO.createUrlConnection(url, false);
            PasteClient.disconnectOnError(cf, httpCon);
            response = HTTPIO.getResponse(httpCon, url);
            this_.url = this_.fallback;
            Log.info("[Paste API]: Connection success using fallback");
        }
        Map<String, Object> r = this_.parseResponse(response);
        this_.session = (String)r.get("id");
        byte[] mojKey = Base64.getDecoder().decode((String)r.get("key"));
        try {
            mojangKey = PasteClient.digestData("tom5454-paste".getBytes(), this_.session.getBytes(), mojKey);
        }
        catch (Exception e) {
            throw new LocalizedIOException("Unknown error", new FormatText("error.paste.unknown", new Object[0]), e);
        }
        try {
            this_.mojang.joinServer(new BigInteger(mojangKey).toString(16));
        }
        catch (LocalizedIOException e) {
            throw new LocalizedIOException(e.getMessage(), new FormatText("error.paste.authFail", e.getLocalizedText()), e.getCause());
        }
        url = new URL(this_.url + "/api/session");
        httpCon = this_.createUrlConnection(url, cf);
        response = HTTPIO.getResponse(httpCon, url);
        this_.parseResponse(response);
        this_.loginTime = System.currentTimeMillis();
        Log.info("[Paste API]: Connection success");
        cf.complete(null);
    }

    static /* synthetic */ Object lambda$disconnectOnError$1(HttpURLConnection httpCon, Throwable x) {
        HttpURLConnection httpURLConnection = httpCon;
        httpURLConnection.getClass();
        Util.closeQuietly(PasteClient$$Lambda$10.lambdaFactory$(httpURLConnection));
        return null;
    }

    static /* synthetic */ void lambda$run$0(ThrowingConsumer task, CompletableFuture cf) {
        try {
            task.accept(cf);
        }
        catch (IOException e) {
            cf.completeExceptionally(e);
        }
    }

    public static class Paste {
        public final String id;
        public final String name;
        public final long time;

        public Paste(String id, String name, long time) {
            this.id = id;
            this.name = name;
            this.time = time;
        }
    }
}

