/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.skin;

import com.tom.cpl.util.Image;
import com.tom.cpm.externals.com.google.common.cache.CacheBuilder;
import com.tom.cpm.externals.com.google.common.cache.CacheLoader;
import com.tom.cpm.externals.com.google.common.cache.LoadingCache;
import com.tom.cpm.externals.com.google.common.hash.Hashing;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.skin.PlayerTextureLoader$$Lambda$1;
import com.tom.cpm.shared.skin.PlayerTextureLoader$$Lambda$2;
import com.tom.cpm.shared.skin.PlayerTextureLoader$$Lambda$3;
import com.tom.cpm.shared.skin.PlayerTextureLoader$$Lambda$4;
import com.tom.cpm.shared.skin.PlayerTextureLoader$$Lambda$5;
import com.tom.cpm.shared.skin.PlayerTextureLoader$Texture$$Lambda$1;
import com.tom.cpm.shared.skin.PlayerTextureLoader$Texture$$Lambda$2;
import com.tom.cpm.shared.skin.PlayerTextureLoader$Texture$$Lambda$3;
import com.tom.cpm.shared.skin.TextureType;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public abstract class PlayerTextureLoader {
    private static final LoadingCache<String, CompletableFuture<Image>> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build(CacheLoader.from(PlayerTextureLoader$$Lambda$5.lambdaFactory$()));
    private Map<TextureType, Texture> textures = new ConcurrentHashMap<TextureType, Texture>();
    private final File skinsDirectory;
    private CompletableFuture<Void> loadFuture;

    public CompletableFuture<Void> load() {
        if (this.loadFuture == null) {
            this.loadFuture = this.load0();
        }
        return this.loadFuture;
    }

    public PlayerTextureLoader() {
        this.skinsDirectory = null;
    }

    public PlayerTextureLoader(File skinsDirectory) {
        this.skinsDirectory = skinsDirectory;
    }

    protected abstract CompletableFuture<Void> load0();

    protected void defineTexture(TextureType type, String url) {
        this.textures.computeIfAbsent(type, PlayerTextureLoader$$Lambda$1.lambdaFactory$()).url = url;
    }

    protected void defineTexture(TextureType type, String url, String hash) {
        Texture tx = this.textures.computeIfAbsent(type, PlayerTextureLoader$$Lambda$2.lambdaFactory$());
        tx.url = url;
        if (this.skinsDirectory != null) {
            String s = Hashing.sha1().hashUnencodedChars(hash).toString();
            File file1 = new File(this.skinsDirectory, s.length() > 2 ? s.substring(0, 2) : "xx");
            tx.cachedFile = new File(file1, s);
        }
    }

    protected void defineTexture(TextureType type, String url, File file) {
        Texture tx = this.textures.computeIfAbsent(type, PlayerTextureLoader$$Lambda$3.lambdaFactory$());
        tx.url = url;
        tx.cachedFile = file;
    }

    protected <Ty extends Enum<Ty>> void defineTexture(Ty type, String url) {
        this.defineTexture(TextureType.valueOf(type.name()), url);
    }

    protected <Ty extends Enum<Ty>> void defineTexture(Ty type, String url, String hash) {
        this.defineTexture(TextureType.valueOf(type.name()), url, hash);
    }

    protected <Ty extends Enum<Ty>, Tx> void defineAll(Map<Ty, Tx> map, Function<Tx, String> toURL) {
        for (Map.Entry<Ty, Tx> e : map.entrySet()) {
            this.defineTexture(TextureType.valueOf(((Enum)e.getKey()).name()), toURL.apply(e.getValue()));
        }
    }

    protected <Ty extends Enum<Ty>, Tx> void defineAll(Map<Ty, Tx> map, Function<Tx, String> toURL, Function<Tx, String> toHash) {
        for (Map.Entry<Ty, Tx> e : map.entrySet()) {
            this.defineTexture(TextureType.valueOf(((Enum)e.getKey()).name()), toURL.apply(e.getValue()), toHash.apply(e.getValue()));
        }
    }

    public CompletableFuture<Image> getTexture(TextureType type) {
        return this.textures.computeIfAbsent(type, PlayerTextureLoader$$Lambda$4.lambdaFactory$()).get();
    }

    public boolean hasTexture(TextureType type) {
        Texture t = this.textures.get((Object)type);
        if (t == null) {
            return false;
        }
        return t.url != null;
    }

    private static class Texture {
        private final TextureType type;
        private CompletableFuture<Image> skinFuture;
        private String url;
        private File cachedFile;
        private UnaryOperator<Image> postProcessor;

        public Texture(TextureType type) {
            this.postProcessor = type == TextureType.SKIN ? PlayerTextureLoader$Texture$$Lambda$1.lambdaFactory$() : UnaryOperator.identity();
            this.type = type;
        }

        public CompletableFuture<Image> get() {
            if (this.skinFuture != null) {
                return this.skinFuture;
            }
            this.skinFuture = this.get0();
            if (this.skinFuture == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.skinFuture;
        }

        private CompletableFuture<Image> get0() {
            if (MinecraftObjectHolder.DEBUGGING && new File(this.type.name().toLowerCase(Locale.ROOT) + "_test.png").exists()) {
                return Image.loadFrom(new File(this.type.name().toLowerCase(Locale.ROOT) + "_test.png")).thenApply(this.postProcessor);
            }
            if (this.url == null) {
                return null;
            }
            if (this.cachedFile != null && this.cachedFile.isFile()) {
                return ((CompletableFuture)Image.loadFrom(this.cachedFile).thenApply(this.postProcessor)).exceptionally(PlayerTextureLoader$Texture$$Lambda$2.lambdaFactory$());
            }
            return ((CompletableFuture)((CompletableFuture)cache.getUnchecked(this.url)).thenApply(this.postProcessor)).exceptionally(PlayerTextureLoader$Texture$$Lambda$3.lambdaFactory$());
        }

        static /* synthetic */ Image lambda$get0$1(Throwable e) {
            return null;
        }

        static /* synthetic */ Image lambda$get0$0(Throwable e) {
            return null;
        }
    }
}

