/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.tom.cpl.function.FloatBiFunction;
import com.tom.cpl.function.FloatFunction;
import com.tom.cpl.function.FloatSupplier;
import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpm.externals.com.udojava.evalex.Expression;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.util.ExpressionExt$$Lambda$1;
import com.tom.cpm.shared.util.ExpressionExt$$Lambda$2;
import com.tom.cpm.shared.util.ExpressionExt$$Lambda$3;
import com.tom.cpm.shared.util.ExpressionExt$ExpResult$$Lambda$1;
import com.tom.cpm.shared.util.ExpressionExt$ExpResult$$Lambda$2;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$OpStore$$Lambda$1;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$1;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$10;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$11;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$12;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$13;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$2;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$3;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$4;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$5;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$6;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$7;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$8;
import com.tom.cpm.shared.util.ExpressionExt$SerializedExpression$Opcode$$Lambda$9;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ExpressionExt
extends Expression {
    private Set<String> customFunc = new HashSet<String>();

    public ExpressionExt(String expression) {
        super(expression);
        this.variables.put("E", Float.valueOf((float)Math.E));
    }

    public ExpressionExt(SerializedExpression cex) {
        super(null);
        this.rpn = new ArrayList();
        cex.operations.forEach(ExpressionExt$$Lambda$1.lambdaFactory$(this));
    }

    public SerializedExpression serialize() {
        this.getRPN();
        SerializedExpression cex = new SerializedExpression();
        for (String token : this.rpn) {
            boolean encoded = false;
            for (SerializedExpression.Opcode op : SerializedExpression.Opcode.VALUES) {
                if (op.value == null || !token.equals(op.value)) continue;
                cex.operations.add(new SerializedExpression.Op(op, token));
                encoded = true;
                break;
            }
            if (encoded) continue;
            if (this.variables.containsKey(token)) {
                cex.operations.add(new SerializedExpression.Op(SerializedExpression.Opcode.LOAD, token));
                continue;
            }
            if (this.functions.containsKey(token.toUpperCase())) {
                if (this.customFunc.contains(token)) {
                    cex.operations.add(new SerializedExpression.Op(SerializedExpression.Opcode.INVOKE, token));
                    continue;
                }
                cex.operations.add(new SerializedExpression.Op(SerializedExpression.Opcode.INVOKE_BUILTIN_FUNC, token));
                continue;
            }
            if (token.equals("0")) {
                cex.operations.add(new SerializedExpression.Op(SerializedExpression.Opcode.ICONST_0, token));
                continue;
            }
            if (token.equals("1")) {
                cex.operations.add(new SerializedExpression.Op(SerializedExpression.Opcode.ICONST_1, token));
                continue;
            }
            try {
                int v = Integer.parseInt(token);
                if (Math.abs(v) < 0xFFFFFF) {
                    cex.operations.add(new SerializedExpression.Op(SerializedExpression.Opcode.VICONST, token));
                    continue;
                }
                cex.operations.add(new SerializedExpression.Op(SerializedExpression.Opcode.ICONST, token));
            }
            catch (NumberFormatException numberFormatException) {
                cex.operations.add(new SerializedExpression.Op(SerializedExpression.Opcode.FCONST, token));
            }
        }
        return cex;
    }

    public FloatSupplier compile(Map<String, FloatSupplier> dynamicVars) {
        Stack<ExpResult> stack = new Stack<ExpResult>();
        for (String token : this.getRPN()) {
            if (this.operators.containsKey(token)) {
                ExpResult v1 = (ExpResult)stack.pop();
                ExpResult v2 = (ExpResult)stack.pop();
                Expression.Operator op = (Expression.Operator)this.operators.get(token);
                FloatSupplier f1 = v1.toResult();
                FloatSupplier f2 = v2.toResult();
                stack.push(new ExpResult(ExpressionExt$$Lambda$2.lambdaFactory$(op, f2, f1), Arrays.asList(v1, v2), true));
                continue;
            }
            if (this.variables.containsKey(token)) {
                FloatSupplier fs = dynamicVars.get(token);
                if (fs != null) {
                    stack.push(new ExpResult(fs, null, false));
                    continue;
                }
                float v = ((Float)this.variables.get(token)).floatValue();
                stack.push(new ExpResult(v));
                continue;
            }
            if (this.functions.containsKey(token.toUpperCase())) {
                Expression.Function f = (Expression.Function)this.functions.get(token.toUpperCase());
                ArrayList<ExpResult> p = new ArrayList<ExpResult>(f.getNumParams());
                ArrayList<FloatSupplier> fs = new ArrayList<FloatSupplier>(f.getNumParams());
                ArrayList<Float> vc = new ArrayList<Float>(f.getNumParams());
                for (int i = 0; i < f.getNumParams(); ++i) {
                    ExpResult r = (ExpResult)stack.pop();
                    p.add(0, r);
                    fs.add(0, r.toResult());
                    vc.add(Float.valueOf(0.0f));
                }
                stack.push(new ExpResult(ExpressionExt$$Lambda$3.lambdaFactory$(f, fs, vc), p, f.isConstFunction()));
                continue;
            }
            try {
                float v = Float.parseFloat(token);
                stack.push(new ExpResult(v));
            }
            catch (NumberFormatException e) {
                throw new Expression.ExpressionException(e.getMessage());
            }
        }
        ExpResult fs = (ExpResult)stack.pop();
        if (!stack.isEmpty()) {
            throw new Expression.ExpressionException("Stack not empty");
        }
        return fs.toResult();
    }

    private static float funcEval(Expression.Function f, List<FloatSupplier> p, List<Float> fs) {
        for (int i = 0; i < f.getNumParams(); ++i) {
            fs.set(i, Float.valueOf(p.get(i).getAsFloat()));
        }
        return f.eval(fs);
    }

    @Override
    @Deprecated
    public Expression.Function addFunction(Expression.Function function) {
        return super.addFunction(function);
    }

    @Override
    @Deprecated
    public Expression.Operator addOperator(Expression.Operator operator) {
        return super.addOperator(operator);
    }

    public void addFunction(String name, final FloatSupplier func, final boolean isConst) {
        this.customFunc.add(name);
        this.addFunction(new Expression.Function(name, 0){

            @Override
            public float eval(List<Float> parameters) {
                return func.getAsFloat();
            }

            @Override
            public boolean isConstFunction() {
                return isConst;
            }
        });
    }

    public void addFunction(String name, final FloatFunction func, final boolean isConst) {
        this.customFunc.add(name);
        this.addFunction(new Expression.Function(name, 1){

            @Override
            public float eval(List<Float> parameters) {
                return func.apply(parameters.get(0).floatValue());
            }

            @Override
            public boolean isConstFunction() {
                return isConst;
            }
        });
    }

    public void addFunction(String name, final FloatBiFunction func, final boolean isConst) {
        this.customFunc.add(name);
        this.addFunction(new Expression.Function(name, 2){

            @Override
            public float eval(List<Float> parameters) {
                return func.apply(parameters.get(0).floatValue(), parameters.get(1).floatValue());
            }

            @Override
            public boolean isConstFunction() {
                return isConst;
            }
        });
    }

    public void addFunction(String name, int args, final ToFloatFunction<List<Float>> func, final boolean isConst) {
        this.customFunc.add(name);
        this.addFunction(new Expression.Function(name, args){

            @Override
            public float eval(List<Float> parameters) {
                return func.apply(parameters);
            }

            @Override
            public boolean isConstFunction() {
                return isConst;
            }
        });
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.rpn = null;
    }

    public ExpressionExt setVariables(Map<String, Float> variables) {
        this.variables.putAll(variables);
        return this;
    }

    static /* synthetic */ float lambda$compile$2(Expression.Function f, List fs, List vc) {
        return ExpressionExt.funcEval(f, fs, vc);
    }

    static /* synthetic */ float lambda$compile$1(Expression.Operator op, FloatSupplier f2, FloatSupplier f1) {
        return op.eval(f2.getAsFloat(), f1.getAsFloat());
    }

    static /* synthetic */ void lambda$new$0(ExpressionExt this_, SerializedExpression.Op op) {
        op.addToRPN(this_.rpn);
    }

    private static class ExpResult {
        private FloatSupplier result;
        private List<ExpResult> in;
        private float constVal;
        private boolean constFun;
        private Boolean isConst;

        public ExpResult(FloatSupplier result, List<ExpResult> in, boolean constFun) {
            this.result = result;
            this.in = in;
            this.constFun = constFun;
        }

        public ExpResult(float constVal) {
            this.constVal = constVal;
        }

        public FloatSupplier toResult() {
            if (this.result == null) {
                Float v = Float.valueOf(this.constVal);
                return ExpressionExt$ExpResult$$Lambda$1.lambdaFactory$(v);
            }
            if (this.isConst()) {
                Float v = Float.valueOf(this.result.getAsFloat());
                return ExpressionExt$ExpResult$$Lambda$2.lambdaFactory$(v);
            }
            return this.result;
        }

        public boolean isConst() {
            if (this.isConst == null) {
                this.isConst = this.result == null || this.constFun && this.checkInputs();
            }
            return this.isConst;
        }

        private boolean checkInputs() {
            if (this.in != null) {
                for (ExpResult expResult : this.in) {
                    if (expResult.isConst()) continue;
                    return false;
                }
            }
            return true;
        }

        static /* synthetic */ float lambda$toResult$1(Float v) {
            return v.floatValue();
        }

        static /* synthetic */ float lambda$toResult$0(Float v) {
            return v.floatValue();
        }
    }

    public static interface ExpContext {
        public String loadVar(IOHelper var1) throws IOException;

        public void storeVar(String var1, IOHelper var2) throws IOException;

        public String loadFunc(IOHelper var1) throws IOException;

        public void storeFunc(String var1, IOHelper var2) throws IOException;
    }

    public static class SerializedExpression {
        private List<Op> operations = new ArrayList<Op>();

        public SerializedExpression(IOHelper in, ExpContext ctx) throws IOException {
            while (true) {
                int op;
                if ((op = in.read()) >= Opcode.VALUES.length) {
                    throw new IOException("Illegal opcode in expression");
                }
                Opcode opcode = Opcode.VALUES[op];
                if (opcode == Opcode.END) break;
                this.operations.add(new Op(opcode, in, ctx));
            }
        }

        private SerializedExpression() {
        }

        public void write(IOHelper out, ExpContext ctx) throws IOException {
            for (Op op : this.operations) {
                out.write(op.opcode.ordinal());
                op.opcode.store.store(out, ctx, op);
            }
            out.write(Opcode.END.ordinal());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Serialized Expression:");
            for (Op op : this.operations) {
                sb.append("\n\t");
                sb.append(op.opcode.name());
                if (op.opcode.store == OpStore.NO_ARGS) continue;
                sb.append(' ');
                sb.append(op.value);
            }
            return sb.toString();
        }

        @FunctionalInterface
        public static interface OpStore {
            public static final OpStore NO_ARGS = ExpressionExt$SerializedExpression$OpStore$$Lambda$1.lambdaFactory$();

            public void store(IOHelper var1, ExpContext var2, Op var3) throws IOException;
        }

        @FunctionalInterface
        public static interface OpInit {
            public void init(IOHelper var1, ExpContext var2, Op var3) throws IOException;
        }

        public static class Op {
            private final Opcode opcode;
            private String value;

            public Op(Opcode opcode, String value) {
                this.opcode = opcode;
                this.value = value;
            }

            public Op(Opcode opcode, IOHelper io, ExpContext ctx) throws IOException {
                this(opcode, null);
                opcode.init.init(io, ctx, this);
            }

            public void addToRPN(List<String> rpn) {
                rpn.add(this.value);
            }

            public void setValue(String value) {
                this.value = value;
            }
        }

        public static enum Functions {
            NOT,
            IF,
            RANDOM,
            SIN,
            COS,
            TAN,
            SINH,
            COSH,
            TANH,
            RAD,
            DEG,
            MAX,
            MIN,
            ABS,
            LOG,
            LOG10,
            ROUND,
            FLOOR,
            CEILING,
            SQRT;

            private static final Functions[] VALUES;

            private static void read(IOHelper io, ExpContext ctx, Op op) throws IOException {
                int f = io.read();
                if (f >= VALUES.length) {
                    throw new IOException("Unknown function");
                }
                op.setValue(VALUES[f].name());
            }

            private static void store(IOHelper io, ExpContext ctx, Op op) throws IOException {
                Enum func = null;
                for (Functions f : VALUES) {
                    if (!f.name().equals(op.value)) continue;
                    func = f;
                    break;
                }
                if (func == null) {
                    throw new IOException("Unknown function");
                }
                io.write(func.ordinal());
            }

            static {
                VALUES = Functions.values();
            }
        }

        public static enum Opcode {
            LOAD(ExpressionExt$SerializedExpression$Opcode$$Lambda$2.lambdaFactory$(), ExpressionExt$SerializedExpression$Opcode$$Lambda$3.lambdaFactory$()),
            OP_ADD("+"),
            OP_SUB("-"),
            OP_MUL("*"),
            OP_DIV("/"),
            OP_REM("%"),
            OP_POW("^"),
            OP_AND("&&"),
            OP_OR("||"),
            OP_CMP_L(">"),
            OP_CMP_LEQ(">="),
            OP_CMP_G("<"),
            OP_CMP_GEQ("<="),
            OP_EQ("="),
            OP_NEQ("!="),
            ICONST(ExpressionExt$SerializedExpression$Opcode$$Lambda$4.lambdaFactory$(), ExpressionExt$SerializedExpression$Opcode$$Lambda$5.lambdaFactory$()),
            VICONST(ExpressionExt$SerializedExpression$Opcode$$Lambda$6.lambdaFactory$(), ExpressionExt$SerializedExpression$Opcode$$Lambda$7.lambdaFactory$()),
            FCONST(ExpressionExt$SerializedExpression$Opcode$$Lambda$8.lambdaFactory$(), ExpressionExt$SerializedExpression$Opcode$$Lambda$9.lambdaFactory$()),
            ICONST_0("FALSE"),
            ICONST_1("TRUE"),
            FCONST_PI("PI"),
            FCONST_E("E"),
            INVOKE_BUILTIN_FUNC(ExpressionExt$SerializedExpression$Opcode$$Lambda$10.lambdaFactory$(), ExpressionExt$SerializedExpression$Opcode$$Lambda$11.lambdaFactory$()),
            INVOKE(ExpressionExt$SerializedExpression$Opcode$$Lambda$12.lambdaFactory$(), ExpressionExt$SerializedExpression$Opcode$$Lambda$13.lambdaFactory$()),
            END;

            public static final Opcode[] VALUES;
            private final OpInit init;
            private final OpStore store;
            private String value;

            private Opcode(OpInit init, OpStore store) {
                this.init = init;
                this.store = store;
            }

            private Opcode(String append) {
                this.init = ExpressionExt$SerializedExpression$Opcode$$Lambda$1.lambdaFactory$(append);
                this.store = OpStore.NO_ARGS;
                this.value = append;
            }

            private Opcode() {
                this.init = null;
                this.store = null;
            }

            static /* synthetic */ void lambda$new$12(String append, IOHelper io, ExpContext ctx, Op op) throws IOException {
                op.setValue(append);
            }

            static /* synthetic */ void lambda$static$11(IOHelper io, ExpContext ctx, Op op) throws IOException {
                ctx.storeFunc(op.value, io);
            }

            static /* synthetic */ void lambda$static$10(IOHelper io, ExpContext ctx, Op op) throws IOException {
                op.setValue(ctx.loadFunc(io));
            }

            static /* synthetic */ void lambda$static$9(IOHelper x$0, ExpContext x$1, Op x$2) throws IOException {
                Functions.store(x$0, x$1, x$2);
            }

            static /* synthetic */ void lambda$static$8(IOHelper x$0, ExpContext x$1, Op x$2) throws IOException {
                Functions.read(x$0, x$1, x$2);
            }

            static /* synthetic */ void lambda$static$7(IOHelper io, ExpContext ctx, Op op) throws IOException {
                io.writeFloat(Float.parseFloat(op.value));
            }

            static /* synthetic */ void lambda$static$6(IOHelper io, ExpContext ctx, Op op) throws IOException {
                Float.toString(io.readFloat());
            }

            static /* synthetic */ void lambda$static$5(IOHelper io, ExpContext ctx, Op op) throws IOException {
                io.writeSignedVarInt(Integer.parseInt(op.value));
            }

            static /* synthetic */ void lambda$static$4(IOHelper io, ExpContext ctx, Op op) throws IOException {
                Integer.toString(io.readSignedVarInt());
            }

            static /* synthetic */ void lambda$static$3(IOHelper io, ExpContext ctx, Op op) throws IOException {
                io.writeInt(Integer.parseInt(op.value));
            }

            static /* synthetic */ void lambda$static$2(IOHelper io, ExpContext ctx, Op op) throws IOException {
                Integer.toString(io.readInt());
            }

            static /* synthetic */ void lambda$static$1(IOHelper io, ExpContext ctx, Op op) throws IOException {
                ctx.storeVar(op.value, io);
            }

            static /* synthetic */ void lambda$static$0(IOHelper io, ExpContext ctx, Op op) throws IOException {
                op.setValue(ctx.loadVar(io));
            }

            static {
                VALUES = Opcode.values();
            }
        }
    }
}

